#ifndef __EventMessage_h
#define __EventMessage_h

#include "CoreEventInfo.h"
#include "ElarmsMessage.h"
#include "VSMessage.h"
#include "OnSiteMessage.h"

typedef list<PGVObservation>::iterator PGVObsIter;
typedef list<PGAObservation>::iterator PGAObsIter;

class EventMessage : public CoreEventInfo
{
 public:
    bool ebool;
    bool vbool;
    bool obool;
    ElarmsMessage* emess;
    VSMessage* vmess;
    OnSiteMessage* omess;
    char elarmssysbuffer[8192];
    char vssysbuffer[8192];
    char onsitesysbuffer[8192];
    EventMessage(int i=-9,
		 float mag=-9.9,
		 float mag_uncer=-9.9,
		 float lat=-999.9,
		 float lat_uncer=-999.9,
		 float lon=-999.9,
		 float lon_uncer=-999.9,
		 float dep=-9.9,
		 float dep_uncer=-9.9,
		 string o_time="2999-12-31T24:60:60.0000Z",
		 float o_time_uncer=-9.9,
		 float lklyhd=-9.9);
    virtual ~EventMessage();
    void addElarmsMessage(char* ebuf,
			  int i=-9,
			  float mag=-9.9,
			  float mag_uncer=-9.9,
			  float lat=-999.9,
			  float lat_uncer=-999.9,
			  float lon=-999.9,
			  float lon_uncer=-999.9,
			  float dep=-9.9,
			  float dep_uncer=-9.9,
			  string o_time="2999-12-31T24:60:60.0000Z",
			  float o_time_uncer=-9.9,
			  float lklyhd=-9.9);
    void addVSMessage(char* vbuf,
		      int i=-9,
		      float mag=-9.9,
		      float mag_uncer=-9.9,
		      float lat=-999.9,
		      float lat_uncer=-999.9,
		      float lon=-999.9,
		      float lon_uncer=-999.9,
		      float dep=-9.9,
		      float dep_uncer=-9.9,
		      string o_time="2999-12-31T24:60:60.0000Z",
		      float o_time_uncer=-9.9,
		      float lklyhd=-9.9);
    void addOnSiteMessage(char* obuf,
			  int i=-9,
			  float mag=-9.9,
			  float mag_uncer=-9.9,
			  float lat=-999.9,
			  float lat_uncer=-999.9,
			  float lon=-999.9,
			  float lon_uncer=-999.9,
			  float dep=-9.9,
			  float dep_uncer=-9.9,
			  string o_time="2999-12-31T24:60:60.0000Z",
			  float o_time_uncer=-9.9,
			  float lklyhd=-9.9);
    int deleteElarmsMessage();
    int deleteVSMessage();
    int deleteOnSiteMessage();
    int calculateComboValues();
    


};


#endif
