#include "OnSiteMessage.h"

OnSiteMessage::OnSiteMessage(int i,
			     float mag,
			     float mag_uncer,
			     float lat,
			     float lat_uncer,
			     float lon,
			     float lon_uncer,
			     float dep,
			     float dep_uncer,
			     string o_time,
			     float o_time_uncer,
			     float lklyhd) : CoreEventInfo(i, 
							   mag, 
							   mag_uncer, 
							   lat, 
							   lat_uncer, 
							   lon, 
							   lon_uncer, 
							   dep, 
							   dep_uncer, 
							   o_time, 
							   o_time_uncer, 
							   lklyhd) {}

OnSiteMessage::~OnSiteMessage() 
{}

list<PGVPrediction>::iterator OnSiteMessage::getPGVPredictionsIteratorBegin() 
{
    return pgvelocity_predictions.begin();
}
list<PGVPrediction>::iterator OnSiteMessage::getPGVPredictionsIteratorEnd() 
{
    return pgvelocity_predictions.end();
}

int OnSiteMessage::getNumberVelocityPredictions() 
{
    int result = 0;
    PGVPredIter i = pgvelocity_predictions.begin();
    PGVPredIter e = pgvelocity_predictions.end();
    for (i; i != e; i++) { result++; }
    return result;
}

int OnSiteMessage::addPGVPrediction(PGVPrediction &A) 
{
    PGVPredIter i = pgvelocity_predictions.begin();
    PGVPredIter e = pgvelocity_predictions.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgvelocity_predictions.push_back(A);
    this->updateVersion();
    return 1;
}
int OnSiteMessage::addPGVPrediction(string sta,
				    string net, 
				    string chan, 
				    string loc, 
				    double pred,
				    double pred_uncer,
				    string p_time,
				    float p_time_uncer,
				    float app_rad,
				    float lat, 
				    float lon,
				    string pred_units,
				    string pred_uncer_units,
				    string p_time_units,
				    string p_time_uncer_units,
				    string app_rad_units,
				    string lat_units,
				    string lon_units) {
    PGVPrediction A(sta, 
		    net, 
		    chan, 
		    loc, 
		    pred, 
		    pred_uncer, 
		    p_time, 
		    p_time_uncer, 
		    app_rad, 
		    lat, 
		    lon, 
		    pred_units, 
		    pred_uncer_units, 
		    p_time_units, 
		    p_time_uncer_units,
		    app_rad_units, 
		    lat_units,
		    lat_units);
    PGVPredIter i = pgvelocity_predictions.begin();
    PGVPredIter e = pgvelocity_predictions.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgvelocity_predictions.push_back(A);
    this->updateVersion();
    return 1;
}
void OnSiteMessage::deletePGVPrediction(PGVPrediction &A) 
{
    pgvelocity_predictions.remove(A);
    this->updateVersion();
}
void OnSiteMessage::deletePGVPrediction(string sta,
					string net, 
					string chan, 
					string loc, 
					double pred,
					double pred_uncer,
					string p_time,
					float p_time_uncer,
					float app_rad,
					float lat, 
					float lon,
					string pred_units,
					string pred_uncer_units,
					string p_time_units,
					string p_time_uncer_units,
					string app_rad_units,
					string lat_units,
					string lon_units)

{
    PGVPrediction A(sta, 
		    net, 
		    chan, 
		    loc, 
		    pred, 
		    pred_uncer, 
		    p_time, 
		    p_time_uncer, 
		    app_rad, 
		    lat, 
		    lon, 
		    pred_units, 
		    pred_uncer_units, 
		    p_time_units, 
		    p_time_uncer_units,
		    app_rad_units, 
		    lat_units,
		    lon_units);
    pgvelocity_predictions.remove(A);
    this->updateVersion();
}
void OnSiteMessage::deletePGVPrediction(string sta,
					string net, 
					string chan, 
					string loc)
{
    StaNetChanLoc snclcomp(sta, net, chan, loc);
    PGVPredIter i = pgvelocity_predictions.begin();
    PGVPredIter e = pgvelocity_predictions.end();
    for (i; i != e; i++) { 
	if(i->getSNCL() == snclcomp.getSNCL()) {
	    pgvelocity_predictions.erase(i);
	    this->updateVersion();
	}
    }


}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

