#include "PG_Info.h"

StaNetChanLoc::StaNetChanLoc(string sta, string net, string chan, string loc) : station(sta),
										network(net),
										channel(chan),
										location(loc) {}

StaNetChanLoc::~StaNetChanLoc() {}
string StaNetChanLoc::setNetwork(string net) {
    network=net;
    return network;
}

string StaNetChanLoc::setStation(string sta)
{
    station=sta;
    return station;
}

string StaNetChanLoc::setChannel(string chan)
{
    channel=chan;
    return chan;
}

string StaNetChanLoc::setLocation(string loc)
{
    location=loc;
    return loc;
}

string StaNetChanLoc::getNetwork() const
{
    return network;
}

string StaNetChanLoc::getStation() const
{
    return station;
}

string StaNetChanLoc::getChannel() const
{
    return channel;
}

string StaNetChanLoc::getLocation() const
{
    return location;
}

string StaNetChanLoc::getSNCL() const
{
    string fullname = this->station+'.';
    fullname += this->network+'.';
    fullname += this->channel+'.';
    fullname += this->location;
    return fullname;
}

bool StaNetChanLoc::operator==(const StaNetChanLoc &A) const
{
    //const StaNetChanLoc* a = &A;
    
    if ( (A.getNetwork() == this->getNetwork()) &&
    	 (A.getStation() == this->getStation()) &&
    	 (A.getChannel() == this->getChannel()) &&
    	 (A.getLocation() == this->getLocation()) ) 
    {
	return true;
    } 
    else {
	return false;
    }
}

bool StaNetChanLoc::operator!=(const StaNetChanLoc &A) const 
{
    return !(*this==A);
}
//CLASS:////////////////////////////////////////////////////////////////////////
//PG_Info///////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
PG_Info::PG_Info(double obs, 
		 float lat, 
		 float lon, 
		 string o_time,
		 string obs_units,
		 string lat_units,
		 string lon_units,
		 string o_time_units): observation(obs),
				       latitude(lat),
				       longitude(lon),
				       observation_time(o_time),
				       observation_units(obs_units),
				       latitude_units(lat_units),
				       longitude_units(lon_units),
				       observation_time_units(o_time_units) {}
PG_Info::~PG_Info() {}
////////////////////////////////////////////////////////////////////////////////
//SET_VALUES////////////////////////////////////////////////////////////////////
double PG_Info::setObservation(double obs) 
{
    observation = obs;
    return observation;
}
float PG_Info::setLatitude(float lat) 
{
    latitude = lat;
    return latitude;
}
float PG_Info::setLongitude(float lon) 
{
    longitude = lon;
    return longitude;
}
string PG_Info::setObservationTime(string o_time) 
{
    observation_time = o_time;
    return observation_time;
}
//////////
//SET_UNITS
string PG_Info::setObservationUnits(string obs_units)
{
    observation_units = obs_units;
    return observation_units;
}
string PG_Info::setLatitudeUnits(string lat_units) 
{
    latitude_units = lat_units;
    return latitude_units;
}
string PG_Info::setLongitudeUnits(string lon_units) 
{
    longitude_units = lon_units;
    return longitude_units;
}
string PG_Info::setObservationTimeUnits(string o_time_units) 
{
    observation_time_units = o_time_units;
    return observation_time_units;
}
////////////////////////////////////////////////////////////////////////////////
//GET_VALUES////////////////////////////////////////////////////////////////////
double PG_Info::getObservation() const
{
    return observation;
}
float PG_Info::getLatitude() const
{
    return latitude;
}
float PG_Info::getLongitude() const
{
    return longitude;
}
string PG_Info::getObservationTime() const
{
    return observation_time;
}
//////////
//GET_UNITS
string PG_Info::getObservationUnits() const
{
    return observation_units;
}
string PG_Info::getLatitudeUnits() const
{
    return latitude_units;
}
string PG_Info::getLongitudeUnits() const 
{
    return longitude_units;
}
string PG_Info::getObservationTimeUnits() const 
{
    return observation_time_units;
}
////////////////////////////////////////////////////////////////////////////////
//OPERATORS/////////////////////////////////////////////////////////////////////
bool PG_Info::operator==(const PG_Info &A) const
{
    if ( (A.getObservation() == this->getObservation()) &&
	 (A.getLatitude() == this->getLatitude()) &&
	 (A.getLongitude() == this->getLongitude()) &&
	 (A.getObservationTime() == this->getObservationTime()) &&
	 (A.getObservationUnits() == this->getObservationUnits()) &&
	 (A.getLatitudeUnits() == this->getLatitudeUnits()) &&
	 (A.getLongitudeUnits() == this->getLongitudeUnits()) &&
	 (A.getObservationTimeUnits() == this->getObservationTimeUnits()) )
    {
	return true;
    } else {
	return false;
    }
}
bool PG_Info::operator!=(const PG_Info &A) const
{
    return !(*this==A);
}
//CLASS:////////////////////////////////////////////////////////////////////////
//PGVObservation////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
PGVObservation::PGVObservation(string sta, 
			       string net, 
			       string chan,
			       string loc,
			       double obs, 
			       float lat,
			       float lon,
			       string o_time,
			       string o_units,
			       string lat_units,
			       string lon_units,
			       string o_time_units):PG_Info(obs, lat, lon, o_time, o_units, lat_units, lon_units, o_time_units),
						    StaNetChanLoc(sta, net, chan, loc) {}
PGVObservation::~PGVObservation() {}
//PGVObservation////////////////////////////////////////////////////////////////
//OPERATORS/////////////////////////////////////////////////////////////////////
/*bool PGVObservation::compareTimeSNCL(const PGVObservation &A) const
{
    return ((A.getObservationTime() == this->getObservationTime()) && (StaNetChanLoc::operator==((StaNetChanLoc)A)) );
}*/
bool PGVObservation::operator==(const PGVObservation &A) const
{
    return ((PG_Info::operator==((PG_Info)A)) && (StaNetChanLoc::operator==((StaNetChanLoc)A)));
    
}
bool PGVObservation::operator!=(const PGVObservation &A) const
{
    return !(*this==A);
}
//CLASS:////////////////////////////////////////////////////////////////////////
//PGAObservation////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
PGAObservation::PGAObservation(string sta, 
			       string net, 
			       string chan,
			       string loc,
			       double obs, 
			       float lat,
			       float lon,
			       string o_time,
			       string obs_units,
			       string lat_units,
			       string lon_units,
			       string o_time_units):PG_Info(obs, lat, lon, o_time, obs_units, lat_units, lon_units, o_time_units),
						    StaNetChanLoc(sta, net, chan, loc) {}
PGAObservation::~PGAObservation() {}
//PGAObservation////////////////////////////////////////////////////////////////
//OPERATORS/////////////////////////////////////////////////////////////////////
/*bool PGAObservation::compareTimeSNCL(const PGAObservation &A) const
{
    return ((A.getObservationTime() == this->getObservationTime()) && (StaNetChanLoc::operator==((StaNetChanLoc)A)) );
}*/
bool PGAObservation::operator==(const PGAObservation &A) const
{
    return ((PG_Info::operator==((PG_Info)A)) && (StaNetChanLoc::operator==((StaNetChanLoc)A)));
    
}
bool PGAObservation::operator!=(const PGAObservation &A) const
{
    return !(*this==A);
}
//CLASS:////////////////////////////////////////////////////////////////////////
//PGVPrediction/////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
PGVPrediction::PGVPrediction(string sta, 
			     string net, 
			     string chan, 
			     string loc,
			     double pred, 
			     double pred_uncer, 
			     string p_time, 
			     float p_time_uncer, 
			     float app_rad, 
			     float lat, 
			     float lon, 
			     string pred_units, 
			     string pred_uncer_units, 
			     string p_time_units,
			     string p_time_uncer_units,
			     string app_rad_units, 
			     string lat_units, 
			     string lon_units):StaNetChanLoc(sta, net, chan, loc),
					       prediction(pred),
					       prediction_uncertainty(pred_uncer),
					       prediction_time(p_time),
					       prediction_time_uncertainty(p_time_uncer),
					       applied_radius(app_rad),
					       latitude(lat),
					       longitude(lon),
					       prediction_units(pred_units),
					       prediction_uncertainty_units(pred_uncer_units),
					       prediction_time_units(p_time_units),
					       prediction_time_uncertainty_units(p_time_uncer_units),
					       applied_radius_units(app_rad_units),
					       latitude_units(lat_units),
					       longitude_units(lon_units) {}
PGVPrediction::~PGVPrediction() {}
////////////////////////////////////////////////////////////////////////////////
//SET_VALUES////////////////////////////////////////////////////////////////////
double PGVPrediction::setPrediction(double pred)
{
    prediction = pred;
    return prediction;
}
double PGVPrediction::setPredictionUncertainty(double pred_uncer)
{
    prediction_uncertainty = pred_uncer;
    return prediction_uncertainty;
}
string PGVPrediction::setPredictionTime(string p_time)
{
    prediction_time = p_time;
    return prediction_time;
}
float PGVPrediction::setPredictionTimeUncertainty(float p_time_uncer)
{
    prediction_time_uncertainty = p_time_uncer;
    return prediction_time_uncertainty;
}
float PGVPrediction::setAppliedRadius(float app_rad) 
{
    applied_radius = app_rad;
    return applied_radius;
}
float PGVPrediction::setLatitude(float lat)
{
    latitude = lat;
    return latitude;
}
float PGVPrediction::setLongitude(float lon)
{
    longitude = lon;
    return longitude;
}
//////////
//SET_UNITS
string  PGVPrediction::setPredictionUnits(string pred_units)
{
    prediction_units = pred_units;
    return prediction_units;
}
string PGVPrediction::setPredictionUncertaintyUnits(string pred_uncer_units)
{
    prediction_uncertainty_units = pred_uncer_units;
    return prediction_uncertainty_units;
}
string PGVPrediction::setPredictionTimeUnits(string p_time_units)
{
    prediction_time_units = p_time_units;
    return prediction_time_units;
}
string PGVPrediction::setPredictionTimeUncertaintyUnits(string p_time_uncer_units)
{
    prediction_time_uncertainty_units = p_time_uncer_units;
    return prediction_time_uncertainty_units;
}
string PGVPrediction::setAppliedRadiusUnits(string app_rad_units) 
{
    applied_radius_units = app_rad_units;
    return applied_radius_units;
}
string PGVPrediction::setLatitudeUnits(string lat_units)
{
    latitude_units = lat_units;
    return latitude_units;
}
string PGVPrediction::setLongitudeUnits(string lon_units)
{
    longitude_units = lon_units;
    return longitude_units;
}

////////////////////////////////////////////////////////////////////////////////
//GET_VALUES////////////////////////////////////////////////////////////////////
double PGVPrediction::getPrediction() const
{
    return prediction;
}
double PGVPrediction::getPredictionUncertainty() const
{
    return prediction_uncertainty;
}
string PGVPrediction::getPredictionTime() const
{
    return prediction_time;
}
float PGVPrediction::getPredictionTimeUncertainty() const
{
    return prediction_time_uncertainty;
}
float PGVPrediction::getAppliedRadius() const
{
    return applied_radius;
}
float PGVPrediction::getLatitude() const
{
    return latitude ;
}
float PGVPrediction::getLongitude() const 
{
    return longitude;
}
//////////
//GET_UNITS
string PGVPrediction::getPredictionUnits() const
{
    return prediction_units;
}
string PGVPrediction::getPredictionUncertaintyUnits() const
{
    return prediction_uncertainty_units;
}
string PGVPrediction::getPredictionTimeUnits() const
{
    return prediction_time_units;
}
string PGVPrediction::getPredictionTimeUncertaintyUnits() const
{
    return prediction_time_uncertainty_units;
}
string PGVPrediction::getAppliedRadiusUnits() const
{
    return applied_radius_units;
}
string PGVPrediction::getLatitudeUnits() const
{
    return latitude_units;
}
string PGVPrediction::getLongitudeUnits() const 
{
    return longitude_units;
}
////////////////////////////////////////////////////////////////////////////////
//OPERATORS/////////////////////////////////////////////////////////////////////
bool PGVPrediction::operator==(const PGVPrediction &A) const
{
    if ( (A.getPrediction() == this->getPrediction()) &&
	 (A.getPredictionUncertainty() == this->getPredictionUncertainty()) &&
	 (A.getPredictionTime() == this->getPredictionTime()) &&
	 (A.getPredictionTimeUncertainty() == this->getPredictionTimeUncertainty()) &&
	 (A.getAppliedRadius() == this->getAppliedRadius()) &&
	 (A.getLatitude() == this->getLatitude()) &&
	 (A.getLongitude() == this->getLongitude()) &&
	 (A.getPredictionUnits() == this->getPredictionUnits()) &&
	 (A.getPredictionUncertaintyUnits() == this->getPredictionUncertaintyUnits()) &&
	 (A.getPredictionTimeUnits() == this->getPredictionTimeUnits()) &&
	 (A.getPredictionTimeUncertaintyUnits() == this->getPredictionTimeUncertaintyUnits()) &&
	 (A.getAppliedRadiusUnits() == this->getAppliedRadiusUnits()) &&
	 (A.getLatitudeUnits() == this->getLatitudeUnits()) &&
	 (A.getLongitudeUnits() == this->getLongitudeUnits()) &&
	 (StaNetChanLoc::operator==((StaNetChanLoc)A)) )
    {
	return true;
    } else {
	return false;
    }
}

bool PGVPrediction::operator!=(const PGVPrediction &A) const
{
    return !(*this==A);
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////





    
    
