/*This Class contains the Event information shared by all Algorithms.
This includes:
-magnitude and error
-latitude and error
-longitude and error
-depth and error
-origin time and error
-likelyhood
*/
#include "CoreEventInfo.h"


    
CoreEventInfo::CoreEventInfo(int i,
			     float mag,
			     float mag_uncer,
			     float lat,
			     float lat_uncer,
			     float lon,
			     float lon_uncer,
			     float dep,
			     float dep_uncer,
			     string o_time,
			     float o_time_uncer,
			     float lklyhd,
			     string mag_units ,
			     string mag_uncer_units,
			     string lat_units,
			     string lat_uncer_units,
			     string lon_units,
			     string lon_uncer_units,
			     string dep_units,
			     string dep_uncer_units,
			     string o_time_units,
			     string o_time_uncer_units
			     ) : id(i),
				 magnitude(mag),
				 magnitude_uncertainty(mag_uncer),
				 latitude(lat),
				 latitude_uncertainty(lat_uncer),
				 longitude(lon),
				 longitude_uncertainty(lon_uncer),
				 depth(dep),
				 depth_uncertainty(dep_uncer),
				 origin_time(o_time),
				 origin_time_uncertainty(o_time_uncer),
				 likelyhood(lklyhd),
				 //////////
				 version(0),
				 sent_flag(false),
				 //////////
				 magnitude_units(mag_units),
				 magnitude_uncertainty_units(mag_uncer_units),
				 latitude_units(lat_units),
				 latitude_uncertainty_units(lat_uncer_units),
				 longitude_units(lon_units),
				 longitude_uncertainty_units(lon_uncer_units),
				 depth_units(dep_units),
				 depth_uncertainty_units(dep_uncer_units),
				 origin_time_units(o_time_units),
				 origin_time_uncertainty_units(o_time_uncer_units) {}
CoreEventInfo::~CoreEventInfo() 
{}

/////////////////////
/////////////////////
//used by DMSender to show that the event has been sent to DecisionModule
void CoreEventInfo::updateSent() 
{
    sent_flag=true;
}
//Called whenever any parameters fo the CoreEventInfo object are changed.
//Also, sent_flag is changed to indicate that Decision Module hasn't 
//updated with the new info
void CoreEventInfo::updateVersion() 
{
    if (sent_flag){
	version++;
	sent_flag=false; 
    }
}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
//VALUES
int CoreEventInfo::setID(int i) {
    if (id != i) {
	id = i;
	updateVersion();
    }
    return id;
}
/*
int CoreEventInfo::setVersion(int ver)
{
    version=ver;
    return ver;
}
*/
//Magnitude, Uncertainty
float CoreEventInfo::setMagnitude(float mag) { 
    if (magnitude != mag) {
	magnitude=mag;
	updateVersion();
    }
    return magnitude;
}
float CoreEventInfo::setMagnitudeUncertainty(float mag_uncer) { 
    if (magnitude_uncertainty != mag_uncer) {
	magnitude_uncertainty=mag_uncer;
	updateVersion();
    }
    return magnitude_uncertainty; 
}
//Latitude, Uncertainty
float CoreEventInfo::setLatitude(float lat) {
    if (latitude != lat) {
	updateVersion();
	latitude=lat;
    }
    return latitude; 
}
float CoreEventInfo::setLatitudeUncertainty(float lat_uncer) { 
    if (latitude_uncertainty != lat_uncer) {
	latitude_uncertainty = lat_uncer;
	updateVersion();
    }
    return latitude_uncertainty; 
}
//Longitude, Uncertainty
float CoreEventInfo::setLongitude(float lon) { 
    if (longitude != lon) {
	longitude = lon;
	updateVersion();
    }
    return longitude; 
}
float CoreEventInfo::setLongitudeUncertainty(float lon_uncer) { 
    if (longitude_uncertainty != lon_uncer) {
	longitude_uncertainty = lon_uncer;
	updateVersion();
    }
    return longitude_uncertainty; 
}
//Depth, Uncertainty
float CoreEventInfo::setDepth(float dep) {
    if (depth != dep) {
	depth = dep;
	updateVersion();
    }
    return depth;
}
float CoreEventInfo::setDepthUncertainty(float dep_uncer) {
    if (depth_uncertainty != dep_uncer) {
	depth_uncertainty = dep_uncer;
	updateVersion();
    }
    return depth_uncertainty;
}
//OriginTime, Uncertainty
//OriginTime string needs to be in format 2999-12-31T24:60:60.0000Z
string CoreEventInfo::setOriginTime(string o_time) { 
    if (origin_time != o_time) {
	origin_time = o_time;
	updateVersion();
    }
    return origin_time;
}
float CoreEventInfo::setOriginTimeUncertainty(float o_time_uncer) { 
    if (origin_time_uncertainty != o_time_uncer) {
	origin_time_uncertainty = o_time_uncer;
	updateVersion();
    }
    return origin_time_uncertainty;
}
float CoreEventInfo::setLikelyhood(float lklyhd) {
    if ((lklyhd >= 0.0) && (lklyhd <= 1.0) && (likelyhood != lklyhd)) {
	likelyhood = lklyhd;
	updateVersion();
    }
    return likelyhood;
}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
//UNITS
string CoreEventInfo::setMagnitudeUnits(string mag_units) {
    if (magnitude_units != mag_units) {
	magnitude_units = mag_units;
	updateVersion();
    }
    return magnitude_units;
}
string CoreEventInfo::setMagnitudeUncertaintyUnits(string mag_uncer_units) {
    if (magnitude_uncertainty_units != mag_uncer_units) {
	magnitude_uncertainty_units = mag_uncer_units;
	updateVersion();
    }
    return magnitude_uncertainty_units;
}
string CoreEventInfo::setLatitudeUnits(string lat_units) {
    if (latitude_units != lat_units) { 
	latitude_units = lat_units;
	updateVersion();
    }
    return latitude_units; 
}
string CoreEventInfo::setLatitudeUncertaintyUnits(string lat_uncer_units) { 
    if (latitude_uncertainty_units != lat_uncer_units) { 
	latitude_uncertainty_units = lat_uncer_units;
	updateVersion();
    }
    return latitude_uncertainty_units; 
}
string CoreEventInfo::setLongitudeUnits(string lon_units) { 
    if (longitude_units != lon_units) { 
	longitude_units = lon_units;
	updateVersion();
    }
    return longitude_units; 
}
string CoreEventInfo::setLongitudeUncertaintyUnits(string lon_uncer_units) { 
    if (longitude_uncertainty_units != lon_uncer_units) {
	longitude_uncertainty_units = lon_uncer_units;
	updateVersion();
    }
    return longitude_uncertainty_units; 
}
string CoreEventInfo::setDepthUnits(string dep_units) {
    if (depth_units != dep_units) {
	depth_units = dep_units;
	updateVersion();
    }
    return depth_units;
}
string CoreEventInfo::setDepthUncertaintyUnits(string dep_uncer_units) {
    if (depth_uncertainty_units != dep_uncer_units) {
	depth_uncertainty_units = dep_uncer_units;
	updateVersion();
    }
    return depth_uncertainty_units;
}
string CoreEventInfo::setOriginTimeUnits(string o_time_units) { 
    if (origin_time_units != o_time_units) {
	origin_time_units = o_time_units;
	updateVersion();
    }
    return origin_time_units;
}
string CoreEventInfo::setOriginTimeUncertaintyUnits(string o_time_uncer_units) { 
    if (origin_time_uncertainty_units != o_time_uncer_units) {
	origin_time_uncertainty_units = o_time_uncer_units;
	updateVersion();
    }
    return origin_time_uncertainty_units;
}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
//addTriggeredStation returns 0 if the same Network.Station.Channel.Location
//are already in the list. It returns 1 if it added the N.S.C.L
/*int CoreEventInfo::addTriggeredStation(const StaNetChanLoc& sncl) {
    for (SNCL_Iter i = triggered_stations.begin(); i != triggered_stations.end(); i++) {
	const StaNetChanLoc& listed_sta = *i;
	if (listed_sta == sncl) {
	    return 0;
	}
    }
    triggered_stations.push_back(sncl);
    updateVersion();
    return 1;
    }*/

/*int CoreEventInfo::addTriggeredStation(string net, string sta, string chan, string loc) {
    StaNetChanLoc sncl(net, sta, chan, loc);
    for (SNCL_Iter i = triggered_stations.begin(); i != triggered_stations.end(); i++) {
	const StaNetChanLoc& listed_sta = *i;
	if (listed_sta == sncl) {
	    return 0;
	}
	}
    triggered_stations.push_back(sncl);
    updateVersion();
    return 1;
    }*/

/*int CoreEventInfo::deleteTriggeredStation(const StaNetChanLoc& sncl) {
    /*int number_erased = 0;
    for (SNCL_Iter i = triggered_stations.begin(); i != triggered_stations.end();) {
	const StaNetChanLoc& listed_sta = *i;
	if (listed_sta == sncl) {
	    triggered_stations.erase(i++);
	    updateVersion();
	} else {
	    ++i;
	}
	
	}*/
//    triggered_stations.remove(sncl);
//    return 1;
//}*/

/*int CoreEventInfo::deleteTriggeredStation(string net, string sta, string chan, string loc) {
    StaNetChanLoc sncl(net, sta, chan, loc);
    triggered_stations.remove(sncl);
    return 1;
}

list<StaNetChanLoc>::const_iterator CoreEventInfo::getTriggeredStationsIteratorBegin() const {
    return triggered_stations.begin();
}

list<StaNetChanLoc>::const_iterator CoreEventInfo::getTriggeredStationsIteratorEnd() const {
    return triggered_stations.end();
    }*/

///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
//Return the protected values of the Event class.
int CoreEventInfo::getID() const{
    return id;
}
int CoreEventInfo::getVersion() const{
    return version;
}
float CoreEventInfo::getMagnitude() const{
    return magnitude; 
}
float CoreEventInfo::getMagnitudeUncertainty() const{
    return magnitude_uncertainty; 
}
float CoreEventInfo::getLatitude() const{
    return latitude; 
}
float CoreEventInfo::getLatitudeUncertainty() const{
    return latitude_uncertainty; 
}
float CoreEventInfo::getLongitude() const{
    return longitude; 
}
float CoreEventInfo::getLongitudeUncertainty() const{ 
    return longitude_uncertainty;
}
float CoreEventInfo::getDepth() const {
    return depth;
}
float CoreEventInfo::getDepthUncertainty() const {
    return depth_uncertainty;
}
string CoreEventInfo::getOriginTime() const {
    return origin_time;
}
float CoreEventInfo::getOriginTimeUncertainty() const {  
    return origin_time_uncertainty;
}
float CoreEventInfo::getLikelyhood() const{
    return likelyhood;
}
/*string CoreEventInfo::getTriggeredStations() const {
    string result="";
    for (SNCL_Iter i = triggered_stations.begin(); i != triggered_stations.end(); i++) {
	const StaNetChanLoc& sncl = *i;
	result = result + sncl.getSNCL() + " ";
    }
    return result;
}
int CoreEventInfo::getNumberTriggeredStations() const {
    int result=0;
    for (SNCL_Iter i = triggered_stations.begin(); i != triggered_stations.end(); i++) {
	result++;
    }
    return result;
    }*/

///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
string CoreEventInfo::getMagnitudeUnits() const{
    return magnitude_units;
}
string CoreEventInfo::getMagnitudeUncertaintyUnits() const{
    return magnitude_uncertainty_units;
}
string CoreEventInfo::getLatitudeUnits() const{
    return latitude_units; 
}
string CoreEventInfo::getLatitudeUncertaintyUnits() const{
    return latitude_uncertainty_units; 
}
string CoreEventInfo::getLongitudeUnits() const{
    return longitude_units; 
}
string CoreEventInfo::getLongitudeUncertaintyUnits() const{ 
    return longitude_uncertainty_units; 
}
string CoreEventInfo::getDepthUnits() const{
    return depth_units; 
}
string CoreEventInfo::getDepthUncertaintyUnits() const{ 
    return depth_uncertainty_units; 
}
string CoreEventInfo::getOriginTimeUnits() const{
    return origin_time_units;
}
string CoreEventInfo::getOriginTimeUncertaintyUnits() const{ 
    return origin_time_uncertainty_units;
}
