#ifndef __DMMessageSender_h
#define __DMMessageSender_h

#include <decaf/lang/Runnable.h>
#include <decaf/util/concurrent/CountDownLatch.h>
#include <activemq/core/ActiveMQConnectionFactory.h>
////#include <activemq/core/ActiveMQConnection.h>
////#include <activemq/transport/DefaultTransportListener.h>
#include <activemq/library/ActiveMQCPP.h>
#include <decaf/lang/Integer.h>
#include <activemq/util/Config.h>
#include <decaf/util/Date.h>
#include <cms/Connection.h>
#include <cms/Session.h>
#include <cms/TextMessage.h>
#include <cms/BytesMessage.h>
#include <cms/MapMessage.h>
#include <cms/ExceptionListener.h>
#include <cms/MessageListener.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <sstream>
#include "ElarmsMessage.h"
#include "OnSiteMessage.h"
#include "VSMessage.h"

//using namespace activemq;
using namespace activemq::core;
//using namespace activemq::transport;
using namespace decaf::lang;
using namespace decaf::util;
using namespace decaf::util::concurrent;
using namespace cms;
using namespace std;

class DMMessageSender : public Runnable
{
 private:
    Connection* connection;
    Session* session;
    Destination* destination;
    MessageProducer* producer;
    bool useTopic;
    bool sessionTransacted;
    std::string brokerURI;
    std::string destinationName;
    enum eewSystemName systemName;
    void cleanup();
    
 public:
    DMMessageSender(const string& brokerURI = "failover:(tcp://localhost:61616)",
		    const string& destinationName = "DecisionModule",
		    bool useTopic = true,
		    bool sessionTransacted = false,
		    enum eewSystemName sysname = ELARMS);
    virtual ~DMMessageSender();
    virtual void run();
    void close();
    int sendString(string s);
    int sendMessage(OnSiteMessage &OSM);
    int sendMessage(VSMessage &VM);
    int sendMessage(ElarmsMessage &EM);
    int sendDeleteMessage(int EventID);
    
};

#endif
