      subroutine fetch_pick(io_res,filen,head,pick,ipick,ierr)
c
c     subroutine will find open pickfile and extract picks for
c     station stat at stime
c
c     input:
c           io_res- io unit to open
c           filen - file containing picks
c           head  - station header structure
c     output:
c           cchan  - chan of pick
c           pid   - pick id
c           pdate    - pick time
c           ierr  - integer error flag
c                 = 0 for picks found
c            = 999 for no picks found
c
      include '/usr/local/include/qlib2.inc'
      record /INT_TIME/ pdate
      record /EXT_TIME/ pt
      include 'station_hdr.inc'
      include 'pick_hdr.inc'
      record /PICK/ pick(100)
c
      character*1 qual, fmotion
      character*3 cchan
      character*4 stat, cstat, pid
      character*256 filen, token, string, string1, string2
      integer*4 io_res, ierr, daymo
c
c     Initialize
c
      ierr = 999
c
      stat  = head.station_id
c
      open(io_res,file=filen)
c
c     read the first 2 lines and ignore them
c
      read(io_res,'(a)') string1
      read(io_res,'(a)') string2
c
      ipick = 0
c
c     loop over the picks in the file
c
100   continue
      read(io_res,'(a)',end=110) string
      call klen(string,kk)
      do ii = 1, kk
        if (string(ii:ii) .eq. ':') then
          string(ii:ii) = ' '
        end if
      end do
c
c     decode various items
c
      is = 0
c
c     station name
c
      call ciptok(string,is,cstat)
      if (cstat .eq. stat) then
          ipick = ipick + 1
c
c         channel
c
          call ciptok(string,is,cchan)
c
c         sample index
c
          call ciptok(string,is,token)
          call cipnum(token,rnum,ierr)
          index = rnum
c
c         pick quality
c
          call ciptok(string,is,qual)
c
c         phase name
c
          call ciptok(string,is,pid)
c
c         time offset
c
          call ciptok(string,is,token)
          call cipnum(token,dtime,ierr)
c
c         first motion
c
          call ciptok(string,is,fmotion)
c
c         time uncertainty
c
          call ciptok(string,is,token)
          call cipnum(token,utime,ierr)
c
c         Now read the actual pick time
c
c         year
c
          call ciptok(string,is,token)
          call cipnum(token,ryr,ierr)
          isyr = ryr
c
c         day of year
c
          call ciptok(string,is,token)
          call cipnum(token,rdy,ierr)
          isdy = rdy
c
c         time
c
          call ciptok(string,is,token)
          call cipnum(token,rshr,ierr)
          ishr = rshr
          call ciptok(string,is,token)
          call cipnum(token,rsmn,ierr)
          ismn = rsmn
          call ciptok(string,is,token)
          call cipnum(token,fsec,ierr)
          issc = int(fsec)
          iusec = (fsec - issc)*usecs_per_sec
c
c         Checking
c
c         print*, stat, chan, pid, isyr, isdy, ishr, ismn, fsec
c
c         Form pick structure
c
          pt.year   = isyr
          pt.doy    = isdy
          ierr = daymo(isdy,pt.month,pt.day,isyr)
          pt.hour   = ishr
          pt.minute = ismn
          pt.second = issc
          pt.usec  = iusec
          call f_ext_to_int(pt,pdate)
c
          pick(ipick).station_id = cstat
          pick(ipick).channel_id = cchan
          pick(ipick).ptime = pdate
          pick(ipick).pid = pid
          pick(ipick).noff = index
          pick(ipick).qual = qual
          pick(ipick).fmotion = fmotion
          ierr = 0
          go to 100
      end if
      go to 100
c
110   continue
c
      close(io_res)
      return
      end
c

c

