	subroutine extra_window(head,id1,t1_time,t2_time,ierr)
c
c     subroutine to check window length
c
c     input:  
c             head    - station/channel header
c             id1      - data array
c             t1_time - desired start time
c             t2_time - desired end time
c     output:  
c             ierr   - error return code
c                      998 if window begins too late
c                      999 if window ends too early
c                      0 otherwise
c
      include '/usr/local/include/qlib2.inc'
      include 'station_hdr.inc'
c
      record /INT_TIME/ beg_time, end_time, t1_time, t2_time
      record /EXT_TIME/ ext_time
c
      integer*4 ierr, npts
      integer*4 id1(*)
      real*4 dt
      real*8 td1, td2
c
c     initialize error return
c
      ierr = 0
c
      npts  = head.num_pts
      dt  = 1.0/head.sample_rate
      beg_time = head.begtime
      end_time = head.endtime
c
c     assume that t2 is later than t1
c
      td1 = f_tdiff(t1_time,beg_time)
      if (td1 .lt. 0.d0) then
        ierr = 998
        return
      end if
      td2 = f_tdiff(end_time, t2_time)
      if (td2 .lt. 0.d0) then
        ierr = 999
        return
      end if
c
c     data brackets the desired time window
c
      td2 = f_tdiff(t2_time,beg_time)
c
      t1 = td1/usecs_per_sec
      t2 = td2/usecs_per_sec
      n1 = int(t1/dt) + 1
      n2 = int(t2/dt) + 1
c
      kk = 0
      do jj = n1, n2
        kk = kk + 1
        id1(kk) = id1(jj)
      end do
c
      head.begtime = t1_time
      head.endtime = t2_time
      head.num_pts = kk
c
c     all done
c
      return
      end
