/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.alomax.io.GeneralInputStream;

public class HelpFrame
extends Frame
implements ActionListener,
KeyListener {
    private static boolean GENERATE_HTML = false;
    protected ResourceBundle resourceBundle;
    protected Vector<String> nameVector = new Vector();
    protected Vector<String> textVector = new Vector();
    protected Vector<JButton> buttonVector = new Vector();
    protected JTextArea textArea;
    protected JPanel contentsPanel = new JPanel();
    protected JLabel messagePanel = new JLabel();
    protected JLabel contentsLabel = new JLabel();
    protected JButton activeButton = null;

    public HelpFrame(String string, int n, int n2, Class clazz, URL uRL, String string2, Locale locale, Image image) {
        super(string);
        if (image != null) {
            // empty if block
        }
        this.setIconImage(image);
        String string3 = "";
        if (locale != null && (string3 = locale.toString()).endsWith("_ ")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        String string4 = string2 + "_" + string3 + ".properties";
        String string5 = "";
        InputStream inputStream = clazz.getResourceAsStream(string4);
        if (inputStream == null) {
            try {
                inputStream = GeneralInputStream.openStream(uRL, string4, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4 + "\n";
            string4 = string2 + "_" + locale.getDefault().toString() + ".properties";
            inputStream = clazz.getResourceAsStream(string4);
            if (inputStream == null) {
                try {
                    inputStream = GeneralInputStream.openStream(uRL, string4, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4 + "\n";
            string4 = string2 + ".properties";
            inputStream = clazz.getResourceAsStream(string4);
            if (inputStream == null) {
                try {
                    inputStream = GeneralInputStream.openStream(uRL, string4, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (inputStream == null) {
            string5 = string5 + "ERROR: opening help text file: " + string4;
            System.out.println(string5);
            this.dispose();
            return;
        }
        try {
            this.resourceBundle = new PropertyResourceBundle(inputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            string5 = "ERROR: creating help text resource bunde : " + string2;
            System.out.println(string5);
            this.dispose();
            return;
        }
        this.setContentsPanel(this.contentsPanel);
        if (GENERATE_HTML) {
            this.generateHtml("HelpFrame.html", string);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add("North", this.messagePanel);
        this.textArea = new JTextArea(" ", 0, 0);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add("Center", jScrollPane);
        this.setLayout(new BorderLayout(0, 0));
        this.add("West", this.contentsPanel);
        this.add("Center", jPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpFrame.this.dispose();
            }
        });
        if (this.textVector.size() > 0) {
            this.writeMessage(this.nameVector.elementAt(0) + ":");
            this.textArea.setText(this.textVector.elementAt(0));
            this.selectButton(this.buttonVector.elementAt(0));
        } else {
            this.writeMessage("ERROR: No help documentation found.");
        }
        this.setSize(n, n2);
    }

    private void setContentsPanel(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        try {
            this.contentsLabel.setText(" " + this.resourceBundle.getString("text.contents") + ":");
        }
        catch (MissingResourceException missingResourceException) {
            this.contentsLabel.setText("Contents:");
        }
        int n = 0;
        while (true) {
            String string;
            String string2;
            try {
                string2 = this.resourceBundle.getString("name." + n);
            }
            catch (MissingResourceException missingResourceException) {
                break;
            }
            try {
                string = this.resourceBundle.getString("text." + n);
            }
            catch (MissingResourceException missingResourceException) {
                string = "???";
            }
            this.nameVector.addElement(string2);
            this.textVector.addElement(string);
            JButton jButton = new JButton(string2);
            jButton.addActionListener(this);
            jButton.addKeyListener(this);
            jPanel.add(jButton);
            this.buttonVector.addElement(jButton);
            ++n;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        for (JButton jButton : this.buttonVector) {
            jButton.setFont(font2);
            jButton.repaint();
        }
        if (this.contentsLabel != null) {
            this.contentsLabel.setFont(font2);
        }
        if (this.messagePanel != null) {
            this.messagePanel.setFont(new Font(font.getName(), 1, 4 * font.getSize() / 3));
        }
        if (this.textArea != null) {
            this.textArea.setFont(new Font(font.getName(), 0, 4 * font.getSize() / 3));
        }
    }

    protected void selectButton(JButton jButton) {
        this.activeButton = jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.buttonVector.size(); ++i) {
            if (!actionEvent.getSource().equals(this.buttonVector.elementAt(i))) continue;
            this.selectButton(this.buttonVector.elementAt(i));
            this.writeMessage(this.nameVector.elementAt(i) + ":");
            this.textArea.setText(this.textVector.elementAt(i));
            this.textArea.setCaretPosition(0);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void writeMessageToConsole(String string) {
        System.out.println(string);
    }

    void writeMessage(String string) {
        this.messagePanel.setText(" " + string);
    }

    public void generateHtmlSimple(String string, String string2) {
        System.out.println("INFO: generating HelpFrame HTML (" + string + ")");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html lang=\"en\">\n<head>\n<meta charset=\"utf-8\">\n    <title>" + string2 + " - " + this.contentsLabel.getText() + "</title>\n  <style>\n<!--\nBODY {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: small; color: #3333AA; background-color: #FFFFFF}\nP {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\ncolor: #3333AA; background-color: #FFFFFF}\nH1 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: x-large;\n\tfont-weight: bold; color: #3333AA; }\nH2 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: large;\n\tfont-weight: bold; color: #3333AA; }\nH3 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tfont-weight: bold; color: #3333AA; }\nTH {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tfont-weight: bold; color: #3333AA; }\nTD {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tcolor: #3333AA; }\nCODE {font-family: Monospaced; font-size: medium; font-weight: bold; color: #000000; }\nDIV.box {background: #FFFFFF; padding: 1.0em; border: none; width: 100%;\n\tmargin-top: 0.75em; margin-bottom: 0.75em; margin-left: 3%; margin-right: 3%;\n\tfont-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tcolor: #3333AA; }\n-->\n  </style>\n</head>\n");
            fileWriter.write("<body\n style=\"color: rgb(51, 51, 170); background-color: rgb(255, 255, 255);\"\n alink=\"#00ff00\" link=\"#cc0000\" vlink=\"#990099\">\n");
            fileWriter.write("<h1>" + string2 + "</h1>\n<h2>\n");
            for (String string3 : this.nameVector) {
                fileWriter.write("<a href=\"#_" + string3 + "\">" + string3 + "</a><br>\n");
            }
            for (String string3 : this.nameVector) {
                fileWriter.write("<a name=\"_" + string3 + "\"></a>\n<h1>" + string3 + "<br></h1>\n<p>\n" + this.textVector.elementAt(this.nameVector.indexOf(string3)).replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "\n<br>\n") + "\n</p>\n");
            }
            fileWriter.write("</body>\n</html>\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(HelpFrame.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void generateHtml(String string, String string2) {
        System.out.println("INFO: generating HelpFrame HTML (" + string + ")");
        try {
            new File(string).mkdir();
            String string3 = "help.css";
            String string4 = string + File.separator + "help.css";
            FileWriter fileWriter = new FileWriter(string4);
            this.writeCSS(fileWriter);
            fileWriter.close();
            String string5 = string + File.separator + "index.html";
            FileWriter fileWriter2 = new FileWriter(string5);
            this.writeHTMLstart(fileWriter2, this.contentsLabel.getText(), string3);
            fileWriter2.write("<h1>" + string2 + "</h1>\n<h2>\n");
            String string6 = "html";
            String string7 = string + File.separator + string6;
            new File(string7).mkdir();
            for (String string8 : this.nameVector) {
                fileWriter2.write("<a href=\"" + this.createHTMLname(string6, string8) + "\">" + string8 + "</a><br>\n");
            }
            string3 = "../" + string3;
            for (String string8 : this.nameVector) {
                FileWriter fileWriter3 = new FileWriter(this.createHTMLname(string7, string8));
                this.writeHTMLstart(fileWriter3, string8, string3);
                fileWriter3.write("<h1>" + string8 + "<br></h1>\n<p>\n" + this.textVector.elementAt(this.nameVector.indexOf(string8)).replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "\n<br>\n") + "\n</p>\n");
                this.writeHTMLend(fileWriter3);
                fileWriter3.close();
            }
            this.writeHTMLend(fileWriter2);
            fileWriter2.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(HelpFrame.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public String cleanFileName(String string) {
        return string.replaceAll("[^a-zA-Z0-9.-]", "_");
    }

    public String createHTMLname(String string, String string2) {
        return string + File.separator + this.cleanFileName(string2) + ".html";
    }

    public void writeCSS(FileWriter fileWriter) throws IOException {
        fileWriter.write("<style>\n<!--\nBODY {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: small; color: #3333AA; background-color: #FFFFFF}\nP {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\ncolor: #3333AA; background-color: #FFFFFF}\nH1 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: x-large;\n\tfont-weight: bold; color: #3333AA; }\nH2 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: large;\n\tfont-weight: bold; color: #3333AA; }\nH3 {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tfont-weight: bold; color: #3333AA; }\nTH {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tfont-weight: bold; color: #3333AA; }\nTD {font-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tcolor: #3333AA; }\nCODE {font-family: Monospaced; font-size: medium; font-weight: bold; color: #000000; }\nDIV.box {background: #FFFFFF; padding: 1.0em; border: none; width: 100%;\n\tmargin-top: 0.75em; margin-bottom: 0.75em; margin-left: 3%; margin-right: 3%;\n\tfont-family: Arial, Helvetica, Verdana, sans-serif; font-size: medium;\n\tcolor: #3333AA; }\n-->\n  </style>\n");
    }

    public void writeHTMLstart(FileWriter fileWriter, String string, String string2) throws IOException {
        fileWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html lang=\"en\">\n<head>\n<meta charset=\"utf-8\">\n    <title>" + string + " - " + string + "</title>\n<link rel=\"stylesheet\" href=\"" + string2 + "\">\n</head>\n<body>\n");
    }

    public void writeHTMLend(FileWriter fileWriter) throws IOException {
        fileWriter.write("</body>\n</html>\n");
    }

    public void generateJavaHelp(String string, String string2, String string3) {
        System.out.println("INFO: generating JavaHelp (" + string + ")");
        try {
            new File(string).mkdir();
            String string4 = "help.css";
            String string5 = string + File.separator + string4;
            FileWriter fileWriter = new FileWriter(string5);
            this.writeCSS(fileWriter);
            fileWriter.close();
            this.writeJavaHelpFile_hs(string, string3, string2);
            String string6 = string + File.separator + string2 + ".hhc";
            FileWriter fileWriter2 = new FileWriter(string6);
            this.writeJavaHelpFile_hhc_start(fileWriter2);
            String string7 = "html";
            String string8 = string + File.separator + string7;
            new File(string8).mkdir();
            this.writeJavaHelpFile_hhc_UL_start(fileWriter2);
            for (String string9 : this.nameVector) {
                String string10 = this.textVector.elementAt(this.nameVector.indexOf(string9));
                String string11 = "html" + File.separator + this.cleanFileName(string9);
                String string12 = string + File.separator + string11;
                new File(string12).mkdir();
                String string13 = "../" + string4;
                String string14 = "../" + string13;
                String[] stringArray = string10.split("==SPLIT0==");
                int n = 0;
                for (String string15 : stringArray) {
                    Object object;
                    String string16;
                    String string17;
                    String string18;
                    if (n == 0) {
                        string18 = string9;
                        string17 = string15;
                        string16 = string14;
                    } else {
                        object = string15.split("==SPLIT1==");
                        string18 = object[0];
                        string17 = object[1];
                        string16 = string14;
                    }
                    this.writeJavaHelpFile_hhc_LI_item(fileWriter2, string18, this.createHTMLname(string11, string18));
                    if (n == 0) {
                        this.writeJavaHelpFile_hhc_UL_start(fileWriter2);
                    }
                    object = new FileWriter(this.createHTMLname(string12, string18));
                    this.writeHTMLstart((FileWriter)object, string18, string16);
                    string17 = string17.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "\n<br>\n");
                    string17 = this.replaceQuotesWithStrong(string17);
                    ((Writer)object).write("<h1>" + string18 + "<br></h1>\n<p>\n" + string17 + "\n</p>\n");
                    this.writeHTMLend((FileWriter)object);
                    ((OutputStreamWriter)object).close();
                    ++n;
                }
                this.writeJavaHelpFile_hhc_UL_end(fileWriter2);
            }
            this.writeJavaHelpFile_hhc_UL_end(fileWriter2);
            this.writeJavaHelpFile_hhc_end(fileWriter2);
            fileWriter2.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(HelpFrame.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void writeJavaHelpFile_hs(String string, String string2, String string3) throws IOException {
        FileWriter fileWriter = new FileWriter(string + File.separator + string3 + ".hs");
        fileWriter.write("<?xml version = '1.0' encoding = 'ISO-8859-1'?>\n\n<helpset>\n\n<title>" + string2 + "</title>\n\n<maps>\n   <mapref location=\"" + string3 + ".oht\"/>\n</maps>\n\n<links>\n</links>\n\n<view>\n   <title>" + string2 + "</title>\n   <type>oracle.help.navigator.tocNavigator.TOCNavigator</type>\n   <data engine=\"oracle.help.engine.HHCEngine\">" + string3 + ".hhc</data>\n</view>\n\n  <!--\n<view>\n   <title>" + string2 + "</title>\n   <type>oracle.help.navigator.keywordNavigator.KeywordNavigator</type>\n   <data engine=\"oracle.help.engine.HHKEngine\">" + string3 + ".hhk</data>\n</view>\n  -->\n\n  <!--\n<view>\n   <title>" + string2 + "</title>\n   <type>oracle.help.navigator.searchNavigator.SearchNavigator</type>\n   <data engine=\"oracle.help.engine.SearchEngine\">" + string3 + ".idx</data>\n</view>\n  -->\n\n\n</helpset>\n");
        fileWriter.close();
    }

    public void writeJavaHelpFile_hhc_start(FileWriter fileWriter) throws IOException {
        fileWriter.write("<html>\n<!Sitemap 1.0>\n<object type=\"text/site properties\">\n    <param name=\"FrameName\" value=\"right\">\n    </object>\n");
    }

    public void writeJavaHelpFile_hhc_UL_start(FileWriter fileWriter) throws IOException {
        fileWriter.write("<ul>\n");
    }

    public void writeJavaHelpFile_hhc_UL_end(FileWriter fileWriter) throws IOException {
        fileWriter.write("</ul>\n");
    }

    public void writeJavaHelpFile_hhc_LI_item(FileWriter fileWriter, String string, String string2) throws IOException {
        fileWriter.write("<li><object type=\"text/sitemap\">\n    <param name=\"Name\" value=\"" + string + "\">\n    <param name=\"Local\" value=\"" + string2 + "\">\n    </object>\n");
    }

    public void writeJavaHelpFile_hhc_end(FileWriter fileWriter) throws IOException {
        fileWriter.write("</html>\n");
    }

    public String replaceQuotesWithStrong(String string) {
        while (string.contains("\"")) {
            string = string.replaceFirst("\"", "<strong>");
            string = string.replaceFirst("\"", "</strong>");
        }
        return string;
    }
}

