/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.geog.AzimuthalEquidistant;
import net.alomax.geog.EarthEllipsoid;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.Position;
import net.alomax.geog.TransverseMercator;
import net.alomax.graphics3d.Vect2D;
import net.alomax.graphics3d.Vect3D;
import sdsu.io.ASCIIInputStream;

public class GeogCoords {
    protected static final String ProgName = "GeogCoords: ";
    public boolean splitLastAtCentralMeridan = false;
    public static final double PI_2 = Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;
    protected double EQ_RAD;
    protected double ECC;
    protected double ECC2;
    protected double ECC4;
    protected double ECC6;
    protected double M_PR_DEG;
    protected boolean NorthPole;
    protected double CentralMeridian;
    protected double Pole;
    protected double LambertConfConic_N;
    protected double LambertConfConic_F;
    protected double LambertConfConic_rho0;
    protected static final int N_ELLIPSOIDS = 15;
    protected static EarthEllipsoid[] ellipse = new EarthEllipsoid[15];
    public int transformType = -1;
    public boolean initialized = false;
    public static final int GLOBAL = 1;
    public static final int NONE = 0;
    protected String transformName = "UNDEF";
    protected double latOrig = 0.0;
    protected double longOrig = 0.0;
    protected double rotAngle = 0.0;
    protected boolean useFalseEasting = false;
    protected double transCos = 0.0;
    protected double transSin = 0.0;
    protected String refEllipsoid;
    protected static final int SIMPLE = 2;
    protected double C111 = 111.11111111111111;
    protected boolean convergence = true;
    protected static final int LAMBERT = 3;
    protected double Lambert1stStdParall = -100.0;
    protected double Lambert2ndStdParall = -100.0;
    protected static final int TRANS_MERC = 4;
    protected static final int AZIMUTHAL_EQUIDIST = 5;
    protected static final int SDC = 6;
    public static final double MAP_TRANS_SDC_DRLT = 0.99330647;
    protected double map_sdc_xltkm;
    protected double map_sdc_xlnkm;
    protected static final int MERCATOR = 7;
    protected double Mercator_j_x;
    protected double Mercato_j_ix;
    protected double Mercator_yshift;
    protected TransverseMercator transverseMercator = new TransverseMercator();
    protected double map_scale_factor = 1.0;
    protected AzimuthalEquidistant azimuthalEquidistant = new AzimuthalEquidistant();

    static double d_log(double d) {
        return d <= 0.0 ? -1.0E10 : Math.log(d);
    }

    static double d_sqrt(double d) {
        return d < 0.0 ? 0.0 : Math.sqrt(d);
    }

    public GeogCoords() {
        this.transformType = 1;
        this.initialized = true;
    }

    public GeogCoords(double d, double d2, double d3, boolean bl) {
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d3;
        this.convergence = bl;
        this.transformName = bl ? "SIMPLE" : "EQUIRECTANGULAR";
        this.init();
    }

    public GeogCoords(double d, double d2, double d3) {
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d3;
        this.convergence = true;
        this.transformName = "SIMPLE";
        this.init();
    }

    public GeogCoords(String string, double d, double d2, double d3, double d4, double d5) {
        this.transformName = this.transformName;
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d5;
        this.refEllipsoid = string;
        this.Lambert1stStdParall = d3;
        this.Lambert2ndStdParall = d4;
        this.transformName = "LAMBERT";
        this.init();
    }

    public GeogCoords(ASCIIInputStream aSCIIInputStream) {
        try {
            this.transformName = aSCIIInputStream.readWord();
            if (!this.transformName.equals("GLOBAL") && !this.transformName.equals("NONE")) {
                if (this.transformName.equals("SDC") || this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
                    String string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                    this.convergence = !this.transformName.equals("EQUIRECTANGULAR");
                } else if (this.transformName.equals("MERCATOR")) {
                    String string = aSCIIInputStream.readWord();
                    this.refEllipsoid = aSCIIInputStream.readWord();
                    string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                } else if (this.transformName.equals("LAMBERT")) {
                    String string = aSCIIInputStream.readWord();
                    this.refEllipsoid = aSCIIInputStream.readWord();
                    string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.Lambert1stStdParall = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.Lambert2ndStdParall = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                } else if (this.transformName.equals("TRANS_MERC")) {
                    String string = aSCIIInputStream.readWord();
                    this.refEllipsoid = aSCIIInputStream.readWord();
                    string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                    try {
                        string = aSCIIInputStream.readWord();
                        this.useFalseEasting = aSCIIInputStream.readInt() == 1;
                    }
                    catch (Exception exception) {
                        this.useFalseEasting = false;
                    }
                } else if (this.transformName.equals("AZIMUTHAL_EQUIDIST")) {
                    String string = aSCIIInputStream.readWord();
                    this.refEllipsoid = aSCIIInputStream.readWord();
                    string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR: reading geographic coordinates transform.");
        }
        this.init();
    }

    protected void init() {
        if (this.transformName.equals("GLOBAL")) {
            this.transformType = 1;
            this.initialized = true;
        } else if (this.transformName.equals("NONE")) {
            this.transformType = 0;
            this.initialized = true;
        } else if (this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            this.transformType = 2;
            this.initialized = true;
        } else if (this.transformName.equals("MERCATOR")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.CentralMeridian = this.longOrig;
                this.Mercator_j_x = Math.cos(this.latOrig * (Math.PI / 180)) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.sin(this.latOrig * (Math.PI / 180)) * Math.sin(this.latOrig * (Math.PI / 180))) * this.EQ_RAD;
                this.Mercato_j_ix = 1.0 / this.Mercator_j_x;
                this.Mercator_yshift = 0.0;
                Vect2D vect2D = this.merc_sph(this.latOrig, this.longOrig);
                this.Mercator_yshift = vect2D.y;
                this.transformType = 7;
                this.initialized = true;
            }
        } else if (this.transformName.equals("SDC")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            double d = Math.atan(0.99330647 * Math.tan(this.latOrig * (Math.PI / 180)));
            double d2 = Math.atan(0.99330647 * Math.tan((this.latOrig + 1.0) * (Math.PI / 180)));
            double d3 = d2 - d;
            double d4 = GeogConstants.PLANET_RADIUS * (1.0 - Math.pow(Math.sin(d), 2.0) * GeogConstants.PLANET_FLATTENING);
            this.map_sdc_xltkm = d4 * d3;
            d3 = Math.acos(1.0 - (1.0 - Math.cos(Math.PI / 180)) * Math.pow(Math.cos(d), 2.0));
            double d5 = d4 * d3;
            this.map_sdc_xlnkm = d5 / Math.cos(d);
            this.transformType = 6;
            this.initialized = true;
        } else if (this.transformName.equals("LAMBERT")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vlamb(this.latOrig, this.longOrig, this.Lambert1stStdParall, this.Lambert2ndStdParall);
                this.transformType = 3;
                this.initialized = true;
            }
        } else if (this.transformName.equals("TRANS_MERC")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vtm(this.latOrig, this.longOrig, this.useFalseEasting);
                this.transformType = 4;
                this.initialized = true;
            }
        } else if (this.transformName.equals("AZIMUTHAL_EQUIDIST")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vazeqdist(this.latOrig, this.longOrig);
                this.transformType = 5;
                this.initialized = true;
            }
        } else {
            System.out.println("GeogCoords: ERROR: unrecognized geographic tranform type: <" + this.transformName + ">");
        }
    }

    public String getTransformName() {
        return this.transformName;
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    public boolean isGlobal() {
        return this.transformType == 1;
    }

    protected int mapSetup(String string) {
        int n;
        for (n = 0; n < ellipse.length && !string.equals(GeogCoords.ellipse[n].name); ++n) {
        }
        if (n == 15) {
            return -1;
        }
        this.EQ_RAD = GeogCoords.ellipse[n].eq_radius;
        double d = GeogCoords.ellipse[n].flattening;
        this.ECC2 = 2.0 * d - d * d;
        this.ECC4 = this.ECC2 * this.ECC2;
        this.ECC6 = this.ECC2 * this.ECC4;
        this.ECC = GeogCoords.d_sqrt(this.ECC2);
        return n;
    }

    protected void vlamb(double d, double d2, double d3, double d4) {
        this.NorthPole = d > 0.0;
        this.Pole = this.NorthPole ? 90.0 : -90.0;
        double d5 = Math.tan(0.7853981633974483 - 0.5 * (d3 *= Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d3)) / (1.0 + this.ECC * Math.sin(d3)), 0.5 * this.ECC);
        double d6 = Math.cos(d3) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.pow(Math.sin(d3), 2.0));
        double d7 = Math.tan(0.7853981633974483 - 0.5 * (d4 *= Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d4)) / (1.0 + this.ECC * Math.sin(d4)), 0.5 * this.ECC);
        double d8 = Math.cos(d4) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.pow(Math.sin(d4), 2.0));
        double d9 = Math.tan(0.7853981633974483 - 0.5 * d * (Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d * (Math.PI / 180))) / (1.0 + this.ECC * Math.sin(d * (Math.PI / 180))), 0.5 * this.ECC);
        this.LambertConfConic_N = d3 != d4 ? (GeogCoords.d_log(d6) - GeogCoords.d_log(d8)) / (GeogCoords.d_log(d5) - GeogCoords.d_log(d7)) : Math.sin(d3);
        this.LambertConfConic_F = d6 / (this.LambertConfConic_N * Math.pow(d5, this.LambertConfConic_N));
        this.CentralMeridian = d2;
        this.LambertConfConic_rho0 = this.EQ_RAD * this.LambertConfConic_F * Math.pow(d9, this.LambertConfConic_N);
    }

    public Vect2D xy2geog(double d, double d2) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            System.out.println("GeogCoords ERROR: Cannot convert x,y to GLOBAL geographic conversion.");
            return new Vect2D(0.0, 0.0);
        }
        if (this.transformType == 0) {
            return new Vect2D(d2, d);
        }
        if (this.transformType == 2) {
            double d3 = d * this.transCos + d2 * this.transSin;
            double d4 = d2 * this.transCos - d * this.transSin;
            double d5 = this.latOrig + d4 / this.C111;
            double d6 = 0.0;
            d6 = this.convergence ? this.longOrig + d3 / (this.C111 * Math.cos(Math.PI / 180 * d5)) : this.longOrig + d3 / this.C111;
            return new Vect2D(d5, d6);
        }
        if (this.transformType == 7) {
            return this.imerc_sph(d, d2);
        }
        if (this.transformType == 6) {
            double d7 = d * this.transCos + d2 * this.transSin;
            double d8 = d2 * this.transCos - d * this.transSin;
            double d9 = this.latOrig + (d8 /= this.map_sdc_xltkm);
            double d10 = Math.atan(0.99330647 * Math.tan(Math.PI / 180 * (d9 + this.latOrig) / 2.0));
            double d11 = this.longOrig + (d7 /= this.map_sdc_xlnkm * Math.cos(d10));
            return new Vect2D(d9, d11);
        }
        if (this.transformType == 3) {
            return this.ilamb(d, d2);
        }
        if (this.transformType == 4) {
            return this.itm(d, d2);
        }
        if (this.transformType == 5) {
            return this.iazeqdist(d, d2);
        }
        return new Vect2D(0.0, 0.0);
    }

    public Vect2D geog2xy(double d, double d2) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d3 = Math.sin(d * (Math.PI / 180));
            double d4 = Math.cos(d2 * (Math.PI / 180));
            double d5 = Math.sin(d2 * (Math.PI / 180));
            double d6 = GeogConstants.PLANET_RADIUS * d4 * d3;
            double d7 = GeogConstants.PLANET_RADIUS * d5 * d3;
            return new Vect2D(d6, d7);
        }
        if (this.transformType == 0) {
            return new Vect2D(d2, d);
        }
        if (this.transformType == 2) {
            double d8 = d2 - this.longOrig;
            this.splitLastAtCentralMeridan = false;
            if (d8 > 180.0) {
                d8 -= 360.0;
                this.splitLastAtCentralMeridan = true;
            }
            if (d8 < -180.0) {
                d8 += 360.0;
                this.splitLastAtCentralMeridan = true;
            }
            double d9 = 0.0;
            d9 = this.convergence ? Math.cos(Math.PI / 180 * d) * d8 * this.C111 : d8 * this.C111;
            double d10 = (d - this.latOrig) * this.C111;
            double d11 = d9 * this.transCos - d10 * this.transSin;
            double d12 = d10 * this.transCos + d9 * this.transSin;
            return new Vect2D(d11, d12);
        }
        if (this.transformType == 7) {
            return this.merc_sph(d, d2);
        }
        if (this.transformType == 6) {
            double d13 = d2 - this.longOrig;
            if (d13 > 180.0) {
                d13 -= 360.0;
            }
            if (d13 < -180.0) {
                d13 += 360.0;
            }
            double d14 = d - this.latOrig;
            double d15 = Math.atan(0.99330647 * Math.tan(Math.PI / 180 * (d + this.latOrig) / 2.0));
            d13 = d13 * this.map_sdc_xlnkm * Math.cos(d15);
            double d16 = d13 * this.transCos - (d14 *= this.map_sdc_xltkm) * this.transSin;
            double d17 = d14 * this.transCos + d13 * this.transSin;
            return new Vect2D(d16, d17);
        }
        if (this.transformType == 3) {
            return this.lamb(d, d2);
        }
        if (this.transformType == 4) {
            return this.tm(d, d2);
        }
        if (this.transformType == 5) {
            return this.azeqdist(d, d2);
        }
        return new Vect2D(0.0, 0.0);
    }

    public Vect3D xyz2geog(Vect3D vect3D) {
        return this.xyz2geog(vect3D.x, vect3D.y, vect3D.z);
    }

    public Vect3D xyz2geog(double d, double d2, double d3) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            double d5 = Math.asin(d3 / d4);
            double d6 = Math.atan2(d2, d);
            d5 /= Math.PI / 180;
            if ((d6 /= Math.PI / 180) > 180.0) {
                d6 -= 360.0;
            } else if (d6 < -180.0) {
                d6 += 360.0;
            }
            return new Vect3D(d5, d6, GeogConstants.PLANET_RADIUS - d4);
        }
        return new Vect3D(this.xy2geog(d, d2), -d3);
    }

    public Vect3D geog2xyz(Vect3D vect3D) {
        return this.geog2xyz(vect3D.x, vect3D.y, vect3D.z);
    }

    public Vect3D geog2xyz(Position position) {
        return this.geog2xyz(position.latitude, position.longitude, position.depth - position.elevation / 1000.0);
    }

    public Vect3D geog2xyz(double d, double d2, double d3) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d4 = Math.cos(d * (Math.PI / 180));
            double d5 = Math.sin(d * (Math.PI / 180));
            double d6 = Math.cos(d2 * (Math.PI / 180));
            double d7 = Math.sin(d2 * (Math.PI / 180));
            double d8 = (GeogConstants.PLANET_RADIUS - d3) * d6 * d4;
            double d9 = (GeogConstants.PLANET_RADIUS - d3) * d7 * d4;
            double d10 = (GeogConstants.PLANET_RADIUS - d3) * d5;
            return new Vect3D(d8, d9, d10);
        }
        return new Vect3D(this.geog2xy(d, d2), -d3);
    }

    public double geogAng2xyAng(double d) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 2 || this.transformType == 6 || this.transformType == 3 || this.transformType == 4 || this.transformType == 5) {
            double d2 = d + this.rotAngle;
            if (d2 > 360.0) {
                d2 -= 360.0;
            }
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            return d2;
        }
        return d;
    }

    public double xyAng2geogAng(double d) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 2 || this.transformType == 6 || this.transformType == 3 || this.transformType == 4 || this.transformType == 5) {
            double d2 = d - this.rotAngle;
            if (d2 > 360.0) {
                d2 -= 360.0;
            }
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            return d2;
        }
        return d;
    }

    public Vect2D merc_sph(double d, double d2) {
        double d3;
        double d4 = d;
        for (d3 = d2 - this.CentralMeridian; d3 < -180.0; d3 += 360.0) {
        }
        while (d3 > 180.0) {
            d3 -= 360.0;
        }
        double d5 = this.Mercator_j_x * (Math.PI / 180) * d3;
        double d6 = Math.abs(d4) < 90.0 ? this.Mercator_j_x * GeogCoords.d_log(Math.tan((45.0 + 0.5 * d4) * (Math.PI / 180))) : Math.copySign(Double.MAX_VALUE, d4);
        double d7 = d5 * this.transCos - d6 * this.transSin;
        double d8 = d6 * this.transCos + d5 * this.transSin;
        d8 /= 1000.0;
        return new Vect2D(d7 /= 1000.0, d8 -= this.Mercator_yshift);
    }

    public Vect2D imerc_sph(double d, double d2) {
        d2 += this.Mercator_yshift;
        double d3 = (d *= 1000.0) * this.transCos + (d2 *= 1000.0) * this.transSin;
        double d4 = d2 * this.transCos - d * this.transSin;
        double d5 = d3 * this.Mercato_j_ix * 57.29577951308232 + this.CentralMeridian;
        double d6 = Math.atan(Math.sinh(d4 * this.Mercato_j_ix)) * 57.29577951308232;
        return new Vect2D(d6, d5);
    }

    public Vect2D lamb(double d, double d2) {
        double d3 = d2;
        double d4 = d;
        this.splitLastAtCentralMeridan = false;
        while (d3 - this.CentralMeridian < -180.0) {
            d3 += 360.0;
            this.splitLastAtCentralMeridan = true;
        }
        while (d3 - this.CentralMeridian > 180.0) {
            d3 -= 360.0;
            this.splitLastAtCentralMeridan = true;
        }
        double d5 = Math.pow((1.0 - this.ECC * Math.sin(d4 *= Math.PI / 180)) / (1.0 + this.ECC * Math.sin(d4)), 0.5 * this.ECC);
        double d6 = Math.tan(0.7853981633974483 - 0.5 * d4);
        if (Math.abs(d6) < Double.MIN_VALUE) {
            d6 = 0.0;
        }
        double d7 = d6 == 0.0 ? 0.0 : Math.pow(d6 / d5, this.LambertConfConic_N);
        double d8 = this.EQ_RAD * this.LambertConfConic_F * d7;
        double d9 = this.LambertConfConic_N * (d3 - this.CentralMeridian) * (Math.PI / 180);
        double d10 = d8 * Math.sin(d9);
        double d11 = this.LambertConfConic_rho0 - d8 * Math.cos(d9);
        double d12 = d10 * this.transCos - d11 * this.transSin;
        double d13 = d11 * this.transCos + d10 * this.transSin;
        return new Vect2D(d12 / 1000.0, d13 / 1000.0);
    }

    public Vect2D ilamb(double d, double d2) {
        double d3 = (d *= 1000.0) * this.transCos + (d2 *= 1000.0) * this.transSin;
        double d4 = d2 * this.transCos - d * this.transSin;
        double d5 = Math.atan(d3 / (this.LambertConfConic_rho0 - d4));
        double d6 = d5 / this.LambertConfConic_N * 57.29577951308232 + this.CentralMeridian;
        double d7 = d3 * d3 + (this.LambertConfConic_rho0 - d4) * (this.LambertConfConic_rho0 - d4);
        double d8 = this.LambertConfConic_N < 0.0 ? -Math.sqrt(d7) : Math.sqrt(d7);
        double d9 = Math.pow(d8 / (this.EQ_RAD * this.LambertConfConic_F), 1.0 / this.LambertConfConic_N);
        double d10 = 1.5707963267948966 - 2.0 * Math.atan(d9);
        double d11 = 1.0;
        double d12 = 0.0;
        for (int i = 0; i < 100 && d11 > 1.0E-8; ++i) {
            d7 = (1.0 - this.ECC * Math.sin(d10)) / (1.0 + this.ECC * Math.sin(d10));
            d12 = 1.5707963267948966 - 2.0 * Math.atan(d9 * Math.pow(d7, 0.5 * this.ECC));
            d11 = Math.abs(Math.abs(d10) - Math.abs(d12));
            d10 = d12;
        }
        double d13 = d12 * 57.29577951308232;
        return new Vect2D(d13, d6);
    }

    protected void vtm(double d, double d2, boolean bl) {
        double d3 = (1.0 - GeogCoords.d_sqrt(1.0 - this.ECC2)) / (1.0 + GeogCoords.d_sqrt(1.0 - this.ECC2));
        this.transverseMercator.t_e2 = this.ECC2 / (1.0 - this.ECC2);
        this.transverseMercator.t_c1 = 1.0 - 0.25 * this.ECC2 - 3.0 * this.ECC4 / 64.0 - 5.0 * this.ECC6 / 256.0;
        this.transverseMercator.t_c2 = 3.0 * this.ECC2 / 8.0 + 3.0 * this.ECC4 / 32.0 + 45.0 * this.ECC6 / 1024.0;
        this.transverseMercator.t_c3 = 15.0 * this.ECC4 / 256.0 + 45.0 * this.ECC6 / 1024.0;
        this.transverseMercator.t_c4 = 35.0 * this.ECC6 / 3072.0;
        this.transverseMercator.t_ic1 = 1.5 * d3 - 27.0 * Math.pow(d3, 3.0) / 32.0;
        this.transverseMercator.t_ic2 = 21.0 * d3 * d3 / 16.0 - 55.0 * Math.pow(d3, 4.0) / 32.0;
        this.transverseMercator.t_ic3 = 151.0 * Math.pow(d3, 3.0) / 96.0;
        this.transverseMercator.t_ic4 = 1097.0 * Math.pow(d3, 4.0) / 512.0;
        this.transverseMercator.central_meridian = d2;
        this.transverseMercator.use_false_easting = bl;
        double d4 = d2;
        double d5 = d;
        this.transverseMercator.y_central_parralel = 0.0;
        Vect2D vect2D = this.tm(d5, d4);
        this.transverseMercator.y_central_parralel = vect2D.y;
    }

    public Vect2D tm(double d, double d2) {
        double d3;
        double d4;
        double d5 = d2 - this.transverseMercator.central_meridian;
        if (Math.abs(d5) > 360.0) {
            d5 += Math.copySign(360.0, -d5);
        }
        if (Math.abs(d5) > 180.0) {
            d5 = Math.copySign(360.0 - Math.abs(d5), -d5);
        }
        double d6 = this.EQ_RAD * (this.transverseMercator.t_c1 * (d *= Math.PI / 180) - this.transverseMercator.t_c2 * Math.sin(2.0 * d) + this.transverseMercator.t_c3 * Math.sin(4.0 * d) - this.transverseMercator.t_c4 * Math.sin(6.0 * d));
        if (Math.abs(d) == 1.5707963267948966) {
            d4 = 0.0;
            d3 = this.map_scale_factor * d6;
        } else {
            double d7 = this.EQ_RAD / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.pow(Math.sin(d), 2.0));
            double d8 = Math.tan(d);
            double d9 = Math.cos(d);
            double d10 = d8 * d8;
            double d11 = d10 * d10;
            double d12 = this.transverseMercator.t_e2 * d9 * d9;
            double d13 = d5 * (Math.PI / 180) * d9;
            double d14 = d13 * d13;
            double d15 = d14 * d13;
            double d16 = d15 * d14;
            d4 = this.map_scale_factor * d7 * (d13 + (1.0 - d10 + d12) * (d15 * 0.16666666666666666) + (5.0 - 18.0 * d10 + d11 + 72.0 * d12 - 58.0 * this.transverseMercator.t_e2) * (d16 * 0.008333333333333333));
            d3 = this.map_scale_factor * (d6 + d7 * Math.tan(d) * (0.5 * d14 + (5.0 - d10 + 9.0 * d12 + 4.0 * d12 * d12) * ((d15 *= d13) * 0.041666666666666664) + (61.0 - 58.0 * d10 + d11 + 600.0 * d12 - 330.0 * this.transverseMercator.t_e2) * ((d16 *= d13) * 0.001388888888888889)));
        }
        d4 /= 1000.0;
        d3 /= 1000.0;
        d3 -= this.transverseMercator.y_central_parralel;
        if (this.transverseMercator.use_false_easting) {
            d4 += 500.0;
        }
        double d17 = d4 * this.transCos - d3 * this.transSin;
        double d18 = d3 * this.transCos + d4 * this.transSin;
        return new Vect2D(d17, d18);
    }

    public Vect2D itm(double d, double d2) {
        double d3 = d * this.transCos + d2 * this.transSin;
        double d4 = d2 * this.transCos - d * this.transSin;
        d4 += this.transverseMercator.y_central_parralel;
        if (this.transverseMercator.use_false_easting) {
            d3 -= 500.0;
        }
        d3 *= 1000.0;
        double d5 = (d4 *= 1000.0) / this.map_scale_factor;
        double d6 = d5 / (this.EQ_RAD * this.transverseMercator.t_c1);
        double d7 = d6 + this.transverseMercator.t_ic1 * Math.sin(2.0 * d6) + this.transverseMercator.t_ic2 * Math.sin(4.0 * d6) + this.transverseMercator.t_ic3 * Math.sin(6.0 * d6) + this.transverseMercator.t_ic4 * Math.sin(8.0 * d6);
        double d8 = Math.cos(d7);
        double d9 = Math.tan(d7);
        double d10 = this.transverseMercator.t_e2 * d8 * d8;
        double d11 = d10 * d10;
        double d12 = d9 * d9;
        double d13 = d12 * d12;
        double d14 = 1.0 - this.ECC2 * (1.0 - d8 * d8);
        double d15 = GeogCoords.d_sqrt(d14);
        double d16 = this.EQ_RAD / d15;
        double d17 = this.EQ_RAD * (1.0 - this.ECC2) / (d14 * d15);
        double d18 = d3 / (d16 * this.map_scale_factor);
        double d19 = d18 * d18;
        double d20 = d19 * d18;
        double d21 = d20 * d19;
        double d22 = this.transverseMercator.central_meridian + 57.29577951308232 * (d18 - (1.0 + 2.0 * d12 + d10) * (d20 * 0.16666666666666666) + (5.0 - 2.0 * d10 + 28.0 * d12 - 3.0 * d11 + 8.0 * this.transverseMercator.t_e2 + 24.0 * d13) * (d21 * 0.008333333333333333)) / Math.cos(d7);
        double d23 = d7 - d16 * Math.tan(d7) / d17 * (0.5 * d19 - (5.0 + 3.0 * d12 + 10.0 * d10 - 4.0 * d11 - 9.0 * this.transverseMercator.t_e2) * ((d20 *= d18) * 0.041666666666666664) + (61.0 + 90.0 * d12 + 298.0 * d10 + 45.0 * d13 - 252.0 * this.transverseMercator.t_e2 - 3.0 * d11) * ((d21 *= d18) * 0.001388888888888889));
        return new Vect2D(d23 *= 57.29577951308232, d22);
    }

    protected void vutm(int n, double d, boolean bl) {
        this.vtm(d, n, bl);
        this.transverseMercator.north_pole = (double)n >= 0.0;
    }

    public Vect2D utm(double d, double d2) {
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        Vect2D vect2D = this.tm(d, d2);
        vect2D.x += 500000.0;
        if (!this.transverseMercator.north_pole) {
            vect2D.y += 1.0E7;
        }
        return vect2D;
    }

    public Vect2D iutm(double d, double d2) {
        d -= 500000.0;
        if (!this.transverseMercator.north_pole) {
            d2 -= 1.0E7;
        }
        Vect2D vect2D = this.itm(d, d2);
        return vect2D;
    }

    protected void vazeqdist(double d, double d2) {
        this.azimuthalEquidistant.central_meridian = d2;
        this.azimuthalEquidistant.pole = d;
        this.azimuthalEquidistant.sinp = Math.sin(d * (Math.PI / 180));
        this.azimuthalEquidistant.cosp = Math.cos(d * (Math.PI / 180));
    }

    public Vect2D azeqdist(double d, double d2) {
        int n;
        for (n = 0; n < 10 && d2 - this.azimuthalEquidistant.central_meridian < -180.0; ++n) {
            d2 += 360.0;
        }
        for (n = 0; n < 10 && d2 - this.azimuthalEquidistant.central_meridian > 180.0; ++n) {
            d2 -= 360.0;
        }
        double d3 = (d2 - this.azimuthalEquidistant.central_meridian) * (Math.PI / 180);
        double d4 = Math.sin(d *= Math.PI / 180);
        double d5 = Math.cos(d);
        double d6 = Math.cos(d3);
        double d7 = this.azimuthalEquidistant.sinp * d4 + this.azimuthalEquidistant.cosp * d5 * d6;
        Vect2D vect2D = new Vect2D();
        if (Math.abs(d7) >= 1.0) {
            vect2D.y = 0.0;
            vect2D.x = 0.0;
        } else {
            double d8 = Math.acos(d7);
            double d9 = this.EQ_RAD * d8 / Math.sin(d8);
            vect2D.x = d9 * d5 * Math.sin(d3);
            vect2D.y = d9 * (this.azimuthalEquidistant.cosp * d4 - this.azimuthalEquidistant.sinp * d5 * d6);
        }
        double d10 = vect2D.x * this.transCos - vect2D.y * this.transSin;
        double d11 = vect2D.y * this.transCos + vect2D.x * this.transSin;
        return new Vect2D(d10 / 1000.0, d11 / 1000.0);
    }

    public Vect2D iazeqdist(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = (d *= 1000.0) * this.transCos + (d2 *= 1000.0) * this.transSin;
        if ((d6 = Math.hypot(d7, d5 = d2 * this.transCos - d * this.transSin)) == 0.0) {
            d4 = this.azimuthalEquidistant.pole;
            d3 = this.azimuthalEquidistant.central_meridian;
        } else {
            double d8 = d6 / this.EQ_RAD;
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            d4 = Math.asin(d10 * this.azimuthalEquidistant.sinp + d5 * d9 * this.azimuthalEquidistant.cosp / d6) * 57.29577951308232;
            d3 = this.azimuthalEquidistant.pole == 90.0 ? this.azimuthalEquidistant.central_meridian + 57.29577951308232 * Math.atan2(d7, -d5) : (this.azimuthalEquidistant.pole == -90.0 ? this.azimuthalEquidistant.central_meridian + 57.29577951308232 * Math.atan2(d7, d5) : this.azimuthalEquidistant.central_meridian + 57.29577951308232 * Math.atan2(d7 * d9, d6 * this.azimuthalEquidistant.cosp * d10 - d5 * this.azimuthalEquidistant.sinp * d9));
            if (d3 <= -180.0) {
                d3 += 360.0;
            }
        }
        return new Vect2D(d4, d3);
    }

    public int writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.transformName);
        if (!this.transformName.equals("GLOBAL") && !this.transformName.equals("NONE")) {
            if (this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
            } else if (this.transformName.equals("MERCATOR")) {
                dataOutputStream.writeUTF(this.refEllipsoid);
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
            } else if (this.transformName.equals("DC")) {
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
            } else if (this.transformName.equals("LAMBERT")) {
                dataOutputStream.writeUTF(this.refEllipsoid);
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.Lambert1stStdParall);
                dataOutputStream.writeFloat((float)this.Lambert2ndStdParall);
                dataOutputStream.writeFloat((float)this.rotAngle);
            } else if (this.transformName.equals("TRANS_MERC")) {
                dataOutputStream.writeUTF(this.refEllipsoid);
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
                dataOutputStream.writeBoolean(this.useFalseEasting);
            } else if (this.transformName.equals("AZIMUTHAL_EQUIDIST")) {
                dataOutputStream.writeUTF(this.refEllipsoid);
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
            }
        }
        return 0;
    }

    public int readBinary(DataInputStream dataInputStream) throws IOException {
        this.transformName = dataInputStream.readUTF();
        if (this.transformName.equals("GLOBAL")) {
            this.transformType = 1;
            this.initialized = true;
        } else if (this.transformName.equals("NONE")) {
            this.transformType = 0;
            this.initialized = true;
        } else if (this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            this.convergence = !this.transformName.equals("EQUIRECTANGULAR");
            this.transformType = 2;
            this.initialized = true;
        } else if (this.transformName.equals("MERCATOR")) {
            this.refEllipsoid = dataInputStream.readUTF();
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.CentralMeridian = this.longOrig;
                this.Mercator_j_x = Math.cos(this.latOrig * (Math.PI / 180)) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.sin(this.latOrig * (Math.PI / 180)) * Math.sin(this.latOrig * (Math.PI / 180))) * this.EQ_RAD;
                this.Mercato_j_ix = 1.0 / this.Mercator_j_x;
                this.Mercator_yshift = 0.0;
                Vect2D vect2D = this.merc_sph(this.latOrig, this.longOrig);
                this.Mercator_yshift = vect2D.y;
                this.transformType = 7;
                this.initialized = true;
            }
        } else if (this.transformName.equals("SDC")) {
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            this.transformType = 6;
            this.initialized = true;
        } else if (this.transformName.equals("LAMBERT")) {
            this.refEllipsoid = dataInputStream.readUTF();
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.Lambert1stStdParall = dataInputStream.readFloat();
            this.Lambert2ndStdParall = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vlamb(this.latOrig, this.longOrig, this.Lambert1stStdParall, this.Lambert2ndStdParall);
                this.transformType = 3;
                this.initialized = true;
            }
        } else if (this.transformName.equals("TRANS_MERC")) {
            this.refEllipsoid = dataInputStream.readUTF();
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            try {
                this.useFalseEasting = dataInputStream.readBoolean();
            }
            catch (Exception exception) {
                this.useFalseEasting = false;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vtm(this.latOrig, this.longOrig, this.useFalseEasting);
                this.transformType = 4;
                this.initialized = true;
            }
        } else if (this.transformName.equals("AZIMUTHAL_EQUIDIST")) {
            this.refEllipsoid = dataInputStream.readUTF();
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vazeqdist(this.latOrig, this.longOrig);
                this.transformType = 5;
                this.initialized = true;
            }
        }
        return 0;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.transformType == 1) {
            stringBuffer.append("GLOBAL ");
            stringBuffer.append(string);
        } else if (this.transformType == 0) {
            stringBuffer.append("NONE ");
            stringBuffer.append(string);
        } else if (this.transformType == 2) {
            if (this.convergence) {
                stringBuffer.append("SIMPLE ");
            } else {
                stringBuffer.append("EQUIRECTANGULAR ");
            }
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else if (this.transformType == 7) {
            stringBuffer.append("MERCATOR ");
            stringBuffer.append("  refEllipsoid ");
            stringBuffer.append(this.refEllipsoid);
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else if (this.transformType == 6) {
            stringBuffer.append("SDC ");
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else if (this.transformType == 3) {
            stringBuffer.append("LAMBERT ");
            stringBuffer.append("  refEllipsoid ");
            stringBuffer.append(this.refEllipsoid);
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  Lambert1stStdParall ");
            stringBuffer.append(this.Lambert1stStdParall);
            stringBuffer.append("  Lambert2ndStdParall ");
            stringBuffer.append(this.Lambert2ndStdParall);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else if (this.transformType == 4) {
            stringBuffer.append("TRANS_MERC ");
            stringBuffer.append("  refEllipsoid ");
            stringBuffer.append(this.refEllipsoid);
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append("  useFalseEasting ");
            stringBuffer.append(this.useFalseEasting);
            stringBuffer.append(string);
        } else if (this.transformType == 5) {
            stringBuffer.append("AZIMUTHAL_EQUIDIST ");
            stringBuffer.append("  refEllipsoid ");
            stringBuffer.append(this.refEllipsoid);
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else {
            stringBuffer.append("ERROR: unrecognized geographic tranform type: <" + this.transformName + ">");
        }
        return stringBuffer.toString();
    }

    static {
        GeogCoords.ellipse[0] = new EarthEllipsoid("WGS-84", 1984, 6378137.0, 6356752.1, 0.0033528469023047466);
        GeogCoords.ellipse[1] = new EarthEllipsoid("GRS-80", 1980, 6378137.0, 6356752.3, 0.0033528131778969143);
        GeogCoords.ellipse[2] = new EarthEllipsoid("WGS-72", 1972, 6378135.0, 6356750.5, 0.003352779454167505);
        GeogCoords.ellipse[3] = new EarthEllipsoid("Australian", 1965, 6378160.0, 6356774.7, 0.003352891869237217);
        GeogCoords.ellipse[4] = new EarthEllipsoid("Krasovsky", 1940, 6378245.0, 6356863.0, 0.003352329869259135);
        GeogCoords.ellipse[5] = new EarthEllipsoid("International", 1924, 6378388.0, 6356911.9, 0.003367003367003367);
        GeogCoords.ellipse[6] = new EarthEllipsoid("Hayford-1909", 1909, 6378388.0, 6356911.9, 0.003367003367003367);
        GeogCoords.ellipse[7] = new EarthEllipsoid("Clarke-1880", 1880, 6378249.1, 6356514.9, 0.0034076194370612693);
        GeogCoords.ellipse[8] = new EarthEllipsoid("Clarke-1866", 1866, 6378206.4, 6356583.8, 0.0033900603430741063);
        GeogCoords.ellipse[9] = new EarthEllipsoid("Airy", 1830, 6377563.4, 6356256.9, 0.0033409060537217695);
        GeogCoords.ellipse[10] = new EarthEllipsoid("Bessel", 1841, 6377397.2, 6356079.0, 0.003342804613070366);
        GeogCoords.ellipse[11] = new EarthEllipsoid("Hayford-1830", 1830, 6377276.3, 6356075.4, 0.003324468085106383);
        GeogCoords.ellipse[12] = new EarthEllipsoid("Sphere", 1980, 6371008.7714, 6371008.7714, 0.0);
        GeogCoords.ellipse[13] = new EarthEllipsoid("NAD-27", 1927, 6378206.4, 6356583.8, 0.0033900603430741063);
        GeogCoords.ellipse[14] = new EarthEllipsoid("NAD-83", 1983, 6378137.4, 6356752.3, 0.003398355196085095);
    }
}

