/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.alomax.geog.Global3D;
import net.alomax.graphics3d.Polygon3D;
import net.alomax.graphics3d.Vect3D;

public class GlobalPolygon3D
extends Polygon3D
implements Global3D {
    protected Vect3D center = null;
    protected boolean canBeHidden = false;

    public GlobalPolygon3D(float[] fArray, float[] fArray2, float[] fArray3) {
        this(fArray, fArray2, fArray3, null, false);
    }

    public GlobalPolygon3D(float[] fArray, float[] fArray2, float[] fArray3, Vect3D vect3D, boolean bl) {
        super(fArray, fArray2, fArray3);
        this.center = vect3D;
        this.canBeHidden = bl;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Color color, BasicStroke basicStroke, boolean bl, Vect3D vect3D) {
        if (n == n2) {
            return;
        }
        if (basicStroke != null) {
            try {
                ((Graphics2D)graphics).setStroke(basicStroke);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.center == null || !this.canBeHidden || bl) {
            super.paint(graphics, n, n2, color);
            return;
        }
        int n3 = n;
        int n4 = n;
        for (int i = n; i <= n2; ++i) {
            Vect3D vect3D2 = new Vect3D(this.xData[i], this.yData[i], this.zData[i]);
            if (this.isHidden(vect3D2, vect3D)) {
                if (n4 > n3) {
                    super.paint(graphics, n3, n4, color);
                }
                n3 = i + 1;
                n4 = i + 1;
                continue;
            }
            n4 = i;
        }
        if (n4 > n3) {
            super.paint(graphics, n3, n4, color);
        }
    }

    @Override
    public boolean isHidden(Vect3D vect3D, Vect3D vect3D2) {
        Vect3D vect3D3 = vect3D.sub(this.center);
        return vect3D2.dot(vect3D3) > 0.0;
    }
}

