/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import net.alomax.geog.Global3D;
import net.alomax.graphics3d.Symbol3D;
import net.alomax.graphics3d.Vect3D;

public class GlobalSymbol3D
implements Global3D {
    protected Vect3D globalCenter = null;
    protected boolean canBeHidden = false;
    protected Symbol3D symbol = null;

    public GlobalSymbol3D(Symbol3D symbol3D, Vect3D vect3D, boolean bl) {
        this.symbol = symbol3D;
        this.globalCenter = vect3D;
        this.canBeHidden = bl;
        if (vect3D != null) {
            Vect3D vect3D2 = symbol3D.getCenter().sub(vect3D);
            vect3D2.normalize();
            symbol3D.transformToUpOnSphere(vect3D2);
        }
    }

    public void paint(Graphics graphics, Color color, BasicStroke basicStroke, boolean bl, Vect3D vect3D) {
        if (this.globalCenter == null || !this.canBeHidden || bl) {
            this.symbol.paint(graphics, basicStroke, color);
            return;
        }
        if (!this.isHidden(this.symbol.getCenter(), vect3D)) {
            this.symbol.paint(graphics, basicStroke, color);
        }
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Color color, BasicStroke basicStroke, boolean bl, Vect3D vect3D) {
        this.paint(graphics, color, basicStroke, bl, vect3D);
    }

    @Override
    public boolean isHidden(Vect3D vect3D, Vect3D vect3D2) {
        Vect3D vect3D3 = vect3D.sub(this.globalCenter);
        return vect3D2.dot(vect3D3) > 0.0;
    }

    @Override
    public int size() {
        return 1;
    }

    public void transform(int n) {
        if (this.symbol != null) {
            this.symbol.transform(n);
        }
    }
}

