/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.Grid3D;
import net.alomax.geog.MapScale;
import net.alomax.geog.MapScaleGlobal;
import net.alomax.geog.MapScaleRectangular;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;
import sdsu.io.ASCIIInputStream;

public class Grid3DRectangular
extends Grid3D {
    protected static final double PLANET_RADIUS = (float)GeogConstants.PLANET_RADIUS;
    protected boolean isGlobal = false;
    protected boolean drawZCoordsSpaced = false;
    protected String zCoordsSpacedPosition = null;
    protected boolean drawZCoordsSouth = true;
    protected boolean drawZCoordsEast = true;
    protected GlobalLine3D[] globalLine3D = null;
    protected Vect3D globalCenter = null;
    protected Line3D[] latlonLine3D = new Line3D[0];
    protected Vect3D[][] text3D = new Vect3D[0][0];
    protected Vect3D[] text3Doffset = new Vect3D[0];
    protected MapScale mapScaleBar = null;
    protected MapScale mapScaleBarVect = null;
    protected int[] itrans000 = new int[3];
    protected int[] itrans001 = new int[3];
    protected int[] itrans010 = new int[3];
    protected int[] itrans011 = new int[3];
    protected int[] itrans100 = new int[3];
    protected int[] itrans101 = new int[3];
    protected int[] itrans110 = new int[3];
    protected int[] itrans111 = new int[3];
    protected Vect3D[] zMinCoordsSouth = null;
    protected Vect3D[] zMaxCoordsSouth = null;
    protected Vect3D[] zMinCoordsEast = null;
    protected Vect3D[] zMaxCoordsEast = null;
    protected Vect3D[][] zCoords = null;
    protected double zCoordsSpacedX;
    protected double zCoordsSpacedY;
    protected double zmin_label = 0.0;
    protected double zspace_label = 0.0;
    protected boolean drawHorizontalScale = false;
    protected int horizNlabel = 0;
    protected Vect3D[][] horizCoordsLabel = null;
    protected Vect3D[][] horizCoordsTic = null;
    protected boolean horizIsIntegerLabels = false;
    protected Vect3D horizCoordsSpacedZeroPos = null;
    protected double horizCoordsSpacedValueMin = -1.0;
    protected double horizCoordsSpacedValueMax = 1.0;
    protected Vect3D horizScalePathVec = null;
    protected Vect3D horizScaleUpVec = null;
    protected Vect3D horizScaleUpVec_horiz = null;
    protected int[] horizCoordsStart = new int[3];
    protected int[] horizCoordsEnd = new int[3];
    protected double horizCoordsSpacedXmin;
    protected double horizCoordsSpacedYmin;
    protected double horizCoordsSpacedZ;
    protected double horizmin_label = 0.0;
    protected double horizspace_label = 0.0;
    protected double horizspace_label_x = 0.0;
    protected double horizspace_label_y = 0.0;
    protected double horizLabelZoffest_x = 1.0;
    protected double horizLabelZoffest_y = 1.0;
    protected double horizLabelZoffest_z = 1.0;
    protected double horizFontSizeFactor = 1.0;
    protected double horizFontDensity = 1.0;
    protected double textFontSizeFactor = 1.0;
    protected double textFontDensity = 1.0;
    protected String textLabelsToPlot = "LRTB";

    public Grid3DRectangular(InputStream inputStream, Component component, Vect3D vect3D) throws Exception {
        this(inputStream, component, vect3D, false);
    }

    public Grid3DRectangular(InputStream inputStream, Component component, Vect3D vect3D, boolean bl) throws Exception {
        super(component);
        String string;
        this.globalCenter = vect3D;
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new BufferedInputStream(inputStream));
        if (bl) {
            try {
                while ((string = aSCIIInputStream.readWord()).compareTo("GRID") != 0) {
                    aSCIIInputStream.flushLine();
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: reading grid description from grid header file.");
                throw exception;
            }
        }
        try {
            this.nx = aSCIIInputStream.readInt();
            this.ny = aSCIIInputStream.readInt();
            this.nz = aSCIIInputStream.readInt();
            this.x0 = aSCIIInputStream.readFloat();
            this.y0 = aSCIIInputStream.readFloat();
            this.z0 = aSCIIInputStream.readFloat();
            this.dx = aSCIIInputStream.readFloat();
            this.dy = aSCIIInputStream.readFloat();
            this.dz = aSCIIInputStream.readFloat();
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading grid description from grid header file.");
            throw exception;
        }
        this.setGrid3DRectangular();
        this.isGlobal = false;
        try {
            aSCIIInputStream.flushLine();
            while (true) {
                if (aSCIIInputStream.eof()) {
                    return;
                }
                string = aSCIIInputStream.readWord();
                if (string.compareTo("TRANSFORM") == 0) {
                    this.geogCoords = new GeogCoords(aSCIIInputStream);
                    if (this.geogCoords.transformType == 1) {
                        this.isGlobal = true;
                        this.setGrid3DGlobal();
                    }
                }
                aSCIIInputStream.flushLine();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading geographic projection from grid header file.");
            throw exception;
        }
    }

    public static void invertColor() {
        Grid3D.invertColor();
    }

    public void setDrawZCoords(boolean bl, boolean bl2, boolean bl3, String string) {
        this.drawZCoordsSouth = bl;
        this.drawZCoordsEast = bl2;
        this.drawZCoordsSpaced = bl3;
        this.zCoordsSpacedPosition = string;
    }

    public void setGrid3DGlobal() {
        double d;
        double d2;
        int n;
        double d3;
        double d4;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        float[] fArray5;
        float[] fArray6;
        int n2;
        double d5;
        double d6;
        double d7;
        float f = this.x0;
        float f2 = this.y0;
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.zmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        double d8 = (double)f2 + (double)this.dy * (double)(this.ny - 1);
        double d9 = (double)f + (double)this.dx * (double)(this.nx - 1);
        if (d9 - (double)f > 359.9) {
            this.isWholeEarth = true;
        }
        Vector<GlobalLine3D> vector = new Vector<GlobalLine3D>();
        double d10 = GeogConstants.PLANET_RADIUS - (double)this.z0;
        double d11 = GeogConstants.PLANET_RADIUS - ((double)this.z0 + (double)this.dz * (double)this.nz);
        for (d7 = (double)f; d7 <= d9; d7 += d9 - (double)f) {
            d6 = Math.cos(d7 * (Math.PI / 180));
            d5 = Math.sin(d7 * (Math.PI / 180));
            n2 = 100;
            fArray6 = new float[n2 + 2];
            fArray5 = new float[n2 + 2];
            fArray4 = new float[n2 + 2];
            fArray3 = new float[n2 + 2];
            fArray2 = new float[n2 + 2];
            fArray = new float[n2 + 2];
            d4 = f2;
            d3 = (d8 - (double)f2) / (double)(n2 - 1);
            for (n = 0; n < n2 + 2; ++n) {
                d2 = Math.cos(d4 * (Math.PI / 180));
                d = Math.sin(d4 * (Math.PI / 180));
                if (n == 0 || n == n2 + 1) {
                    fArray6[n] = (float)(d11 * d6 * d2);
                    fArray5[n] = (float)(d11 * d5 * d2);
                    fArray4[n] = (float)(d11 * d);
                    fArray3[n] = (float)(d10 * d6 * d2);
                    fArray2[n] = (float)(d10 * d5 * d2);
                    fArray[n] = (float)(d10 * d);
                } else {
                    fArray6[n] = (float)(d10 * d6 * d2);
                    fArray5[n] = (float)(d10 * d5 * d2);
                    fArray4[n] = (float)(d10 * d);
                    fArray3[n] = (float)(d11 * d6 * d2);
                    fArray2[n] = (float)(d11 * d5 * d2);
                    fArray[n] = (float)(d11 * d);
                }
                if (n != 0 && n != n2) {
                    d4 += d3;
                }
                this.xmin = Math.min(this.xmin, (double)fArray6[n]);
                this.xmin = Math.min(this.xmin, (double)fArray3[n]);
                this.xmax = Math.max(this.xmax, (double)fArray6[n]);
                this.xmax = Math.max(this.xmax, (double)fArray3[n]);
                this.ymin = Math.min(this.ymin, (double)fArray5[n]);
                this.ymin = Math.min(this.ymin, (double)fArray2[n]);
                this.ymax = Math.max(this.ymax, (double)fArray5[n]);
                this.ymax = Math.max(this.ymax, (double)fArray2[n]);
                this.zmin = Math.min(this.zmin, (double)fArray4[n]);
                this.zmin = Math.min(this.zmin, (double)fArray[n]);
                this.zmax = Math.max(this.zmax, (double)fArray4[n]);
                this.zmax = Math.max(this.zmax, (double)fArray[n]);
            }
            vector.addElement(new GlobalLine3D(fArray6, fArray5, fArray4, this.globalCenter, true));
            vector.addElement(new GlobalLine3D(fArray3, fArray2, fArray, this.globalCenter, true));
        }
        for (d7 = (double)f2; d7 <= d8; d7 += d8 - (double)f2) {
            d6 = Math.cos(d7 * (Math.PI / 180));
            d5 = Math.sin(d7 * (Math.PI / 180));
            n2 = 100;
            fArray6 = new float[n2];
            fArray5 = new float[n2];
            fArray4 = new float[n2];
            fArray3 = new float[n2];
            fArray2 = new float[n2];
            fArray = new float[n2];
            d9 = (double)f + (double)this.dx * (double)(this.nx - 1);
            d4 = f;
            d3 = (d9 - (double)f) / (double)(n2 - 1);
            for (n = 0; n < n2; ++n) {
                d2 = Math.cos(d4 * (Math.PI / 180));
                d = Math.sin(d4 * (Math.PI / 180));
                fArray6[n] = (float)(d10 * d2 * d6);
                fArray5[n] = (float)(d10 * d * d6);
                fArray4[n] = (float)(d10 * d5);
                fArray3[n] = (float)(d11 * d2 * d6);
                fArray2[n] = (float)(d11 * d * d6);
                fArray[n] = (float)(d11 * d5);
                d4 += d3;
            }
            vector.addElement(new GlobalLine3D(fArray6, fArray5, fArray4, this.globalCenter, true));
            vector.addElement(new GlobalLine3D(fArray3, fArray2, fArray, this.globalCenter, true));
        }
        this.globalLine3D = new GlobalLine3D[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.globalLine3D[i] = (GlobalLine3D)vector.elementAt(i);
        }
    }

    public void setGrid3DRectangular() {
        this.xmin = this.x0;
        this.xmax = this.xmin + (double)(this.nx - 1) * (double)this.dx;
        this.ymin = this.y0;
        this.ymax = this.ymin + (double)(this.ny - 1) * (double)this.dy;
        this.zmin = this.z0;
        this.zmax = this.zmin + (double)(this.nz - 1) * (double)this.dz;
    }

    @Override
    public void createScaleBar(double d, Vect3D vect3D, double d2, double d3, double d4) {
        this.mapScaleBar = this.isGlobal ? new MapScaleGlobal(this, d, this.globalCenter, vect3D, d2, d3) : new MapScaleRectangular(this, d, vect3D, d2, d3, d4);
    }

    @Override
    public void createVectScaleBar(double d, Vect3D vect3D, double d2, double d3, double d4, Vect3D vect3D2) {
        this.mapScaleBarVect = this.isGlobal ? new MapScaleGlobal(this, d, this.globalCenter, vect3D, d2, d3, d4, vect3D2) : new MapScaleRectangular(this, d, vect3D, d2, d3, d4, vect3D2);
    }

    @Override
    public void createLabels(double d) {
        if (this.drawZCoordsEast || this.drawZCoordsSouth) {
            this.createLabelsMinMax(d);
        } else if (this.drawZCoordsSpaced) {
            this.createLabelsSpacedVertical(d);
        }
        if (this.drawHorizontalScale) {
            this.createLabelsHorizontalScale(d);
        }
    }

    public void createLabelsMinMax(double d) {
        double d2 = this.zmin;
        if (Math.abs(d2 - 0.0) < 4.9E-323) {
            d2 = 0.0;
        }
        StringVectorizer stringVectorizer = new StringVectorizer(String.valueOf((float)d2) + " km", this.component, this.component.getFont().getName(), 0, (double)this.component.getFont().getSize() * 1.5 * this.textFontSizeFactor, this.textFontDensity);
        this.zMinCoordsSouth = stringVectorizer.toWorldCoords(d, 0, 2, new Vect3D(1.0f, 0.0f, 0.0f), new Vect3D(0.0f, 0.0f, 1.0f));
        this.zMinCoordsEast = stringVectorizer.toWorldCoords(d, 0, 2, new Vect3D(0.0f, 1.0f, 0.0f), new Vect3D(0.0f, 0.0f, 1.0f));
        stringVectorizer = new StringVectorizer(String.valueOf((float)this.zmax) + " km", this.component, this.component.getFont().getName(), 0, (double)this.component.getFont().getSize() * 1.5 * this.textFontSizeFactor, this.textFontDensity);
        this.zMaxCoordsSouth = stringVectorizer.toWorldCoords(d, 0, 0, new Vect3D(1.0f, 0.0f, 0.0f), new Vect3D(0.0f, 0.0f, 1.0f));
        this.zMaxCoordsEast = stringVectorizer.toWorldCoords(d, 0, 0, new Vect3D(0.0f, 1.0f, 0.0f), new Vect3D(0.0f, 0.0f, 1.0f));
    }

    public void createLabelsSpacedVertical(double d) {
        double d2;
        int n;
        Vect3D vect3D;
        int n2;
        block9: {
            double d3 = 2.0;
            this.zspace_label = this.getTickSpace(this.zmin, this.zmax, d3);
            this.zmin_label = 0.0;
            this.zmin_label = this.zmin >= 0.0 ? Math.floor(this.zmin / this.zspace_label) * this.zspace_label : Math.ceil(this.zmin / this.zspace_label) * this.zspace_label;
            if (Math.abs(this.zmin_label - 0.0) < 4.9E-323) {
                this.zmin_label = 0.0;
            }
            n2 = 0;
            double d4 = this.zmin_label;
            while (d4 < this.zmax + this.zspace_label / 2.0) {
                d4 += this.zspace_label;
                ++n2;
            }
            double d5 = (this.xmax - this.xmin) / 100.0;
            vect3D = new Vect3D(1.0f, 1.0f, 0.0f);
            n = 2;
            this.zCoordsSpacedX = this.xmin - d5;
            this.zCoordsSpacedY = this.ymin - d5;
            StringTokenizer stringTokenizer = new StringTokenizer(this.zCoordsSpacedPosition, ",");
            try {
                this.zCoordsSpacedX = Double.valueOf(stringTokenizer.nextToken());
                this.zCoordsSpacedY = Double.valueOf(stringTokenizer.nextToken());
                d2 = Double.valueOf(stringTokenizer.nextToken());
                vect3D = new Vect3D(Math.sin(Math.PI / 180 * d2), Math.cos(Math.PI / 180 * d2), 0.0);
                n = 1;
            }
            catch (Exception exception) {
                if (stringTokenizer.countTokens() > 1) {
                    System.out.println("ERROR: reading general grid.zlimits.spaced parameter: " + this.zCoordsSpacedPosition);
                }
                if (this.zCoordsSpacedPosition.equals("SE")) {
                    vect3D = new Vect3D(1.0f, -1.0f, 0.0f);
                    n = 0;
                    this.zCoordsSpacedX = this.xmax + d5;
                    this.zCoordsSpacedY = this.ymin - d5;
                }
                if (this.zCoordsSpacedPosition.equals("NE")) {
                    vect3D = new Vect3D(1.0f, 1.0f, 0.0f);
                    n = 0;
                    this.zCoordsSpacedX = this.xmax + d5;
                    this.zCoordsSpacedY = this.ymax + d5;
                }
                if (this.zCoordsSpacedPosition.equals("NW")) {
                    vect3D = new Vect3D(1.0f, -1.0f, 0.0f);
                    n = 2;
                    this.zCoordsSpacedX = this.xmin - d5;
                    this.zCoordsSpacedY = this.ymax + d5;
                }
                if (!this.zCoordsSpacedPosition.equalsIgnoreCase("NONE")) break block9;
                this.drawZCoordsSpaced = false;
            }
        }
        this.zCoords = new Vect3D[n2][];
        d2 = this.zmin_label;
        for (int i = 0; i < n2; ++i) {
            StringVectorizer stringVectorizer = new StringVectorizer(String.valueOf((float)d2) + " km \u2500", this.component, this.component.getFont().getName(), 0, (double)this.component.getFont().getSize() * 1.5 * this.textFontSizeFactor, this.textFontDensity);
            this.zCoords[i] = stringVectorizer.toWorldCoords(d, n, 1, vect3D, new Vect3D(0.0f, 0.0f, 1.0f));
            d2 += this.zspace_label;
        }
    }

    @Override
    public void createHorizontalScale(Vect3D vect3D, double d, double d2, double d3, double d4, double d5, double d6, Vect3D vect3D2, boolean bl) {
        this.horizCoordsSpacedZeroPos = vect3D;
        this.horizCoordsSpacedValueMin = d;
        this.horizCoordsSpacedValueMax = d2;
        this.horizspace_label = d3;
        this.horizmin_label = 0.0;
        this.horizmin_label = d >= 0.0 ? Math.floor(d / this.horizspace_label) * this.horizspace_label : Math.ceil(d / this.horizspace_label) * this.horizspace_label;
        if (Math.abs(this.horizmin_label - 0.0) < 4.9E-323) {
            this.horizmin_label = 0.0;
        }
        this.horizNlabel = 0;
        double d7 = this.horizmin_label;
        while (d7 < this.horizCoordsSpacedValueMax + this.horizspace_label / 2.0) {
            d7 += this.horizspace_label;
            ++this.horizNlabel;
        }
        this.horizScalePathVec = new Vect3D(Math.sin(Math.PI / 180 * d6), Math.cos(Math.PI / 180 * d6), 0.0);
        this.horizScaleUpVec = new Vect3D(0.0f, 0.0f, 1.0f);
        this.horizScaleUpVec_horiz = new Vect3D(-Math.cos(Math.PI / 180 * d6), Math.sin(Math.PI / 180 * d6), 0.0);
        this.horizCoordsSpacedZ = this.horizCoordsSpacedZeroPos.z;
        this.horizCoordsSpacedXmin = this.horizCoordsSpacedZeroPos.x + d * this.horizScalePathVec.x;
        this.horizspace_label_x = this.horizspace_label * this.horizScalePathVec.x;
        this.horizCoordsSpacedYmin = this.horizCoordsSpacedZeroPos.y + d * this.horizScalePathVec.y;
        this.horizspace_label_y = this.horizspace_label * this.horizScalePathVec.y;
        this.horizFontSizeFactor = d4;
        this.horizFontDensity = d5;
        this.horizIsIntegerLabels = bl;
        this.drawHorizontalScale = true;
    }

    public void createLabelsHorizontalScale(double d) {
        this.horizCoordsLabel = new Vect3D[2 * this.horizNlabel][];
        this.horizCoordsTic = new Vect3D[2 * this.horizNlabel][];
        double d2 = (double)this.component.getFont().getSize() * 1.5 * this.horizFontSizeFactor;
        double d3 = this.horizmin_label;
        boolean bl = false;
        for (int i = 0; i < this.horizNlabel; ++i) {
            String string = this.horizIsIntegerLabels ? String.valueOf(Math.round((float)d3)) : String.valueOf((float)d3);
            String string2 = "";
            if (string.equals("0") || !bl && i == this.horizCoordsLabel.length / 2 - 1) {
                string2 = " km";
                bl = true;
            }
            int n = 1;
            if (i == 0) {
                n = 0;
            } else if (i == this.horizNlabel - 1) {
                n = 2;
            }
            StringVectorizer stringVectorizer = new StringVectorizer(string + string2, this.component, this.component.getFont().getName(), 0, d2, this.horizFontDensity);
            this.horizCoordsLabel[i] = stringVectorizer.toWorldCoords(d, n, 1, this.horizScalePathVec, this.horizScaleUpVec);
            stringVectorizer = new StringVectorizer("|", this.component, this.component.getFont().getName(), 0, d2, this.horizFontDensity);
            this.horizCoordsTic[i] = stringVectorizer.toWorldCoords(d, 1, 1, this.horizScalePathVec, this.horizScaleUpVec);
            stringVectorizer = new StringVectorizer(string + string2, this.component, this.component.getFont().getName(), 0, d2, this.horizFontDensity);
            this.horizCoordsLabel[i + this.horizNlabel] = stringVectorizer.toWorldCoords(d, n, 1, this.horizScalePathVec, this.horizScaleUpVec_horiz);
            stringVectorizer = new StringVectorizer("|", this.component, this.component.getFont().getName(), 0, d2, this.horizFontDensity);
            this.horizCoordsTic[i + this.horizNlabel] = stringVectorizer.toWorldCoords(d, 1, 1, this.horizScalePathVec, this.horizScaleUpVec_horiz);
            d3 += this.horizspace_label;
        }
        this.horizLabelZoffest_x = -1.5 * this.horizScaleUpVec_horiz.x * d2 * d;
        this.horizLabelZoffest_y = -1.5 * this.horizScaleUpVec_horiz.y * d2 * d;
        this.horizLabelZoffest_z = -1.5 * d2 * d;
    }

    @Override
    protected void createLatLonGrid(double d, Vect3D vect3D, double d2, double d3, String string, String string2, double d4, boolean bl, boolean bl2) {
        int n;
        Object object;
        Vect3D vect3D2;
        Vect3D vect3D3;
        Vect3D vect3D4;
        Vect3D vect3D5;
        double d5;
        int n2;
        Vect3D vect3D6;
        StringVectorizer stringVectorizer;
        String string3;
        String string4;
        float f;
        double d6;
        double d7;
        boolean bl3;
        boolean bl4;
        double d8;
        double d9;
        boolean bl5;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        float[] fArray5;
        float[] fArray6;
        int n3;
        boolean bl6;
        double d10;
        boolean bl7;
        boolean bl8;
        double d11;
        float[] fArray7;
        float[] fArray8;
        float[] fArray9;
        Object object2;
        if (this.isGlobal || string == null) {
            return;
        }
        double d12 = 999.0;
        double d13 = -999.0;
        double d14 = 999.0;
        double d15 = -999.0;
        double d16 = 0.0;
        double d17 = 0.0;
        boolean bl9 = false;
        boolean bl10 = false;
        try {
            object2 = new StringTokenizer(string, ",");
            d12 = Double.parseDouble(((StringTokenizer)object2).nextToken());
            d13 = Double.parseDouble(((StringTokenizer)object2).nextToken());
            d14 = Double.parseDouble(((StringTokenizer)object2).nextToken());
            d15 = Double.parseDouble(((StringTokenizer)object2).nextToken());
            this.textFontSizeFactor = d2 * Double.valueOf(((StringTokenizer)object2).nextToken());
            this.textFontDensity = Double.valueOf(((StringTokenizer)object2).nextToken());
            try {
                this.textLabelsToPlot = ((StringTokenizer)object2).nextToken();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl10 = true;
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading grid.latlontext parameter: " + string);
            return;
        }
        d14 = d14 >= -180.0 || d14 < d15 ? d14 : d14 + 360.0;
        double d18 = d15 = d15 >= -180.0 || d15 > d14 ? d15 : d15 + 360.0;
        if (string2 != null) {
            try {
                object2 = new StringTokenizer(string2, ",");
                d16 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                try {
                    d17 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                    bl9 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (Exception exception) {
                System.out.println("ERROR: reading grid.latlon.depth parameter: " + string2);
                return;
            }
        }
        if (d14 >= d15) {
            System.out.println("ERROR: minimum longitude > maximum longitude in grid.latlontext parameter: " + string);
            return;
        }
        if (d12 >= d13) {
            System.out.println("ERROR: minimum latitude > maximum latitude in grid.latlontext parameter: " + string);
            return;
        }
        Vector<Line3D> vector = new Vector<Line3D>();
        Vector<Vect3D[]> vector2 = new Vector<Vect3D[]>();
        Vector<Vect3D> vector3 = new Vector<Vect3D>();
        double d19 = d4 / 100.0;
        this.clipLatLonBoxLine3D = null;
        if (bl2) {
            fArray9 = new float[4];
            fArray8 = new float[4];
            fArray7 = new float[4];
            object2 = this.geogCoords.geog2xyz(d12, d14, d16);
            fArray9[0] = (float)((Vect3D)object2).x;
            fArray8[0] = (float)((Vect3D)object2).y;
            fArray7[0] = (float)((Vect3D)object2).z;
            object2 = this.geogCoords.geog2xyz(d13, d14, d16);
            fArray9[1] = (float)((Vect3D)object2).x;
            fArray8[1] = (float)((Vect3D)object2).y;
            fArray7[1] = (float)((Vect3D)object2).z;
            object2 = this.geogCoords.geog2xyz(d13, d15, d16);
            fArray9[2] = (float)((Vect3D)object2).x;
            fArray8[2] = (float)((Vect3D)object2).y;
            fArray7[2] = (float)((Vect3D)object2).z;
            object2 = this.geogCoords.geog2xyz(d12, d15, d16);
            fArray9[3] = (float)((Vect3D)object2).x;
            fArray8[3] = (float)((Vect3D)object2).y;
            fArray7[3] = (float)((Vect3D)object2).z;
            this.clipLatLonBoxLine3D = new Line3D(fArray9, fArray8, fArray7);
        }
        this.clipLatLonBoundsLine3D = null;
        if (bl2) {
            fArray9 = new float[2];
            fArray8 = new float[2];
            fArray7 = new float[2];
            fArray9[0] = (float)d14;
            fArray8[0] = (float)d12;
            fArray7[0] = (float)d16;
            fArray9[1] = (float)d15;
            fArray8[1] = (float)d13;
            fArray7[1] = (float)d17;
            this.clipLatLonBoundsLine3D = new Line3D(fArray9, fArray8, fArray7);
        }
        double d20 = (d15 - d14) / 150.0;
        fArray7 = null;
        float[] fArray10 = null;
        float[] fArray11 = null;
        double d21 = d4 / 15.0;
        double d22 = d12;
        double d23 = d13 + d21 + d19;
        int n4 = 1 + (int)((d23 - d22) / d21);
        for (d11 = d14; d11 <= d15 + 2.0 * d4 + d19; d11 += d4) {
            bl8 = Math.abs(d11 - d14) < d19 || d11 > d15 + d4;
            bl7 = bl && !bl8;
            d10 = d11 <= d15 ? d11 : d15;
            boolean bl11 = bl6 = Math.abs(Math.IEEEremainder(d10, d4)) < d19;
            if (!bl8 && !bl6) {
                d10 = d4 * Math.floor(d11 / d4);
                if (d10 < d14) continue;
                bl6 = true;
            }
            n3 = 0;
            fArray6 = new float[n4];
            fArray5 = new float[n4];
            fArray4 = new float[n4];
            if (bl9) {
                fArray7 = new float[n4 + 2];
                fArray10 = new float[n4 + 2];
                fArray11 = new float[n4 + 2];
            }
            fArray3 = new float[2];
            fArray2 = new float[2];
            fArray = new float[2];
            bl5 = false;
            for (d9 = d22; d9 <= d23; d9 += d21) {
                d8 = d9 <= d13 ? d9 : d13;
                object2 = this.geogCoords.geog2xyz(d8, d10, d16);
                if (bl7 && d8 == d13) {
                    ++n3;
                    Vect3D vect3D7 = this.geogCoords.geog2xyz(d8 - d21, d10, d16);
                    fArray6[0] = (float)vect3D7.x;
                    fArray5[0] = (float)vect3D7.y;
                    fArray4[0] = (float)vect3D7.z;
                }
                fArray6[n3] = (float)((Vect3D)object2).x;
                fArray5[n3] = (float)((Vect3D)object2).y;
                fArray4[n3] = (float)((Vect3D)object2).z;
                if (bl9) {
                    if (n3 == 0) {
                        object2 = this.geogCoords.geog2xyz(d8, d10, d16);
                        fArray7[n3] = (float)((Vect3D)object2).x;
                        fArray10[n3] = (float)((Vect3D)object2).y;
                        fArray11[n3] = (float)((Vect3D)object2).z;
                    }
                    object2 = this.geogCoords.geog2xyz(d8, d10, d17);
                    fArray7[n3 + 1] = (float)((Vect3D)object2).x;
                    fArray10[n3 + 1] = (float)((Vect3D)object2).y;
                    fArray11[n3 + 1] = (float)((Vect3D)object2).z;
                    if (n3 == n4 - 1) {
                        object2 = this.geogCoords.geog2xyz(d8, d10, d16);
                        fArray7[n3 + 2] = (float)((Vect3D)object2).x;
                        fArray10[n3 + 2] = (float)((Vect3D)object2).y;
                        fArray11[n3 + 2] = (float)((Vect3D)object2).z;
                    }
                }
                bl4 = bl6 && (Math.abs(d8 - d12) < d19 || Math.abs(d8 - d13) < d19) && d10 >= d14 - d19 && d10 <= d15 + d19;
                boolean bl12 = bl3 = bl4 && bl10 && (Math.abs(d8 - d12) < d19 && this.textLabelsToPlot.contains("B") || Math.abs(d8 - d13) < d19 && this.textLabelsToPlot.contains("T"));
                if (bl3) {
                    d7 = 1.0;
                    if (this.textFontSizeFactor > 0.0) {
                        d7 = this.textFontSizeFactor;
                    }
                    d6 = 1.0;
                    if (this.textFontDensity > 0.0) {
                        d6 = this.textFontDensity;
                    }
                    f = (float)(d10 <= 180.0 ? d10 : d10 - 360.0);
                    string4 = "" + Math.abs(f);
                    if (string4.endsWith(".0")) {
                        string4 = string4.replace(".0", "");
                    }
                    if (string4.startsWith("-")) {
                        string4 = string4.replace("-", "");
                    }
                    string3 = "";
                    string3 = (double)Math.abs(f - 180.0f) < d19 ? "180\u00b0" : (f > 0.0f ? "" + string4 + "\u00b0E" : (f < 0.0f ? "" + string4 + "\u00b0W" : "0\u00b0"));
                    stringVectorizer = new StringVectorizer(string3, this.component, this.component.getFont().getName(), 0, (int)(5.0 * d7 * (double)this.component.getFont().getSize()), d6 / 2.0);
                    vect3D6 = this.geogCoords.xyz2geog(fArray6[n3], fArray5[n3], fArray4[n3]);
                    n2 = 0;
                    d5 = d20;
                    if (Math.abs(d8 - d12) < d19) {
                        n2 = 2;
                        d5 *= -1.0;
                    }
                    Vect3D vect3D8 = new Vect3D(d5, 0.0, 0.0);
                    vect3D6 = vect3D6.add(vect3D8);
                    Vect3D vect3D9 = this.geogCoords.geog2xyz(vect3D6);
                    vect3D5 = this.geogCoords.geog2xyz(vect3D6.add(new Vect3D(0.01, 0.0, 0.0)));
                    vect3D4 = vect3D5.sub(vect3D9);
                    vect3D3 = this.geogCoords.geog2xyz(vect3D6.add(new Vect3D(0.0, -0.01, 0.0)));
                    vect3D2 = vect3D3.sub(vect3D9);
                    object = stringVectorizer.toWorldCoords(d, n2, 1, vect3D4, vect3D2);
                    vector2.add((Vect3D[])object);
                    vector3.add(vect3D9);
                }
                if (bl7) {
                    if (d8 == d22) {
                        ++n3;
                    } else if (n3 == 1) {
                        fArray3[0] = fArray6[0];
                        fArray3[1] = fArray6[1];
                        fArray2[0] = fArray5[0];
                        fArray2[1] = fArray5[1];
                        fArray[0] = fArray4[0];
                        fArray[1] = fArray4[1];
                        if (bl4 || bl5) {
                            vector.addElement(new Line3D(fArray3, fArray2, fArray, color, basicStroke));
                        }
                        fArray3 = new float[2];
                        fArray2 = new float[2];
                        fArray = new float[2];
                        n3 = 0;
                    }
                } else {
                    ++n3;
                }
                bl5 = bl4;
            }
            if (bl7) continue;
            vector.addElement(new Line3D(fArray6, fArray5, fArray4, color, basicStroke));
            if (!bl9) continue;
            vector.addElement(new Line3D(fArray7, fArray10, fArray11, color, basicStrokeDashed));
        }
        d21 = d4 / 15.0;
        d22 = d14;
        d23 = d15 + (d21 /= Math.cos(Math.PI / 180 * (d12 + d13) / 2.0)) + d19;
        n4 = 1 + (int)((d23 - d22) / d21);
        for (d11 = d12; d11 <= d13 + 2.0 * d4 + d19; d11 += d4) {
            bl8 = Math.abs(d11 - d12) < d19 || d11 > d13 + d4;
            bl7 = bl && !bl8;
            d10 = d11 <= d13 ? d11 : d13;
            boolean bl13 = bl6 = Math.abs(Math.IEEEremainder(d10, d4)) < d19;
            if (!bl8 && !bl6) {
                d10 = d4 * Math.floor(d11 / d4);
                if (d10 < d12) continue;
                bl6 = true;
            }
            n3 = 0;
            fArray6 = new float[1 + (int)((d23 - d22) / d21)];
            fArray5 = new float[1 + (int)((d23 - d22) / d21)];
            fArray4 = new float[1 + (int)((d23 - d22) / d21)];
            if (bl9) {
                fArray7 = new float[n4];
                fArray10 = new float[n4];
                fArray11 = new float[n4];
            }
            fArray3 = new float[2];
            fArray2 = new float[2];
            fArray = new float[2];
            bl5 = false;
            for (d9 = d22; d9 <= d23; d9 += d21) {
                d8 = d9 <= d15 ? d9 : d15;
                object2 = this.geogCoords.geog2xyz(d10, d8, d16);
                if (bl7 && d8 == d15) {
                    ++n3;
                    Vect3D vect3D10 = this.geogCoords.geog2xyz(d10, d8 - d21, d16);
                    fArray6[0] = (float)vect3D10.x;
                    fArray5[0] = (float)vect3D10.y;
                    fArray4[0] = (float)vect3D10.z;
                }
                fArray6[n3] = (float)((Vect3D)object2).x;
                fArray5[n3] = (float)((Vect3D)object2).y;
                fArray4[n3] = (float)((Vect3D)object2).z;
                if (bl9) {
                    object2 = this.geogCoords.geog2xyz(d10, d8, d17);
                    fArray7[n3] = (float)((Vect3D)object2).x;
                    fArray10[n3] = (float)((Vect3D)object2).y;
                    fArray11[n3] = (float)((Vect3D)object2).z;
                }
                bl4 = bl6 && (Math.abs(d8 - d14) < d19 || Math.abs(d8 - d15) < d19) && d10 >= d12 - d19 && d10 <= d13 + d19;
                boolean bl14 = bl3 = bl4 && bl10 && (Math.abs(d8 - d14) < d19 && this.textLabelsToPlot.contains("L") || Math.abs(d8 - d15) < d19 && this.textLabelsToPlot.contains("R"));
                if (bl3) {
                    d7 = 1.0;
                    if (this.textFontSizeFactor > 0.0) {
                        d7 = this.textFontSizeFactor;
                    }
                    d6 = 1.0;
                    if (this.textFontDensity > 0.0) {
                        d6 = this.textFontDensity;
                    }
                    f = (float)d10;
                    string4 = "" + Math.abs(f);
                    if (string4.endsWith(".0")) {
                        string4 = string4.replace(".0", "");
                    }
                    if (string4.startsWith("-")) {
                        string4 = string4.replace("-", "");
                    }
                    string3 = "";
                    string3 = f > 0.0f ? "" + string4 + "\u00b0N" : (f < 0.0f ? "" + string4 + "\u00b0S" : "0\u00b0");
                    stringVectorizer = new StringVectorizer(string3, this.component, this.component.getFont().getName(), 0, (int)(5.0 * d7 * (double)this.component.getFont().getSize()), d6 / 2.0);
                    vect3D6 = this.geogCoords.xyz2geog(fArray6[n3], fArray5[n3], fArray4[n3]);
                    n2 = 0;
                    d5 = d20;
                    double d24 = Math.cos(d10 * (Math.PI / 180));
                    if (Math.abs(d24) > (double)1.4E-45f) {
                        d5 /= d24;
                    }
                    if (Math.abs(d8 - d14) < d19) {
                        n2 = 2;
                        d5 *= -1.0;
                    }
                    vect3D5 = new Vect3D(0.0, d5, 0.0);
                    vect3D6 = vect3D6.add(vect3D5);
                    vect3D4 = this.geogCoords.geog2xyz(vect3D6);
                    vect3D3 = this.geogCoords.geog2xyz(vect3D6.add(new Vect3D(0.0, 0.01, 0.0)));
                    vect3D2 = vect3D3.sub(vect3D4);
                    object = this.geogCoords.geog2xyz(vect3D6.add(new Vect3D(0.01, 0.0, 0.0)));
                    Vect3D vect3D11 = ((Vect3D)object).sub(vect3D4);
                    Vect3D[] vect3DArray = stringVectorizer.toWorldCoords(d, n2, 1, vect3D2, vect3D11);
                    vector2.add(vect3DArray);
                    vector3.add(vect3D4);
                }
                if (bl7) {
                    if (d8 == d22) {
                        ++n3;
                    } else if (n3 == 1) {
                        fArray3[0] = fArray6[0];
                        fArray3[1] = fArray6[1];
                        fArray2[0] = fArray5[0];
                        fArray2[1] = fArray5[1];
                        fArray[0] = fArray4[0];
                        fArray[1] = fArray4[1];
                        if (bl4 || bl5) {
                            vector.addElement(new Line3D(fArray3, fArray2, fArray, color, basicStroke));
                        }
                        fArray3 = new float[2];
                        fArray2 = new float[2];
                        fArray = new float[2];
                        n3 = 0;
                    }
                } else {
                    ++n3;
                }
                bl5 = bl4;
            }
            if (bl7) continue;
            vector.addElement(new Line3D(fArray6, fArray5, fArray4, color, basicStroke));
            if (!bl9) continue;
            vector.addElement(new Line3D(fArray7, fArray10, fArray11, color, basicStrokeDashed));
        }
        this.latlonLine3D = new Line3D[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.latlonLine3D[n] = (Line3D)vector.elementAt(n);
        }
        if (bl10) {
            this.text3D = new Vect3D[vector2.size()][];
            this.text3Doffset = new Vect3D[vector3.size()];
            for (n = 0; n < vector2.size(); ++n) {
                this.text3D[n] = (Vect3D[])vector2.elementAt(n);
                this.text3Doffset[n] = (Vect3D)vector3.elementAt(n);
            }
        }
    }

    @Override
    public void transform(int n) {
        if (this.isGlobal && this.getTransformed(n)) {
            return;
        }
        Matrix3D.applyPerspTrans(this.xmin, this.ymin, -this.zmin, this.itrans000);
        Matrix3D.applyPerspTrans(this.xmin, this.ymin, -this.zmax, this.itrans001);
        Matrix3D.applyPerspTrans(this.xmin, this.ymax, -this.zmin, this.itrans010);
        Matrix3D.applyPerspTrans(this.xmin, this.ymax, -this.zmax, this.itrans011);
        Matrix3D.applyPerspTrans(this.xmax, this.ymin, -this.zmin, this.itrans100);
        Matrix3D.applyPerspTrans(this.xmax, this.ymin, -this.zmax, this.itrans101);
        Matrix3D.applyPerspTrans(this.xmax, this.ymax, -this.zmin, this.itrans110);
        Matrix3D.applyPerspTrans(this.xmax, this.ymax, -this.zmax, this.itrans111);
        if (this.drawHorizontalScale) {
            Matrix3D.applyPerspTrans(this.horizCoordsSpacedZeroPos.x + this.horizCoordsSpacedValueMin * this.horizScalePathVec.x, this.horizCoordsSpacedZeroPos.y + this.horizCoordsSpacedValueMin * this.horizScalePathVec.y, -(this.horizCoordsSpacedZeroPos.z + this.horizCoordsSpacedValueMin * this.horizScalePathVec.z), this.horizCoordsStart);
            Matrix3D.applyPerspTrans(this.horizCoordsSpacedZeroPos.x + this.horizCoordsSpacedValueMax * this.horizScalePathVec.x, this.horizCoordsSpacedZeroPos.y + this.horizCoordsSpacedValueMax * this.horizScalePathVec.y, -(this.horizCoordsSpacedZeroPos.z + this.horizCoordsSpacedValueMax * this.horizScalePathVec.z), this.horizCoordsEnd);
        }
        this.setLastTransformationIndex(n);
    }

    @Override
    public void paint(Graphics graphics, boolean bl, Vect3D vect3D) {
        block27: {
            double d;
            block26: {
                graphics.setColor(color);
                if (!this.isGlobal) break block26;
                if (this.scalebarVisible && this.mapScaleBar != null) {
                    this.mapScaleBar.paint(graphics, color, bl, vect3D);
                }
                if (!this.visible) break block27;
                for (int i = 0; i < this.globalLine3D.length; ++i) {
                    this.globalLine3D[i].paint(graphics, 0, this.globalLine3D[i].size() - 1, color, basicStroke, bl, vect3D);
                }
                break block27;
            }
            if (this.scalebarVisible) {
                if (this.mapScaleBar != null) {
                    this.mapScaleBar.paint(graphics, color, bl, vect3D);
                }
                if (this.mapScaleBarVect != null) {
                    this.mapScaleBarVect.paint(graphics, color, bl, vect3D);
                }
            }
            if (this.visible) {
                Draw3D.drawLine(graphics, this.itrans000[0], this.itrans000[1], this.itrans001[0], this.itrans001[1]);
                Draw3D.drawLine(graphics, this.itrans001[0], this.itrans001[1], this.itrans011[0], this.itrans011[1]);
                Draw3D.drawLine(graphics, this.itrans011[0], this.itrans011[1], this.itrans010[0], this.itrans010[1]);
                Draw3D.drawLine(graphics, this.itrans010[0], this.itrans010[1], this.itrans000[0], this.itrans000[1]);
                Draw3D.drawLine(graphics, this.itrans100[0], this.itrans100[1], this.itrans101[0], this.itrans101[1]);
                Draw3D.drawLine(graphics, this.itrans101[0], this.itrans101[1], this.itrans111[0], this.itrans111[1]);
                Draw3D.drawLine(graphics, this.itrans111[0], this.itrans111[1], this.itrans110[0], this.itrans110[1]);
                Draw3D.drawLine(graphics, this.itrans110[0], this.itrans110[1], this.itrans100[0], this.itrans100[1]);
                Draw3D.drawLine(graphics, this.itrans000[0], this.itrans000[1], this.itrans100[0], this.itrans100[1]);
                Draw3D.drawLine(graphics, this.itrans001[0], this.itrans001[1], this.itrans101[0], this.itrans101[1]);
                Draw3D.drawLine(graphics, this.itrans010[0], this.itrans010[1], this.itrans110[0], this.itrans110[1]);
                Draw3D.drawLine(graphics, this.itrans011[0], this.itrans011[1], this.itrans111[0], this.itrans111[1]);
                if (this.drawZCoordsSouth) {
                    if (this.zMinCoordsSouth != null) {
                        StringVectorizer.paint(graphics, this.zMinCoordsSouth, this.xmin + (this.xmax - this.xmin) / 100.0, this.ymin, -(this.zmin + (this.zmax - this.zmin) / 200.0), true);
                    }
                    if (this.zMaxCoordsSouth != null) {
                        StringVectorizer.paint(graphics, this.zMaxCoordsSouth, this.xmin + (this.xmax - this.xmin) / 100.0, this.ymin, -this.zmax, true);
                    }
                }
                if (this.drawZCoordsEast) {
                    if (this.zMinCoordsEast != null) {
                        StringVectorizer.paint(graphics, this.zMinCoordsEast, this.xmax, this.ymin + (this.ymax - this.ymin) / 100.0, -(this.zmin + (this.zmax - this.zmin) / 200.0), true);
                    }
                    if (this.zMaxCoordsEast != null) {
                        StringVectorizer.paint(graphics, this.zMaxCoordsEast, this.xmax, this.ymin + (this.ymax - this.ymin) / 100.0, -this.zmax, true);
                    }
                }
            }
            if (this.drawZCoordsSpaced && this.zCoords != null) {
                d = this.zmin_label;
                for (int i = 0; i < this.zCoords.length; ++i) {
                    StringVectorizer.paint(graphics, this.zCoords[i], this.zCoordsSpacedX, this.zCoordsSpacedY, -d, true);
                    d += this.zspace_label;
                }
            }
            if (this.drawHorizontalScale) {
                int n;
                double d2;
                if (this.horizCoordsLabel != null) {
                    d = this.horizmin_label;
                    double d3 = this.horizCoordsSpacedXmin;
                    d2 = this.horizCoordsSpacedYmin;
                    for (n = 0; n < this.horizCoordsLabel.length / 2; ++n) {
                        StringVectorizer.paint(graphics, this.horizCoordsLabel[n], d3, d2, -this.horizCoordsSpacedZ + this.horizLabelZoffest_z, true);
                        d += this.horizspace_label;
                        d3 += this.horizspace_label_x;
                        d2 += this.horizspace_label_y;
                    }
                    d = this.horizmin_label;
                    d3 = this.horizCoordsSpacedXmin;
                    d2 = this.horizCoordsSpacedYmin;
                    for (n = this.horizCoordsLabel.length / 2; n < this.horizCoordsLabel.length; ++n) {
                        StringVectorizer.paint(graphics, this.horizCoordsLabel[n], d3 + this.horizLabelZoffest_x, d2 + this.horizLabelZoffest_y, -this.horizCoordsSpacedZ, true);
                        d += this.horizspace_label;
                        d3 += this.horizspace_label_x;
                        d2 += this.horizspace_label_y;
                    }
                }
                if (this.horizCoordsTic != null) {
                    d = this.horizmin_label;
                    double d4 = this.horizCoordsSpacedXmin;
                    d2 = this.horizCoordsSpacedYmin;
                    for (n = 0; n < this.horizCoordsLabel.length / 2; ++n) {
                        StringVectorizer.paint(graphics, this.horizCoordsTic[n], d4, d2, -this.horizCoordsSpacedZ, true);
                        d += this.horizspace_label;
                        d4 += this.horizspace_label_x;
                        d2 += this.horizspace_label_y;
                    }
                    d = this.horizmin_label;
                    d4 = this.horizCoordsSpacedXmin;
                    d2 = this.horizCoordsSpacedYmin;
                    for (n = this.horizCoordsLabel.length / 2; n < this.horizCoordsLabel.length; ++n) {
                        StringVectorizer.paint(graphics, this.horizCoordsTic[n], d4, d2, -this.horizCoordsSpacedZ, true);
                        d += this.horizspace_label;
                        d4 += this.horizspace_label_x;
                        d2 += this.horizspace_label_y;
                    }
                }
                try {
                    ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Draw3D.drawLine(graphics, this.horizCoordsStart[0], this.horizCoordsStart[1], this.horizCoordsEnd[0], this.horizCoordsEnd[1]);
            }
            if (this.latLonVisible) {
                int n;
                graphics.setColor(color);
                for (n = 0; n < this.latlonLine3D.length; ++n) {
                    this.latlonLine3D[n].paint(graphics, 0, this.latlonLine3D[n].size() - 1, color, this.latlonLine3D[n].basicStroke);
                }
                for (n = 0; n < this.text3D.length; ++n) {
                    StringVectorizer.paint(graphics, this.text3D[n], this.text3Doffset[n].x, this.text3Doffset[n].y, this.text3Doffset[n].z, true);
                }
            }
        }
    }
}

