/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.IOException;
import net.alomax.awt.AJLColor;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.MapPolygons;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Vect3D;
import sdsu.io.ASCIIInputStream;

public class MapObjects {
    protected static final String ProgName = "MapObjects: ";
    public Color color = Color.white;
    protected BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0);
    public GeogCoords geogCoords = null;
    public String filename = null;
    public String name = "";
    protected static Line3D clipLatLonBoundsLine3D = null;
    protected static boolean clipDepth = true;
    protected boolean formatXYZ = false;
    protected boolean formatLonFirst = false;
    protected boolean formatLatFirst = false;
    protected boolean formatLonLat = false;
    protected boolean formatLatLon = false;
    protected boolean formatLatLonDepth = false;
    protected boolean formatLonLatDepth = false;
    protected boolean formatLatLonRadius = false;
    protected boolean formatLonLatRadius = false;
    protected boolean formatLatLonElevMeters = false;
    protected boolean formatLonLatElevMeters = false;
    protected boolean formatPointsOSDRect = false;
    protected boolean formatPointsOSDRectXYZ = false;
    protected boolean clipPolygons = false;
    public static double[] planeCoefficients = null;
    public static double clipDistancePlane = -1.0;

    public MapObjects(Color color, GeogCoords geogCoords, String string, String string2) {
        this.color = color;
        this.geogCoords = geogCoords;
        this.filename = string;
        this.name = string2;
    }

    public MapObjects(Color color, BasicStroke basicStroke, GeogCoords geogCoords, String string, String string2) {
        this(color, basicStroke, geogCoords, string, string2, false);
    }

    public MapObjects(Color color, BasicStroke basicStroke, GeogCoords geogCoords, String string, String string2, boolean bl) {
        this.color = color;
        this.basicStroke = basicStroke;
        this.geogCoords = geogCoords;
        this.filename = string;
        this.name = string2;
        this.clipPolygons = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean setFormat(String string) {
        this.formatLonFirst = false;
        this.formatLatFirst = false;
        this.formatXYZ = false;
        if (string.equals("XYZ") || string.equals("GMT_XYZ")) {
            this.formatXYZ = true;
            return true;
        }
        if (string.equals("XY_")) return true;
        if (string.equals("XY_LONLAT")) {
            return true;
        }
        if (string.equals("POINTS_OSD_RECT")) {
            this.formatPointsOSDRect = true;
            return true;
        }
        if (string.equals("POINTS_OSD_RECT_XYZ")) {
            this.formatPointsOSDRectXYZ = true;
            return true;
        }
        if (!string.substring(0, 4).equals("GMT_")) {
            System.out.println("MapObjects: ERROR: File: <" + this.filename + ">: unrecognized mapline file format: <" + string + ">.");
            return false;
        }
        if (this.geogCoords != null && this.geogCoords.initialized) {
            if (string.equals("GMT_LATLONDEPTH")) {
                this.formatLatLonDepth = true;
                this.formatLatFirst = true;
                return true;
            }
            if (string.equals("GMT_LONLATDEPTH")) {
                this.formatLonLatDepth = true;
                this.formatLonFirst = true;
                return true;
            }
            if (string.equals("GMT_LATLONRADIUS")) {
                this.formatLatLonRadius = true;
                this.formatLatFirst = true;
                return true;
            }
            if (string.equals("GMT_LONLATRADIUS")) {
                this.formatLonLatRadius = true;
                this.formatLonFirst = true;
                return true;
            }
            if (string.equals("GMT_LATLONELEV_M")) {
                this.formatLatLonElevMeters = true;
                this.formatLatFirst = true;
                return true;
            }
            if (string.equals("GMT_LONLATELEV_M")) {
                this.formatLonLatElevMeters = true;
                this.formatLonFirst = true;
                return true;
            }
            if (string.equals("GMT_LONLAT")) {
                this.formatLonLat = true;
                this.formatLonFirst = true;
                return true;
            }
            if (!string.equals("GMT_LATLON")) return true;
            this.formatLatLon = true;
            this.formatLatFirst = true;
            return true;
        }
        System.out.println("MapObjects: ERROR: File: <" + this.filename + ">: mapline file format: <" + string + "> is not x/y, but geographic coordinate transform is not intialized.");
        return false;
    }

    protected Vect3D[] project(float f, float f2, ASCIIInputStream aSCIIInputStream) throws IOException {
        Vect3D[] vect3DArray = new Vect3D[1];
        if (this.formatLonLat) {
            vect3DArray[0] = this.geogCoords.geog2xyz(f2, f, 0.0);
        } else if (this.formatLatLon) {
            vect3DArray[0] = this.geogCoords.geog2xyz(f, f2, 0.0);
        } else if (this.formatLatLonDepth) {
            float f3 = aSCIIInputStream.readFloat();
            vect3DArray[0] = this.geogCoords.geog2xyz(f, f2, f3);
        } else if (this.formatLonLatDepth) {
            float f4 = aSCIIInputStream.readFloat();
            vect3DArray[0] = this.geogCoords.geog2xyz(f2, f, f4);
        } else if (this.formatLatLonRadius) {
            float f5 = aSCIIInputStream.readFloat();
            vect3DArray[0] = this.geogCoords.geog2xyz(f, f2, (float)GeogConstants.PLANET_RADIUS - f5);
        } else if (this.formatLonLatRadius) {
            float f6 = aSCIIInputStream.readFloat();
            vect3DArray[0] = this.geogCoords.geog2xyz(f2, f, (float)GeogConstants.PLANET_RADIUS - f6);
        } else if (this.formatLatLonElevMeters) {
            float f7 = -aSCIIInputStream.readFloat() / 1000.0f;
            vect3DArray[0] = this.geogCoords.geog2xyz(f, f2, f7);
        } else if (this.formatLonLatElevMeters) {
            float f8 = -aSCIIInputStream.readFloat() / 1000.0f;
            vect3DArray[0] = this.geogCoords.geog2xyz(f2, f, f8);
        } else if (this.formatXYZ) {
            float f9 = aSCIIInputStream.readFloat();
            vect3DArray[0] = new Vect3D(f, f2, f9);
        } else if (this.formatPointsOSDRect) {
            vect3DArray = this.createPointsOSDRect(f, f2, aSCIIInputStream, true);
        } else if (this.formatPointsOSDRectXYZ) {
            vect3DArray = this.createPointsOSDRect(f, f2, aSCIIInputStream, false);
        } else {
            vect3DArray[0] = new Vect3D(f, f2, 0.0f);
        }
        return vect3DArray;
    }

    public Vect3D[] createPointsOSDRect(float f, float f2, ASCIIInputStream aSCIIInputStream, boolean bl) throws IOException {
        Object object;
        double d;
        double d2;
        double d3 = aSCIIInputStream.readFloat();
        double d4 = aSCIIInputStream.readFloat();
        double d5 = aSCIIInputStream.readFloat();
        double d6 = aSCIIInputStream.readFloat();
        double d7 = aSCIIInputStream.readFloat();
        double d8 = aSCIIInputStream.readFloat();
        double d9 = aSCIIInputStream.readFloat();
        if (bl) {
            d2 = f;
            d = f2;
        } else {
            object = this.geogCoords.xyz2geog(f, f2, d3);
            d2 = ((Vect3D)object).x;
            d = ((Vect3D)object).y;
        }
        object = new GeogCoords(d2, d, -d4);
        Vect3D vect3D = ((GeogCoords)object).geog2xyz(d2, d, d3);
        Vect3D vect3D2 = new Vect3D(vect3D.x + d8 * Math.cos(d7 * (Math.PI / 180)), vect3D.y, vect3D.z - d8 * Math.sin(d7 * (Math.PI / 180)));
        Vect3D vect3D3 = new Vect3D(vect3D.x + d9 * Math.cos(d7 * (Math.PI / 180)), vect3D.y, vect3D.z - d9 * Math.sin(d7 * (Math.PI / 180)));
        Vect3D[] vect3DArray = new Vect3D[]{new Vect3D(vect3D2.x, vect3D2.y + d5, vect3D2.z), new Vect3D(vect3D2.x, vect3D2.y + d6, vect3D2.z), new Vect3D(vect3D3.x, vect3D3.y + d6, vect3D3.z), new Vect3D(vect3D3.x, vect3D3.y + d5, vect3D3.z)};
        vect3DArray[0] = this.geogCoords.geog2xyz(((GeogCoords)object).xyz2geog(vect3DArray[0]));
        vect3DArray[1] = this.geogCoords.geog2xyz(((GeogCoords)object).xyz2geog(vect3DArray[1]));
        vect3DArray[2] = this.geogCoords.geog2xyz(((GeogCoords)object).xyz2geog(vect3DArray[2]));
        vect3DArray[3] = this.geogCoords.geog2xyz(((GeogCoords)object).xyz2geog(vect3DArray[3]));
        return vect3DArray;
    }

    public void invertColor() {
        this.color = AJLColor.invert(this.color);
    }

    public static Line3D getClipLatLonBoundsLine3D() {
        return clipLatLonBoundsLine3D;
    }

    public static void setClipLatLonBoundsLine3D(Line3D line3D) {
        clipLatLonBoundsLine3D = line3D;
    }

    public static void setClipLatLonBoundsLine3D(Line3D line3D, boolean bl) {
        clipLatLonBoundsLine3D = line3D;
        clipDepth = bl;
    }

    public static void addPolygonPlaneFilter(MapPolygons mapPolygons, double d) {
        if (d <= 0.0) {
            System.out.println("ERROR: initializing PolygonPlaneFilter: clipDistancePlane < 0.0.");
            return;
        }
        clipDistancePlane = d;
        planeCoefficients = MapPolygons.createPolygonPlaneFilterCoefficients(mapPolygons);
    }

    public boolean clip(float f, float f2, float f3) {
        if (!this.clip(f, f2, f3, clipLatLonBoundsLine3D)) {
            if (this.clipPolygons && planeCoefficients != null) {
                double d;
                Vect3D vect3D = this.geogCoords.geog2xyz(f, f2, f3);
                double d2 = planeCoefficients[0];
                double d3 = vect3D.x;
                double d4 = planeCoefficients[1];
                double d5 = vect3D.y;
                double d6 = planeCoefficients[2];
                double d7 = vect3D.z;
                double d8 = planeCoefficients[3];
                double d9 = Math.abs(d2 * d3 + d4 * d5 + d6 * d7 + d8);
                double d10 = d9 / (d = Math.sqrt(d2 * d2 + d4 * d4 + d6 * d6));
                if (d10 > clipDistancePlane) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean clip(float f, float f2, float f3, Line3D line3D) {
        if (line3D == null) {
            return false;
        }
        if (f < line3D.yData[0] || f2 < line3D.xData[0] || clipDepth && f3 < line3D.zData[0]) {
            return true;
        }
        return f > line3D.yData[1] || f2 > line3D.xData[1] || clipDepth && f3 > line3D.zData[1];
    }
}

