/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.io.InputStream;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.GlobalPolygon3D;
import net.alomax.geog.MapLines;
import net.alomax.graphics3d.Vect2D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.ASCIIOutputStream;

public class MapPolygons
extends MapLines {
    protected static final String ProgName = "MapPolygons: ";
    public GlobalPolygon3D[] polygonSegmentArray = new GlobalPolygon3D[0];
    protected int fill = 0;
    protected int border = 1;
    protected static String endline = System.getProperty("line.separator");

    public MapPolygons(InputStream inputStream, String string, String string2, GeogCoords geogCoords, Color color, String string3, String string4, Vect3D vect3D, boolean bl) throws Exception {
        this(inputStream, string, string2, geogCoords, color, new BasicStroke(1.0f, 2, 0), string3, string4, vect3D, bl);
    }

    public MapPolygons(InputStream inputStream, String string, String string2, GeogCoords geogCoords, Color color, BasicStroke basicStroke, String string3, String string4, Vect3D vect3D, boolean bl) throws Exception {
        super(inputStream, string, string2, geogCoords, color, basicStroke, vect3D, bl);
        this.convertArray();
        this.lineSegmentArray = null;
        for (int i = 0; i < this.polygonSegmentArray.length; ++i) {
            this.polygonSegmentArray[i].setFill(string3);
            this.polygonSegmentArray[i].setBorder(string4);
        }
    }

    public void convertArray() {
        this.polygonSegmentArray = new GlobalPolygon3D[this.lineSegmentArray.length];
        for (int i = 0; i < this.lineSegmentArray.length; ++i) {
            GlobalLine3D globalLine3D = this.lineSegmentArray[i];
            this.polygonSegmentArray[i] = new GlobalPolygon3D(globalLine3D.xData, globalLine3D.yData, globalLine3D.zData, globalLine3D.center, globalLine3D.canBeHidden);
        }
    }

    @Override
    public void paint(Graphics graphics, boolean bl, Vect3D vect3D) {
        for (int i = 0; i < this.polygonSegmentArray.length; ++i) {
            this.polygonSegmentArray[i].paint(graphics, 0, this.polygonSegmentArray[i].size() - 1, this.color, this.basicStroke, bl, vect3D);
        }
    }

    @Override
    public int printLatLong(ASCIIOutputStream aSCIIOutputStream, GeogCoords geogCoords) throws Exception {
        aSCIIOutputStream.writeWord("> GMT_LATLONDEPTH" + endline);
        for (int i = 0; i < this.polygonSegmentArray.length; ++i) {
            aSCIIOutputStream.writeWord(">" + endline);
            GlobalPolygon3D globalPolygon3D = this.polygonSegmentArray[i];
            for (int j = 0; j < globalPolygon3D.xData.length; ++j) {
                Vect3D vect3D = geogCoords.xyz2geog(globalPolygon3D.xData[j], globalPolygon3D.yData[j], globalPolygon3D.zData[j]);
                aSCIIOutputStream.writeFloat((float)vect3D.x);
                aSCIIOutputStream.writeWord(" ");
                aSCIIOutputStream.writeFloat((float)vect3D.y);
                aSCIIOutputStream.writeWord(" ");
                aSCIIOutputStream.writeFloat((float)vect3D.z);
                aSCIIOutputStream.writeWord(endline);
            }
        }
        return this.polygonSegmentArray.length;
    }

    @Override
    public boolean contains(double d, double d2) {
        Vect2D vect2D = this.geogCoords.geog2xy(d2, d);
        for (GlobalPolygon3D globalPolygon3D : this.polygonSegmentArray) {
            if (!globalPolygon3D.contains(vect2D.x, vect2D.y)) continue;
            return true;
        }
        return false;
    }

    public static double[] createPolygonPlaneFilterCoefficients(MapPolygons mapPolygons) {
        if (mapPolygons.polygonSegmentArray.length < 1) {
            System.out.println("ERROR: initializing PolygonPlaneFilter: empty polygon definition.");
            return null;
        }
        GlobalPolygon3D globalPolygon3D = mapPolygons.polygonSegmentArray[0];
        double d = globalPolygon3D.xData[0];
        double d2 = globalPolygon3D.yData[0];
        double d3 = globalPolygon3D.zData[0];
        double d4 = globalPolygon3D.xData[1];
        double d5 = globalPolygon3D.yData[1];
        double d6 = globalPolygon3D.zData[1];
        double d7 = globalPolygon3D.xData[2];
        double d8 = globalPolygon3D.yData[2];
        double d9 = globalPolygon3D.zData[2];
        double d10 = d4 - d;
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = d7 - d;
        double d14 = d8 - d2;
        double d15 = d9 - d3;
        double d16 = d11 * d15 - d14 * d12;
        double d17 = d13 * d12 - d10 * d15;
        double d18 = d10 * d14 - d11 * d13;
        double d19 = -d16 * d - d17 * d2 - d18 * d3;
        double[] dArray = new double[]{d16, d17, d18, d19};
        return dArray;
    }
}

