/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.alomax.geog.Grid3D;
import net.alomax.geog.MapScale;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;

public class MapScaleRectangular
extends MapScale {
    protected final int nPts = 4;
    protected Vect3D[] points = new Vect3D[4];
    protected Vect3D[] textCoords;
    protected double xOffset;
    protected double yOffset;
    protected double zOffset;

    public MapScaleRectangular(Grid3D grid3D, double d, Vect3D vect3D, double d2, double d3) {
        this(grid3D.component, grid3D.xmin, grid3D.xmax, grid3D.ymin, grid3D.ymax, grid3D.zmin, grid3D.zmax, d, vect3D, d2, d3, 90.0, new Vect3D(0.0, 1.0, 0.0));
    }

    public MapScaleRectangular(Grid3D grid3D, double d, Vect3D vect3D, double d2, double d3, double d4) {
        this(grid3D.component, grid3D.xmin, grid3D.xmax, grid3D.ymin, grid3D.ymax, grid3D.zmin, grid3D.zmax, d, vect3D, d2, d3, d4, new Vect3D(Math.sin(Math.PI * (-90.0 + d4) / 180.0), Math.cos(Math.PI * (90.0 - d4) / 180.0), 0.0));
    }

    public MapScaleRectangular(Grid3D grid3D, double d, Vect3D vect3D, double d2, double d3, double d4, Vect3D vect3D2) {
        this(grid3D.component, grid3D.xmin, grid3D.xmax, grid3D.ymin, grid3D.ymax, grid3D.zmin, grid3D.zmax, d, vect3D, d2, d3, d4, vect3D2);
    }

    public MapScaleRectangular(Component component, double d, double d2, double d3, double d4, double d5, Vect3D vect3D, double d6, double d7) {
        this(component, d, d2, d3, d4, 0.0, 0.0, d5, vect3D, d6, d7, 90.0, new Vect3D(0.0, 0.0, 1.0));
    }

    public MapScaleRectangular(Component component, double d, double d2, double d3, double d4, double d5, double d6, double d7, Vect3D vect3D, double d8, double d9, double d10) {
        this(component, d, d2, d3, d4, d5, d6, d7, vect3D, d8, d9, d10, new Vect3D(0.0, 0.0, 1.0));
    }

    public MapScaleRectangular(Component component, double d, double d2, double d3, double d4, double d5, double d6, double d7, Vect3D vect3D, double d8, double d9, double d10, Vect3D vect3D2) {
        float f = (float)(d2 - d);
        float f2 = (float)Math.pow(10.0, 1 + (int)(Math.log(f) / Math.log(10.0)));
        float f3 = 3.0f;
        do {
            if (f2 > f / f3) {
                f2 /= 2.0f;
            }
            if (f2 > f / f3) {
                f2 /= 2.5f;
            }
            if (!(f2 > f / f3)) continue;
            f2 /= 2.0f;
        } while (f2 > f / f3);
        float f4 = f2 / 30.0f;
        double d11 = d + 0.95 * (d2 - d);
        double d12 = d3 + 0.05 * (d4 - d3);
        double d13 = d5;
        if (vect3D != null) {
            d11 = (double)f2 / 2.0 + d + vect3D.x * (d2 - d);
            d12 = d3 + vect3D.y * (d4 - d3);
            d13 = d5 + vect3D.z * (d6 - d5);
        }
        Vect3D vect3D3 = new Vect3D(Math.sin(Math.PI / 180 * d10), Math.cos(Math.PI / 180 * d10), 0.0);
        Vect3D vect3D4 = new Vect3D(d11, d12, -d13);
        this.points[0] = vect3D4.add(vect3D2.mult(f4));
        this.points[1] = vect3D4;
        this.points[2] = vect3D4 = vect3D4.sub(vect3D3.mult(f2));
        this.points[3] = vect3D4.add(vect3D2.mult(f4));
        double d14 = 1.0;
        if (d8 > 0.0) {
            d14 = d8;
        }
        double d15 = 3.0;
        if (d9 > 0.0) {
            d15 = d9;
        }
        StringVectorizer stringVectorizer = new StringVectorizer(String.valueOf(f2) + " km", component, component.getFont().getName(), 0, (int)(0.5 + 1.25 * d14 * (double)component.getFont().getSize()), d15);
        this.textCoords = stringVectorizer.toWorldCoords(d7, 1, -1, vect3D3, vect3D2);
        this.xOffset = (this.points[0].x + this.points[2].x) / 2.0;
        this.yOffset = (this.points[0].y + this.points[2].y) / 2.0;
        this.zOffset = (this.points[0].z + this.points[2].z) / 2.0;
    }

    public void paint(Graphics graphics, Color color) {
        this.paint(graphics, color, false, null);
    }

    @Override
    public void paint(Graphics graphics, Color color, boolean bl, Vect3D vect3D) {
        Graphics graphics2 = graphics.create();
        if (color != null) {
            graphics2.setColor(color);
        }
        if (this.basicStroke != null) {
            try {
                ((Graphics2D)graphics2).setStroke(this.basicStroke);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Polygon polygon = new Polygon();
        int[] nArray = new int[3];
        for (int i = 0; i < 4; ++i) {
            Matrix3D.applyPerspTrans(this.points[i].x, this.points[i].y, this.points[i].z, nArray);
            polygon.addPoint(nArray[0], nArray[1]);
        }
        Draw3D.fillPolygon(graphics2, polygon);
        StringVectorizer.paint(graphics2, this.textCoords, this.xOffset, this.yOffset, this.zOffset, true);
        graphics2.dispose();
    }
}

