/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.net.URL;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.Global3D;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.GlobalPolygon3D;
import net.alomax.geog.GlobalSymbol3D;
import net.alomax.geog.MapObjects;
import net.alomax.geotools.ShapeReader;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Symbol3D;
import net.alomax.graphics3d.Vect3D;

public class MapShapefile
extends MapObjects {
    protected static final String ProgName = "MapShapefile: ";
    protected Global3D[] segmentArray = new Global3D[0];
    protected BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0);
    public static final double NO_FORCE_Z = Double.NaN;

    public MapShapefile(URL uRL, String string, GeogCoords geogCoords, Color color, String string2, String string3, String string4, double d, double d2, Vect3D vect3D, boolean bl, double d3, Line3D line3D) throws Exception {
        super(color, geogCoords, uRL.toString(), string);
        Vect3D vect3D2;
        Object object;
        Object object2;
        float[] fArray;
        double[][] dArray;
        int n;
        boolean bl2;
        boolean bl3 = bl2 = d3 != Double.NaN;
        if (d2 > 0.0) {
            this.basicStroke = new BasicStroke((float)d2, 2, 0);
        }
        ShapeReader shapeReader = new ShapeReader(uRL);
        double[][][] dArray2 = shapeReader.getPolygons(0);
        double[][][] dArray3 = shapeReader.getLineStrings(0);
        double[][][] dArray4 = shapeReader.getPoints(0);
        this.segmentArray = new Global3D[dArray2.length + dArray3.length + dArray4.length];
        for (n = 0; n < dArray2.length; ++n) {
            dArray = dArray2[n];
            fArray = new float[dArray.length];
            object2 = new float[dArray.length];
            object = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                vect3D2 = geogCoords.geog2xyz(dArray[i][1], dArray[i][0], dArray[i][2]);
                fArray[i] = (float)vect3D2.x;
                object2[i] = (float)vect3D2.y;
                object[i] = bl2 ? (float)d3 : (float)vect3D2.z;
            }
            GlobalPolygon3D globalPolygon3D = new GlobalPolygon3D(fArray, (float[])object2, (float[])object, vect3D, bl);
            globalPolygon3D.setFill(string2);
            globalPolygon3D.setBorder(string3);
            this.segmentArray[n] = globalPolygon3D;
        }
        for (n = dArray2.length; n < dArray2.length + dArray3.length; ++n) {
            int n2;
            dArray = dArray3[n];
            fArray = new float[dArray.length];
            object2 = new float[dArray.length];
            object = new float[dArray.length];
            for (n2 = 0; !(n2 >= dArray.length || line3D != null && this.clip((float)dArray[n2][1], (float)dArray[n2][0], (float)dArray[n2][2], line3D)); ++n2) {
                vect3D2 = geogCoords.geog2xyz(dArray[n2][1], dArray[n2][0], dArray[n2][2]);
                fArray[n2] = (float)vect3D2.x;
                object2[n2] = (float)vect3D2.y;
                object[n2] = bl2 ? (float)d3 : (float)vect3D2.z;
            }
            this.segmentArray[n] = n2 < dArray.length ? null : new GlobalLine3D(fArray, (float[])object2, (float[])object, color, vect3D, bl);
        }
        for (n = dArray2.length + dArray3.length; n < dArray2.length + dArray3.length + dArray4.length; ++n) {
            dArray = dArray4[n];
            for (int i = 0; i < dArray.length; ++i) {
                object2 = geogCoords.geog2xyz(dArray[i][1], dArray[i][0], bl2 ? d3 : dArray[i][2]);
                object = Symbol3D.createSymbol(string4, (Vect3D)object2, d, color);
                GlobalSymbol3D globalSymbol3D = new GlobalSymbol3D((Symbol3D)object, vect3D, bl);
                this.segmentArray[n] = globalSymbol3D;
            }
        }
    }

    public void paint(Graphics graphics, boolean bl, Vect3D vect3D) {
        for (int i = 0; i < this.segmentArray.length; ++i) {
            if (this.segmentArray[i] == null) continue;
            this.segmentArray[i].paint(graphics, 0, this.segmentArray[i].size() - 1, this.color, this.basicStroke, bl, vect3D);
        }
    }

    public void transform(int n) {
        for (int i = 0; i < this.segmentArray.length; ++i) {
            if (this.segmentArray[i] == null) continue;
            try {
                ((GlobalSymbol3D)this.segmentArray[i]).transform(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

