/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geotools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;

public class ShapeReader {
    ShapefileDataStore store = null;

    private static URL getResource(String string) {
        return ShapeReader.class.getClassLoader().getResource(string);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            URL uRL = null;
            if (stringArray.length > 0) {
                uRL = new File(stringArray[0]).toURL();
            } else {
                object = new JFileChooser();
                int n = ((JFileChooser)object).showOpenDialog(null);
                if (n == 0) {
                    File file = ((JFileChooser)object).getSelectedFile();
                    uRL = file.toURL();
                } else {
                    System.exit(0);
                }
            }
            System.out.println("shapeURL: " + uRL);
            object = new ShapeReader(uRL);
            ((ShapeReader)object).printAtributes();
            System.out.println();
            ((ShapeReader)object).getLineStrings(1);
        }
        catch (Exception exception) {
            System.out.println("Ops! Something went wrong :-(");
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public ShapeReader(URL uRL) throws Exception {
        if (uRL.toString().startsWith("file://")) {
            uRL = new URL(uRL.toString().replace("file://", "file:/"));
        }
        this.store = new ShapefileDataStore(uRL);
    }

    public void printAtributes() throws Exception {
        AttributeType attributeType;
        int n;
        FeatureSource featureSource = this.store.getFeatureSource(this.store.getTypeNames()[0]);
        FeatureResults featureResults = featureSource.getFeatures();
        FeatureType featureType = featureSource.getSchema();
        System.out.println("FID\t");
        for (n = 0; n < featureType.getAttributeCount(); ++n) {
            attributeType = featureType.getAttributeType(n);
            if (Geometry.class.isAssignableFrom(attributeType.getType())) continue;
            System.out.print(attributeType.getType().getName() + "\t");
        }
        System.out.println();
        for (n = 0; n < featureType.getAttributeCount(); ++n) {
            attributeType = featureType.getAttributeType(n);
            if (Geometry.class.isAssignableFrom(attributeType.getType())) continue;
            System.out.print(attributeType.getName() + "\t");
        }
        System.out.println();
        FeatureReader featureReader = featureResults.reader();
        while (featureReader.hasNext()) {
            attributeType = featureReader.next();
            System.out.print(attributeType.getID() + "\t");
            for (int i = 0; i < attributeType.getNumberOfAttributes(); ++i) {
                Object object = attributeType.getAttribute(i);
                if (object instanceof Geometry) continue;
                System.out.print(object + "\t");
            }
            System.out.println();
        }
        featureReader.close();
    }

    public double[][][] getLineStrings(int n) throws Exception {
        Object object;
        FeatureSource featureSource = this.store.getFeatureSource(this.store.getTypeNames()[0]);
        FeatureResults featureResults = featureSource.getFeatures();
        FeatureReader featureReader = featureResults.reader();
        Vector<double[][]> vector = new Vector<double[][]>();
        while (featureReader.hasNext()) {
            object = featureReader.next();
            if (n > 0) {
                System.out.println("ID: " + object.getID());
            }
            if (n > 2) {
                System.out.println("FeatureType: " + object.getFeatureType());
            }
            Geometry geometry = object.getDefaultGeometry();
            if (n > 0) {
                System.out.println("DefaultGeometry: " + geometry.getGeometryType());
            }
            if (geometry instanceof MultiLineString) {
                if (n > 0) {
                    System.out.println("DefaultGeometry is com.vivid.jts.geom.MultiLineString!");
                }
                MultiLineString multiLineString = (MultiLineString)geometry;
                if (n > 0) {
                    System.out.println("Dimension(): " + multiLineString.getDimension());
                }
                if (n > 0) {
                    System.out.println("NumGeometries(): " + multiLineString.getNumGeometries());
                }
                int n2 = multiLineString.getNumGeometries();
                if (n > 0) {
                    System.out.println("NumPoints(): " + multiLineString.getNumPoints());
                }
                for (int i = 0; i < n2; ++i) {
                    if (n > 1) {
                        System.out.println("LineString(): " + i);
                    }
                    LineString lineString = (LineString)multiLineString.getGeometryN(i);
                    Coordinate[] coordinateArray = lineString.getCoordinates();
                    double[][] dArray = new double[coordinateArray.length][3];
                    vector.add(dArray);
                    for (int j = 0; j < coordinateArray.length; ++j) {
                        double d = coordinateArray[j].x;
                        if (Double.isNaN(d)) {
                            d = 0.0;
                        }
                        dArray[j][0] = d;
                        double d2 = coordinateArray[j].y;
                        if (Double.isNaN(d2)) {
                            d2 = 0.0;
                        }
                        dArray[j][1] = d2;
                        double d3 = coordinateArray[j].z;
                        if (Double.isNaN(d3)) {
                            d3 = 0.0;
                        }
                        dArray[j][2] = d3;
                        if (n <= 2) continue;
                        System.out.println("  " + dArray[j][0] + ", " + dArray[j][1] + ", " + dArray[j][2]);
                    }
                }
            }
            if (n <= 0) continue;
            System.out.println();
        }
        featureReader.close();
        object = new double[vector.size()][][];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (Feature)((double[][])vector.get(i));
        }
        return object;
    }

    public double[][][] getPolygons(int n) throws Exception {
        Object object;
        FeatureSource featureSource = this.store.getFeatureSource(this.store.getTypeNames()[0]);
        FeatureResults featureResults = featureSource.getFeatures();
        FeatureReader featureReader = featureResults.reader();
        Vector<double[][]> vector = new Vector<double[][]>();
        while (featureReader.hasNext()) {
            object = featureReader.next();
            if (n > 0) {
                System.out.println("ID: " + object.getID());
            }
            if (n > 2) {
                System.out.println("FeatureType: " + object.getFeatureType());
            }
            Geometry geometry = object.getDefaultGeometry();
            if (n > 0) {
                System.out.println("DefaultGeometry: " + geometry.getGeometryType());
            }
            if (geometry instanceof MultiPolygon) {
                if (n > 0) {
                    System.out.println("DefaultGeometry is com.vivid.jts.geom.MultiPolygon!");
                }
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                if (n > 0) {
                    System.out.println("Dimension(): " + multiPolygon.getDimension());
                }
                if (n > 0) {
                    System.out.println("NumGeometries(): " + multiPolygon.getNumGeometries());
                }
                int n2 = multiPolygon.getNumGeometries();
                if (n > 0) {
                    System.out.println("NumPoints(): " + multiPolygon.getNumPoints());
                }
                for (int i = 0; i < n2; ++i) {
                    if (n > 1) {
                        System.out.println("Polygon(): " + i);
                    }
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                    Coordinate[] coordinateArray = polygon.getCoordinates();
                    double[][] dArray = new double[coordinateArray.length][3];
                    vector.add(dArray);
                    for (int j = 0; j < coordinateArray.length; ++j) {
                        double d = coordinateArray[j].x;
                        if (Double.isNaN(d)) {
                            d = 0.0;
                        }
                        dArray[j][0] = d;
                        double d2 = coordinateArray[j].y;
                        if (Double.isNaN(d2)) {
                            d2 = 0.0;
                        }
                        dArray[j][1] = d2;
                        double d3 = coordinateArray[j].z;
                        if (Double.isNaN(d3)) {
                            d3 = 0.0;
                        }
                        dArray[j][2] = d3;
                        if (n <= 2) continue;
                        System.out.println("  " + dArray[j][0] + ", " + dArray[j][1] + ", " + dArray[j][2]);
                    }
                }
            }
            if (n <= 0) continue;
            System.out.println();
        }
        featureReader.close();
        object = new double[vector.size()][][];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (Feature)((double[][])vector.get(i));
        }
        return object;
    }

    public double[][][] getPoints(int n) throws Exception {
        Object object;
        FeatureSource featureSource = this.store.getFeatureSource(this.store.getTypeNames()[0]);
        FeatureResults featureResults = featureSource.getFeatures();
        FeatureReader featureReader = featureResults.reader();
        Vector<double[][]> vector = new Vector<double[][]>();
        boolean bl = false;
        while (featureReader.hasNext()) {
            object = featureReader.next();
            if (n > 0) {
                System.out.println("ID: " + object.getID());
            }
            if (n > 2) {
                System.out.println("FeatureType: " + object.getFeatureType());
            }
            Geometry geometry = object.getDefaultGeometry();
            if (n > 0) {
                System.out.println("DefaultGeometry: " + geometry.getGeometryType());
            }
            int n2 = 0;
            MultiPoint multiPoint = null;
            if (geometry instanceof MultiPoint) {
                if (n > 0) {
                    System.out.println("DefaultGeometry is com.vivid.jts.geom.MultiPoint!");
                }
                multiPoint = (MultiPoint)geometry;
                if (n > 0) {
                    System.out.println("Dimension(): " + multiPoint.getDimension());
                }
                if (n > 0) {
                    System.out.println("NumGeometries(): " + multiPoint.getNumGeometries());
                }
                n2 = multiPoint.getNumGeometries();
                if (n > 0) {
                    System.out.println("NumPoints(): " + multiPoint.getNumPoints());
                }
            } else if (geometry instanceof Point) {
                if (n > 0) {
                    System.out.println("DefaultGeometry is com.vivid.jts.geom.Point!");
                }
                n2 = 1;
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (n > 1) {
                        System.out.println("Point(): " + i);
                    }
                    Point point = null;
                    point = bl ? (Point)multiPoint.getGeometryN(i) : (Point)geometry;
                    Coordinate[] coordinateArray = point.getCoordinates();
                    double[][] dArray = new double[coordinateArray.length][3];
                    vector.add(dArray);
                    for (int j = 0; j < coordinateArray.length; ++j) {
                        double d = coordinateArray[j].x;
                        if (Double.isNaN(d)) {
                            d = 0.0;
                        }
                        dArray[j][0] = d;
                        double d2 = coordinateArray[j].y;
                        if (Double.isNaN(d2)) {
                            d2 = 0.0;
                        }
                        dArray[j][1] = d2;
                        double d3 = coordinateArray[j].z;
                        if (Double.isNaN(d3)) {
                            d3 = 0.0;
                        }
                        dArray[j][2] = d3;
                        if (n <= 2) continue;
                        System.out.println("  " + dArray[j][0] + ", " + dArray[j][1] + ", " + dArray[j][2]);
                    }
                }
            }
            if (n <= 0) continue;
            System.out.println();
        }
        featureReader.close();
        object = new double[vector.size()][][];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (Feature)((double[][])vector.get(i));
        }
        return object;
    }
}

