/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import JSci.awt.AbstractGraphModel;
import JSci.awt.Graph2DModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import net.alomax.graphics2d.objects.DataMarker;

public final class MarkerGraph2DModel
extends AbstractGraphModel
implements Graph2DModel,
TableModelListener {
    private static final int X_AXIS_COLUMN = 0;
    private static final int SERIES_COLUMN = 1;
    private float[] defaultXAxis = new float[0];
    private final List series = new ArrayList();
    private int pos = 0;
    private DataSeries curSeries = null;

    public void setXAxis(float[] fArray) {
        if (this.defaultXAxis.length != fArray.length) {
            this.defaultXAxis = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.defaultXAxis, 0, fArray.length);
    }

    public void setXAxis(double[] dArray) {
        if (this.defaultXAxis.length != dArray.length) {
            this.defaultXAxis = new float[dArray.length];
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.defaultXAxis[i] = (float)dArray[i];
        }
    }

    public void setXAxis(float f, float f2, int n) {
        if (this.defaultXAxis.length != n) {
            this.defaultXAxis = new float[n];
        }
        float f3 = (f2 - f) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            this.defaultXAxis[i] = f3 * (float)i + f;
        }
    }

    public void addSeries(float[] fArray, DataMarker[] dataMarkerArray) {
        this.addSeries(new DataSeries(this.defaultXAxis, fArray, dataMarkerArray));
    }

    public void addSeries(double[] dArray, DataMarker[] dataMarkerArray) {
        this.addSeries(new DataSeries(this.defaultXAxis, dArray, dataMarkerArray));
    }

    public void addSeries(DataSeries dataSeries) {
        this.series.add(dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void addSeries(float[] fArray, float[] fArray2, DataMarker[] dataMarkerArray) {
        this.addSeries(new DataSeries(fArray, fArray2, dataMarkerArray));
    }

    public void addSeries(float[] fArray, double[] dArray, DataMarker[] dataMarkerArray) {
        this.addSeries(new DataSeries(fArray, dArray, dataMarkerArray));
    }

    public void addSeries(double[] dArray, double[] dArray2, DataMarker[] dataMarkerArray) {
        this.addSeries(new DataSeries(dArray, dArray2, dataMarkerArray));
    }

    public void changeSeries(int n, DataSeries dataSeries) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.set(n, dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void changeSeries(int n, float[] fArray) {
        this.getSeries(n).setValues(fArray);
    }

    public void changeSeries(int n, double[] dArray) {
        this.getSeries(n).setValues(dArray);
    }

    public void removeSeries(int n) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.remove(n);
        this.fireGraphDataChanged();
    }

    public DataSeries getSeries(int n) {
        return (DataSeries)this.series.get(n);
    }

    public void setSeriesVisible(int n, boolean bl) {
        this.getSeries(n).setVisible(bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getColumn() == 1) {
            this.fireGraphSeriesUpdated(this.series.indexOf(tableModelEvent.getSource()));
        } else {
            this.fireGraphDataChanged();
        }
    }

    public DataMarker getMarker(int n) {
        return this.curSeries.getMarker(n);
    }

    @Override
    public float getXCoord(int n) {
        return this.curSeries.getXCoord(n);
    }

    @Override
    public float getYCoord(int n) {
        return this.curSeries.getValue(n);
    }

    @Override
    public int seriesLength() {
        return this.curSeries.length();
    }

    @Override
    public void firstSeries() {
        this.curSeries = this.getSeries(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = this.getSeries(++this.pos);
        }
    }

    @Override
    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = this.getSeries(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }

    public static class DataSeries
    extends AbstractTableModel {
        protected DataMarker[] marker = new DataMarker[0];
        protected float[] xAxis = new float[0];
        protected float[] series = new float[0];
        private boolean isVis = true;

        protected DataSeries() {
        }

        public DataSeries(float[] fArray, float[] fArray2, DataMarker[] dataMarkerArray) {
            this.setMarkers(dataMarkerArray);
            this.setXAxis(fArray);
            this.setValues(fArray2);
        }

        public DataSeries(float[] fArray, double[] dArray, DataMarker[] dataMarkerArray) {
            this.setMarkers(dataMarkerArray);
            this.setXAxis(fArray);
            this.setValues(dArray);
        }

        public DataSeries(double[] dArray, double[] dArray2, DataMarker[] dataMarkerArray) {
            this.setMarkers(dataMarkerArray);
            this.setXAxis(dArray);
            this.setValues(dArray2);
        }

        public void setMarkers(DataMarker[] dataMarkerArray) {
            if (this.marker.length != dataMarkerArray.length) {
                this.marker = new DataMarker[dataMarkerArray.length];
            }
            System.arraycopy(dataMarkerArray, 0, this.marker, 0, dataMarkerArray.length);
            this.fireTableColumnUpdated(1);
        }

        public void setXAxis(float[] fArray) {
            if (this.xAxis.length != fArray.length) {
                this.xAxis = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.xAxis, 0, fArray.length);
            this.fireTableColumnUpdated(0);
        }

        public void setXAxis(double[] dArray) {
            if (this.xAxis.length != dArray.length) {
                this.xAxis = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.xAxis[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(0);
        }

        public void setValues(float[] fArray) {
            if (this.series.length != fArray.length) {
                this.series = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.series, 0, fArray.length);
            this.fireTableColumnUpdated(1);
        }

        public void setValues(double[] dArray) {
            if (this.series.length != dArray.length) {
                this.series = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.series[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(1);
        }

        public DataMarker getMarker(int n) {
            return this.marker[n];
        }

        public void setMarker(int n, DataMarker dataMarker) {
            this.marker[n] = dataMarker;
            this.fireTableCellUpdated(n, 0);
        }

        public float getXCoord(int n) {
            return this.xAxis[n];
        }

        public void setXCoord(int n, float f) {
            this.xAxis[n] = f;
            this.fireTableCellUpdated(n, 0);
        }

        public float getValue(int n) {
            return this.series[n];
        }

        public void setValue(int n, float f) {
            this.series[n] = f;
            this.fireTableCellUpdated(n, 1);
        }

        public int length() {
            return Math.min(this.xAxis.length, this.series.length);
        }

        public final void setVisible(boolean bl) {
            if (bl != this.isVis) {
                this.isVis = bl;
                this.fireTableDataChanged();
            }
        }

        public final boolean isVisible() {
            return this.isVis;
        }

        private void fireTableColumnUpdated(int n) {
            if (n == 0) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.xAxis.length - 1, n));
            } else if (n == 1) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.series.length - 1, n));
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "X";
            }
            if (n == 1) {
                return "Y";
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return Float.class;
        }

        @Override
        public final int getRowCount() {
            return this.length();
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Float(this.getXCoord(n));
            }
            if (n2 == 1) {
                return new Float(this.getValue(n));
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.setXCoord(n, ((Float)object).floatValue());
            } else if (n2 == 1) {
                this.setValue(n, ((Float)object).floatValue());
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

