/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Graphics;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Drawable3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;

public class Arrowhead
extends Drawable3D {
    protected static final int NUM_ARROW_BASE = 16;
    protected static final int NUM_ARROW_BODY = 8;
    protected Color color;
    protected int[][] itransBase = null;
    protected int[][][] itransBody = null;
    protected Vect3D[] arrowBase;
    protected Vect3D[][] arrowBody;

    public Arrowhead(Vect3D vect3D, Vect3D vect3D2, Vect3D vect3D3, Vect3D vect3D4, Color color, double d, double d2) {
        double d3;
        int n;
        vect3D2 = vect3D2.normalize();
        vect3D3 = vect3D3.normalize();
        vect3D4 = vect3D4.normalize();
        this.color = color;
        this.itransBase = new int[16][3];
        this.itransBody = new int[8][2][3];
        Vect3D vect3D5 = vect3D.sub(new Vect3D(vect3D2).mult(d));
        this.arrowBase = new Vect3D[16];
        for (n = 0; n < 16; ++n) {
            d3 = (double)n * Math.PI * 2.0 / 16.0;
            this.arrowBase[n] = vect3D5.add(vect3D3.mult(d2 * Math.cos(d3))).add(vect3D4.mult(d2 * Math.sin(d3)));
        }
        this.arrowBody = new Vect3D[8][2];
        for (n = 0; n < 8; ++n) {
            d3 = (double)n * Math.PI * 2.0 / 8.0;
            this.arrowBody[n][0] = vect3D;
            this.arrowBody[n][1] = vect3D5.add(vect3D3.mult(d2 * Math.cos(d3))).add(vect3D4.mult(d2 * Math.sin(d3)));
        }
    }

    @Override
    public void transform(int n) {
        int n2;
        if (this.getTransformed(n)) {
            return;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            Matrix3D.applyPerspTrans(this.arrowBase[n2], this.itransBase[n2]);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            Matrix3D.applyPerspTrans(this.arrowBody[n2][0], this.itransBody[n2][0]);
            Matrix3D.applyPerspTrans(this.arrowBody[n2][1], this.itransBody[n2][1]);
        }
        this.setLastTransformationIndex(n);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, this.color);
    }

    @Override
    public void paint(Graphics graphics, Color color) {
        int n;
        graphics.setColor(color);
        for (n = 0; n < 15; ++n) {
            int n2 = n < 15 ? n + 1 : 0;
            Draw3D.drawLine(graphics, this.itransBase[n][0], this.itransBase[n][1], this.itransBase[n2][0], this.itransBase[n2][1]);
        }
        for (n = 0; n < 8; ++n) {
            Draw3D.drawLine(graphics, this.itransBody[n][0][0], this.itransBody[n][0][1], this.itransBody[n][1][0], this.itransBody[n][1][1]);
        }
    }

    @Override
    public void scaleZ(double d) {
    }
}

