/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.graphics3d.Ellipse3D;
import net.alomax.graphics3d.Vect3D;

public class Ellipsoid3D {
    protected static final int NUMPOINTS = 32;
    protected static final double RPD = 0.01745329238474369;
    protected boolean isValid = false;
    public double x0;
    public double y0;
    public double z0;
    public double az1;
    public double dip1;
    public double se1;
    public double az2;
    public double dip2;
    public double se2;
    public double se3;
    protected Vect3D center;
    protected Vect3D axis1;
    protected Vect3D axis2;
    protected Vect3D axis3;
    protected Ellipse3D ellipse12;
    protected Ellipse3D ellipse31;
    protected Ellipse3D ellipse23;

    public Ellipsoid3D() {
        this.isValid = false;
    }

    public Ellipsoid3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.x0 = d;
        this.y0 = d2;
        this.z0 = d3;
        this.az1 = 90.0 - d4;
        this.dip1 = -d5;
        this.se1 = d6;
        this.az2 = 90.0 - d7;
        this.dip2 = -d8;
        this.se2 = d9;
        this.se3 = d10;
        this.init();
    }

    protected void init() {
        this.center = new Vect3D(this.x0, this.y0, this.z0);
        double d = (float)Math.cos(0.01745329238474369 * this.dip1);
        this.axis1 = new Vect3D(Math.cos(0.01745329238474369 * this.az1) * d, Math.sin(0.01745329238474369 * this.az1) * d, Math.sin(0.01745329238474369 * this.dip1));
        double d2 = (float)Math.cos(0.01745329238474369 * this.dip2);
        this.axis2 = new Vect3D(Math.cos(0.01745329238474369 * this.az2) * d2, Math.sin(0.01745329238474369 * this.az2) * d2, Math.sin(0.01745329238474369 * this.dip2));
        this.axis3 = this.axis1.cross(this.axis2);
        this.axis1 = this.axis1.mult(this.se1);
        this.axis2 = this.axis2.mult(this.se2);
        this.axis3 = this.axis3.mult(this.se3);
        this.isValid = true;
    }

    public Ellipsoid3D(DataInputStream dataInputStream) throws IOException {
        this.x0 = dataInputStream.readFloat();
        this.y0 = dataInputStream.readFloat();
        this.z0 = dataInputStream.readFloat();
        this.az1 = dataInputStream.readFloat();
        this.dip1 = dataInputStream.readFloat();
        this.se1 = dataInputStream.readFloat();
        this.az2 = dataInputStream.readFloat();
        this.dip2 = dataInputStream.readFloat();
        this.se2 = dataInputStream.readFloat();
        this.se3 = dataInputStream.readFloat();
        this.init();
    }

    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat((float)this.x0);
        dataOutputStream.writeFloat((float)this.y0);
        dataOutputStream.writeFloat((float)this.z0);
        dataOutputStream.writeFloat((float)this.az1);
        dataOutputStream.writeFloat((float)this.dip1);
        dataOutputStream.writeFloat((float)this.se1);
        dataOutputStream.writeFloat((float)this.az2);
        dataOutputStream.writeFloat((float)this.dip2);
        dataOutputStream.writeFloat((float)this.se2);
        dataOutputStream.writeFloat((float)this.se3);
    }

    public void calcEllipses() {
        if (!this.isValid) {
            return;
        }
        this.ellipse12 = new Ellipse3D(this.center, this.axis1, this.axis2, 32);
        this.ellipse23 = new Ellipse3D(this.center, this.axis2, this.axis3, 32);
        this.ellipse31 = new Ellipse3D(this.center, this.axis3, this.axis1, 32);
    }

    public void paint(Graphics graphics, Color color) {
        if (!this.isValid) {
            return;
        }
        graphics.setColor(color);
        this.ellipse12.paint(graphics);
        this.ellipse31.paint(graphics);
        this.ellipse23.paint(graphics);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Xcent ").append((float)this.x0);
        stringBuffer.append("  Ycent ").append((float)this.y0);
        stringBuffer.append("  Zcent ").append((float)this.z0);
        stringBuffer.append("  ");
        stringBuffer.append(this.toStringAxes());
        return stringBuffer.toString();
    }

    public String toStringAxes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Az1 ").append(90.0 - this.az1);
        stringBuffer.append("  Dip1 ").append((float)(-this.dip1));
        stringBuffer.append("  Len1 ").append((float)this.se1);
        stringBuffer.append("  Az2 ").append(90.0 - this.az2);
        stringBuffer.append("  Dip2 ").append((float)(-this.dip2));
        stringBuffer.append("  Len2 ").append((float)this.se2);
        stringBuffer.append("  Len3 ").append((float)this.se3);
        return stringBuffer.toString();
    }

    public String toStringAxesCsv() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((float)(90.0 - this.az1));
        stringBuffer.append(", ").append((float)(-this.dip1));
        stringBuffer.append(", ").append((float)this.se1);
        stringBuffer.append(", ").append((float)(90.0 - this.az2));
        stringBuffer.append(", ").append((float)(-this.dip2));
        stringBuffer.append(", ").append((float)this.se2);
        stringBuffer.append(", ").append((float)this.se3);
        return stringBuffer.toString();
    }

    public static String toStringAxesCsvHeader() {
        return "EllipsoidAz1, EllipsoidDip1, EllipsoidLen1, EllipsoidAz2, EllipsoidDip2, EllipsoidLen2, EllipsoidLen3";
    }
}

