/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Symbol3D;
import net.alomax.graphics3d.Vect3D;

public class FilledSphereSymbol3D
extends Symbol3D {
    protected static final int NUM_SIDES = 3;
    protected int maxRadius = 0;
    protected boolean outline = true;

    public FilledSphereSymbol3D(Vect3D vect3D, double d, Color color) {
        this(vect3D, d, true, color);
    }

    public FilledSphereSymbol3D(Vect3D vect3D, double d, boolean bl, Color color) {
        this.center = vect3D;
        this.outline = bl;
        Vect3D[][] vect3DArray = new Vect3D[2][];
        double d2 = d / 2.0;
        double d3 = 2.0943951023931953;
        vect3DArray[0] = new Vect3D[1];
        vect3DArray[0][0] = new Vect3D(vect3D);
        vect3DArray[1] = new Vect3D[4];
        double d4 = 0.0;
        for (int i = 0; i < 4; ++i) {
            vect3DArray[1][i] = new Vect3D(vect3D.add(new Vect3D(0.0, d2 * Math.cos(d4), d2 * Math.sin(d4))));
            d4 += d3;
        }
        this.setVertices(vect3DArray);
        this.setColor(color);
    }

    @Override
    public void transform(int n) {
        if (this.getTransformed(n)) {
            return;
        }
        super.transform(n);
        this.maxRadius = 0;
        for (int i = 0; i < this.itrans[1].length; ++i) {
            int n2 = this.itrans[1][0][i] - this.itrans[0][0][0];
            int n3 = this.itrans[1][1][i] - this.itrans[0][1][0];
            int n4 = this.itrans[1][2][i] - this.itrans[0][2][0];
            int n5 = (int)Math.sqrt(n2 * n2 + n3 * n3 + n4 * n4);
            this.maxRadius = Math.max(this.maxRadius, n5);
        }
        this.setLastTransformationIndex(n);
    }

    @Override
    public void paint(Graphics graphics, BasicStroke basicStroke, Color color) {
        if (this.maxRadius < 1) {
            return;
        }
        graphics.setColor(color);
        int n = 2 * this.maxRadius;
        int n2 = this.itrans[0][0][0] - this.maxRadius;
        int n3 = this.itrans[0][1][0] - this.maxRadius;
        Draw3D.fillOval(graphics, n2, n3, n, n);
        if (this.outline) {
            graphics.setColor(Color.BLACK);
            Draw3D.drawOval(graphics, n2, n3, n, n);
        }
    }
}

