/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Path2D;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.DrawableSet3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Range3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.math.RangeDouble;

public class Line3D
extends DrawableSet3D {
    public float[] xData;
    public float[] yData;
    public float[] zData;
    public BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0);
    protected Path2D.Double path2Dxy = null;

    public Line3D(float[] fArray, float[] fArray2, float[] fArray3) {
        this(fArray, fArray2, fArray3, null);
    }

    public Line3D(float[] fArray, float[] fArray2, float[] fArray3, Color color) {
        this.xData = fArray;
        this.yData = fArray2;
        this.zData = fArray3;
        if (color != null) {
            this.color = color;
        }
    }

    public Line3D(float[] fArray, float[] fArray2, float[] fArray3, Color color, BasicStroke basicStroke) {
        this(fArray, fArray2, fArray3, color);
        if (basicStroke != null) {
            this.basicStroke = basicStroke;
        }
    }

    public Line3D(Vect3D[] vect3DArray) {
        this(vect3DArray, null);
    }

    public Line3D(Vect3D[] vect3DArray, Color color) {
        this.xData = new float[vect3DArray.length];
        this.yData = new float[vect3DArray.length];
        this.zData = new float[vect3DArray.length];
        for (int i = 0; i < vect3DArray.length; ++i) {
            this.xData[i] = (float)vect3DArray[i].x;
            this.yData[i] = (float)vect3DArray[i].y;
            this.zData[i] = (float)vect3DArray[i].z;
        }
        if (color != null) {
            this.color = color;
        }
    }

    public Line3D(Vect3D[] vect3DArray, Color color, BasicStroke basicStroke) {
        this(vect3DArray, color);
        if (basicStroke != null) {
            this.basicStroke = basicStroke;
        }
    }

    @Override
    public int size() {
        if (this.xData != null) {
            return this.xData.length;
        }
        if (this.yData != null) {
            return this.yData.length;
        }
        if (this.zData != null) {
            return this.zData.length;
        }
        return 0;
    }

    public Vect3D get(int n) {
        Vect3D vect3D = new Vect3D(this.xData[n], this.yData[n], this.zData[n]);
        return vect3D;
    }

    public int[] getPespTrans(int n) {
        int[] nArray = new int[3];
        float f = this.xData == null ? 0.0f : this.xData[n];
        float f2 = this.yData == null ? 0.0f : this.yData[n];
        float f3 = this.zData == null ? 0.0f : this.zData[n];
        Matrix3D.applyPerspTrans(f, f2, f3, nArray);
        return nArray;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Color color) {
        this.paint(graphics, n, n2, color, null);
    }

    public void paint(Graphics graphics, int n, int n2, Color color, BasicStroke basicStroke) {
        if (n >= n2) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (this.color != null) {
            graphics2.setColor(this.color);
        } else {
            graphics2.setColor(color);
        }
        if (basicStroke != null) {
            try {
                ((Graphics2D)graphics2).setStroke(basicStroke);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        float f = this.xData == null ? 0.0f : this.xData[n];
        float f2 = this.yData == null ? 0.0f : this.yData[n];
        float f3 = this.zData == null ? 0.0f : this.zData[n];
        Matrix3D.applyPerspTrans(f, f2, f3, nArray);
        for (int i = n + 1; i <= n2; ++i) {
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            f = this.xData == null ? 0.0f : this.xData[i];
            f2 = this.yData == null ? 0.0f : this.yData[i];
            f3 = this.zData == null ? 0.0f : this.zData[i];
            Matrix3D.applyPerspTrans(f, f2, f3, nArray);
            Draw3D.drawLine(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
        graphics2.dispose();
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, 0, this.xData.length - 1, this.color);
    }

    @Override
    public void paint(Graphics graphics, Color color) {
        this.paint(graphics, 0, this.xData.length - 1, color);
    }

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        this.paint(graphics, 0, this.xData.length - 1, this.color);
    }

    public void paintSample(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        int[] nArray = new int[3];
        float f = this.xData == null ? 0.0f : this.xData[n];
        float f2 = this.yData == null ? 0.0f : this.yData[n];
        float f3 = this.zData == null ? 0.0f : this.zData[n];
        Matrix3D.applyPerspTrans(f, f2, f3, nArray);
        Draw3D.fillOval(graphics, nArray[0] - n2, nArray[1] - n2, 2 * n2, 2 * n2);
    }

    @Override
    public void transform(int n) {
        this.setLastTransformationIndex(n);
    }

    @Override
    public void scaleZ(double d) {
    }

    @Override
    public Range3D bounds() {
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        for (int i = 0; i < this.xData.length; ++i) {
            float f3 = this.xData[i];
            if (f3 < f) {
                f = f3;
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        RangeDouble rangeDouble = new RangeDouble(f, f2);
        f = Float.MAX_VALUE;
        f2 = -3.4028235E38f;
        for (int i = 0; i < this.yData.length; ++i) {
            float f4 = this.yData[i];
            if (f4 < f) {
                f = f4;
            }
            if (!(f4 > f2)) continue;
            f2 = f4;
        }
        RangeDouble rangeDouble2 = new RangeDouble(f, f2);
        f = Float.MAX_VALUE;
        f2 = -3.4028235E38f;
        for (int i = 0; i < this.zData.length; ++i) {
            float f5 = this.zData[i];
            if (f5 < f) {
                f = f5;
            }
            if (!(f5 > f2)) continue;
            f2 = f5;
        }
        RangeDouble rangeDouble3 = new RangeDouble(f, f2);
        return new Range3D(rangeDouble, rangeDouble2, rangeDouble3);
    }

    public Polygon toPolygon() {
        int[] nArray = new int[this.xData.length];
        int[] nArray2 = new int[this.xData.length];
        int[] nArray3 = new int[3];
        for (int i = 0; i < this.xData.length; ++i) {
            float f = this.xData == null ? 0.0f : this.xData[i];
            float f2 = this.yData == null ? 0.0f : this.yData[i];
            float f3 = this.zData == null ? 0.0f : this.zData[i];
            Matrix3D.applyPerspTrans(f, f2, f3, nArray3);
            nArray[i] = nArray3[0];
            nArray2[i] = nArray3[1];
        }
        return new Polygon(nArray, nArray2, this.xData.length);
    }

    public Path2D.Double toXYpath2D() {
        Path2D.Double double_ = new Path2D.Double();
        for (int i = 0; i < this.xData.length; ++i) {
            float f;
            float f2 = this.xData == null ? 0.0f : this.xData[i];
            float f3 = f = this.yData == null ? 0.0f : this.yData[i];
            if (i == 0) {
                double_.moveTo(f2, f);
                continue;
            }
            double_.lineTo(f2, f);
        }
        return double_;
    }

    public final boolean contains(double d, double d2) {
        if (this.path2Dxy == null) {
            this.path2Dxy = this.toXYpath2D();
        }
        return this.path2Dxy.contains(d, d2);
    }
}

