/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import net.alomax.graphics3d.Vect3D;

public class Matrix3D {
    public double xx;
    public double xy;
    public double xz;
    public double xo;
    public double yx;
    public double yy;
    public double yz;
    public double yo;
    public double zx;
    public double zy;
    public double zz;
    public double zo;
    public static final double DEG2RAD = Math.PI / 180;
    protected static Matrix3D viewMat;
    protected static Matrix3D projMat;
    protected static double perspDist;

    public Matrix3D() {
        this.xx = 1.0;
        this.yy = 1.0;
        this.zz = 1.0;
    }

    public Matrix3D(Matrix3D matrix3D) {
        this.xx = matrix3D.xx;
        this.xy = matrix3D.xy;
        this.xz = matrix3D.xz;
        this.xo = matrix3D.xo;
        this.yx = matrix3D.yx;
        this.yy = matrix3D.yy;
        this.yz = matrix3D.yz;
        this.yo = matrix3D.yo;
        this.zx = matrix3D.zx;
        this.zy = matrix3D.zy;
        this.zz = matrix3D.zz;
        this.zo = matrix3D.zo;
    }

    public static void setPerspTrans(Matrix3D matrix3D, double d, Matrix3D matrix3D2) {
        viewMat = new Matrix3D();
        viewMat.mult(matrix3D);
        perspDist = d;
        projMat = new Matrix3D();
        projMat.mult(matrix3D2);
    }

    public static final void applyPerspTrans(Vect3D vect3D, int[] nArray) {
        Matrix3D.applyPerspTrans(vect3D.x, vect3D.y, vect3D.z, nArray);
    }

    public static final void applyPerspTrans(double[] dArray, int[] nArray) {
        Matrix3D.applyPerspTrans(dArray[0], dArray[1], dArray[2], nArray);
    }

    public static final void applyPerspTrans(double d, double d2, double d3, int[] nArray) {
        double[] dArray = new double[3];
        viewMat.transform(d, d2, d3, dArray);
        if (perspDist > 1.1754943508222875E-38) {
            if (dArray[2] > -perspDist * 0.9) {
                double d4 = dArray[2] / perspDist + 1.0;
                dArray[0] = dArray[0] / d4;
                dArray[1] = dArray[1] / d4;
                dArray[2] = dArray[2] / d4;
            } else {
                nArray[0] = -536870911;
                return;
            }
        }
        projMat.transform(dArray, dArray);
        nArray[0] = (int)(0.5 + dArray[0]);
        nArray[1] = (int)(0.5 + dArray[1]);
        nArray[2] = (int)(0.5 + dArray[2]);
    }

    public static double[] applyInversePerspTrans(int[] nArray) {
        double[] dArray = new double[]{nArray[0], nArray[1], nArray[2]};
        projMat.inverse().transformInv(dArray, dArray);
        if (perspDist > 0.0) {
            double d = dArray[2] / (1.0 - dArray[2] / perspDist);
            if (d > -perspDist * 0.9) {
                double d2 = d / perspDist + 1.0;
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = dArray[2] * d2;
            } else {
                nArray[0] = -536870911;
                return null;
            }
        }
        viewMat.inverse().transformInv(dArray, dArray);
        return dArray;
    }

    public void scale(double d) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d;
        this.yy *= d;
        this.yz *= d;
        this.yo *= d;
        this.zx *= d;
        this.zy *= d;
        this.zz *= d;
        this.zo *= d;
    }

    public void scale(double d, double d2, double d3) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d2;
        this.yy *= d2;
        this.yz *= d2;
        this.yo *= d2;
        this.zx *= d3;
        this.zy *= d3;
        this.zz *= d3;
        this.zo *= d3;
    }

    public void translate(double d, double d2, double d3) {
        this.xo += d;
        this.yo += d2;
        this.zo += d3;
    }

    public void transInvert() {
        this.xo = -this.xo;
        this.yo = -this.yo;
        this.zo = -this.zo;
    }

    public void yrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.xx * d2 + this.zx * d3;
        double d5 = this.xy * d2 + this.zy * d3;
        double d6 = this.xz * d2 + this.zz * d3;
        double d7 = this.xo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.xx * d3;
        double d9 = this.zy * d2 - this.xy * d3;
        double d10 = this.zz * d2 - this.xz * d3;
        double d11 = this.zo * d2 - this.xo * d3;
        this.xo = d7;
        this.xx = d4;
        this.xy = d5;
        this.xz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    public void xrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.zx * d3;
        double d5 = this.yy * d2 + this.zy * d3;
        double d6 = this.yz * d2 + this.zz * d3;
        double d7 = this.yo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.yx * d3;
        double d9 = this.zy * d2 - this.yy * d3;
        double d10 = this.zz * d2 - this.yz * d3;
        double d11 = this.zo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    public void zrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.xx * d3;
        double d5 = this.yy * d2 + this.xy * d3;
        double d6 = this.yz * d2 + this.xz * d3;
        double d7 = this.yo * d2 + this.xo * d3;
        double d8 = this.xx * d2 - this.yx * d3;
        double d9 = this.xy * d2 - this.yy * d3;
        double d10 = this.xz * d2 - this.yz * d3;
        double d11 = this.xo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.xo = d11;
        this.xx = d8;
        this.xy = d9;
        this.xz = d10;
    }

    public void rotInvert() {
        double d = this.xy;
        this.xy = this.yx;
        this.yx = d;
        d = this.xz;
        this.xz = this.zx;
        this.zx = d;
        d = this.yz;
        this.yz = this.zy;
        this.zy = d;
    }

    public void mult(Matrix3D matrix3D) {
        double d = this.xx * matrix3D.xx + this.yx * matrix3D.xy + this.zx * matrix3D.xz;
        double d2 = this.xy * matrix3D.xx + this.yy * matrix3D.xy + this.zy * matrix3D.xz;
        double d3 = this.xz * matrix3D.xx + this.yz * matrix3D.xy + this.zz * matrix3D.xz;
        double d4 = this.xo * matrix3D.xx + this.yo * matrix3D.xy + this.zo * matrix3D.xz + matrix3D.xo;
        double d5 = this.xx * matrix3D.yx + this.yx * matrix3D.yy + this.zx * matrix3D.yz;
        double d6 = this.xy * matrix3D.yx + this.yy * matrix3D.yy + this.zy * matrix3D.yz;
        double d7 = this.xz * matrix3D.yx + this.yz * matrix3D.yy + this.zz * matrix3D.yz;
        double d8 = this.xo * matrix3D.yx + this.yo * matrix3D.yy + this.zo * matrix3D.yz + matrix3D.yo;
        double d9 = this.xx * matrix3D.zx + this.yx * matrix3D.zy + this.zx * matrix3D.zz;
        double d10 = this.xy * matrix3D.zx + this.yy * matrix3D.zy + this.zy * matrix3D.zz;
        double d11 = this.xz * matrix3D.zx + this.yz * matrix3D.zy + this.zz * matrix3D.zz;
        double d12 = this.xo * matrix3D.zx + this.yo * matrix3D.zy + this.zo * matrix3D.zz + matrix3D.zo;
        this.xx = d;
        this.xy = d2;
        this.xz = d3;
        this.xo = d4;
        this.yx = d5;
        this.yy = d6;
        this.yz = d7;
        this.yo = d8;
        this.zx = d9;
        this.zy = d10;
        this.zz = d11;
        this.zo = d12;
    }

    public void unit() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
    }

    public void transformArray(double[] dArray, int[] nArray, int n) {
        double d = this.xx;
        double d2 = this.xy;
        double d3 = this.xz;
        double d4 = this.xo;
        double d5 = this.yx;
        double d6 = this.yy;
        double d7 = this.yz;
        double d8 = this.yo;
        double d9 = this.zx;
        double d10 = this.zy;
        double d11 = this.zz;
        double d12 = this.zo;
        int n2 = n * 3;
        while ((n2 -= 3) >= 0) {
            double d13 = dArray[n2];
            double d14 = dArray[n2 + 1];
            double d15 = dArray[n2 + 2];
            nArray[n2] = (int)(d13 * d + d14 * d2 + d15 * d3 + d4);
            nArray[n2 + 1] = (int)(d13 * d5 + d14 * d6 + d15 * d7 + d8);
            nArray[n2 + 2] = (int)(d13 * d9 + d14 * d10 + d15 * d11 + d12);
        }
    }

    public final void transform(double d, double d2, double d3, double[] dArray) {
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        dArray[0] = d4 * this.xx + d5 * this.xy + d6 * this.xz + this.xo;
        dArray[1] = d4 * this.yx + d5 * this.yy + d6 * this.yz + this.yo;
        dArray[2] = d4 * this.zx + d5 * this.zy + d6 * this.zz + this.zo;
    }

    public final void transform(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        dArray2[0] = d * this.xx + d2 * this.xy + d3 * this.xz + this.xo;
        dArray2[1] = d * this.yx + d2 * this.yy + d3 * this.yz + this.yo;
        dArray2[2] = d * this.zx + d2 * this.zy + d3 * this.zz + this.zo;
    }

    public final Vect3D transform(double d, double d2, double d3) {
        Vect3D vect3D = new Vect3D();
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        vect3D.x = d4 * this.xx + d5 * this.xy + d6 * this.xz + this.xo;
        vect3D.y = d4 * this.yx + d5 * this.yy + d6 * this.yz + this.yo;
        vect3D.z = d4 * this.zx + d5 * this.zy + d6 * this.zz + this.zo;
        return vect3D;
    }

    public final Vect3D transform(Vect3D vect3D) {
        Vect3D vect3D2 = new Vect3D();
        double d = vect3D.x;
        double d2 = vect3D.y;
        double d3 = vect3D.z;
        vect3D2.x = d * this.xx + d2 * this.xy + d3 * this.xz + this.xo;
        vect3D2.y = d * this.yx + d2 * this.yy + d3 * this.yz + this.yo;
        vect3D2.z = d * this.zx + d2 * this.zy + d3 * this.zz + this.zo;
        return vect3D2;
    }

    public void transformInv(double[] dArray, double[] dArray2) {
        double d = dArray[0] - this.xo;
        double d2 = dArray[1] - this.yo;
        double d3 = dArray[2] - this.zo;
        dArray2[0] = d * this.xx + d2 * this.xy + d3 * this.xz;
        dArray2[1] = d * this.yx + d2 * this.yy + d3 * this.yz;
        dArray2[2] = d * this.zx + d2 * this.zy + d3 * this.zz;
    }

    public Matrix3D inverse() {
        double d = this.zx * this.xy * this.yz - this.zx * this.xz * this.yy - this.yx * this.xy * this.zz + this.yx * this.xz * this.zy + this.xx * this.yy * this.zz - this.xx * this.yz * this.zy;
        if (Math.abs(d) < Double.MIN_NORMAL) {
            return null;
        }
        Matrix3D matrix3D = new Matrix3D();
        matrix3D.xx = (this.yy * this.zz - this.yz * this.zy) / d;
        matrix3D.xy = -(this.xy * this.zz - this.xz * this.zy) / d;
        matrix3D.xz = (this.xy * this.yz - this.xz * this.yy) / d;
        matrix3D.yx = -(-this.zx * this.yz + this.yx * this.zz) / d;
        matrix3D.yy = (-this.zx * this.xz + this.xx * this.zz) / d;
        matrix3D.yz = -(-this.yx * this.xz + this.xx * this.yz) / d;
        matrix3D.zx = (-this.zx * this.yy + this.yx * this.zy) / d;
        matrix3D.zy = -(-this.zx * this.xy + this.xx * this.zy) / d;
        matrix3D.zz = (-this.yx * this.xy + this.xx * this.yy) / d;
        matrix3D.xo = this.xo;
        matrix3D.yo = this.yo;
        matrix3D.zo = this.zo;
        return matrix3D;
    }

    public String toString() {
        return "[" + this.xx + "," + this.xy + "," + this.xz + "," + this.xo + ";" + this.yx + "," + this.yy + "," + this.yz + "," + this.yo + ";" + this.zx + "," + this.zy + "," + this.zz + "," + this.zo + ")";
    }

    public static Matrix3D createTranformToUpOnSphere(Vect3D vect3D, Vect3D vect3D2) {
        Matrix3D matrix3D = new Matrix3D();
        matrix3D.unit();
        matrix3D.translate(-vect3D.x, -vect3D.y, -vect3D.z);
        Vect3D vect3D3 = new Vect3D(vect3D2);
        vect3D3.normalize();
        float f = (float)(57.29577951308232 * Math.acos(vect3D3.z));
        float f2 = Math.abs(vect3D3.x) > (double)1.4E-45f ? (float)(57.29577951308232 * Math.atan2(vect3D3.y, vect3D3.x)) : (vect3D3.y > 0.0 ? 90.0f : -90.0f);
        matrix3D.zrot(90.0);
        matrix3D.yrot(f);
        matrix3D.zrot(f2);
        matrix3D.translate(vect3D.x, vect3D.y, vect3D.z);
        return matrix3D;
    }
}

