/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;

public class Polygon3D
extends Line3D {
    public static final int NO_FILL = 0;
    public static final int SOLID_FILL = 1;
    public static final int TRANSPARENT_FILL = 2;
    public static final int MESH_FILL = 3;
    public static final int NO_BORDER = 0;
    public static final int SOLID_BORDER = 1;
    public static final int SOLID_BORDER_TOP_THICKER = 2;
    public static final int SOLID_BORDER_TOP_THICKER2 = 3;
    public static final int SOLID_BORDER_TOP_THICKER3 = 4;
    protected int fill = 0;
    protected int border = 1;
    protected int sRGB_trans = new Color(0, 0, 0, 0).getRGB();
    protected int nTexture = 3;
    protected int[] rgbArray = null;
    protected Rectangle anchor = null;
    protected Vect3D[] vertex = new Vect3D[0];
    protected int[][] itrans = new int[3][0];

    public Polygon3D(float[] fArray, float[] fArray2, float[] fArray3) {
        this(fArray, fArray2, fArray3, null);
    }

    public Polygon3D(float[] fArray, float[] fArray2, float[] fArray3, Color color) {
        super(fArray, fArray2, fArray3, color);
    }

    public Polygon3D(Vect3D[] vect3DArray) {
        this(vect3DArray, null);
    }

    public Polygon3D(Vect3D[] vect3DArray, Color color) {
        super(vect3DArray, color);
    }

    public void setFill(String string) {
        if (string.equals("NO_FILL")) {
            this.fill = 0;
        } else if (string.equals("SOLID_FILL")) {
            this.fill = 1;
        } else if (string.equals("TRANSPARENT_FILL")) {
            this.fill = 2;
        } else if (string.equals("MESH_FILL")) {
            this.fill = 3;
        } else {
            System.out.println("ERROR: unrecognized polygon fill style: " + string);
        }
    }

    public void setBorder(String string) {
        if (string.equals("NO_BORDER")) {
            this.border = 0;
        } else if (string.equals("SOLID_BORDER")) {
            this.border = 1;
        } else if (string.equals("SOLID_BORDER_TOP_THICKER")) {
            this.border = 2;
        } else if (string.equals("SOLID_BORDER_TOP_THICKER2")) {
            this.border = 3;
        } else if (string.equals("SOLID_BORDER_TOP_THICKER3")) {
            this.border = 4;
        } else {
            System.out.println("ERROR: unrecognized polygon border style: " + string);
        }
    }

    public void setFill(int n) {
        this.fill = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Color color) {
        if (n == n2) {
            return;
        }
        graphics.setColor(color);
        int[] nArray = new int[3];
        int[] nArray2 = new int[n2 - n + 1];
        int[] nArray3 = new int[n2 - n + 1];
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        float f = -3.4028235E38f;
        float f2 = -3.4028235E38f;
        for (int i = n; i <= n2; ++i) {
            float f3 = this.xData == null ? 0.0f : this.xData[i];
            float f4 = this.yData == null ? 0.0f : this.yData[i];
            float f5 = this.zData == null ? 0.0f : this.zData[i];
            Matrix3D.applyPerspTrans(f3, f4, f5, nArray);
            nArray2[n3] = nArray[0];
            nArray3[n3] = nArray[1];
            if (f5 > f) {
                f2 = f;
                n5 = n4;
                f = f5;
                n4 = n3;
            } else if (f5 > f2) {
                f2 = f5;
                n5 = n3;
            }
            ++n3;
        }
        Polygon polygon = new Polygon(nArray2, nArray3, n3);
        Graphics graphics2 = graphics.create();
        if (this.fill == 1) {
            graphics2.fillPolygon(polygon);
        } else if (this.fill == 2) {
            graphics2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 63));
            graphics2.fillPolygon(polygon);
            graphics2.dispose();
        } else if (this.fill == 3) {
            int n6;
            if (this.rgbArray == null) {
                this.rgbArray = new int[this.nTexture * this.nTexture];
                for (n6 = 0; n6 < this.nTexture * this.nTexture; ++n6) {
                    this.rgbArray[n6] = this.sRGB_trans;
                }
            }
            if (this.anchor == null) {
                n6 = (int)(0.5 + Math.random() * (double)(this.nTexture - 1));
                int n7 = (int)(0.5 + Math.random() * (double)(this.nTexture - 1));
                this.anchor = new Rectangle(n6, n7, this.nTexture, this.nTexture);
            }
            this.rgbArray[0] = color.getRGB();
            BufferedImage bufferedImage = new BufferedImage(this.nTexture, this.nTexture, 2);
            bufferedImage.setRGB(0, 0, this.nTexture, this.nTexture, this.rgbArray, 0, this.nTexture);
            TexturePaint texturePaint = new TexturePaint(bufferedImage, this.anchor);
            graphics2.setColor(color);
            try {
                ((Graphics2D)graphics2).setPaint(texturePaint);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                graphics2.fillPolygon(polygon);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        graphics2.dispose();
        if (this.border == 1) {
            Draw3D.drawPolygon(graphics, polygon);
        } else if (this.border > 1) {
            Draw3D.drawPolygon(graphics, polygon);
            if (n4 >= 0 && n5 >= 0) {
                graphics2 = graphics.create();
                try {
                    float f6 = ((BasicStroke)((Graphics2D)graphics2).getStroke()).getLineWidth();
                    if (this.border == 2) {
                        ((Graphics2D)graphics2).setStroke(new BasicStroke(2.0f * f6, 2, 0));
                    } else if (this.border == 3) {
                        ((Graphics2D)graphics2).setStroke(new BasicStroke(3.0f * f6, 2, 0));
                    } else if (this.border == 4) {
                        ((Graphics2D)graphics2).setStroke(new BasicStroke(4.0f * f6, 2, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Draw3D.drawLine(graphics2, nArray2[n4], nArray3[n4], nArray2[n5], nArray3[n5]);
            }
        }
    }
}

