/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import net.alomax.awt.AJLColor;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.DrawableSet3D;
import net.alomax.graphics3d.Range3D;
import net.alomax.graphics3d.Sample4D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.RangeDouble;
import net.alomax.util.BinaryType;

public class Sample4DSet
extends DrawableSet3D {
    protected Sample4D[] sample4D = new Sample4D[0];
    protected int sampleDiameter = 1;
    protected boolean valueIsAlpha = false;
    protected static String endline = System.getProperty("line.separator");

    public Sample4DSet(Color color, int n, Sample4D[] sample4DArray) {
        this.color = color;
        this.sampleDiameter = n;
        this.sample4D = sample4DArray;
    }

    public Sample4DSet(InputStream inputStream, Color color, GeogCoords geogCoords, boolean bl) {
        this(inputStream, color, 1, geogCoords, bl);
    }

    public Sample4DSet(InputStream inputStream, Color color, int n, GeogCoords geogCoords, boolean bl) {
        this.color = color;
        this.sampleDiameter = n;
        this.sample4D = Sample4DSet.readSamplesBinary(geogCoords, null, inputStream, bl, n);
    }

    public Sample4DSet(InputStream inputStream, Color color, int n, GeogCoords geogCoords, boolean bl, boolean bl2) {
        this.color = color;
        this.valueIsAlpha = bl2;
        this.sampleDiameter = n;
        this.sample4D = Sample4DSet.readSamplesBinary(geogCoords, null, inputStream, bl, n);
    }

    public Sample4DSet(Sample4D[] sample4DArray) {
        this.sample4D = sample4DArray;
    }

    public static Sample4D[] readSamplesBinary(GeogCoords geogCoords, GeogCoords geogCoords2, InputStream inputStream, boolean bl) {
        return Sample4DSet.readSamplesBinary(geogCoords, geogCoords2, inputStream, bl, 1);
    }

    public static Sample4D[] readSamplesBinary(GeogCoords geogCoords, GeogCoords geogCoords2, InputStream inputStream, boolean bl, int n) {
        return Sample4DSet.readSamplesBinary(geogCoords, geogCoords2, inputStream, bl, Color.red, n, 1);
    }

    public static Sample4D[] readSamplesBinary(GeogCoords geogCoords, GeogCoords geogCoords2, InputStream inputStream, boolean bl, int n, int n2) {
        return Sample4DSet.readSamplesBinary(geogCoords, geogCoords2, inputStream, bl, Color.red, n, n2);
    }

    public static Sample4D[] readSamplesBinary(GeogCoords geogCoords, GeogCoords geogCoords2, InputStream inputStream, boolean bl, Color color, int n, int n2) {
        Sample4D[] sample4DArray;
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = n2 - 1;
        boolean bl2 = geogCoords != null && geogCoords2 != null && geogCoords != geogCoords2;
        int n4 = 1;
        boolean bl3 = false;
        inputStream.mark(Integer.MAX_VALUE);
        while (true) {
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(inputStream, n4);
                int n5 = binaryInputStream.readIntB();
                sample4DArray = new Sample4D[n5 / n2];
                binaryInputStream.skip(12L);
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n7 < n5 && n6 < sample4DArray.length) {
                    Vect3D vect3D;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    d = binaryInputStream.readFloatB();
                    d2 = binaryInputStream.readFloatB();
                    d3 = binaryInputStream.readFloatB();
                    d4 = binaryInputStream.readFloatB();
                    ++n7;
                    if (n3 > 0) {
                        if (n8 < n3) {
                            ++n8;
                            continue;
                        }
                        n8 = 0;
                    }
                    if (geogCoords2 != null && geogCoords2.isGlobal() || bl) {
                        if (d < -999.9 || d > 999.9) continue;
                        vect3D = geogCoords.geog2xyz(d2, d, d3);
                    } else {
                        vect3D = new Vect3D(d, d2, -d3);
                        if (bl2) {
                            vect3D = geogCoords2.xyz2geog(vect3D);
                            vect3D = geogCoords.geog2xyz(vect3D);
                        }
                    }
                    if (n <= 1) {
                        sample4DArray[n6] = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d4, 0);
                        sample4DArray[n6].setColor(color);
                        ++n6;
                        continue;
                    }
                    sample4DArray[n6] = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d4, 1, n, n, n);
                    sample4DArray[n6].setColor(color);
                    ++n6;
                }
            }
            catch (Throwable throwable) {
                if (bl3) {
                    System.out.println("ERROR: Sample4DSet.readSamplesBinary: " + throwable.getMessage());
                    throwable.printStackTrace();
                    sample4DArray = new Sample4D[]{};
                    break;
                }
                bl3 = true;
                n4 = BinaryType.invert(n4);
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
        return sample4DArray;
    }

    @Override
    public void transform(int n) {
        for (int i = 0; i < this.sample4D.length; ++i) {
            this.sample4D[i].transform(n);
        }
    }

    @Override
    public void scaleZ(double d) {
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, this.color);
    }

    public void invertColor() {
        this.color = AJLColor.invert(this.color);
    }

    @Override
    public Range3D bounds() {
        double d = 3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = -3.4028234663852886E38;
        double d5 = 3.4028234663852886E38;
        double d6 = -3.4028234663852886E38;
        for (int i = 0; i < this.sample4D.length; ++i) {
            double d7 = this.sample4D[i].x;
            if (d7 < d) {
                d = d7;
            } else if (d7 > d2) {
                d2 = d7;
            }
            double d8 = this.sample4D[i].y;
            if (d8 < d3) {
                d3 = d8;
            } else if (d8 > d4) {
                d4 = d8;
            }
            double d9 = this.sample4D[i].z;
            if (d9 < d5) {
                d5 = d9;
                continue;
            }
            if (!(d9 > d6)) continue;
            d6 = d9;
        }
        RangeDouble rangeDouble = new RangeDouble(d, d2);
        RangeDouble rangeDouble2 = new RangeDouble(d3, d4);
        RangeDouble rangeDouble3 = new RangeDouble(d5, d6);
        return new Range3D(rangeDouble, rangeDouble2, rangeDouble3);
    }

    @Override
    public void paint(Graphics graphics, Color color) {
        if (this.sample4D != null && this.sample4D.length > 0) {
            float[] fArray = null;
            if (this.valueIsAlpha) {
                fArray = new float[3];
            }
            for (int i = 0; i < this.sample4D.length; ++i) {
                if (this.valueIsAlpha) {
                    fArray = color.getColorComponents(fArray);
                    Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)this.sample4D[i].value);
                    this.sample4D[i].paint(graphics, color2);
                    continue;
                }
                this.sample4D[i].paint(graphics, color);
            }
        }
    }

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        this.paint(graphics, n, n2, this.color);
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Color color) {
        if (this.sample4D != null && this.sample4D.length > n2) {
            float[] fArray = null;
            if (this.valueIsAlpha) {
                fArray = new float[3];
            }
            for (int i = n; i < n2 - 1; ++i) {
                if (this.valueIsAlpha) {
                    fArray = color.getColorComponents(fArray);
                    Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)this.sample4D[i].value);
                    this.sample4D[i].paint(graphics, color2);
                    continue;
                }
                this.sample4D[i].paint(graphics, color);
            }
        }
    }

    @Override
    public int size() {
        return this.sample4D.length;
    }

    public Sample4D[] getSamples() {
        return this.sample4D;
    }

    public void setSamples(Sample4D[] sample4DArray) {
        this.sample4D = sample4DArray;
    }

    public int printLatLong(ASCIIOutputStream aSCIIOutputStream, GeogCoords geogCoords) throws Exception {
        aSCIIOutputStream.writeWord("> GMT_LATLONDEPTH " + this.sample4D.length + " " + endline);
        for (int i = 0; i < this.sample4D.length; ++i) {
            Sample4D sample4D = this.sample4D[i];
            Vect3D vect3D = geogCoords.xyz2geog(sample4D.x, sample4D.y, sample4D.z);
            aSCIIOutputStream.writeFloat((float)vect3D.x);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeFloat((float)vect3D.y);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeFloat((float)vect3D.z);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeFloat((float)sample4D.value);
            aSCIIOutputStream.writeWord(endline);
        }
        return this.sample4D.length;
    }
}

