/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect2D;

public class Vect3D {
    public double x;
    public double y;
    public double z;
    protected static final double RAD2DEG = 57.29577951308232;
    protected static final double DEG2RAD = Math.PI / 180;

    public Vect3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vect3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vect3D(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vect3D(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vect3D(Vect3D vect3D) {
        this.x = vect3D.x;
        this.y = vect3D.y;
        this.z = vect3D.z;
    }

    public Vect3D(Vect2D vect2D, double d) {
        this.x = vect2D.x;
        this.y = vect2D.y;
        this.z = d;
    }

    public Vect3D(double d, double d2) {
        double d3 = Math.cos(d2 * (Math.PI / 180));
        double d4 = Math.sin(d2 * (Math.PI / 180));
        double d5 = Math.cos(d * (Math.PI / 180));
        double d6 = Math.sin(d * (Math.PI / 180));
        this.x = d5 * d3;
        this.y = d6 * d3;
        this.z = d4;
    }

    public final double getDip() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d <= (double)1.4E-45f) {
            return 0.0;
        }
        d = Math.sqrt(d);
        double d2 = Math.asin(this.z / d) * 57.29577951308232;
        return d2;
    }

    public final double getAzimuth() {
        if (Math.abs(this.x) < (double)1.4E-45f) {
            return this.y > 0.0 ? 90.0 : -90.0;
        }
        double d = Math.atan2(this.y, this.x) * 57.29577951308232;
        return d;
    }

    public final double getMagnitude() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d <= (double)1.4E-45f) {
            return 0.0;
        }
        d = Math.sqrt(d);
        return d;
    }

    public final Vect3D normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d <= (double)1.4E-45f) {
            return this;
        }
        d = Math.sqrt(d);
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public final Vect3D add(Vect3D vect3D) {
        Vect3D vect3D2 = new Vect3D();
        vect3D2.x = this.x + vect3D.x;
        vect3D2.y = this.y + vect3D.y;
        vect3D2.z = this.z + vect3D.z;
        return vect3D2;
    }

    public final Vect3D sub(Vect3D vect3D) {
        Vect3D vect3D2 = new Vect3D();
        vect3D2.x = this.x - vect3D.x;
        vect3D2.y = this.y - vect3D.y;
        vect3D2.z = this.z - vect3D.z;
        return vect3D2;
    }

    public final Vect3D mult(double d) {
        Vect3D vect3D = new Vect3D();
        vect3D.x = this.x * d;
        vect3D.y = this.y * d;
        vect3D.z = this.z * d;
        return vect3D;
    }

    public final Vect3D mult(float f) {
        Vect3D vect3D = new Vect3D();
        vect3D.x = this.x * (double)f;
        vect3D.y = this.y * (double)f;
        vect3D.z = this.z * (double)f;
        return vect3D;
    }

    public final Vect3D mult(Matrix3D matrix3D) {
        Vect3D vect3D = new Vect3D();
        vect3D.x = this.x * matrix3D.xx + this.y * matrix3D.xy + this.z * matrix3D.xz + matrix3D.xo;
        vect3D.y = this.x * matrix3D.yx + this.y * matrix3D.yy + this.z * matrix3D.yz + matrix3D.yo;
        vect3D.z = this.x * matrix3D.zx + this.y * matrix3D.zy + this.z * matrix3D.zz + matrix3D.zo;
        return vect3D;
    }

    public final double dot(Vect3D vect3D) {
        return this.x * vect3D.x + vect3D.y * this.y + vect3D.z * this.z;
    }

    public final Vect3D cross(Vect3D vect3D) {
        Vect3D vect3D2 = new Vect3D();
        vect3D2.x = this.y * vect3D.z - vect3D.y * this.z;
        vect3D2.y = this.z * vect3D.x - vect3D.z * this.x;
        vect3D2.z = this.x * vect3D.y - vect3D.x * this.y;
        return vect3D2;
    }

    public final double dist(Vect3D vect3D) {
        double d = Math.sqrt((this.x - vect3D.x) * (this.x - vect3D.x) + (this.y - vect3D.y) * (this.y - vect3D.y) + (this.z - vect3D.z) * (this.z - vect3D.z));
        return d;
    }

    public String toString() {
        return new String("(" + this.x + "," + this.y + "," + this.z + ")");
    }
}

