/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.net;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class Browser {
    private static final boolean DEBUG = false;
    private static final String[] badEndings = new String[]{".htm", ".html", ".htw", ".mht", ".cdf", ".mhtml", ".stm"};

    public Browser(String string) throws InterruptedException, IOException {
        Browser.open(string);
    }

    public static void open(String string) throws InterruptedException, IOException {
        if (!Desktop.isDesktopSupported()) {
            System.err.println("ERROR: net.alomax.net.Browser: java.awt.Desktop is not available on your system.");
            return;
        }
        if (string == null || string.length() < 1) {
            System.err.println("ERROR: net.alomax.net.Browser: invalid or empty url.");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.err.println("ERROR: net.alomax.net.Browser: java.awt.Desktop doe not support the browse action on your system.");
            return;
        }
        try {
            URI uRI = new URI(string);
            desktop.browse(uRI);
        }
        catch (Exception exception) {
            if (string.startsWith("file://") && !string.startsWith("file:///")) {
                try {
                    URI uRI = new URI(string.substring(0, 6) + "/" + string.substring(6));
                    desktop.browse(uRI);
                }
                catch (Exception exception2) {
                    System.err.println(exception2.getMessage());
                }
            }
            System.err.println(exception.getMessage());
        }
    }

    private static String maybeFixupURLForWindows(String string) {
        if (string == null || string.length() < 2 || string.charAt(0) == '\\' || string.charAt(1) == ':') {
            return string;
        }
        String string2 = string.toLowerCase();
        int n = badEndings.length;
        while (n-- > 0) {
            if (!string2.endsWith(badEndings[n])) continue;
            return Browser.fixupURLForWindows(string);
        }
        return string;
    }

    private static String fixupURLForWindows(String string) {
        if (string.indexOf(63) == -1) {
            return string + "?";
        }
        return string + "&workaroundStupidWindowsBug";
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }
}

