/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import net.alomax.graphics2d.JStereographic;
import net.alomax.graphics2d.MarkerGraph2DModel;
import net.alomax.graphics2d.objects.CircleDataMarker;
import net.alomax.graphics2d.objects.DataMarker;
import net.alomax.graphics2d.objects.SquareDataMarker;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeisPhase;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.swing.JBasicFrame;
import net.alomax.swing.PrintUtils;
import net.alomax.swing.SwingText;

public class FocalSphereFrame
extends JBasicFrame {
    protected JStereographic frameGraph = null;
    protected SeismicityFrame seisFrame = null;
    protected Color defaultColor = Color.RED;
    protected Color foregroundColor = Color.WHITE;
    protected Color gridLineColor = Color.DARK_GRAY;
    protected Color backgroundColor = Color.BLACK;
    protected static final double INV_LOG_10 = 1.0 / Math.log(10.0);
    protected static final double TWO_PI = Math.PI * 2;

    public FocalSphereFrame(SeismicityFrame seismicityFrame, String string, Color color, Color color2, Color color3, Color color4, int n, int n2, Image image) {
        super(seismicityFrame, string, false, image);
        this.seisFrame = seismicityFrame;
        this.defaultColor = color;
        this.gridLineColor = color3;
        this.foregroundColor = color2;
        this.backgroundColor = color4;
        int n3 = seismicityFrame.getWidth() < seismicityFrame.getHeight() ? seismicityFrame.getWidth() : seismicityFrame.getHeight();
        this.setDefaultSize(n3, 11 * n3 / 10);
    }

    protected void display() {
        this.display(null, false);
    }

    @Override
    public void display(Graphics graphics, boolean bl) {
        MarkerGraph2DModel markerGraph2DModel = new MarkerGraph2DModel();
        boolean bl2 = this.seisFrame.eventPlotFirst == this.seisFrame.eventPlotLast;
        for (int i = this.seisFrame.eventPlotFirst; i < this.seisFrame.eventPlotLast + 1; ++i) {
            Object object;
            SeisEvent seisEvent = (SeisEvent)this.seisFrame.seisEventList.get(i);
            if (!bl2 && !this.seisFrame.seisEventFilter.accept(seisEvent)) continue;
            int n = seisEvent.phaseList.size();
            Color color = this.foregroundColor;
            Color color2 = SeismicityColors.phaseFirstMotionUp;
            int n2 = 10;
            int n3 = 10;
            if (bl) {
                color = Color.BLACK;
            }
            Object[] objectArray = new double[n];
            Object object2 = new double[n];
            DataMarker[] dataMarkerArray = new DataMarker[n];
            for (int j = 0; j < n; ++j) {
                object = seisEvent.phaseList.elementAt(j);
                objectArray[j] = ((SeisPhase)object).ray_azim;
                object2[j] = ((SeisPhase)object).ray_dip;
                dataMarkerArray[j] = null;
                if (((SeisPhase)object).ray_qual < 1) {
                    dataMarkerArray[j] = new CircleDataMarker(0, false, color);
                    continue;
                }
                if (((SeisPhase)object).ray_dip <= 90.0) {
                    if (!this.seisFrame.firstMotionFlag || ((SeisPhase)object).polarity == 0) {
                        dataMarkerArray[j] = new CircleDataMarker(n2, false, color);
                        continue;
                    }
                    if (((SeisPhase)object).polarity == 1) {
                        dataMarkerArray[j] = new CircleDataMarker(n3, true, SeismicityColors.phaseFirstMotionUp);
                        continue;
                    }
                    dataMarkerArray[j] = new CircleDataMarker(n3, false, SeismicityColors.phaseFirstMotionDown);
                    continue;
                }
                dataMarkerArray[j] = !this.seisFrame.firstMotionFlag || ((SeisPhase)object).polarity == 0 ? new SquareDataMarker(n2, false, color) : (((SeisPhase)object).polarity == 1 ? new SquareDataMarker(n3, true, SeismicityColors.phaseFirstMotionUp) : new SquareDataMarker(n3, false, SeismicityColors.phaseFirstMotionDown));
            }
            markerGraph2DModel.addSeries((double[])objectArray, (double[])object2, dataMarkerArray);
            if (!this.seisFrame.probDenFlag) continue;
            n = seisEvent.samples.length;
            color = SeisEvent.sampleCol;
            int n4 = 1;
            if (bl) {
                color = Color.BLACK;
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            objectArray = new DataMarker[n];
            object2 = seisEvent.hypocenter.getCoordinates();
            for (int j = 0; j < n; ++j) {
                Vect3D vect3D = seisEvent.samples[j].getCoordinates();
                object = vect3D.sub((Vect3D)object2);
                dArray[j] = 90.0 - ((Vect3D)object).getAzimuth();
                dArray2[j] = ((Vect3D)object).getDip() + 90.0;
                objectArray[j] = (double)new CircleDataMarker(n4, true, color);
            }
            markerGraph2DModel.addSeries(dArray, dArray2, (DataMarker[])objectArray);
        }
        JStereographic jStereographic = null;
        if (!bl && this.frameGraph != null) {
            this.getContentPane().remove(this.frameGraph);
        }
        jStereographic = new JStereographic(markerGraph2DModel);
        if (bl) {
            jStereographic.setForeground(Color.BLACK);
            jStereographic.setGridLineColor(Color.GRAY);
            jStereographic.setBackground(Color.WHITE);
        } else {
            jStereographic.setForeground(this.foregroundColor);
            jStereographic.setGridLineColor(this.gridLineColor);
            jStereographic.setBackground(this.backgroundColor);
            jStereographic.setDisplayCursorPosition(true);
        }
        jStereographic.setGridLines(true);
        jStereographic.setTitle(this.getTitle());
        if (bl) {
            jStereographic.print(graphics);
        } else {
            this.getContentPane().add((Component)jStereographic, "Center");
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.validate();
            this.frameGraph = jStereographic;
        }
    }

    @Override
    public void print(Graphics graphics) {
        int n = 24;
        try {
            n = Integer.valueOf(this.seisFrame.getParameter("print.font.size"));
        }
        catch (Exception exception) {
            n = 24;
        }
        graphics.setFont(new Font("SansSerif", 0, n));
        PrintGraphics printGraphics = null;
        Dimension dimension = null;
        try {
            printGraphics = (PrintGraphics)((Object)graphics);
            PrintJob printJob = printGraphics.getPrintJob();
            dimension = printJob.getPageDimension();
            System.out.println("INFO: Print Page Dimension is: width=" + printJob.getPageDimension().width + " height=" + printJob.getPageDimension().height);
        }
        catch (ClassCastException classCastException) {
            String string = "ERROR: Cannot get PrintGraphics object: " + classCastException;
            System.out.println(string);
            this.seisFrame.writeMessage(string);
            return;
        }
        int n2 = 15;
        int n3 = dimension.width / n2;
        int n4 = dimension.height / n2;
        Dimension dimension2 = new Dimension(dimension.width - 2 * n3, dimension.height - 2 * n4);
        dimension2.height = dimension2.width = dimension2.width < dimension2.height ? dimension2.width : dimension2.height;
        System.out.println("drawOriginX, drawOriginY, drawSize.width, drawSize.height " + n3 + " " + n4 + " " + dimension2.width + " " + dimension2.height);
        Graphics graphics2 = graphics.create(n3, n4, dimension2.width, dimension2.height);
        this.display(graphics2, true);
        graphics2.dispose();
    }

    @Override
    public void doPrintJob() {
        Cursor cursor = this.getCursor();
        int n = 150;
        try {
            n = Integer.valueOf(this.seisFrame.getParameter("print.resolution"));
        }
        catch (Exception exception) {
            n = 150;
        }
        PrintJob printJob = null;
        try {
            printJob = PrintUtils.getPrintJob(this, this.getTitle(), n);
        }
        catch (Exception exception) {
            this.seisFrame.writeAppletSecurityMessage(SwingText.PRINT, exception);
            return;
        }
        if (printJob == null) {
            this.setCursor(cursor);
            return;
        }
        this.setCursor(new Cursor(3));
        this.seisFrame.writeMessage("Printing...");
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
        this.setCursor(cursor);
        this.seisFrame.writeMessage("_READY");
    }

    @Override
    public void windowIsClosing() {
    }
}

