/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import net.alomax.io.BinaryInputStream;
import net.alomax.io.BinaryOutputStream;
import net.alomax.seismicity.Grid2GMTException;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.seismicity.SeismicityText;

public class Grid2GMTParameters {
    public static final String[] modeNames = new String[]{"L - Location (Horizontal and cross sections)", "H - Horizontal section"};
    public static final String[] plotTypeNames = new String[]{"S000 - PDF (scatter-cloud)", "S100 - PDF (scatter-cloud, max-like)", "S011 - PDF (scatter-cloud, expect, ellipsoid)", "S111 - PDF (scatter-cloud, max-like, expect, ellipsoid)", "E100 - Location (max-like)", "E011 - Location (expect, ellipsoid)", "E111 - Location (max-like, expect, ellipsoid)", "M - Plot focal mechanisms", "RP - Plot P phase residuals scale 0.5 s/cm ", "RP/0.1 - Plot P phase residuals scale 0.1 s/cm", "RP/2.5 - Plot P phase residuals scale 2.5 s/cm", "RS - Plot S phase residuals scale 0.5 s/cm ", "RS/0.1 - Plot S phase residuals scale 0.1 s/cm", "RS/2.5 - Plot S phase residuals scale 2.5 s/cm"};
    protected String controlfile = "";
    protected String gridroot = "";
    protected String outroot = "";
    protected String modeID = "L";
    protected String plotTypeID = "S000";
    protected int ix1 = 0;
    protected int ix2 = 0;
    protected int iy1 = 0;
    protected int iy2 = 0;
    protected int ix = 0;
    protected int iy = 0;
    protected int iz = 0;
    protected double lat1 = 0.0;
    protected double lat2 = 0.0;
    protected double lon1 = 0.0;
    protected double lon2 = 0.0;
    protected SeismicityFrame seismicityFrame = null;
    public String lastErrorString = "";

    Grid2GMTParameters(SeismicityFrame seismicityFrame) {
        this.seismicityFrame = seismicityFrame;
        try {
            this.controlfile = seismicityFrame.getParameter("interface.grid2gmt.controlfile");
        }
        catch (Exception exception) {
            this.controlfile = "ERROR";
        }
        System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.controlfile = " + this.controlfile);
        try {
            this.outroot = seismicityFrame.getParameter("interface.grid2gmt.outroot");
        }
        catch (Exception exception) {
            this.outroot = "ERROR";
        }
        System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.outroot = " + this.outroot);
        try {
            this.modeID = this.toModeID(seismicityFrame.getParameter("interface.grid2gmt.mode"));
        }
        catch (Exception exception) {
            this.modeID = "L";
        }
        System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.mode = " + this.modeID);
        try {
            this.plotTypeID = this.toPlotTypeID(seismicityFrame.getParameter("interface.grid2gmt.plottype"));
        }
        catch (Exception exception) {
            this.plotTypeID = "S000";
        }
        System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.plottype = " + this.plotTypeID);
        try {
            this.ix1 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.ix1"));
        }
        catch (Exception exception) {
            this.ix1 = 0;
        }
        try {
            this.ix2 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.ix2"));
        }
        catch (Exception exception) {
            this.ix2 = 0;
        }
        try {
            this.iy1 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.iy1"));
        }
        catch (Exception exception) {
            this.iy1 = 0;
        }
        try {
            this.iy2 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.iy2"));
        }
        catch (Exception exception) {
            this.iy2 = 0;
        }
        try {
            this.ix = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.ix"));
        }
        catch (Exception exception) {
            this.ix = 0;
        }
        try {
            this.iy = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.iy"));
        }
        catch (Exception exception) {
            this.iy = 0;
        }
        try {
            this.iz = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.iz"));
        }
        catch (Exception exception) {
            this.iz = 0;
        }
        try {
            this.lat1 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.lat1"));
        }
        catch (Exception exception) {
            this.lat1 = 0.0;
        }
        try {
            this.lat2 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.lat2"));
        }
        catch (Exception exception) {
            this.lat2 = 0.0;
        }
        try {
            this.lon1 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.lon1"));
        }
        catch (Exception exception) {
            this.lon1 = 0.0;
        }
        try {
            this.lon2 = Integer.parseInt(seismicityFrame.getParameter("interface.grid2gmt.lon2"));
        }
        catch (Exception exception) {
            this.lon2 = 0.0;
        }
    }

    Grid2GMTParameters(Grid2GMTParameters grid2GMTParameters) {
        this.seismicityFrame = grid2GMTParameters.seismicityFrame;
        this.controlfile = grid2GMTParameters.controlfile;
        this.gridroot = grid2GMTParameters.gridroot;
        this.outroot = grid2GMTParameters.outroot;
        this.modeID = grid2GMTParameters.modeID;
        this.plotTypeID = grid2GMTParameters.plotTypeID;
        this.ix1 = grid2GMTParameters.ix1;
        this.ix2 = grid2GMTParameters.ix2;
        this.iy1 = grid2GMTParameters.iy1;
        this.iy2 = grid2GMTParameters.iy2;
        this.ix = grid2GMTParameters.ix;
        this.iy = grid2GMTParameters.iy;
        this.iz = grid2GMTParameters.iz;
        this.lat1 = grid2GMTParameters.lat1;
        this.lat2 = grid2GMTParameters.lat2;
        this.lon1 = grid2GMTParameters.lon1;
        this.lon2 = grid2GMTParameters.lon2;
    }

    public String toModeID(String string) {
        String string2 = string.toUpperCase();
        for (int i = 0; i < modeNames.length; ++i) {
            if (!string2.equals(modeNames[i].toUpperCase())) continue;
            return modeNames[i].substring(0, modeNames[i].indexOf(32)).toUpperCase();
        }
        return null;
    }

    public String toModeName(String string) {
        String string2 = string.toUpperCase();
        for (int i = 0; i < modeNames.length; ++i) {
            String string3 = modeNames[i].substring(0, modeNames[i].indexOf(32)).toUpperCase();
            if (!string2.equals(string3)) continue;
            return modeNames[i];
        }
        return null;
    }

    public String toPlotTypeID(String string) {
        String string2 = string.toUpperCase();
        for (int i = 0; i < plotTypeNames.length; ++i) {
            if (!string2.equals(plotTypeNames[i].toUpperCase())) continue;
            return plotTypeNames[i].substring(0, plotTypeNames[i].indexOf(32)).toUpperCase();
        }
        return null;
    }

    public String toPlotTypeName(String string) {
        String string2 = string.toUpperCase();
        for (int i = 0; i < plotTypeNames.length; ++i) {
            String string3 = plotTypeNames[i].substring(0, plotTypeNames[i].indexOf(32)).toUpperCase();
            if (!string2.equals(string3)) continue;
            return plotTypeNames[i];
        }
        return null;
    }

    public boolean plotTypeIsScatter() {
        return this.plotTypeID.startsWith("S");
    }

    public String generateGrid2GMTCommand() throws Exception {
        String[] stringArray;
        this.gridroot = null;
        if (this.gridroot == null) {
            stringArray = this.seismicityFrame.getPlottedEventsFilenames();
            System.out.println("getPlottedEventsFilenames: n=" + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("" + i + " " + stringArray[i]);
            }
            if (stringArray.length < 1) {
                throw new Grid2GMTException("No events displayed.");
            }
            if (stringArray.length == 1) {
                this.gridroot = stringArray[0];
                this.gridroot = this.gridroot.substring(0, this.gridroot.lastIndexOf(46));
            } else {
                int n;
                Object object;
                this.gridroot = this.outroot + "_eventsum";
                String string = this.gridroot + ".hyp";
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                char[] cArray = new char[4096];
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2;
                    if (stringArray[i].equals(string2)) continue;
                    object = new BufferedReader(new FileReader(stringArray[i]));
                    while ((n2 = ((Reader)object).read(cArray)) > 0) {
                        bufferedWriter.write(cArray, 0, n2);
                    }
                    bufferedWriter.newLine();
                    ((BufferedReader)object).close();
                    string2 = stringArray[i];
                }
                bufferedWriter.close();
                String string3 = this.gridroot + ".hdr";
                object = stringArray[0].substring(0, stringArray[0].lastIndexOf(46)) + ".hdr";
                bufferedWriter = new BufferedWriter(new FileWriter(string3));
                BufferedReader bufferedReader = new BufferedReader(new FileReader((String)object));
                while ((n = bufferedReader.read()) >= 0) {
                    bufferedWriter.write(n);
                }
                bufferedWriter.newLine();
                bufferedReader.close();
                bufferedWriter.close();
                if (this.plotTypeIsScatter()) {
                    String string4 = this.gridroot + ".scat";
                    this.combineScatterFile(stringArray, string4);
                }
            }
        }
        stringArray = "Grid2GMT ";
        stringArray = (String)stringArray + this.controlfile + " ";
        stringArray = (String)stringArray + this.gridroot + " ";
        stringArray = (String)stringArray + this.outroot + " ";
        if (this.modeID.startsWith("L")) {
            stringArray = (String)stringArray + "L ";
            stringArray = (String)stringArray + this.plotTypeID + " ";
        } else if (this.modeID.startsWith("H")) {
            stringArray = (String)stringArray + "H ";
            stringArray = (String)stringArray + this.plotTypeID + " " + this.iz;
        }
        return stringArray;
    }

    public boolean checkParameterValues() {
        if (this.controlfile == null || !new File(this.controlfile).exists()) {
            System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.controlfile = " + this.controlfile);
            this.lastErrorString = "file does not exist: parameter interface.grid2gmt.controlfile = " + this.controlfile;
            return false;
        }
        if (this.outroot == null || !new File(this.outroot).exists()) {
            System.out.println("Grid2GMT: INFO: parameter interface.grid2gmt.outroot = " + this.outroot);
            this.lastErrorString = "path does not exist: parameter interface.grid2gmt.outroot = " + this.outroot;
            return false;
        }
        if (!this.check(this.ix1, 0, Integer.MAX_VALUE, -1, "ix1")) {
            return false;
        }
        if (!this.check(this.ix2, 0, Integer.MAX_VALUE, -1, "ix2")) {
            return false;
        }
        if (!this.check(this.iy1, 0, Integer.MAX_VALUE, -1, "iy1")) {
            return false;
        }
        if (!this.check(this.iy2, 0, Integer.MAX_VALUE, -1, "iy2")) {
            return false;
        }
        if (!this.check(this.ix, 0, Integer.MAX_VALUE, -1, "ix")) {
            return false;
        }
        if (!this.check(this.iy, 0, Integer.MAX_VALUE, -1, "iy")) {
            return false;
        }
        if (!this.check(this.iz, 0, Integer.MAX_VALUE, -1, "iz")) {
            return false;
        }
        if (!this.check(this.lat1, -90.0, 90.0, 0.0, "lat1")) {
            return false;
        }
        if (!this.check(this.lat2, -90.0, 90.0, 0.0, "lat2")) {
            return false;
        }
        if (!this.check(this.lon1, -180.0, 180.0, 0.0, "lon1")) {
            return false;
        }
        return this.check(this.lon2, -180.0, 180.0, 0.0, "lon2");
    }

    protected boolean check(int n, int n2, int n3, int n4, String string) {
        if (n == n4) {
            return true;
        }
        try {
            if (n >= n2 && n <= n3) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastErrorString = SeismicityText.INVALID_VALUE + " " + string + ": \"" + n + "\": (" + n2 + "," + n3 + ")";
        return false;
    }

    protected boolean check(double d, double d2, double d3, double d4, String string) {
        if (d == d4) {
            return true;
        }
        try {
            if (d >= d2 && d <= d3) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastErrorString = SeismicityText.INVALID_VALUE + " " + string + ": \"" + d + "\": " + SeismicityText.VALID_RANGE + "(" + d2 + "," + d3 + ")";
        return false;
    }

    protected boolean checkValuesEntered(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) {
                bl2 = true;
                continue;
            }
            bl = false;
        }
        if (bl || !bl2) {
            return true;
        }
        String string = "";
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            string = string + stringArray2[i] + ", ";
        }
        string = string + stringArray2[stringArray2.length - 1];
        this.lastErrorString = SeismicityText.INVALID_VALUE + " " + string + ": " + SeismicityText.ALL_NON_BLANK;
        return false;
    }

    protected void combineScatterFile(String[] stringArray, String string) throws Exception, IOException {
        Object object;
        int n;
        int n2 = 1;
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(string)), n2);
        String string2 = "";
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(string2)) continue;
            String string3 = stringArray[n].substring(0, stringArray[n].indexOf(".hyp")) + ".scat";
            object = new BinaryInputStream((InputStream)new BufferedInputStream(new FileInputStream(string3)), n2);
            n3 += ((BinaryInputStream)object).readIntB();
            ((FilterInputStream)object).close();
            string2 = stringArray[n];
        }
        binaryOutputStream.writeIntB(n3);
        binaryOutputStream.writeFloatB(-1.0f);
        binaryOutputStream.writeFloatB(-1.0f);
        binaryOutputStream.writeFloatB(-1.0f);
        string2 = "";
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(string2)) continue;
            object = stringArray[i].substring(0, stringArray[i].indexOf(".hyp")) + ".scat";
            BinaryInputStream binaryInputStream = new BinaryInputStream((InputStream)new FileInputStream((String)object), n2);
            n += this.concatenateScatterFile(binaryInputStream, binaryOutputStream);
            binaryInputStream.close();
            string2 = stringArray[i];
        }
        binaryOutputStream.close();
        if (n != n3) {
            throw new Grid2GMTException("Combining pdf scater files: number of points written not equal to nominal total number of points.");
        }
    }

    protected int concatenateScatterFile(BinaryInputStream binaryInputStream, BinaryOutputStream binaryOutputStream) throws IOException {
        int n = binaryInputStream.readIntB();
        System.out.println("SCATTER Nsamples " + n);
        binaryInputStream.readFloatB();
        binaryInputStream.readFloatB();
        binaryInputStream.readFloatB();
        for (int i = 0; i < n; ++i) {
            binaryOutputStream.writeFloatB(binaryInputStream.readFloatB());
            binaryOutputStream.writeFloatB(binaryInputStream.readFloatB());
            binaryOutputStream.writeFloatB(binaryInputStream.readFloatB());
            binaryOutputStream.writeFloatB(binaryInputStream.readFloatB());
        }
        return n;
    }
}

