/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import net.alomax.awt.AJLColor;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.CovMatrix;
import net.alomax.graphics3d.Ellipse3D;
import net.alomax.graphics3d.Ellipsoid3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Sample4D;
import net.alomax.graphics3d.Sample4DSet;
import net.alomax.graphics3d.Transformable3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.FocalMechanism;
import net.alomax.seismicity.SeisPhase;
import net.alomax.seismicity.SeismicityColorMap;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.swing.seis.EventSearchException;
import net.alomax.util.Date2;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public class SeisEvent
extends Transformable3D {
    private boolean DEBUG;
    public static int Number_quality_RMS = 0;
    public static double Sum_quality_RMS = 0.0;
    public static double Sum_quality_RMS_2 = 0.0;
    public static int Number_ellipsoid_se3 = 0;
    public static double Sum_ellipsoid_se3 = 0.0;
    public static double Sum_ellipsoid_se3_2 = 0.0;
    protected SeismicityFrame seisApp;
    protected String eventFileName;
    protected static Color maxLikeColDefault;
    protected static Color maxLikeCol;
    protected static Color expectCol;
    protected static Color covCol;
    protected static Color ellipsoidCol;
    protected static Color ellipsoid2Col;
    protected static Color sampleColDefault;
    protected static Color sampleCol;
    protected static boolean samples_applycolormap;
    protected static boolean ellipsoid_applycolormap;
    protected static SeismicityColorMap colorMap;
    public int original_index;
    public String filename;
    public String signature;
    public String publicId;
    public String obs_file;
    public String comment;
    protected static final GregorianCalendar DEFAULT_CALANDER;
    protected int iyear;
    protected int imonth;
    protected int iday;
    protected int ihour;
    protected int imin;
    protected double sec;
    protected long oTimeMillisec;
    protected double quality_Pmax;
    protected double quality_MFmin;
    protected double quality_MFmax;
    protected double quality_RMS;
    public static double DELTA_CHI_SQR_68_2;
    protected double quality_errH;
    protected double quality_errZ;
    protected int quality_Nphs;
    protected int quality_Gap;
    protected double quality_Dist;
    protected double quality_Mamp;
    protected int quality_nRdgsMamp;
    protected double quality_Mdur;
    protected int quality_nRdgsMdur;
    protected double quality_octree_scatter_volume;
    protected Vect3D hypoGeog;
    protected Vect3D expectationGeog;
    protected Sample4D hypocenter;
    protected Sample4D expectation;
    protected static final int HYPO_TYPE = 1;
    protected int expectType;
    protected CovMatrix covariance;
    protected Ellipse3D ellipse;
    protected Ellipsoid3D ellipsoid;
    protected Ellipsoid3D ellipsoid2;
    protected FocalMechanism focalMech;
    protected Sample4D[] samples;
    protected int maxNumSamples;
    protected int sampleType;
    protected Vector<SeisPhase> phaseList;
    protected String dateStr;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double zmin;
    protected double zmax;
    protected boolean isGlobal;
    protected GeogCoords eventGeogCoords;
    protected static final long RANDOM_SEED = 123456L;
    protected static Random random;
    protected static String csvCompact_header_line;
    static final int EARLY_EST_CSV_VERSION_PRE_2014_03 = 0;
    static final int EARLY_EST_CSV_VERSION_POST_2014_03 = 1;
    static final int EARLY_EST_CSV_VERSION_POST_2016 = 2;
    static int earlyEstCsvVersion;

    public static void reseedRansom() {
        random = new Random(123456L);
    }

    public static void invertColor(boolean bl) {
        expectCol = AJLColor.invert(expectCol);
        covCol = AJLColor.invert(covCol);
        ellipsoidCol = AJLColor.invert(ellipsoidCol);
        ellipsoid2Col = AJLColor.invert(ellipsoid2Col);
        if (bl) {
            maxLikeCol = Color.black;
            sampleCol = AJLColor.lighter(sampleColDefault);
        } else {
            maxLikeCol = maxLikeColDefault;
            sampleCol = sampleColDefault;
        }
    }

    public static void setColorMap(SeismicityColorMap seismicityColorMap) {
        colorMap = seismicityColorMap;
    }

    public static SeismicityColorMap getColorMap() {
        return colorMap;
    }

    public static long calcTimeInMillis(Calendar calendar, int n, int n2, int n3, int n4, int n5, double d) {
        calendar.clear();
        calendar.set(n, n2 - 1, n3, n4, n5, (int)d);
        long l = calendar.getTimeInMillis();
        return l += Math.round(1000.0 * (d - Math.floor(d)));
    }

    protected long calcOTimeInMillis(Calendar calendar) {
        calendar.clear();
        calendar.set(this.iyear, this.imonth - 1, this.iday, this.ihour, this.imin, (int)this.sec);
        long l = calendar.getTimeInMillis();
        return l += Math.round(1000.0 * (this.sec - Math.floor(this.sec)));
    }

    public SeisEvent(SeismicityFrame seismicityFrame, String string) {
        this.DEBUG = false;
        this.seisApp = null;
        this.eventFileName = null;
        this.original_index = -1;
        this.filename = new String();
        this.signature = new String();
        this.publicId = new String();
        this.obs_file = new String();
        this.comment = new String();
        this.oTimeMillisec = 0L;
        this.quality_RMS = -1.0;
        this.quality_errH = -1.0;
        this.quality_errZ = -1.0;
        this.hypoGeog = null;
        this.expectationGeog = null;
        this.hypocenter = null;
        this.expectation = null;
        this.expectType = 1;
        this.ellipse = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        this.maxNumSamples = 0;
        this.sampleType = 0;
        this.phaseList = new Vector();
        this.isGlobal = false;
        this.eventGeogCoords = null;
        this.seisApp = seismicityFrame;
        this.eventFileName = string;
        this.isGlobal = seismicityFrame.isGlobal();
        expectCol = SeismicityColors.createColor(seismicityFrame, "color.expectation", expectCol);
        maxLikeCol = maxLikeColDefault = SeismicityColors.createColor(seismicityFrame, "color.maxlikelihood", maxLikeColDefault);
        samples_applycolormap = seismicityFrame.getTrueFalseParameter(false, "scattersamples.applycolormap");
        ellipsoid_applycolormap = seismicityFrame.getTrueFalseParameter(false, "ellipsoid.applycolormap");
        this.DEBUG = SeismicityFrame.DEBUG_LEVEL > 2;
    }

    public SeisEvent(SeismicityFrame seismicityFrame, String string, ASCIIInputStream aSCIIInputStream, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d3) throws Exception {
        boolean bl5;
        int n;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        boolean bl6;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        block149: {
            double d21;
            double d22;
            double d23;
            double d24;
            double d25;
            block148: {
                this(seismicityFrame, string);
                d20 = 0.0;
                d19 = 0.0;
                d18 = 0.0;
                d17 = 0.0;
                d16 = 0.0;
                d15 = 0.0;
                d14 = 0.0;
                d13 = 0.0;
                d12 = 0.0;
                d11 = 0.0;
                bl6 = false;
                d10 = 0.0;
                d9 = 0.0;
                d8 = 0.0;
                d7 = -3.4028234663852886E38;
                d6 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                n = 0;
                bl5 = false;
                d25 = -3.4028234663852886E38;
                d24 = -3.4028234663852886E38;
                d23 = -3.4028234663852886E38;
                d22 = -3.4028234663852886E38;
                this.hypocenter = null;
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("Reading NLLoc event file: " + this.getEventFileName());
                }
                String string2 = "!@#$%";
                try {
                    String string3;
                    double d26;
                    int n2;
                    if (this.DEBUG) {
                        System.out.println("find TRANSFORM");
                    }
                    aSCIIInputStream.mark(10000);
                    while (!aSCIIInputStream.eof() && string2.compareTo("PHASE") != 0 && string2.compareTo("END_NLLOC") != 0) {
                        string2 = aSCIIInputStream.readWord();
                        if (this.DEBUG) {
                            System.out.println("TRANSFORM Reading: " + string2);
                        }
                        if (string2.compareTo("TRANSFORM") == 0) {
                            this.eventGeogCoords = new GeogCoords(aSCIIInputStream);
                            if (this.DEBUG) {
                                System.out.println("isGlobal: " + this.isGlobal);
                            }
                            if (seismicityFrame.geogCoords == null) {
                                seismicityFrame.geogCoords = this.eventGeogCoords;
                            }
                            this.isGlobal = seismicityFrame.geogCoords.isGlobal();
                            if (this.DEBUG) {
                                System.out.println("isGlobal: " + this.isGlobal);
                            }
                            aSCIIInputStream.flushLine();
                            break;
                        }
                        aSCIIInputStream.flushLine();
                    }
                    aSCIIInputStream.reset();
                    if (this.eventGeogCoords == null) {
                        this.eventGeogCoords = seismicityFrame.geogCoords;
                    }
                    if (this.isGlobal) {
                        if (this.DEBUG) {
                            System.out.println("find GRID and STAT_GEOG");
                        }
                        aSCIIInputStream.mark(10000);
                        while (!aSCIIInputStream.eof()) {
                            string2 = aSCIIInputStream.readWord();
                            if (this.DEBUG) {
                                System.out.println("GRID and STAT_GEOG Reading: " + string2);
                            }
                            if (string2.compareTo("PHASE") == 0 || string2.compareTo("END_NLLOC") == 0) {
                                aSCIIInputStream.flushLine();
                                break;
                            }
                            if (string2.compareTo("GRID") == 0) {
                                if (this.DEBUG) {
                                    System.out.println("Found GRID");
                                }
                                int n3 = -1;
                                n2 = -1;
                                d26 = 0.0;
                                d21 = 0.0;
                                try {
                                    n3 = aSCIIInputStream.readInt();
                                    n2 = aSCIIInputStream.readInt();
                                    string3 = aSCIIInputStream.readWord();
                                    string3 = aSCIIInputStream.readWord();
                                    string3 = aSCIIInputStream.readWord();
                                    string3 = aSCIIInputStream.readWord();
                                    d26 = Double.parseDouble(aSCIIInputStream.readWord());
                                    d21 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (n3 > 0 && n2 > 0) {
                                    double d27 = Math.max((double)(n3 - 1) * d26, (double)(n2 - 1) * d21);
                                    seismicityFrame.setGlobalWorldWidthMax(d27 * GeogConstants.DEG2KM);
                                    if (this.DEBUG) {
                                        System.out.println("seisApp.setGlobalWorldWidthMax");
                                    }
                                }
                            } else if (string2.compareTo("STAT_GEOG") == 0) {
                                if (this.DEBUG) {
                                    System.out.println("Found STAT_GEOG");
                                }
                                double d28 = 0.0;
                                d26 = 0.0;
                                d21 = 0.0;
                                string3 = aSCIIInputStream.readWord();
                                try {
                                    d28 = Double.parseDouble(aSCIIInputStream.readWord());
                                    string3 = aSCIIInputStream.readWord();
                                    d26 = Double.parseDouble(aSCIIInputStream.readWord());
                                    string3 = aSCIIInputStream.readWord();
                                    d21 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                Vect3D vect3D = seismicityFrame.geogCoords.geog2xyz(d28, d26, d21);
                                this.expectation = new Sample4D(vect3D.x, vect3D.y, vect3D.z, 0.0, this.expectType);
                                if (this.DEBUG) {
                                    System.out.println("set expectation = new Sample4D");
                                }
                                this.expectationGeog = new Vect3D(d28, d26, d21);
                            }
                            aSCIIInputStream.flushLine();
                        }
                        aSCIIInputStream.reset();
                    }
                    this.filename = aSCIIInputStream.readWord();
                    if (!this.filename.startsWith("\"")) {
                        this.filename = "\"" + this.filename;
                    }
                    if (!this.filename.endsWith("\"")) {
                        this.filename = this.filename + "\"";
                    }
                    if (this.DEBUG) {
                        System.out.println("Reading filename: " + this.filename);
                    }
                    if (this.DEBUG) {
                        System.out.println("Reading eof(): " + aSCIIInputStream.eof());
                    }
                    aSCIIInputStream.flushLine();
                    if (this.DEBUG) {
                        System.out.println("Reading eof(): " + aSCIIInputStream.eof());
                    }
                    while (!aSCIIInputStream.eof()) {
                        block151: {
                            block156: {
                                Vect3D vect3D;
                                double d29;
                                double d30;
                                double d31;
                                double d32;
                                block155: {
                                    block154: {
                                        block153: {
                                            block152: {
                                                block150: {
                                                    string2 = aSCIIInputStream.readWord();
                                                    if (this.DEBUG) {
                                                        System.out.println("Reading: " + string2);
                                                    }
                                                    if (string2.compareTo("END_NLLOC") == 0) {
                                                        aSCIIInputStream.flushLine();
                                                        break;
                                                    }
                                                    if (string2.compareTo("COMMENT") == 0) {
                                                        this.comment = aSCIIInputStream.readLine();
                                                        continue;
                                                    }
                                                    if (string2.compareTo("PUBLIC_ID") != 0) break block150;
                                                    this.publicId = aSCIIInputStream.readWord();
                                                    break block151;
                                                }
                                                if (string2.compareTo("SIGNATURE") == 0) {
                                                    this.signature = aSCIIInputStream.readLine();
                                                    if (this.signature.indexOf("obs:") <= 0) continue;
                                                    this.obs_file = this.signature.substring(this.signature.indexOf("obs:") + 4);
                                                    if (this.obs_file.indexOf(" ") <= 0) continue;
                                                    this.obs_file = this.obs_file.substring(0, this.obs_file.indexOf(" "));
                                                    continue;
                                                }
                                                if (string2.compareTo("SEARCH") != 0) break block152;
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                string3 = aSCIIInputStream.readWord();
                                                this.quality_octree_scatter_volume = aSCIIInputStream.readDouble();
                                                break block151;
                                            }
                                            if (string2.compareTo("HYPOCENTER") == 0) continue;
                                            if (string2.compareTo("GEOGRAPHIC") != 0) break block153;
                                            string3 = aSCIIInputStream.readWord();
                                            this.iyear = aSCIIInputStream.readInt();
                                            this.imonth = aSCIIInputStream.readInt();
                                            this.iday = aSCIIInputStream.readInt();
                                            this.ihour = aSCIIInputStream.readInt();
                                            this.imin = aSCIIInputStream.readInt();
                                            this.sec = Double.parseDouble(aSCIIInputStream.readWord());
                                            this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                                            string3 = aSCIIInputStream.readWord();
                                            d25 = aSCIIInputStream.readDouble();
                                            string3 = aSCIIInputStream.readWord();
                                            d24 = aSCIIInputStream.readDouble();
                                            string3 = aSCIIInputStream.readWord();
                                            d23 = aSCIIInputStream.readDouble();
                                            this.hypoGeog = new Vect3D(d25, d24, d23);
                                            break block151;
                                        }
                                        if (string2.compareTo("QUALITY") != 0) break block154;
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Pmax = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_MFmin = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_MFmax = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_RMS = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Nphs = aSCIIInputStream.readInt();
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Gap = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Dist = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Mamp = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        try {
                                            this.quality_nRdgsMamp = aSCIIInputStream.readInt();
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        string3 = aSCIIInputStream.readWord();
                                        try {
                                            this.quality_Mdur = Double.parseDouble(aSCIIInputStream.readWord());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        try {
                                            this.quality_nRdgsMdur = aSCIIInputStream.readInt();
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        d22 = this.quality_Mamp;
                                        if (d22 < -9.0) {
                                            d22 = this.quality_Mdur;
                                        }
                                        if (this.hypocenter != null) {
                                            this.hypocenter.setValue(d22);
                                        }
                                        if (this.expectation != null) {
                                            this.expectation.setValue(d22);
                                        }
                                        break block151;
                                    }
                                    if (string2.compareTo("STATISTICS") != 0) break block155;
                                    double d33 = 0.0;
                                    d26 = 0.0;
                                    d21 = 0.0;
                                    double d34 = 0.0;
                                    double d35 = 0.0;
                                    double d36 = 0.0;
                                    d32 = 0.0;
                                    d31 = 0.0;
                                    d30 = 0.0;
                                    d29 = 0.0;
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d33 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d26 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d21 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d35 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d36 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d32 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d31 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d30 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    d29 = -1.0;
                                    try {
                                        d29 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    if (d29 > Double.MIN_NORMAL) {
                                        this.quality_errZ = Math.sqrt(DELTA_CHI_SQR_68_2 * d29);
                                    }
                                    double d37 = 0.0;
                                    if (d22 > -3.4028234663852886E38) {
                                        d37 = d22;
                                    }
                                    vect3D = null;
                                    if (this.isGlobal) {
                                        if (this.expectation != null) {
                                            this.expectation.value = d37;
                                        }
                                    } else {
                                        if (!this.eventGeogCoords.isGlobal()) {
                                            vect3D = new Vect3D(d33, d26, -d21);
                                            vect3D = this.eventGeogCoords.xyz2geog(vect3D);
                                        } else {
                                            vect3D = new Vect3D(d26, d33, d21);
                                        }
                                        vect3D = seismicityFrame.geogCoords.geog2xyz(vect3D);
                                        this.expectation = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d37, this.expectType);
                                        this.expectationGeog = new Vect3D(d26, d33, d21);
                                    }
                                    if (bl) {
                                        this.covariance = new CovMatrix(d35, d36, -d32, d31, -d30, d29);
                                    }
                                    if (!bl) break block151;
                                    double d38 = -3.4028234663852886E38;
                                    double d39 = 0.0;
                                    double d40 = 0.0;
                                    double d41 = 0.0;
                                    double d42 = 0.0;
                                    double d43 = 0.0;
                                    double d44 = 0.0;
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d38 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d39 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d40 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d41 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d42 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d43 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    string3 = aSCIIInputStream.readWord();
                                    try {
                                        d44 = Double.parseDouble(aSCIIInputStream.readWord());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    if (!(d38 >= 0.0)) break block151;
                                    if (this.isGlobal) {
                                        Vect3D vect3D2 = new Vect3D(d33, d26, d21);
                                        Vect3D vect3D3 = vect3D2.sub(seismicityFrame.globalCenter);
                                        Matrix3D matrix3D = Matrix3D.createTranformToUpOnSphere(new Vect3D(0.0, 0.0, 0.0), vect3D3);
                                        Vect3D vect3D4 = new Vect3D(90.0 - d38, -d39);
                                        vect3D4 = matrix3D.transform(vect3D4);
                                        d38 = -(vect3D4.getAzimuth() - 90.0);
                                        d39 = -vect3D4.getDip();
                                        Vect3D vect3D5 = new Vect3D(90.0 - d41, -d42);
                                        vect3D5 = matrix3D.transform(vect3D5);
                                        d41 = -(vect3D5.getAzimuth() - 90.0);
                                        d42 = -vect3D5.getDip();
                                    }
                                    double d45 = -this.eventGeogCoords.getRotationAngle() + seismicityFrame.geogCoords.getRotationAngle();
                                    double d46 = d38 + d45;
                                    double d47 = d41 + d45;
                                    this.ellipsoid = new Ellipsoid3D(this.expectation.x, this.expectation.y, this.expectation.z, d46, d39, d40, d47, d42, d43, d44);
                                    break block151;
                                }
                                if (!bl || string2.compareTo("QML_OriginUncertainty") != 0) break block156;
                                if (!bl) break block151;
                                double d48 = 0.0;
                                d26 = 0.0;
                                d21 = 0.0;
                                double d49 = 0.0;
                                string3 = aSCIIInputStream.readWord();
                                try {
                                    d48 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                string3 = aSCIIInputStream.readWord();
                                try {
                                    d26 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                string3 = aSCIIInputStream.readWord();
                                try {
                                    d21 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (d21 > Double.MIN_NORMAL) {
                                    this.quality_errH = d21;
                                }
                                string3 = aSCIIInputStream.readWord();
                                try {
                                    d49 = Double.parseDouble(aSCIIInputStream.readWord());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (!(d26 >= 0.0)) break block151;
                                double d50 = -3.4028234663852886E38;
                                double d51 = 0.0;
                                d32 = 0.0;
                                d31 = 0.0;
                                d30 = d49 + 90.0;
                                if (d30 > 360.0) {
                                    d30 -= 180.0;
                                }
                                d29 = d49;
                                boolean bl7 = true;
                                if (!bl7) {
                                    if (this.isGlobal) {
                                        Vect3D vect3D6 = new Vect3D(this.expectation.x, this.expectation.y, this.expectation.z);
                                        vect3D = vect3D6.sub(seismicityFrame.globalCenter);
                                        Matrix3D matrix3D = Matrix3D.createTranformToUpOnSphere(new Vect3D(0.0, 0.0, 0.0), vect3D);
                                        Vect3D vect3D7 = new Vect3D(90.0 - d49 + 90.0, 0.0);
                                        vect3D7 = matrix3D.transform(vect3D7);
                                        d50 = -(vect3D7.getAzimuth() - 90.0);
                                        d51 = -vect3D7.getDip();
                                        Vect3D vect3D8 = new Vect3D(90.0 - d49, 0.0);
                                        vect3D8 = matrix3D.transform(vect3D8);
                                        d32 = -(vect3D8.getAzimuth() - 90.0);
                                        d31 = -vect3D8.getDip();
                                    }
                                    double d52 = -this.eventGeogCoords.getRotationAngle() + seismicityFrame.geogCoords.getRotationAngle();
                                    d30 = d50 + d52;
                                    d29 = d32 + d52;
                                }
                                this.ellipse = new Ellipse3D(this.expectation.x, this.expectation.y, this.expectation.z, d30, d51, d26, d29, d31, d21);
                                break block151;
                            }
                            if (bl && string2.compareTo("ELLIPSOID") == 0) {
                                string3 = aSCIIInputStream.readWord();
                                d20 = Double.parseDouble(aSCIIInputStream.readWord());
                                d19 = Double.parseDouble(aSCIIInputStream.readWord());
                                d18 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                d17 = Double.parseDouble(aSCIIInputStream.readWord());
                                d16 = Double.parseDouble(aSCIIInputStream.readWord());
                                d15 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                d14 = Double.parseDouble(aSCIIInputStream.readWord());
                                d13 = Double.parseDouble(aSCIIInputStream.readWord());
                                d12 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                d11 = Double.parseDouble(aSCIIInputStream.readWord());
                                bl6 = true;
                            } else if (bl3 && string2.compareTo("FOCALMECH") == 0) {
                                string3 = aSCIIInputStream.readWord();
                                d10 = Double.parseDouble(aSCIIInputStream.readWord());
                                d9 = Double.parseDouble(aSCIIInputStream.readWord());
                                d8 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                d7 = Double.parseDouble(aSCIIInputStream.readWord());
                                d6 = Double.parseDouble(aSCIIInputStream.readWord());
                                d5 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                d4 = Double.parseDouble(aSCIIInputStream.readWord());
                                string3 = aSCIIInputStream.readWord();
                                n = aSCIIInputStream.readInt();
                                if (n >= 0) {
                                    bl5 = true;
                                }
                            } else if (bl2 && string2.compareTo("PHASE") == 0) {
                                aSCIIInputStream.flushLine();
                                while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readWord()).compareTo("END_PHASE") != 0) {
                                    SeisPhase seisPhase = new SeisPhase(aSCIIInputStream, string2, d, d2, this.isGlobal, seismicityFrame.geogCoords, this.eventGeogCoords);
                                    this.phaseList.addElement(seisPhase);
                                }
                            } else if (bl4 && string2.compareTo("SCATTER") == 0) {
                                int n4 = 0;
                                try {
                                    string3 = aSCIIInputStream.readWord();
                                    n2 = aSCIIInputStream.readInt();
                                    this.samples = new Sample4D[n2];
                                    while (!aSCIIInputStream.eof() && n4 < this.samples.length) {
                                        aSCIIInputStream.flushLine();
                                        d26 = 0.0;
                                        d21 = 0.0;
                                        double d53 = 0.0;
                                        double d54 = 0.0;
                                        d26 = Double.parseDouble(aSCIIInputStream.readWord());
                                        d21 = Double.parseDouble(aSCIIInputStream.readWord());
                                        d53 = Double.parseDouble(aSCIIInputStream.readWord());
                                        d54 = Double.parseDouble(aSCIIInputStream.readWord());
                                        Vect3D vect3D = this.eventGeogCoords.isGlobal() ? seismicityFrame.geogCoords.geog2xyz(new Vect3D(d21, d26, d53)) : new Vect3D(d26, d21, -d53);
                                        this.samples[n4++] = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d54, this.sampleType);
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    while (n4 < this.samples.length) {
                                        this.samples[n4++] = new Sample4D(0.0, 0.0, 0.0, 0.0, this.sampleType);
                                    }
                                    break;
                                }
                            }
                        }
                        aSCIIInputStream.flushLine();
                        if (!this.DEBUG) continue;
                        System.out.println("Reading eof(): " + aSCIIInputStream.eof());
                    }
                }
                catch (IOException iOException) {
                    if (this.DEBUG) {
                        System.out.println("Reading Exception: " + iOException);
                    }
                    if (!SeismicityFrame.PRINT_STACK_TRACES) break block148;
                    iOException.printStackTrace();
                }
            }
            if (this.hypocenter == null && d25 > -3.4028234663852886E38 && d24 > -3.4028234663852886E38 && d23 > -3.4028234663852886E38) {
                Vect3D vect3D = seismicityFrame.geogCoords.geog2xyz(d25, d24, d23);
                double d55 = 0.0;
                if (d22 > -3.4028234663852886E38) {
                    d55 = d22;
                }
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d55, 1);
                String string4 = seismicityFrame.getParameter("event.randomize");
                if (string4 != null) {
                    try {
                        d21 = Double.valueOf(string4).floatValue();
                        if (d21 > 0.0) {
                            this.hypocenter.randomShift(random, d21);
                        }
                    }
                    catch (Exception exception) {
                        if (!SeismicityFrame.PRINT_STACK_TRACES) break block149;
                        exception.printStackTrace();
                    }
                }
            }
        }
        if (this.hypoGeog == null && this.hypocenter != null) {
            this.hypoGeog = this.eventGeogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        }
        if (this.ellipsoid != null) {
            this.ellipsoid.calcEllipses();
        } else if (this.covariance != null) {
            this.covariance.calcEllipses(this.expectation);
        }
        if (bl6) {
            Vect3D vect3D = seismicityFrame.geogCoords.geog2xyz(d20, d19, d18);
            this.ellipsoid2 = new Ellipsoid3D(vect3D.x, vect3D.y, vect3D.z, d17, d16, d15, d14, d13, d12, d11);
            if (this.ellipsoid2 != null) {
                this.ellipsoid2.calcEllipses();
            }
            if (this.ellipsoid == null) {
                this.ellipsoid = this.ellipsoid2;
                this.ellipsoid2 = null;
            }
        }
        if (bl5) {
            Vect3D vect3D = seismicityFrame.geogCoords.geog2xyz(d10, d9, d8);
            double d56 = seismicityFrame.geogCoords.geogAng2xyAng(d7);
            this.focalMech = new FocalMechanism(vect3D.x, vect3D.y, vect3D.z, d56, d6, d5, d4, n, d3);
            if (this.focalMech != null) {
                this.focalMech.calcEllipses();
            }
        }
        if (this.DEBUG) {
            System.out.println(this);
        }
        if (this.isGlobal) {
            Vect3D vect3D = this.getRotationAngles();
            if (vect3D != null) {
                seismicityFrame.setInitialRotationAngles(vect3D.z, vect3D.y, vect3D.x);
            }
            seismicityFrame.setWorldCenterPoint(this.getWorldCenter());
        }
    }

    protected Vect3D getWorldCenter() {
        if (this.hypocenter != null) {
            return new Vect3D(this.hypocenter.x, this.hypocenter.y, -this.hypocenter.z);
        }
        return null;
    }

    protected Vect3D getRotationAngles() {
        if (this.hypoGeog != null && this.isGlobal) {
            return new Vect3D(-(90.0 - this.hypoGeog.x), 0.0, -(this.hypoGeog.y + 90.0));
        }
        return null;
    }

    public int getNumberOfSamples() {
        if (this.samples != null) {
            return this.samples.length;
        }
        return 0;
    }

    public int readSamplesBinary(InputStream inputStream, int n) {
        this.samples = Sample4DSet.readSamplesBinary(this.seisApp.geogCoords, this.eventGeogCoords, inputStream, this.isGlobal, n);
        return this.samples.length;
    }

    public int readSamplesBinary(InputStream inputStream, int n, int n2) {
        this.samples = Sample4DSet.readSamplesBinary(this.seisApp.geogCoords, this.eventGeogCoords, inputStream, this.isGlobal, n, n2);
        return this.samples.length;
    }

    @Override
    public void transform(int n) {
        this.transform(n, true, true, true);
    }

    public void transform(int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.getTransformed(n)) {
            return;
        }
        if (bl) {
            this.hypocenter.transform(n);
        }
        if (bl2 && this.expectation != null) {
            this.expectation.transform(n);
        }
        if (!bl3 || this.samples.length <= 0) {
            return;
        }
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i].transform(n);
        }
        this.setLastTransformationIndex(n);
    }

    public String dateString() {
        if (this.dateStr == null) {
            this.dateStr = new String(SeisEvent.intString(this.iyear, 4) + " " + SeisEvent.intString(this.imonth, 2) + " " + SeisEvent.intString(this.iday, 2) + "  " + SeisEvent.intString(this.ihour, 2) + ":" + SeisEvent.intString(this.imin, 2) + ":" + SeisEvent.intString((int)this.sec, 2) + "." + SeisEvent.intString((int)(10000.0 * (this.sec - (double)((int)this.sec))), 4));
        }
        return this.dateStr;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dateString());
        String string = NumberFormat.doubleString(this.hypoGeog.x, -1, 4, true);
        if (bl) {
            string = NumberFormat.prependBlanks(string, 8);
        }
        String string2 = NumberFormat.doubleString(this.hypoGeog.y, -1, 4, true);
        if (bl) {
            string2 = NumberFormat.prependBlanks(string2, 9);
        }
        String string3 = NumberFormat.doubleString(this.hypoGeog.z, -1, 4, true);
        if (bl) {
            string3 = NumberFormat.prependBlanks(string3, 8);
        }
        stringBuilder.append("  ").append(string).append(" ").append(string2).append("  h ").append(string3);
        String string4 = NumberFormat.doubleString(this.hypocenter.value, -1, 2, true);
        if (bl) {
            string4 = NumberFormat.prependBlanks(string4, 5);
        }
        stringBuilder.append("  M ").append(string4);
        String string5 = NumberFormat.doubleString(this.quality_RMS, -1, 4, true);
        if (bl) {
            string5 = NumberFormat.prependBlanks(string5, 8);
        }
        String string6 = "" + this.quality_Nphs;
        if (bl) {
            string6 = NumberFormat.prependBlanks(string6, 5);
        }
        String string7 = "" + this.quality_Gap;
        if (bl) {
            string7 = NumberFormat.prependBlanks(string7, 3);
        }
        String string8 = NumberFormat.doubleString(this.quality_Dist, -1, 4, true);
        if (bl) {
            string8 = NumberFormat.prependBlanks(string8, 9);
        }
        String string9 = NumberFormat.doubleString(this.quality_errH, -1, 2, true);
        if (bl) {
            string9 = NumberFormat.prependBlanks(string9, 7);
        }
        String string10 = NumberFormat.doubleString(this.quality_errZ, -1, 2, true);
        if (bl) {
            string10 = NumberFormat.prependBlanks(string10, 7);
        }
        stringBuilder.append("  RMS ").append(string5);
        stringBuilder.append("  Nphs ").append(string6);
        stringBuilder.append("  Gap ").append(string7);
        stringBuilder.append("  Dist ").append(string8);
        stringBuilder.append("  errH ").append(string9);
        stringBuilder.append("  errZ ").append(string10);
        stringBuilder.append("  id ").append(this.publicId);
        return stringBuilder.toString();
    }

    public String toInfoString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Event: \t");
        stringBuffer.append(this.dateString());
        stringBuffer.append("  " + NumberFormat.doubleString(this.hypoGeog.x, -1, 4, false) + " " + NumberFormat.doubleString(this.hypoGeog.y, -1, 4, false) + " h=" + NumberFormat.doubleString(this.hypoGeog.z, -1, 4, false));
        stringBuffer.append("  M=" + NumberFormat.doubleString(this.hypocenter.value, -1, 2, false));
        stringBuffer.append(string);
        stringBuffer.append("Source: \t").append(this.filename).append(string);
        stringBuffer.append("Signature:\t").append(this.signature).append(string);
        stringBuffer.append("Comment:\t").append(this.comment).append(string);
        stringBuffer.append("Quality: \t");
        stringBuffer.append("Pmax " + this.quality_Pmax);
        stringBuffer.append("  MFmin " + this.quality_MFmin);
        stringBuffer.append("  MFmax " + this.quality_MFmax);
        stringBuffer.append("  RMS " + this.quality_RMS);
        stringBuffer.append("  Nphs " + this.quality_Nphs);
        stringBuffer.append("  Gap " + this.quality_Gap);
        stringBuffer.append("  Dist " + this.quality_Dist);
        stringBuffer.append("  errH " + this.quality_errH);
        stringBuffer.append("  errZ " + this.quality_errZ);
        stringBuffer.append("  Mamp " + this.quality_Mamp);
        stringBuffer.append(" (" + this.quality_nRdgsMamp + ")");
        stringBuffer.append("  Mdur " + this.quality_Mdur);
        stringBuffer.append(" (" + this.quality_nRdgsMdur + ")");
        stringBuffer.append(string);
        stringBuffer.append("Expectation: \t");
        if (this.expectation != null) {
            Vect3D vect3D = this.seisApp.geogCoords.xyz2geog(this.expectation.x, this.expectation.y, this.expectation.z);
            stringBuffer.append("" + NumberFormat.doubleString(vect3D.x, -1, 4, false) + " " + NumberFormat.doubleString(vect3D.y, -1, 4, false) + " h=" + NumberFormat.doubleString(vect3D.z, -1, 4, false));
        }
        stringBuffer.append(string);
        stringBuffer.append("Ellipsoid: \t");
        if (this.ellipsoid != null) {
            stringBuffer.append(this.ellipsoid.toStringAxes());
        }
        stringBuffer.append(string);
        stringBuffer.append("HorizEllipse: \t");
        if (this.ellipse != null) {
            stringBuffer.append(this.ellipse.toStringAxes());
        }
        stringBuffer.append(string);
        stringBuffer.append("Trans: \t").append(this.seisApp.geogCoords.toString()).append(string);
        return stringBuffer.toString();
    }

    public String toStringSimpleLonLatTimeDepthMagnitude() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SeisEvent.intString(this.iyear, 4) + "-" + SeisEvent.intString(this.imonth, 2) + "-" + SeisEvent.intString(this.iday, 2) + "T" + SeisEvent.intString(this.ihour, 2) + ":" + SeisEvent.intString(this.imin, 2) + ":" + SeisEvent.intString((int)this.sec, 2) + "." + SeisEvent.intString((int)(10000.0 * (this.sec - (double)((int)this.sec))), 4) + " ");
        stringBuffer.append(NumberFormat.doubleString(this.hypoGeog.y, -1, 4, false) + " " + NumberFormat.doubleString(this.hypoGeog.x, -1, 4, false) + " " + NumberFormat.doubleString(this.hypoGeog.z, -1, 4, false) + " ");
        if (this.quality_Mamp > -9.0) {
            stringBuffer.append((float)this.quality_Mamp);
        } else {
            stringBuffer.append((float)this.quality_Mdur);
        }
        return stringBuffer.toString();
    }

    public String toStringXYZ() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HYPOCENTER ");
        stringBuffer.append(" x " + this.hypocenter.x);
        stringBuffer.append(" y " + this.hypocenter.y);
        stringBuffer.append(" z " + -this.hypocenter.z);
        stringBuffer.append(" OT " + this.sec);
        return stringBuffer.toString();
    }

    public String toStringCsv() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SeisEvent.intString(this.iyear, 4) + ", " + SeisEvent.intString(this.imonth, 2) + ", " + SeisEvent.intString(this.iday, 2) + ", " + SeisEvent.intString(this.ihour, 2) + ", " + SeisEvent.intString(this.imin, 2) + ", " + SeisEvent.intString((int)this.sec, 2) + "." + SeisEvent.intString((int)(10000.0 * (this.sec - (double)((int)this.sec))), 4) + ", ");
        stringBuffer.append(NumberFormat.doubleString(this.hypoGeog.x, -1, 4, false) + ", " + NumberFormat.doubleString(this.hypoGeog.y, -1, 4, false) + ", " + NumberFormat.doubleString(this.hypoGeog.z, -1, 4, false) + ", ");
        stringBuffer.append((float)this.quality_Pmax + ", ");
        stringBuffer.append((float)this.quality_MFmin + ", ");
        stringBuffer.append((float)this.quality_MFmax + ", ");
        stringBuffer.append((float)this.quality_RMS + ", ");
        stringBuffer.append(this.quality_Nphs + ", ");
        stringBuffer.append((float)this.quality_Gap + ", ");
        double d = this.eventGeogCoords.isGlobal() ? this.quality_Dist * GeogConstants.DEG2KM : this.quality_Dist;
        stringBuffer.append((float)this.quality_Dist + ", ");
        stringBuffer.append((float)this.quality_errH + ", ");
        stringBuffer.append((float)this.quality_errZ + ", ");
        stringBuffer.append((float)this.quality_Mamp + ", ");
        stringBuffer.append(this.quality_nRdgsMamp + ", ");
        stringBuffer.append((float)this.quality_Mdur + ", ");
        stringBuffer.append(this.quality_nRdgsMdur + ", ");
        if (this.expectation != null) {
            Vect3D vect3D = this.seisApp.geogCoords.xyz2geog(this.expectation.x, this.expectation.y, this.expectation.z);
            stringBuffer.append(NumberFormat.doubleString(vect3D.x, -1, 4, false) + ", " + NumberFormat.doubleString(vect3D.y, -1, 4, false) + ", " + NumberFormat.doubleString(vect3D.z, -1, 4, false) + ", ");
        }
        if (this.ellipsoid != null) {
            stringBuffer.append(this.ellipsoid.toStringAxesCsv() + ", ");
        }
        if (this.ellipse != null) {
            stringBuffer.append(this.ellipse.toStringAxesCsv() + ", ");
        }
        stringBuffer.append(this.filename + ", ");
        stringBuffer.append(this.signature.replace(',', '_') + ", ");
        stringBuffer.append(this.obs_file.replace(',', '_') + ", ");
        stringBuffer.append(this.comment.replace(',', '_'));
        stringBuffer.append(", " + this.publicId.replace(',', '_'));
        return stringBuffer.toString();
    }

    public static String toStringCsvHeader() {
        return "year, month, day, hour, min, sec, latitude, longitude, depth, Pmax, MFmin, MFmax, RMS, Nphs, Gap, Dist, errH, errZ, Mamp, nRdgsMamp, Mdur, nRdgsMdur, expect_lat, expect_lon, expect_z, " + Ellipsoid3D.toStringAxesCsvHeader() + ", " + Ellipse3D.toStringAxesCsvHeader() + ", " + "filename, signature, obs_file, comment, publicId";
    }

    public int readCsvCompact(ASCIIInputStream aSCIIInputStream, double d, double d2, double d3, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("CSV_COMPACT: " + string2);
            }
            if (string2.contains("date-time") || string2.contains("latitude") || string2.contains("longitude") || string2.contains("depth")) {
                csvCompact_header_line = string2;
                continue;
            }
            if (string2.trim().startsWith("#")) continue;
            try {
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 5) continue;
                int n = 0;
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.replace("Z", "").substring(17));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d9 = Float.valueOf(stringArray[n++]).floatValue();
                double d10 = Float.valueOf(stringArray[n++]).floatValue();
                double d11 = 0.0;
                try {
                    d11 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d9 + ", lon: " + d10 + ", depth: " + d11);
                }
                this.quality_RMS = Float.valueOf(stringArray[n++]).floatValue();
                this.quality_Nphs = Integer.valueOf(stringArray[n++].trim());
                this.quality_Gap = (int)(0.5f + Float.valueOf(stringArray[n++]).floatValue());
                this.quality_Dist = Float.valueOf(stringArray[n++]).floatValue();
                this.quality_errH = Float.valueOf(stringArray[n++]).floatValue();
                this.quality_errZ = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   quality_RMS: " + this.quality_RMS + ", quality_Nphs: " + this.quality_Nphs + ", quality_Gap: " + d11);
                    System.out.println("   quality_Dist: " + this.quality_Dist + ", quality_errH: " + this.quality_errH + ", quality_errZ: " + this.quality_errZ);
                }
                this.quality_Mamp = Float.valueOf(stringArray[n++]).floatValue();
                this.quality_Mdur = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   quality_Mamp: " + this.quality_Mamp + ", quality_Mdur: " + this.quality_Mdur);
                }
                if ((d8 = this.quality_Mamp) < -9.0) {
                    d8 = this.quality_Mdur;
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d9, d10, d11);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                if (this.DEBUG) {
                    System.out.println("   hypoGeog: " + this.hypoGeog);
                }
                try {
                    d9 = Float.valueOf(stringArray[n++]).floatValue();
                    d10 = Float.valueOf(stringArray[n++]).floatValue();
                    d11 = Float.valueOf(stringArray[n++]).floatValue();
                    vect3D = this.seisApp.geogCoords.geog2xyz(d9, d10, d11);
                    this.expectation = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
                    if (this.DEBUG) {
                        System.out.println("   expectation: " + this.expectation);
                    }
                    this.expectationGeog = this.seisApp.geogCoords.xyz2geog(this.expectation.x, this.expectation.y, this.expectation.z);
                    double d12 = Float.valueOf(stringArray[n++]).floatValue();
                    d7 = Float.valueOf(stringArray[n++]).floatValue();
                    d6 = Float.valueOf(stringArray[n++]).floatValue();
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                    d4 = Float.valueOf(stringArray[n++]).floatValue();
                    double d13 = Float.valueOf(stringArray[n++]).floatValue();
                    double d14 = Float.valueOf(stringArray[n++]).floatValue();
                    this.ellipsoid = new Ellipsoid3D(this.expectation.x, this.expectation.y, this.expectation.z, d12, d7, d6, d5, d4, d13, d14);
                    this.ellipsoid.calcEllipses();
                    if (this.DEBUG) {
                        System.out.println("   ellipsoid: " + this.ellipsoid);
                    }
                    d7 = 0.0;
                    d12 = -999.9;
                    d4 = 0.0;
                    d6 = Float.valueOf(stringArray[n++]).floatValue();
                    d13 = Float.valueOf(stringArray[n++]).floatValue();
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                    this.ellipse = new Ellipse3D(this.expectation.x, this.expectation.y, this.expectation.z, d12, d7, d6, d5, d4, d13);
                    if (this.DEBUG) {
                        System.out.println("   ellipse: " + this.ellipse);
                    }
                }
                catch (Exception exception) {
                    n = 25;
                }
                if (this.DEBUG) {
                    System.out.println("   current index: " + n);
                }
                try {
                    this.quality_octree_scatter_volume = Float.valueOf(stringArray[n++]).floatValue();
                    if (this.DEBUG) {
                        System.out.println("   quality_octree_scatter_volume: " + this.quality_octree_scatter_volume);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.focalMech = null;
                if (csvCompact_header_line != null && csvCompact_header_line.contains("mech_strike")) {
                    try {
                        double d15 = Float.valueOf(stringArray[n++]).floatValue();
                        d7 = d15 + 90.0;
                        if (d7 >= 360.0) {
                            d7 -= 360.0;
                        }
                        d6 = Float.valueOf(stringArray[n++]).floatValue();
                        d5 = Float.valueOf(stringArray[n++]).floatValue();
                        d4 = Float.valueOf(stringArray[n++]).floatValue();
                        int n2 = Integer.valueOf(stringArray[n++].trim());
                        double d16 = this.seisApp.geogCoords.geogAng2xyAng(d7);
                        this.focalMech = new FocalMechanism(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z, d16, d6, d5, d4, n2, d3);
                        if (this.focalMech != null) {
                            this.focalMech.calcEllipses();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    this.publicId = stringArray[n++].trim();
                    if (this.DEBUG) {
                        System.out.println("   publicId: " + this.publicId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("---------------");
                }
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.samples = new Sample4D[0];
        return 0;
    }

    public String toStringCsvCompact() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SeisEvent.intString(this.iyear, 4) + "-" + SeisEvent.intString(this.imonth, 2) + "-" + SeisEvent.intString(this.iday, 2) + "T" + SeisEvent.intString(this.ihour, 2) + ":" + SeisEvent.intString(this.imin, 2) + ":" + SeisEvent.intString((int)this.sec, 2) + "." + SeisEvent.intString((int)(1000000.0 * (this.sec - (double)((int)this.sec))), 6) + ", ");
        stringBuffer.append(NumberFormat.doubleString(this.hypoGeog.x, -1, 4, false) + ", " + NumberFormat.doubleString(this.hypoGeog.y, -1, 4, false) + ", " + NumberFormat.doubleString(this.hypoGeog.z, -1, 4, false) + ", ");
        stringBuffer.append((float)this.quality_RMS + ", ");
        stringBuffer.append(this.quality_Nphs + ", ");
        stringBuffer.append((float)this.quality_Gap + ", ");
        double d = this.quality_Dist;
        try {
            d = this.eventGeogCoords.isGlobal() ? this.quality_Dist * GeogConstants.DEG2KM : this.quality_Dist;
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append((float)d + ", ");
        stringBuffer.append((float)this.quality_errH + ", ");
        stringBuffer.append((float)this.quality_errZ + ", ");
        stringBuffer.append((float)this.quality_Mamp + ", ");
        stringBuffer.append((float)this.quality_Mdur + ", ");
        if (this.expectation != null) {
            Vect3D vect3D = this.seisApp.geogCoords.xyz2geog(this.expectation.x, this.expectation.y, this.expectation.z);
            stringBuffer.append(NumberFormat.doubleString(vect3D.x, -1, 4, false) + ", " + NumberFormat.doubleString(vect3D.y, -1, 4, false) + ", " + NumberFormat.doubleString(vect3D.z, -1, 4, false) + ", ");
        } else {
            stringBuffer.append("0, 0, 0, ");
        }
        if (this.ellipsoid != null) {
            stringBuffer.append(this.ellipsoid.toStringAxesCsv() + ", ");
        } else {
            stringBuffer.append("0, 0, 0, 0, 0, 0, 0, ");
        }
        if (this.ellipse != null) {
            stringBuffer.append(this.ellipse.toStringAxesHorizCsv() + ", ");
        } else {
            stringBuffer.append("0, 0, 0, ");
        }
        stringBuffer.append((float)this.quality_octree_scatter_volume + ", ");
        if (this.focalMech != null && this.focalMech.nObs > 0) {
            double d2 = 90.0 - this.focalMech.dipDir;
            double d3 = d2 - 90.0;
            if (d3 < 0.0) {
                d3 += 360.0;
            }
            double d4 = this.seisApp.geogCoords.xyAng2geogAng(d3);
            stringBuffer.append((float)d4 + ", ");
            stringBuffer.append((float)(-this.focalMech.dipAng) + ", ");
            stringBuffer.append((float)this.focalMech.rake + ", ");
            stringBuffer.append((float)this.focalMech.misfit + ", ");
            stringBuffer.append(this.focalMech.nObs + ", ");
        } else {
            stringBuffer.append("-999.0, -99.0, -99.0, -1.0, -1, ");
        }
        stringBuffer.append(this.publicId.replace(',', '_').trim());
        return stringBuffer.toString();
    }

    public static String toStringCsvCompactHeader() {
        return "date-time, latitude, longitude, depth, RMS, Nphs, Gap, Dist, errH, errZ, Mamp, Mdur, expect_lat, expect_lon, expect_z, " + Ellipsoid3D.toStringAxesCsvHeader() + ", " + Ellipse3D.toStringAxesHorizCsvHeader() + ", pdfVolume, mech_strike, mech_dip, mech_rake, mech_misfit, mech_Nobs, publicId";
    }

    public String getEventFileName() {
        return new String(this.eventFileName);
    }

    public Vector<SeisPhase> getPhaseList() {
        return this.phaseList;
    }

    public JLabel[][] getPhaseData(Font font, double d, double d2) {
        JLabel[][] jLabelArray = new JLabel[this.phaseList.size()][];
        for (int i = 0; i < this.phaseList.size(); ++i) {
            jLabelArray[i] = this.phaseList.elementAt(i).getPhaseData(font, d, d2);
        }
        return jLabelArray;
    }

    public JLabel[] getPhaseHeadings(double d, double d2) {
        return SeisPhase.getPhaseHeadings(d, d2);
    }

    protected static String intString(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    protected double valueForColorMapType(SeismicityColorMap.Type type) {
        return this.valueForColorMapType(type, null);
    }

    protected double valueForColorMapType(SeismicityColorMap.Type type, Sample4D sample4D) {
        switch (type) {
            case DEPTH: {
                if (sample4D != null) {
                    return -sample4D.z;
                }
                return this.hypoGeog.z;
            }
            case OTIME: {
                return this.oTimeMillisec;
            }
            case MONTH: {
                return this.imonth;
            }
            case RMS: {
                return this.quality_RMS;
            }
            case ERRH: {
                return this.quality_errH;
            }
            case ERRZ: {
                return this.quality_errZ;
            }
            case NPHS: {
                return this.quality_Nphs;
            }
            case GAP: {
                return this.quality_Gap;
            }
            case DIST: {
                return this.seisApp.isGlobal ? this.quality_Dist * GeogConstants.DEG2KM : this.quality_Dist;
            }
            case MAG_AMP: {
                return this.hypocenter.value;
            }
            case MAG_DUR: {
                return this.quality_Mdur;
            }
            case EVT_NUM: {
                return this.seisApp.seisEventList.indexOf(this);
            }
        }
        return Double.NaN;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, double d, Vect3D vect3D, double d2, int n, boolean bl20, boolean bl21, double d3, double d4, double d5, double d6) {
        Color color;
        if (bl4 && this.samples != null && this.samples.length > 0) {
            color = sampleCol;
            if (samples_applycolormap && colorMap != null) {
                if (!SeisEvent.colorMap.initialized) {
                    this.seisApp.autoSetColormap(colorMap);
                }
                color = colorMap.colorAt(this.valueForColorMapType(SeisEvent.colorMap.type));
            }
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i].paint(graphics, color);
            }
        }
        if (this.hypocenter == null) {
            return;
        }
        if (this.focalMech != null) {
            this.focalMech.paint(graphics, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, d, vect3D, d2, n, bl20);
        }
        if (bl) {
            color = maxLikeCol;
            if (colorMap != null) {
                if (!SeisEvent.colorMap.initialized) {
                    this.seisApp.autoSetColormap(colorMap);
                }
                color = colorMap.colorAt(this.valueForColorMapType(SeisEvent.colorMap.type));
            }
            this.hypocenter.paint(graphics, color, d5, bl21, d3, d4, d6);
            ++Number_quality_RMS;
            Sum_quality_RMS += this.quality_RMS;
            Sum_quality_RMS_2 += this.quality_RMS * this.quality_RMS;
            if (this.ellipsoid != null) {
                ++Number_ellipsoid_se3;
                Sum_ellipsoid_se3 += this.ellipsoid.se3;
                Sum_ellipsoid_se3_2 += this.ellipsoid.se3 * this.ellipsoid.se3;
            }
        }
        if (bl2 && this.expectation != null) {
            color = expectCol;
            if (colorMap != null) {
                if (!SeisEvent.colorMap.initialized) {
                    this.seisApp.autoSetColormap(colorMap);
                }
                color = colorMap.colorAt(this.valueForColorMapType(SeisEvent.colorMap.type, this.expectation));
            }
            this.expectation.paint(graphics, color, d5, bl21, d3, d4, d6);
        }
        if (bl3) {
            color = ellipsoidCol;
            if (ellipsoid_applycolormap && colorMap != null) {
                if (!SeisEvent.colorMap.initialized) {
                    this.seisApp.autoSetColormap(colorMap);
                }
                color = colorMap.colorAt(this.valueForColorMapType(SeisEvent.colorMap.type));
            }
            if (this.ellipsoid != null) {
                this.ellipsoid.paint(graphics, color);
            } else if (this.covariance != null) {
                this.covariance.paint(graphics, covCol);
            }
        }
        if (this.ellipsoid2 != null) {
            this.ellipsoid2.paint(graphics, ellipsoid2Col);
        }
        for (int i = 0; i < this.phaseList.size(); ++i) {
            this.phaseList.elementAt(i).paint(graphics, bl5, bl6, bl7, bl8, bl9, bl10, bl11, new Vect3D(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z), this.seisApp);
        }
    }

    public void getBoundingBox() {
        double d;
        double d2;
        double d3;
        if (this.samples.length <= 0) {
            return;
        }
        Sample4D[] sample4DArray = this.samples;
        double d4 = d3 = sample4DArray[0].x;
        double d5 = d2 = sample4DArray[0].y;
        double d6 = d = sample4DArray[0].z;
        for (int i = 0; i < this.samples.length; ++i) {
            double d7;
            double d8;
            double d9 = sample4DArray[i].x;
            if (d9 < d3) {
                d3 = d9;
            }
            if (d9 > d4) {
                d4 = d9;
            }
            if ((d8 = sample4DArray[i].y) < d2) {
                d2 = d8;
            }
            if (d8 > d5) {
                d5 = d8;
            }
            if ((d7 = sample4DArray[i].z) < d) {
                d = d7;
            }
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        this.xmax = d4;
        this.xmin = d3;
        this.ymax = d5;
        this.ymin = d2;
        this.zmax = d6;
        this.zmin = d;
    }

    public int writeBinary(DataOutputStream dataOutputStream) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        dataOutputStream.writeUTF(this.filename);
        dataOutputStream.writeUTF(this.signature);
        dataOutputStream.writeUTF(this.comment);
        this.hypocenter.writeBinary(dataOutputStream, bl, bl2);
        dataOutputStream.writeInt(this.iyear);
        dataOutputStream.writeInt(this.imonth);
        dataOutputStream.writeInt(this.iday);
        dataOutputStream.writeInt(this.ihour);
        dataOutputStream.writeInt(this.imin);
        dataOutputStream.writeFloat((float)this.sec);
        if (this.expectation != null) {
            dataOutputStream.writeBoolean(true);
            this.expectation.writeBinary(dataOutputStream, bl, bl2);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.covariance != null) {
            dataOutputStream.writeBoolean(true);
            this.covariance.writeBinary(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.ellipse != null) {
            dataOutputStream.writeBoolean(true);
            this.ellipse.writeBinary(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.ellipsoid != null) {
            dataOutputStream.writeBoolean(true);
            this.ellipsoid.writeBinary(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.ellipsoid2 != null) {
            dataOutputStream.writeBoolean(true);
            this.ellipsoid2.writeBinary(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this.focalMech != null) {
            dataOutputStream.writeBoolean(true);
            this.focalMech.writeBinary(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        dataOutputStream.writeInt(this.samples.length);
        for (n = 0; n < this.samples.length; ++n) {
            this.samples[n].writeBinary(dataOutputStream, bl, bl2);
        }
        dataOutputStream.writeInt(this.phaseList.size());
        for (int i = 0; i < this.phaseList.size(); ++i) {
            this.phaseList.elementAt(i).writeBinary(dataOutputStream);
        }
        return n;
    }

    public int readBinary(DataInputStream dataInputStream, double d, double d2) throws IOException, Exception {
        int n;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6 = false;
        boolean bl7 = false;
        this.filename = dataInputStream.readUTF();
        this.signature = dataInputStream.readUTF();
        this.comment = dataInputStream.readUTF();
        this.hypocenter = new Sample4D();
        this.hypocenter.readBinary(dataInputStream, bl6, bl7);
        this.hypocenter.type = 1;
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.iyear = dataInputStream.readInt();
        this.imonth = dataInputStream.readInt();
        this.iday = dataInputStream.readInt();
        this.ihour = dataInputStream.readInt();
        this.imin = dataInputStream.readInt();
        this.sec = dataInputStream.readFloat();
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        boolean bl8 = dataInputStream.readBoolean();
        if (bl8) {
            this.expectation = new Sample4D();
            this.expectation.readBinary(dataInputStream, bl6, bl7);
            this.expectation.type = this.expectType;
        }
        if (bl5 = dataInputStream.readBoolean()) {
            this.covariance = new CovMatrix(dataInputStream);
            this.covariance.calcEllipses(this.expectation);
        }
        if (bl4 = dataInputStream.readBoolean()) {
            this.ellipsoid = new Ellipsoid3D(dataInputStream);
            this.ellipsoid.calcEllipses();
        }
        if (bl3 = dataInputStream.readBoolean()) {
            this.ellipse = new Ellipse3D(dataInputStream);
        }
        if (bl2 = dataInputStream.readBoolean()) {
            this.ellipsoid2 = new Ellipsoid3D(dataInputStream);
            this.ellipsoid2.calcEllipses();
        }
        if (bl = dataInputStream.readBoolean()) {
            this.focalMech = new FocalMechanism(dataInputStream);
            this.focalMech.calcEllipses();
        }
        int n2 = dataInputStream.readInt();
        this.samples = new Sample4D[n2];
        for (n = 0; n < n2; ++n) {
            this.samples[n] = new Sample4D(this.sampleType);
            this.samples[n].readBinary(dataInputStream, bl6, bl7);
        }
        n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            SeisPhase seisPhase = new SeisPhase(dataInputStream, d, d2);
            this.phaseList.addElement(seisPhase);
        }
        return this.samples.length;
    }

    public int readHypo(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        this.iyear = aSCIIInputStream.readInt();
        this.iyear += 1900;
        this.imonth = aSCIIInputStream.readInt();
        this.iday = aSCIIInputStream.readInt();
        this.ihour = aSCIIInputStream.readInt();
        this.imin = aSCIIInputStream.readInt();
        this.sec = (float)aSCIIInputStream.readInt() / 100.0f;
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = aSCIIInputStream.readInt();
        String string2 = aSCIIInputStream.readWord();
        double d4 = aSCIIInputStream.readInt();
        d3 = string2.compareTo("N") == 0 ? d3 : -(d3 += d4 / 6000.0);
        double d5 = aSCIIInputStream.readInt();
        String string3 = aSCIIInputStream.readWord();
        double d6 = aSCIIInputStream.readInt();
        d5 = string3.compareTo("E") == 0 ? d5 : -(d5 += d6 / 6000.0);
        double d7 = (float)aSCIIInputStream.readInt() / 100.0f;
        double d8 = (float)aSCIIInputStream.readInt() / 10.0f;
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d5, d7);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readAlbertoTomo(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        String string2;
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("ALBERTO_TOMO: " + string2);
            }
            if (string2.contains("yearmo")) {
                string2 = aSCIIInputStream.readLine();
            }
            if (aSCIIInputStream.hadEof() || aSCIIInputStream.eof()) {
                return -1;
            }
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                int n = 0;
                int n2 = Integer.parseInt(stringArray[n++]);
                this.iyear = n2 / 100;
                this.iyear = this.iyear < 50 ? (this.iyear += 2000) : (this.iyear += 1900);
                this.imonth = n2 % 100;
                this.iday = Integer.parseInt(stringArray[n++]);
                this.ihour = Integer.parseInt(stringArray[n++]);
                this.imin = Integer.parseInt(stringArray[n++]);
                this.sec = Double.parseDouble(stringArray[n++]);
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Double.parseDouble(stringArray[n++]);
                String string3 = stringArray[n++];
                double d4 = Double.parseDouble(stringArray[n++]);
                d3 = string3.compareTo("N") == 0 ? d3 : -(d3 += d4 / 60.0);
                double d5 = Double.parseDouble(stringArray[n++]);
                String string4 = stringArray[n++];
                double d6 = Double.parseDouble(stringArray[n++]);
                d5 = string4.compareTo("E") == 0 ? d5 : -(d5 += d6 / 60.0);
                double d7 = Double.parseDouble(stringArray[n++]);
                double d8 = Double.parseDouble(stringArray[n++]);
                this.quality_Nphs = Integer.parseInt(stringArray[n++]);
                this.quality_RMS = Double.parseDouble(stringArray[n++]);
                this.publicId = stringArray[n++];
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d5, d7);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                this.expectation = null;
                this.covariance = null;
                this.ellipsoid = null;
                this.ellipsoid2 = null;
                this.focalMech = null;
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        return 0;
    }

    public int readSeisan(ASCIIInputStream aSCIIInputStream, double d, double d2, String string, double d3, double d4) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        long l = aSCIIInputStream.readLong();
        this.iyear = 1900 + (int)(l / 10000L);
        if (this.iyear < 1930) {
            this.iyear += 100;
        }
        this.imonth = (int)((l %= 10000L) / 100L);
        this.iday = (int)l % 100;
        long l2 = aSCIIInputStream.readInt();
        this.ihour = (int)l2 / 100;
        this.imin = (int)l2 % 100;
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d5 = aSCIIInputStream.readInt();
        double d6 = Double.parseDouble(aSCIIInputStream.readWord());
        d5 += d6 / 60.0;
        d5 *= d3;
        double d7 = aSCIIInputStream.readInt();
        double d8 = Double.parseDouble(aSCIIInputStream.readWord());
        d7 += d8 / 60.0;
        double d9 = Double.parseDouble(aSCIIInputStream.readWord());
        double d10 = Double.parseDouble(aSCIIInputStream.readWord());
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d5, d7 *= d4, d9);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d10, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readFriuliVeneziaGiuliaNetwork(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        String string2;
        this.filename = string;
        this.comment = " ";
        while ((string2 = aSCIIInputStream.readWord()).startsWith("#")) {
            aSCIIInputStream.flushLine();
        }
        string2 = aSCIIInputStream.readWord();
        String string3 = aSCIIInputStream.readWord();
        String[] stringArray = StringExt.parse(string3, "-");
        this.iyear = Integer.parseInt(stringArray[0]);
        this.imonth = Integer.parseInt(stringArray[1]);
        this.iday = Integer.parseInt(stringArray[2]);
        String string4 = aSCIIInputStream.readWord();
        stringArray = StringExt.parse(string4, ":");
        this.ihour = Integer.parseInt(stringArray[0]);
        this.imin = Integer.parseInt(stringArray[1]);
        this.sec = Float.valueOf(stringArray[2]).floatValue();
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        Double.parseDouble(aSCIIInputStream.readWord());
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = Double.parseDouble(aSCIIInputStream.readWord());
        double d7 = Double.parseDouble(aSCIIInputStream.readWord());
        int n = aSCIIInputStream.readInt();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        double d8 = Double.parseDouble(aSCIIInputStream.readWord());
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d6);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        double d9 = d5 * d5 / 4.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = d5 * d5 / 4.0;
        double d13 = 0.0;
        double d14 = d7 * d7 / 4.0;
        this.covariance = new CovMatrix(d9, d10, -d11, d12, -d13, d14);
        this.covariance.calcEllipses(this.hypocenter);
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readSpyder(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        long l = aSCIIInputStream.readLong();
        this.iyear = 1900 + (int)(l / 100000000L);
        if (this.iyear < 1930) {
            this.iyear += 100;
        }
        this.imonth = (int)((l %= 100000000L) / 1000000L);
        this.iday = (int)(l %= 1000000L) / 10000;
        this.ihour = (int)(l %= 10000L) / 100;
        this.imin = (int)(l %= 100L) / 1;
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        String string2 = aSCIIInputStream.readWord();
        d3 = string2.compareTo("N") == 0 ? d3 : -d3;
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        String string3 = aSCIIInputStream.readWord();
        d4 = string3.compareTo("E") == 0 ? d4 : -d4;
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = Double.parseDouble(aSCIIInputStream.readWord());
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readString(ASCIIInputStream aSCIIInputStream, double d, double d2) throws IOException, Exception {
        this.filename = "STRING";
        this.comment = " ";
        this.iyear = aSCIIInputStream.readInt();
        this.imonth = aSCIIInputStream.readInt();
        this.iday = aSCIIInputStream.readInt();
        this.ihour = aSCIIInputStream.readInt();
        this.imin = aSCIIInputStream.readInt();
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = -9.9f;
        try {
            d6 = Double.parseDouble(aSCIIInputStream.readWord());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readGSE(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        String string2 = aSCIIInputStream.readWord();
        String[] stringArray = StringExt.parse(string2, "/");
        this.iyear = Integer.parseInt(stringArray[0]);
        this.imonth = Integer.parseInt(stringArray[1]);
        this.iday = Integer.parseInt(stringArray[2]);
        String string3 = aSCIIInputStream.readWord();
        stringArray = StringExt.parse(string3, ":");
        this.ihour = Integer.parseInt(stringArray[0]);
        this.imin = Integer.parseInt(stringArray[1]);
        this.sec = Float.parseFloat(stringArray[2]);
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        this.quality_Nphs = Integer.parseInt(aSCIIInputStream.readWord());
        int n = Integer.parseInt(aSCIIInputStream.readWord());
        this.quality_Gap = Integer.parseInt(aSCIIInputStream.readWord());
        aSCIIInputStream.readWord();
        double d6 = -9.9f;
        try {
            d6 = Double.parseDouble(aSCIIInputStream.readWord());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readEqMonCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        try {
            aSCIIInputStream.readInt();
        }
        catch (Exception exception) {
            aSCIIInputStream.flushLine();
            aSCIIInputStream.readWord();
        }
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        this.quality_Nphs = aSCIIInputStream.readInt();
        aSCIIInputStream.readWord();
        this.quality_Gap = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        String string2 = aSCIIInputStream.readWord();
        String[] stringArray = StringExt.parse(string2, "-");
        String[] stringArray2 = StringExt.parse(stringArray[0], ".");
        this.iyear = Integer.parseInt(stringArray2[0]);
        this.imonth = Integer.parseInt(stringArray2[1]);
        this.iday = Integer.parseInt(stringArray2[2]);
        String[] stringArray3 = StringExt.parse(stringArray[1], ":");
        this.ihour = Integer.parseInt(stringArray3[0]);
        this.imin = Integer.parseInt(stringArray3[1]);
        this.sec = Float.parseFloat(stringArray3[2]);
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        this.quality_errH = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        this.quality_errZ = Double.parseDouble(aSCIIInputStream.readWord());
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        double d6 = -9.9f;
        try {
            d6 = Double.parseDouble(aSCIIInputStream.readWord());
        }
        catch (Exception exception) {
            // empty catch block
        }
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        aSCIIInputStream.readWord();
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readEpi(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        this.iyear = aSCIIInputStream.readInt();
        this.imonth = Date2.str2intMonth(aSCIIInputStream.readWord());
        this.iday = aSCIIInputStream.readInt();
        this.ihour = aSCIIInputStream.readInt();
        this.imin = aSCIIInputStream.readInt();
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = -9.9f;
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readNllGeog(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        String string2 = aSCIIInputStream.readWord();
        string2 = aSCIIInputStream.readWord();
        this.iyear = aSCIIInputStream.readInt();
        this.imonth = aSCIIInputStream.readInt();
        this.iday = aSCIIInputStream.readInt();
        this.ihour = aSCIIInputStream.readInt();
        this.imin = aSCIIInputStream.readInt();
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        string2 = aSCIIInputStream.readWord();
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        string2 = aSCIIInputStream.readWord();
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        string2 = aSCIIInputStream.readWord();
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = -9.9f;
        this.hypoGeog = new Vect3D(d3, d4, d5);
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readGeoNetCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        String string2;
        this.filename = string;
        boolean bl = false;
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("GEONET_DB: " + string2);
            }
            if (string2.contains("publicid")) {
                string2 = aSCIIInputStream.readLine();
            }
            if (aSCIIInputStream.hadEof() || aSCIIInputStream.eof()) {
                return -1;
            }
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                int n = 0;
                this.comment = "" + stringArray[n++];
                int n2 = ++n;
                ++n;
                String string3 = stringArray[n2];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.substring(17, 23));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                int n3 = ++n;
                double d3 = Float.valueOf(stringArray[n3]).floatValue();
                int n4 = ++n;
                double d4 = Float.valueOf(stringArray[n4]).floatValue();
                int n5 = ++n;
                ++n;
                double d5 = Float.valueOf(stringArray[n5]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d5);
                }
                double d6 = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   lat: " + d4 + ", lon: " + d3 + ", depth: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d4, d3, d6);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d5, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                ++n;
                ++n;
                ++n;
                ++n;
                ++n;
                int n6 = ++n;
                ++n;
                this.quality_Nphs = Integer.parseInt(stringArray[n6]);
                if (this.DEBUG) {
                    System.out.println("   quality_Nphs: " + this.quality_Nphs);
                }
                int n7 = ++n;
                ++n;
                this.quality_nRdgsMamp = Integer.parseInt(stringArray[n7]);
                if (this.DEBUG) {
                    System.out.println("   quality_nRdgsMamp: " + this.quality_nRdgsMamp);
                }
                this.quality_Dist = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   quality_Dist: " + this.quality_Dist);
                }
                this.quality_Gap = (int)Math.round(Double.parseDouble(stringArray[n++]));
                if (this.DEBUG) {
                    System.out.println("   quality_Gap: " + this.quality_Gap);
                }
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readEarlyEstCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        try {
            long l = aSCIIInputStream.readLong();
            this.publicId = "" + l;
            this.comment = "" + l;
        }
        catch (Exception exception) {
            String string2 = aSCIIInputStream.readLine();
            earlyEstCsvVersion = string2.contains(" loc_seq_num ") ? 2 : (string2.contains(" atten ") ? 1 : 0);
            if (aSCIIInputStream.hadEof() || aSCIIInputStream.eof()) {
                return -1;
            }
            long l = aSCIIInputStream.readLong();
            this.publicId = "" + l;
            this.comment = "" + l;
        }
        String string3 = aSCIIInputStream.readWord();
        if (earlyEstCsvVersion >= 2) {
            int n = aSCIIInputStream.readInt();
        }
        int n = aSCIIInputStream.readInt();
        this.quality_Nphs = aSCIIInputStream.readInt();
        this.quality_Dist = aSCIIInputStream.readDouble();
        this.quality_Gap = (int)Math.round(aSCIIInputStream.readDouble());
        double d3 = (int)Math.round(aSCIIInputStream.readDouble());
        if (earlyEstCsvVersion >= 1) {
            double d4 = aSCIIInputStream.readDouble();
        }
        this.quality_RMS = aSCIIInputStream.readDouble();
        String string4 = aSCIIInputStream.readWord();
        this.iyear = Integer.parseInt(string4.substring(0, 4));
        this.imonth = Integer.parseInt(string4.substring(5, 7));
        this.iday = Integer.parseInt(string4.substring(8, 10));
        this.ihour = Integer.parseInt(string4.substring(11, 13));
        this.imin = Integer.parseInt(string4.substring(14, 16));
        this.sec = Double.parseDouble(string4.substring(17));
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d5 = aSCIIInputStream.readDouble();
        double d6 = aSCIIInputStream.readDouble();
        this.quality_errH = aSCIIInputStream.readDouble();
        double d7 = aSCIIInputStream.readDouble();
        this.quality_errZ = aSCIIInputStream.readDouble();
        if (earlyEstCsvVersion >= 2) {
            string3 = aSCIIInputStream.readWord();
        }
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        double d8 = -9.9f;
        double d9 = aSCIIInputStream.readDouble();
        int n2 = aSCIIInputStream.readInt();
        if (n2 >= 4 && d9 > -8.0) {
            d8 = d9;
        }
        d9 = aSCIIInputStream.readDouble();
        n2 = aSCIIInputStream.readInt();
        if (n2 >= 4 && d9 > -8.0) {
            d8 = d9;
        }
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        string3 = aSCIIInputStream.readWord();
        this.comment = this.comment + " - " + aSCIIInputStream.readWord();
        this.hypoGeog = new Vect3D(d5, d6, d7);
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d5, d6, d7);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readIngvDbText(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            Object object;
            if (this.DEBUG) {
                System.out.println("INGV_DB: " + string2);
            }
            if (string2.indexOf("Error") >= 0) {
                while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
                    string2 = aSCIIInputStream.readLine();
                    System.out.println("error line: " + string2);
                }
                object = "ERROR: Reading INGV_DB: " + this.filename;
                throw new EventSearchException((String)object);
            }
            try {
                object = string2.split("\\s+");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + ((String[])object).length);
                }
                if (((String[])object).length < 13) continue;
                int n = 0;
                String string3 = object[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.substring(17));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(object[n++]).floatValue();
                double d4 = Float.valueOf(object[n++]).floatValue();
                double d5 = Float.valueOf(object[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   lat: " + d4 + ", lon: " + d3 + ", depth: " + d5);
                }
                ++n;
                ++n;
                ++n;
                ++n;
                int n2 = ++n;
                ++n;
                double d6 = Float.valueOf(object[n2]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d4, d3, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readFdsnEventText(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            Object object;
            if (this.DEBUG) {
                System.out.println("FdsnEvent: " + string2);
            }
            if (string2.indexOf("Error") >= 0) {
                while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
                    string2 = aSCIIInputStream.readLine();
                    System.out.println("error line: " + string2);
                }
                if (!aSCIIInputStream.eof()) {
                    object = "ERROR: Reading FDSN WS event: " + this.filename;
                    throw new EventSearchException((String)object);
                }
            }
            try {
                String string3;
                object = string2.split("\\|");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + ((String[])object).length);
                }
                if (((String[])object).length < 13) continue;
                int n = 0;
                int n2 = ++n;
                ++n;
                String string4 = object[n2].trim();
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string4);
                }
                this.iyear = Integer.parseInt(string4.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string4.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string4.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string4.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string4.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                if ((string3 = string4.substring(17)).endsWith("Z")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (this.DEBUG) {
                    System.out.println("   secondStr: " + string3);
                }
                this.sec = Double.parseDouble(string3);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(object[n++].trim()).floatValue();
                double d4 = Float.valueOf(object[n++].trim()).floatValue();
                double d5 = Float.valueOf(object[n++].trim()).floatValue();
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                ++n;
                ++n;
                ++n;
                ++n;
                int n3 = ++n;
                ++n;
                double d6 = Float.valueOf(object[n3].trim()).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readOVINGVEventText(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            Object object;
            if (this.DEBUG) {
                System.out.println("OVINGVEvent: " + string2);
            }
            if (string2.indexOf("Error") >= 0) {
                while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
                    string2 = aSCIIInputStream.readLine();
                    System.out.println("error line: " + string2);
                }
                if (!aSCIIInputStream.eof()) {
                    object = "ERROR: Reading OVINGV event: " + this.filename;
                    throw new EventSearchException((String)object);
                }
            }
            try {
                String string3;
                object = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + ((String[])object).length);
                }
                if (((String[])object).length < 11) continue;
                int n = 0;
                int n2 = ++n;
                ++n;
                String string4 = object[n2].trim();
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string4);
                }
                this.iyear = Integer.parseInt(string4.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string4.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string4.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string4.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string4.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                if ((string3 = string4.substring(17)).endsWith("Z")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (this.DEBUG) {
                    System.out.println("   secondStr: " + string3);
                }
                this.sec = Double.parseDouble(string3);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(object[n++].trim()).floatValue();
                double d4 = Float.valueOf(object[n++].trim()).floatValue();
                double d5 = Float.valueOf(object[n++].trim()).floatValue();
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                ++n;
                double d6 = 0.0;
                try {
                    d6 = Float.valueOf(object[n++].trim()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readNEICSearch4(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            Object object;
            if (string2.indexOf("Error") >= 0) {
                string2 = aSCIIInputStream.readLine();
                System.out.println("error line: " + string2);
                if (string2.length() < 6) {
                    string2 = aSCIIInputStream.readLine();
                }
                System.out.println("error line2: " + string2);
                object = string2;
                try {
                    object = string2.substring(string2.indexOf(">") + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf("<"));
                }
                catch (Exception exception) {
                    object = string2;
                }
                object = "ERROR: NEIC Search: " + (String)object;
                throw new EventSearchException((String)object);
            }
            try {
                object = new StringTokenizer(string2);
                if (((StringTokenizer)object).countTokens() < 9) continue;
                ((StringTokenizer)object).nextToken();
                this.iyear = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.imonth = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.iday = Integer.valueOf(((StringTokenizer)object).nextToken());
                String string3 = ((StringTokenizer)object).nextToken();
                try {
                    this.ihour = Integer.parseInt(string3.substring(0, 2));
                }
                catch (Exception exception) {
                    this.ihour = 0;
                }
                try {
                    this.imin = Integer.parseInt(string3.substring(2, 4));
                }
                catch (Exception exception) {
                    this.imin = 0;
                }
                try {
                    this.sec = Float.valueOf(string3.substring(4, 9)).floatValue();
                }
                catch (Exception exception) {
                    this.sec = 0.0;
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d4 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d5 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d6 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readNEICSearch6(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            Object object;
            if (string2.indexOf("Error") >= 0) {
                string2 = aSCIIInputStream.readLine();
                System.out.println("error line: " + string2);
                if (string2.length() < 6) {
                    string2 = aSCIIInputStream.readLine();
                }
                System.out.println("error line2: " + string2);
                object = string2;
                try {
                    object = string2.substring(string2.indexOf(">") + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf("<"));
                }
                catch (Exception exception) {
                    object = string2;
                }
                object = "ERROR: NEIC Search: " + (String)object;
                throw new EventSearchException((String)object);
            }
            try {
                object = new StringTokenizer(string2, ",");
                if (((StringTokenizer)object).countTokens() != 8) continue;
                this.iyear = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.imonth = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.iday = Integer.valueOf(((StringTokenizer)object).nextToken());
                String string3 = ((StringTokenizer)object).nextToken();
                this.ihour = Integer.parseInt(string3.substring(0, 2));
                this.imin = Integer.parseInt(string3.substring(2, 4));
                this.sec = Float.valueOf(string3.substring(4, 9)).floatValue();
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d4 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d5 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                double d6 = Float.valueOf(((StringTokenizer)object).nextToken()).floatValue();
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d6);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d5, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readNCEDCCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() != 12 || string2.contains("DateTime")) continue;
                String string3 = stringTokenizer.nextToken();
                String[] stringArray = StringExt.parse(string3, " ");
                String[] stringArray2 = StringExt.parse(stringArray[0], "/");
                this.iyear = Integer.parseInt(stringArray2[0]);
                this.imonth = Integer.parseInt(stringArray2[1]);
                this.iday = Integer.parseInt(stringArray2[2]);
                String[] stringArray3 = StringExt.parse(stringArray[1], ":");
                this.ihour = Integer.parseInt(stringArray3[0]);
                this.imin = Integer.parseInt(stringArray3[1]);
                this.sec = Float.parseFloat(stringArray3[2]);
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d4 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d5 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d6 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                String string4 = stringTokenizer.nextToken();
                this.quality_Nphs = Integer.valueOf(stringTokenizer.nextToken());
                this.quality_Gap = Integer.valueOf(stringTokenizer.nextToken());
                this.quality_Dist = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.quality_RMS = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readGEIN_NOA_EPICsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                if (stringTokenizer.countTokens() != 18) {
                    System.out.println("strTzr.countTokens() " + stringTokenizer.countTokens());
                    continue;
                }
                if (string2.contains("Date")) continue;
                String string3 = stringTokenizer.nextToken();
                String[] stringArray = StringExt.parse(string3, "/");
                this.iyear = Integer.parseInt(stringArray[0]);
                this.imonth = Integer.parseInt(stringArray[1]);
                this.iday = Integer.parseInt(stringArray[2]);
                String string4 = stringTokenizer.nextToken();
                String[] stringArray2 = StringExt.parse(string4, ":");
                this.ihour = Integer.parseInt(stringArray2[0]);
                this.imin = Integer.parseInt(stringArray2[1]);
                this.sec = Float.parseFloat(stringArray2[2]);
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                this.quality_RMS = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d4 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                double d5 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.quality_errH = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.quality_Nphs = Integer.valueOf(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.quality_Gap = Integer.valueOf(stringTokenizer.nextToken());
                this.quality_Dist = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                double d6 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                stringTokenizer.nextToken();
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readMonfret(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        String string2 = aSCIIInputStream.readLine();
        double d3 = Float.parseFloat(string2.substring(0, 7).trim());
        double d4 = Float.parseFloat(string2.substring(9, 17).trim());
        double d5 = -Float.parseFloat(string2.substring(19, 27).trim());
        this.iyear = Integer.parseInt(string2.substring(29, 31).trim());
        this.iyear += 1900;
        if (this.iyear < 1930) {
            this.iyear += 100;
        }
        this.imonth = Integer.parseInt(string2.substring(31, 33).trim());
        this.iday = Integer.parseInt(string2.substring(33, 35).trim());
        this.ihour = Integer.parseInt(string2.substring(36, 38).trim());
        this.imin = Integer.parseInt(string2.substring(38, 40).trim());
        this.sec = Float.parseFloat(string2.substring(40, 46).trim());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        int n = Integer.parseInt(string2.substring(48, 50).trim());
        double d6 = Float.parseFloat(string2.substring(51, 56).trim());
        double d7 = Float.parseFloat(string2.substring(67, 70).trim());
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d4, d3, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d7, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readCeline(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        long l = 0L;
        while (true) {
            try {
                l = aSCIIInputStream.readLong();
            }
            catch (Exception exception) {
                aSCIIInputStream.flushLine();
                if (!aSCIIInputStream.hadEof() && !aSCIIInputStream.eof()) continue;
                return -1;
            }
            break;
        }
        this.iyear = (int)(l / 10000000000L);
        this.imonth = (int)((l %= 10000000000L) / 100000000L);
        this.iday = (int)((l %= 100000000L) / 1000000L);
        this.ihour = (int)((l %= 1000000L) / 10000L);
        this.imin = (int)((l %= 10000L) / 100L);
        this.sec = (l %= 100L) / 1L;
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d4 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d5 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        d5 *= -1.0;
        double d6 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d7 = Double.parseDouble(aSCIIInputStream.readWord());
        double d8 = Double.parseDouble(aSCIIInputStream.readWord());
        double d9 = Double.parseDouble(aSCIIInputStream.readWord());
        double d10 = Double.parseDouble(aSCIIInputStream.readWord());
        double d11 = Double.parseDouble(aSCIIInputStream.readWord());
        double d12 = Double.parseDouble(aSCIIInputStream.readWord());
        double d13 = -9.9f;
        this.sec += d6;
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d10, d11, d12);
        Vect3D vect3D2 = vect3D.add(new Vect3D(d3, d4, d5));
        this.hypocenter = new Sample4D(vect3D2.x, vect3D2.y, vect3D2.z, d13, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        Vect3D vect3D3 = this.seisApp.geogCoords.geog2xyz(d7, d8, d9);
        this.expectation = new Sample4D(vect3D3.x, vect3D3.y, vect3D3.z, d13, 1);
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readGot(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        long l = 0L;
        while (true) {
            try {
                l = aSCIIInputStream.readLong();
            }
            catch (Exception exception) {
                aSCIIInputStream.flushLine();
                if (!aSCIIInputStream.hadEof() && !aSCIIInputStream.eof()) continue;
                return -1;
            }
            break;
        }
        this.iyear = (int)(l / 10000000000L);
        this.imonth = (int)((l %= 10000000000L) / 100000000L);
        this.iday = (int)((l %= 100000000L) / 1000000L);
        this.ihour = (int)((l %= 1000000L) / 10000L);
        this.imin = (int)((l %= 10000L) / 100L);
        this.sec = (l %= 100L) / 1L;
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d4 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d5 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d6 = Double.parseDouble(aSCIIInputStream.readWord()) / 1000.0;
        double d7 = -9.9f;
        this.sec += d6 / 1000.0;
        Vect3D vect3D = new Vect3D(0.0, 0.0, 0.0);
        Vect3D vect3D2 = vect3D.add(new Vect3D(d3, d4, d5));
        this.hypocenter = new Sample4D(vect3D2.x, vect3D2.y, vect3D2.z, d7, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readHypoInv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        int n;
        this.filename = string;
        this.comment = " ";
        String string2 = "";
        while (true) {
            if (aSCIIInputStream.eof()) {
                return -1;
            }
            string2 = aSCIIInputStream.readLine();
            if (SeismicityFrame.VERBOSE) {
                System.out.println("<" + string2 + ">");
            }
            try {
                this.iyear = Integer.parseInt(string2.substring(0, 4).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("iyear " + this.iyear);
                }
                if (this.iyear < 1900 || this.iyear > 2100) continue;
                this.imonth = Integer.parseInt(string2.substring(4, 6).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  imonth " + this.imonth);
                }
                if (this.imonth < 1 || this.imonth > 12) continue;
                this.iday = Integer.parseInt(string2.substring(6, 8).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  iday " + this.iday);
                }
                if (this.iday < 1 || this.iday > 31) continue;
                this.ihour = Integer.parseInt(string2.substring(8, 10).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  ihour " + this.ihour);
                }
                if (this.ihour < 0 || this.ihour > 24) continue;
                this.imin = Integer.parseInt(string2.substring(10, 12).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  imin " + this.imin);
                }
                if (this.imin < 0 || this.imin > 60) continue;
                this.sec = Float.parseFloat(string2.substring(12, 16).trim()) / 100.0f;
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  sec " + this.sec);
                }
                if (this.sec < 0.0) continue;
                if (!(this.sec > 60.0)) break;
            }
            catch (Exception exception) {}
        }
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Float.parseFloat(string2.substring(16, 18).trim());
        d3 += (double)(Float.parseFloat(string2.substring(19, 23).trim()) / 6000.0f);
        if (string2.substring(18, 19).equalsIgnoreCase("S")) {
            d3 *= -1.0;
        }
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  flat " + d3);
        }
        double d4 = Float.parseFloat(string2.substring(23, 26).trim());
        d4 += (double)(Float.parseFloat(string2.substring(27, 31).trim()) / 6000.0f);
        if (!string2.substring(26, 27).equalsIgnoreCase("E")) {
            d4 *= -1.0;
        }
        double d5 = Float.parseFloat(string2.substring(31, 36).trim()) / 100.0f;
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  depth " + d5);
        }
        try {
            n = Integer.parseInt(string2.substring(39, 42).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  no " + n);
            }
            this.quality_Nphs = n;
        }
        catch (Exception exception) {
            this.quality_Nphs = 0;
        }
        try {
            n = Integer.parseInt(string2.substring(42, 45).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  gap " + n);
            }
            this.quality_Gap = n;
        }
        catch (Exception exception) {
            this.quality_Gap = 0;
        }
        try {
            double d6 = Float.parseFloat(string2.substring(48, 52).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dist " + d6);
            }
            this.quality_Dist = d6;
        }
        catch (Exception exception) {
            this.quality_Dist = 0.0;
        }
        try {
            double d7 = Float.parseFloat(string2.substring(48, 52).trim()) / 100.0f;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  rms " + d7);
            }
            this.quality_RMS = d7;
        }
        catch (Exception exception) {
            this.quality_RMS = 0.0;
        }
        double d8 = -9.9f;
        try {
            d8 = Float.parseFloat(string2.substring(146, 149).trim()) / 100.0f;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  xmag " + d8);
            }
            this.quality_Mamp = d8;
        }
        catch (Exception exception) {
            d8 = -9.9f;
        }
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  flat " + d3 + " flong " + d4 + " x " + vect3D.x + " y " + vect3D.y + " depth " + d5);
        }
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        this.covariance = null;
        try {
            double d9 = Float.parseFloat(string2.substring(52, 55).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  az1 " + d9);
            }
            double d10 = Float.parseFloat(string2.substring(55, 57).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dip1 " + d10);
            }
            double d11 = Float.parseFloat(string2.substring(57, 61).trim());
            d11 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se1 " + d11);
            }
            double d12 = Float.parseFloat(string2.substring(61, 64).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  az2 " + d12);
            }
            double d13 = Float.parseFloat(string2.substring(64, 66).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dip2 " + d13);
            }
            double d14 = Float.parseFloat(string2.substring(66, 70).trim());
            d14 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se2 " + d14);
            }
            double d15 = Float.parseFloat(string2.substring(76, 80).trim());
            d15 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se3 " + d15);
            }
            double d16 = 0.0;
            try {
                d16 = -this.eventGeogCoords.getRotationAngle() + this.seisApp.geogCoords.getRotationAngle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d17 = d9 + d16;
            double d18 = d12 + d16;
            this.ellipsoid = new Ellipsoid3D(this.expectation.x, this.expectation.y, this.expectation.z, d17, d10, d11, d18, d13, d14, d15);
            this.ellipsoid.calcEllipses();
        }
        catch (Exception exception) {
            if (SeismicityFrame.VERBOSE) {
                System.out.println("ERROR: creating Ellipsoid3D" + exception);
            }
            this.ellipsoid = null;
        }
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        if (SeismicityFrame.VERBOSE) {
            System.out.println("");
        }
        return 0;
    }

    public int readHypoellise(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        int n;
        this.filename = string;
        this.comment = " ";
        String string2 = "";
        while (true) {
            if (aSCIIInputStream.eof()) {
                return -1;
            }
            string2 = aSCIIInputStream.readLine();
            if (SeismicityFrame.VERBOSE) {
                System.out.println("<" + string2 + ">");
            }
            try {
                this.iyear = Integer.parseInt(string2.substring(0, 4).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("iyear " + this.iyear);
                }
                if (this.iyear < 1900 || this.iyear > 2100) continue;
                this.imonth = Integer.parseInt(string2.substring(4, 6).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  imonth " + this.imonth);
                }
                if (this.imonth < 1 || this.imonth > 12) continue;
                this.iday = Integer.parseInt(string2.substring(6, 8).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  iday " + this.iday);
                }
                if (this.iday < 1 || this.iday > 31) continue;
                this.ihour = Integer.parseInt(string2.substring(8, 10).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  ihour " + this.ihour);
                }
                if (this.ihour < 0 || this.ihour > 24) continue;
                this.imin = Integer.parseInt(string2.substring(10, 12).trim());
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  imin " + this.imin);
                }
                if (this.imin < 0 || this.imin > 60) continue;
                this.sec = Float.parseFloat(string2.substring(12, 16).trim()) / 100.0f;
                if (SeismicityFrame.VERBOSE) {
                    System.out.println("  sec " + this.sec);
                }
                if (this.sec < 0.0) continue;
                if (!(this.sec > 60.0)) break;
            }
            catch (Exception exception) {}
        }
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Float.parseFloat(string2.substring(16, 18).trim());
        d3 += (double)(Float.parseFloat(string2.substring(19, 23).trim()) / 6000.0f);
        if (string2.substring(18, 19).equalsIgnoreCase("S")) {
            d3 *= -1.0;
        }
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  flat " + d3);
        }
        double d4 = Float.parseFloat(string2.substring(23, 26).trim());
        d4 += (double)(Float.parseFloat(string2.substring(27, 31).trim()) / 6000.0f);
        if (!string2.substring(26, 27).equalsIgnoreCase("E")) {
            d4 *= -1.0;
        }
        double d5 = Float.parseFloat(string2.substring(31, 36).trim()) / 100.0f;
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  depth " + d5);
        }
        try {
            n = Integer.parseInt(string2.substring(38, 41).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  no " + n);
            }
            this.quality_Nphs = n;
        }
        catch (Exception exception) {
            this.quality_Nphs = 0;
        }
        try {
            n = Integer.parseInt(string2.substring(41, 44).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  gap " + n);
            }
            this.quality_Gap = n;
        }
        catch (Exception exception) {
            this.quality_Gap = 0;
        }
        try {
            double d6 = Float.parseFloat(string2.substring(44, 47).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dist " + d6);
            }
            this.quality_Dist = d6;
        }
        catch (Exception exception) {
            this.quality_Dist = 0.0;
        }
        try {
            double d7 = Float.parseFloat(string2.substring(47, 51).trim()) / 100.0f;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  rms " + d7);
            }
            this.quality_RMS = d7;
        }
        catch (Exception exception) {
            this.quality_RMS = 0.0;
        }
        double d8 = -9.9f;
        try {
            d8 = Float.parseFloat(string2.substring(69, 71).trim()) / 10.0f;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  xmag " + d8);
            }
            this.quality_Mamp = d8;
        }
        catch (Exception exception) {
            d8 = -9.9f;
        }
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        if (SeismicityFrame.VERBOSE) {
            System.out.println("  flat " + d3 + " flong " + d4 + " x " + vect3D.x + " y " + vect3D.y + " depth " + d5);
        }
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d8, 1);
        this.covariance = null;
        try {
            double d9 = Float.parseFloat(string2.substring(51, 54).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  az1 " + d9);
            }
            double d10 = Float.parseFloat(string2.substring(54, 56).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dip1 " + d10);
            }
            double d11 = Float.parseFloat(string2.substring(56, 60).trim());
            d11 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se1 " + d11);
            }
            double d12 = Float.parseFloat(string2.substring(60, 63).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  az2 " + d12);
            }
            double d13 = Float.parseFloat(string2.substring(63, 65).trim());
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  dip2 " + d13);
            }
            double d14 = Float.parseFloat(string2.substring(65, 69).trim());
            d14 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se2 " + d14);
            }
            double d15 = Float.parseFloat(string2.substring(74, 78).trim());
            d15 /= 100.0;
            if (SeismicityFrame.VERBOSE) {
                System.out.println("  se3 " + d15);
            }
            if (d15 < (double)1.4E-45f) {
                d15 = 1.4E-45f;
            }
            double d16 = 0.0;
            try {
                d16 = -this.eventGeogCoords.getRotationAngle() + this.seisApp.geogCoords.getRotationAngle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d17 = d9 + d16;
            double d18 = d12 + d16;
            this.ellipsoid = new Ellipsoid3D(this.expectation.x, this.expectation.y, this.expectation.z, d17, d10, d11, d18, d13, d14, d15);
            this.ellipsoid.calcEllipses();
        }
        catch (Exception exception) {
            if (SeismicityFrame.VERBOSE) {
                System.out.println("ERROR: creating Ellipsoid3D" + exception);
            }
            this.ellipsoid = null;
        }
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        if (SeismicityFrame.VERBOSE) {
            System.out.println("");
        }
        return 0;
    }

    public int readEqDD(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        boolean bl = false;
        this.filename = string;
        this.comment = " ";
        String string2 = aSCIIInputStream.readWord();
        if (bl) {
            System.out.println("DEBUG: readEqDD year_str 0: " + string2);
        }
        while (true) {
            try {
                this.iyear = Integer.parseInt(string2);
                if (!bl) break;
                System.out.println("DEBUG: readEqDD iyear: " + this.iyear);
            }
            catch (Exception exception) {
                aSCIIInputStream.flushLine();
                string2 = aSCIIInputStream.readWord();
                if (!bl) continue;
                System.out.println("DEBUG: readEqDD year_str 1: " + string2);
                continue;
            }
            break;
        }
        this.imonth = aSCIIInputStream.readInt();
        this.iday = aSCIIInputStream.readInt();
        this.ihour = aSCIIInputStream.readInt();
        this.imin = aSCIIInputStream.readInt();
        this.sec = Double.parseDouble(aSCIIInputStream.readWord());
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = aSCIIInputStream.readDouble();
        double d4 = aSCIIInputStream.readDouble();
        double d5 = aSCIIInputStream.readDouble();
        double d6 = -9.9f;
        try {
            this.quality_errH = d6 = aSCIIInputStream.readDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d7 = -9.9f;
        try {
            d7 = aSCIIInputStream.readDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d8 = -9.9f;
        try {
            d8 = aSCIIInputStream.readDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d9 = -9.9f;
        try {
            this.quality_errZ = d9 = aSCIIInputStream.readDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d10 = -9.9f;
        double d11 = -9.9f;
        this.quality_Mamp = -9.9f;
        try {
            d10 = Double.parseDouble(aSCIIInputStream.readWord());
            if (Double.isFinite(d10)) {
                this.quality_Mamp = d10;
                d11 = d10;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            System.out.println("iyear " + this.iyear + " imonth " + this.imonth + " iday " + this.iday + " ihour " + this.ihour + " imin " + this.imin + " dlat " + d3 + " dlong " + d4 + " depth " + d5 + " eh1 " + d6 + " eh2 " + d7 + " az " + d8 + " ez " + d9 + " xmag " + d10);
        }
        String string3 = aSCIIInputStream.readWord();
        try {
            long l = Long.parseLong(string3);
            this.publicId = "" + l;
        }
        catch (Exception exception) {
            this.quality_Mdur = -9.9f;
            try {
                d10 = Double.parseDouble(string3);
                if (Double.isFinite(d10)) {
                    this.quality_Mdur = d10;
                    if (d11 < -9.0) {
                        d11 = d10;
                    }
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                long l = aSCIIInputStream.readLong();
                this.publicId = "" + l;
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        aSCIIInputStream.flushLine();
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d11, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readUSGSCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("USGS_CSV: " + string2);
            }
            if (string2.contains("time")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 22) continue;
                int n = 0;
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.replace("Z", "").substring(17));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                double d4 = Float.valueOf(stringArray[n++]).floatValue();
                double d5 = 0.0;
                try {
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = 0.0;
                try {
                    d6 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                this.quality_Mamp = d6;
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readBasicCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("BASIC_CSV: " + string2);
            }
            if (string2.contains("time") || string2.trim().startsWith("#")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 5 && (stringArray = string2.split("\\s+")).length < 5) continue;
                int n = 0;
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.replace("Z", "").substring(17));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                double d4 = Float.valueOf(stringArray[n++]).floatValue();
                double d5 = 0.0;
                try {
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = 0.0;
                try {
                    d6 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                this.quality_Mamp = d6;
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readSCECGrowClust(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("SCEC_GROWCLUST: " + string2);
            }
            if (string2.contains("time") || string2.contains("lat")) continue;
            try {
                String[] stringArray = string2.split("\\s+");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 10) continue;
                int n = 0;
                this.iyear = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                String string3 = stringArray[n++];
                this.publicId = "" + string3;
                this.comment = "" + string3;
                double d3 = Double.parseDouble(stringArray[n++]);
                double d4 = Double.parseDouble(stringArray[n++]);
                double d5 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readTexNetGrowClust(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("TEXNET_GROWCLUST: " + string2);
            }
            if (string2.contains("EventId")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 12) continue;
                int n = 0;
                int n2 = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   objectID: " + n2);
                }
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   eventId: " + string3);
                }
                this.publicId = "" + string3;
                this.comment = "" + string3;
                this.iyear = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                String string4 = stringArray[n++];
                double d3 = Double.parseDouble(stringArray[n++]);
                double d4 = Double.parseDouble(stringArray[n++]);
                double d5 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readMunchmeyerHypoDD(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("TRUG_2020: " + string2);
            }
            if (string2.contains("latitude")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 10) continue;
                int n = 0;
                this.publicId = stringArray[n++];
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                double d4 = Float.valueOf(stringArray[n++]).floatValue();
                double d5 = 0.0;
                try {
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                try {
                    this.sec = Double.parseDouble(string3.substring(17, 24));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sec = Double.parseDouble(string3.substring(17, 19));
                }
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d6 = Float.valueOf(stringArray[29]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                this.quality_Mamp = d6;
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readTrugman2020(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("TRUG_2020: " + string2);
            }
            if (string2.contains("evid")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 10) continue;
                int n = 0;
                this.publicId = stringArray[n++];
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(string3.substring(11, 13));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string3.substring(14, 16));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string3.substring(17));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                double d4 = Float.valueOf(stringArray[n++]).floatValue();
                double d5 = 0.0;
                try {
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readRuhl2021(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("RUHL_2020: " + string2);
            }
            if (string2.contains("evid")) continue;
            try {
                String[] stringArray = string2.split(" ");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 7) continue;
                int n = 0;
                this.publicId = stringArray[n++];
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                double d4 = Float.valueOf(stringArray[n++]).floatValue();
                double d5 = 0.0;
                try {
                    d5 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.DEBUG) {
                    System.out.println("   lat: " + d4 + ", lon: " + d3 + ", depth: " + d5);
                }
                String string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   orignDate: " + string3);
                }
                String[] stringArray2 = string3.split("-");
                this.iyear = Integer.parseInt(stringArray2[0]);
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(stringArray2[1]);
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(stringArray2[2]);
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                string3 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string3);
                }
                stringArray2 = string3.split(":");
                this.ihour = Integer.parseInt(stringArray2[0]);
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(stringArray2[1]);
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(stringArray2[2]);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d6 = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d4, d3, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readBasic(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("BASIC: " + string2);
            }
            if (string2.startsWith("#") || string2.startsWith("//") || string2.startsWith("!") || string2.toLowerCase().contains("time") || string2.toLowerCase().contains("lat")) continue;
            try {
                String[] stringArray = string2.split("\\s+");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 9 && (stringArray = string2.split(",")).length < 9) continue;
                int n = 0;
                this.iyear = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                double d3 = Double.parseDouble(stringArray[n++]);
                double d4 = Double.parseDouble(stringArray[n++]);
                double d5 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                this.quality_Mamp = -9.9;
                if (stringArray.length > 9) {
                    this.quality_Mamp = Double.parseDouble(stringArray[n++]);
                    if (this.DEBUG) {
                        System.out.println("   quality_Mamp: " + this.quality_Mamp);
                    }
                }
                double d6 = this.quality_Mamp;
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readLinCombloc(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("LIN_COMBLOC: " + string2);
            }
            if (string2.contains("time") || string2.contains("lat")) continue;
            try {
                String[] stringArray = string2.split("\\s+");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 10) continue;
                int n = 0;
                String string3 = stringArray[n++];
                this.publicId = "" + string3;
                this.comment = "" + string3;
                this.iyear = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                this.ihour = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                double d3 = Double.parseDouble(stringArray[n++]);
                double d4 = Double.parseDouble(stringArray[n++]);
                double d5 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   lat: " + d3 + ", lon: " + d4 + ", depth: " + d5);
                }
                double d6 = Double.parseDouble(stringArray[n++]);
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d6);
                }
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    public int readSheng2022(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, Exception {
        this.filename = string;
        this.comment = " ";
        long l = 0L;
        while (true) {
            try {
                l = aSCIIInputStream.readLong();
            }
            catch (Exception exception) {
                aSCIIInputStream.flushLine();
                if (!aSCIIInputStream.hadEof() && !aSCIIInputStream.eof()) continue;
                return -1;
            }
            break;
        }
        this.iyear = (int)(l / 10000L);
        this.imonth = (int)((l %= 10000L) / 100L);
        this.iday = (int)l % 100;
        String string2 = aSCIIInputStream.readWord();
        String[] stringArray = StringExt.parse(string2, ":");
        this.ihour = Integer.parseInt(stringArray[0]);
        this.imin = Integer.parseInt(stringArray[1]);
        this.sec = Float.valueOf(stringArray[2]).floatValue();
        this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        double d5 = Double.parseDouble(aSCIIInputStream.readWord());
        double d6 = 0.0;
        Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d3, d4, d5 -= 0.82);
        this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d6, 1);
        this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        aSCIIInputStream.flushLine();
        return 0;
    }

    public int readTexNetCsv(ASCIIInputStream aSCIIInputStream, double d, double d2, String string) throws IOException, EventSearchException {
        this.filename = string;
        this.comment = " ";
        boolean bl = false;
        String string2 = "";
        while (!aSCIIInputStream.eof() && (string2 = aSCIIInputStream.readLine()) != null) {
            if (this.DEBUG) {
                System.out.println("TEXNET_CSV: " + string2);
            }
            if (string2.contains("EventID")) continue;
            try {
                String[] stringArray = string2.split(",");
                if (this.DEBUG) {
                    System.out.println("   tokens.length: " + stringArray.length);
                }
                if (stringArray.length < 10) continue;
                int n = 0;
                this.publicId = stringArray[n++];
                int n2 = ++n;
                ++n;
                String string3 = stringArray[n2];
                if (this.DEBUG) {
                    System.out.println("   orignDate: " + string3);
                }
                this.iyear = Integer.parseInt(string3.substring(0, 4));
                if (this.DEBUG) {
                    System.out.println("   iyear: " + this.iyear);
                }
                this.imonth = Integer.parseInt(string3.substring(5, 7));
                if (this.DEBUG) {
                    System.out.println("   imonth: " + this.imonth);
                }
                this.iday = Integer.parseInt(string3.substring(8, 10));
                if (this.DEBUG) {
                    System.out.println("   iday: " + this.iday);
                }
                String string4 = stringArray[n++];
                if (this.DEBUG) {
                    System.out.println("   originTime: " + string4);
                }
                this.ihour = Integer.parseInt(string4.substring(0, 2));
                if (this.DEBUG) {
                    System.out.println("   ihour: " + this.ihour);
                }
                this.imin = Integer.parseInt(string4.substring(3, 5));
                if (this.DEBUG) {
                    System.out.println("   imin: " + this.imin);
                }
                this.sec = Double.parseDouble(string4.substring(6));
                if (this.DEBUG) {
                    System.out.println("   sec: " + this.sec);
                }
                this.oTimeMillisec = this.calcOTimeInMillis(DEFAULT_CALANDER);
                double d3 = Float.valueOf(stringArray[n++]).floatValue();
                if (this.DEBUG) {
                    System.out.println("   xmag: " + d3);
                }
                int n3 = ++n;
                ++n;
                double d4 = Float.valueOf(stringArray[n3]).floatValue();
                int n4 = ++n;
                ++n;
                double d5 = Float.valueOf(stringArray[n4]).floatValue();
                ++n;
                double d6 = 0.0;
                try {
                    d6 = Float.valueOf(stringArray[n++]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++n;
                ++n;
                if (this.DEBUG) {
                    System.out.println("   lat: " + d4 + ", lon: " + d5 + ", depth: " + d6);
                }
                this.quality_RMS = Float.valueOf(stringArray[n++]).floatValue();
                this.quality_Nphs = Integer.valueOf(stringArray[n++]);
                Vect3D vect3D = this.seisApp.geogCoords.geog2xyz(d4, d5, d6);
                this.hypocenter = new Sample4D(vect3D.x, vect3D.y, vect3D.z, d3, 1);
                this.hypoGeog = this.seisApp.geogCoords.xyz2geog(this.hypocenter.x, this.hypocenter.y, this.hypocenter.z);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            return -1;
        }
        this.expectation = null;
        this.covariance = null;
        this.ellipsoid = null;
        this.ellipsoid2 = null;
        this.focalMech = null;
        this.samples = new Sample4D[0];
        return 0;
    }

    static {
        maxLikeCol = maxLikeColDefault = Color.yellow;
        expectCol = Color.cyan;
        covCol = Color.cyan;
        ellipsoidCol = Color.cyan;
        ellipsoid2Col = Color.green;
        sampleCol = sampleColDefault = Color.red;
        samples_applycolormap = false;
        ellipsoid_applycolormap = false;
        colorMap = null;
        DEFAULT_CALANDER = new GregorianCalendar();
        DELTA_CHI_SQR_68_2 = 2.3;
        random = new Random(123456L);
        csvCompact_header_line = null;
        earlyEstCsvVersion = 2;
    }
}

