/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.util.ArrayList;
import net.alomax.geog.Grid3D;
import net.alomax.geog.MapPolygons;
import net.alomax.graphics3d.Vect3D;
import net.alomax.math.RangeDouble;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeismicityColorMap;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.util.StringExt;

public class SeisEventFilter {
    public Vect3D[] hypoLimits = null;
    protected boolean hypoLimits_expectation = false;
    public double[] magLimits = null;
    public double[] mdurLimits = null;
    public double[] mampLimits = null;
    public double[] rmsLimits = null;
    public double[] gapLimits = null;
    public double[] distLimits = null;
    public double[] ellSe3Limits = null;
    public double[] errhLimits = null;
    public double[] errzLimits = null;
    public int[] nPhsLimits = null;
    public long[] otimeLimits = null;
    public int[] indexLimits = null;
    public ArrayList<MapPolygons> polygonLimitsArray = new ArrayList();
    public double[] planeCoefficients = null;
    public double clipDistancePlane = -1.0;
    protected boolean testGrid = false;
    protected SeismicityFrame seismicityFrame = null;

    public SeisEventFilter(SeismicityFrame seismicityFrame) {
        this.seismicityFrame = seismicityFrame;
    }

    public void setLimits() {
        this.magLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.mag"));
        this.mdurLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.mdur"));
        this.mampLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.mamp"));
        this.rmsLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.rms"));
        this.nPhsLimits = this.parseIntLimits(this.seismicityFrame.getParameter("event.filter.nphs"));
        this.gapLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.gap"));
        this.distLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.dist"));
        this.ellSe3Limits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.ellipsoid.se3"));
        this.errhLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.errh"));
        this.errzLimits = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.errz"));
        this.indexLimits = this.parseIntLimits(this.seismicityFrame.getParameter("event.filter.index"));
        this.otimeLimits = this.parseTimeLimits(this.seismicityFrame.getParameter("event.filter.otime"));
        this.hypoLimits_expectation = false;
        String string = this.seismicityFrame.getParameter("event.filter.hypo");
        if (string == null) {
            string = this.seismicityFrame.getParameter("event.filter.expectation");
            if (string != null) {
                this.hypoLimits_expectation = true;
            } else {
                double[] dArray = this.parseDoubleLimits(this.seismicityFrame.getParameter("event.filter.depth"));
                if (dArray != null) {
                    string = "-99,-999," + dArray[0] + ";99,999," + dArray[1];
                }
            }
        }
        this.hypoLimits = this.parseVect3DLimits(string);
        this.testGrid = this.seismicityFrame.getTrueFalseParameter(false, "event.filter.grid");
    }

    public boolean accept(SeisEvent seisEvent) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        if (this.magLimits != null && !this.isInside(seisEvent.hypocenter.value, this.magLimits)) {
            return false;
        }
        if (this.mdurLimits != null && !this.isInside(seisEvent.quality_Mdur, this.mdurLimits)) {
            return false;
        }
        if (this.mampLimits != null && !this.isInside(seisEvent.quality_Mamp, this.mampLimits)) {
            return false;
        }
        if (this.rmsLimits != null && !this.isInside(seisEvent.quality_RMS, this.rmsLimits)) {
            return false;
        }
        if (this.nPhsLimits != null && !this.isInside(seisEvent.quality_Nphs, this.nPhsLimits)) {
            return false;
        }
        if (this.indexLimits != null && !this.isInside(seisEvent.original_index, this.indexLimits)) {
            return false;
        }
        if (this.gapLimits != null && !this.isInside((double)seisEvent.quality_Gap, this.gapLimits)) {
            return false;
        }
        if (this.distLimits != null && !this.isInside(seisEvent.quality_Dist, this.distLimits)) {
            return false;
        }
        if (this.ellSe3Limits != null && seisEvent.ellipsoid != null && !this.isInside(seisEvent.ellipsoid.se3, this.ellSe3Limits)) {
            return false;
        }
        if (this.errhLimits != null && seisEvent.quality_errH > 0.0 && !this.isInside(seisEvent.quality_errH, this.errhLimits)) {
            return false;
        }
        if (this.errzLimits != null && seisEvent.quality_errZ > 0.0 && !this.isInside(seisEvent.quality_errZ, this.errzLimits)) {
            return false;
        }
        if (this.otimeLimits != null && !this.isInsideOtime(seisEvent, this.otimeLimits)) {
            return false;
        }
        if (this.hypoLimits != null && (this.hypoLimits_expectation ? !this.isInside(seisEvent.expectationGeog, this.hypoLimits) : !this.isInside(seisEvent.hypoGeog, this.hypoLimits))) {
            return false;
        }
        if (this.testGrid && !this.isInsideGrid(seisEvent.hypoGeog, this.seismicityFrame.getGrid3D())) {
            return false;
        }
        if (this.polygonLimitsArray != null && !this.polygonLimitsArray.isEmpty()) {
            boolean bl = false;
            for (MapPolygons mapPolygons : this.polygonLimitsArray) {
                if (!mapPolygons.contains(seisEvent.hypoGeog.y, seisEvent.hypoGeog.x)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return this.planeCoefficients == null || !((d10 = (d9 = Math.abs((d8 = this.planeCoefficients[0]) * (d7 = seisEvent.hypocenter.x) + (d6 = this.planeCoefficients[1]) * (d5 = seisEvent.hypocenter.y) + (d4 = this.planeCoefficients[2]) * (d3 = seisEvent.hypocenter.z) + (d2 = this.planeCoefficients[3]))) / (d = Math.sqrt(d8 * d8 + d6 * d6 + d4 * d4))) > this.clipDistancePlane);
    }

    public boolean isInsideGrid(Vect3D vect3D, Grid3D grid3D) {
        return grid3D.isInsideGeographic(vect3D.x, vect3D.y, -vect3D.z);
    }

    public boolean isInside(double d, double[] dArray) {
        if (!Double.isFinite(d)) {
            return false;
        }
        if (dArray[0] != Double.NaN && d < dArray[0]) {
            return false;
        }
        return dArray[1] == Double.NaN || !(d > dArray[1]);
    }

    public boolean isInside(int n, int[] nArray) {
        if (nArray[0] > Integer.MIN_VALUE && n < nArray[0]) {
            return false;
        }
        return nArray[1] >= Integer.MAX_VALUE || n <= nArray[1];
    }

    public boolean isInsideOtime(SeisEvent seisEvent, long[] lArray) {
        if (lArray[0] > Long.MIN_VALUE && seisEvent.oTimeMillisec < lArray[0]) {
            return false;
        }
        return lArray[1] >= Long.MAX_VALUE || seisEvent.oTimeMillisec <= lArray[1];
    }

    public boolean isInside(Vect3D vect3D, Vect3D[] vect3DArray) {
        if (vect3DArray[0] != null) {
            if (vect3D.x < vect3DArray[0].x) {
                return false;
            }
            if (vect3D.y < vect3DArray[0].y) {
                return false;
            }
            if (vect3D.z < vect3DArray[0].z) {
                return false;
            }
        }
        if (vect3DArray[1] != null) {
            if (vect3D.x > vect3DArray[1].x) {
                return false;
            }
            if (vect3D.y > vect3DArray[1].y) {
                return false;
            }
            if (vect3D.z > vect3DArray[1].z) {
                return false;
            }
        }
        return true;
    }

    protected double[] parseDoubleLimits(String string) {
        double[] dArray = new double[]{Double.NaN, Double.NaN};
        if (string == null) {
            return null;
        }
        try {
            String[] stringArray = string.split("[,;]");
            if (stringArray.length > 0) {
                dArray[0] = Double.parseDouble(stringArray[0]);
            }
            if (stringArray.length > 1) {
                dArray[1] = Double.parseDouble(stringArray[1]);
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading filter parameters: " + string + " : " + exception);
        }
        return dArray;
    }

    protected int[] parseIntLimits(String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        try {
            String[] stringArray = string.split("[,;]");
            if (stringArray.length > 0) {
                nArray[0] = Integer.parseInt(stringArray[0]);
            }
            if (stringArray.length > 1) {
                nArray[1] = Integer.parseInt(stringArray[1]);
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading filter parameters: " + string + " : " + exception);
        }
        return nArray;
    }

    protected Vect3D[] parseVect3DLimits(String string) {
        if (string == null) {
            return null;
        }
        Vect3D[] vect3DArray = new Vect3D[2];
        vect3DArray[1] = null;
        vect3DArray[0] = null;
        try {
            String[] stringArray = string.split("[;#]");
            for (int i = 0; i < stringArray.length && i < 2; ++i) {
                vect3DArray[i] = new Vect3D();
                String[] stringArray2 = StringExt.parse(stringArray[i], ",");
                if (stringArray2.length < 1) continue;
                vect3DArray[i].x = Double.parseDouble(stringArray2[0]);
                if (stringArray2.length < 2) continue;
                vect3DArray[i].y = Double.parseDouble(stringArray2[1]);
                if (stringArray2.length < 3) continue;
                vect3DArray[i].z = Double.parseDouble(stringArray2[2]);
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading filter parameters: " + string + " : " + exception);
        }
        return vect3DArray;
    }

    protected long[] parseTimeLimits(String string) {
        if (string == null) {
            return null;
        }
        long[] lArray = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            double d = 0.0;
            String[] stringArray = string.split("[;#]");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    if (stringArray[i].length() <= 7) continue;
                    n = Integer.parseInt(stringArray[i].substring(0, 4));
                    n2 = Integer.parseInt(stringArray[i].substring(4, 6));
                    n3 = Integer.parseInt(stringArray[i].substring(6, 8));
                    if (stringArray[i].length() <= 13) continue;
                    stringArray[i].replace(".", "");
                    n4 = Integer.parseInt(stringArray[i].substring(8, 10));
                    n5 = Integer.parseInt(stringArray[i].substring(10, 12));
                    d = Double.parseDouble(stringArray[i].substring(12, 14));
                    continue;
                }
                catch (Exception exception) {
                    block14: {
                        try {
                            String[] stringArray2 = StringExt.parse(stringArray[i], ",");
                            if (stringArray2.length > 0) {
                                n = Integer.parseInt(stringArray2[0]);
                                if (stringArray2.length > 1) {
                                    n2 = Integer.parseInt(stringArray2[1]);
                                    if (stringArray2.length > 2) {
                                        n3 = Integer.parseInt(stringArray2[2]);
                                        if (stringArray2.length > 3) {
                                            n4 = Integer.parseInt(stringArray2[3]);
                                            if (stringArray2.length > 4) {
                                                n5 = Integer.parseInt(stringArray2[4]);
                                                if (stringArray2.length > 5) {
                                                    d = Double.parseDouble(stringArray2[5]);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception exception2) {
                            String string2 = stringArray[i];
                            n = Integer.parseInt(string2.substring(0, 4));
                            n2 = Integer.parseInt(string2.substring(5, 7));
                            n3 = Integer.parseInt(string2.substring(8, 10));
                            if (string2.length() <= 10) break block14;
                            n4 = Integer.parseInt(string2.substring(11, 13));
                            n5 = Integer.parseInt(string2.substring(14, 16));
                            d = Double.parseDouble(string2.replace("Z", "").substring(17));
                        }
                    }
                    SeisEvent.DEFAULT_CALANDER.clear();
                    SeisEvent.DEFAULT_CALANDER.set(n, n2 - 1, n3, n4, n5, (int)d);
                    long l = SeisEvent.DEFAULT_CALANDER.getTimeInMillis();
                    lArray[i] = l += Math.round(1000.0 * (d - Math.floor(d)));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading filter parameters: " + string + " : " + exception);
        }
        return lArray;
    }

    public RangeDouble limitsForColorMapType(SeismicityColorMap.Type type) {
        switch (type) {
            case DEPTH: {
                return new RangeDouble(this.hypoLimits[0].z, this.hypoLimits[1].z);
            }
            case OTIME: {
                return new RangeDouble(this.otimeLimits[0], this.otimeLimits[1]);
            }
            case MONTH: {
                return null;
            }
            case RMS: {
                return new RangeDouble(this.rmsLimits[0], this.rmsLimits[1]);
            }
            case ERRH: {
                return new RangeDouble(this.errhLimits[0], this.errhLimits[1]);
            }
            case ERRZ: {
                return new RangeDouble(this.errzLimits[0], this.errzLimits[1]);
            }
            case NPHS: {
                return new RangeDouble(this.nPhsLimits[0], this.nPhsLimits[1]);
            }
            case GAP: {
                return new RangeDouble(this.gapLimits[0], this.gapLimits[1]);
            }
            case DIST: {
                return new RangeDouble(this.distLimits[0], this.distLimits[1]);
            }
            case MAG_AMP: {
                return new RangeDouble(this.mampLimits[0], this.mampLimits[1]);
            }
            case MAG_DUR: {
                return new RangeDouble(this.mdurLimits[0], this.mdurLimits[1]);
            }
            case EVT_NUM: {
                if (this.indexLimits != null) {
                    return new RangeDouble(this.indexLimits[0], this.indexLimits[1]);
                }
                return new RangeDouble(0.0, this.seismicityFrame.seisEventList.size() - 1);
            }
        }
        return null;
    }

    public void addPolygonFilter(MapPolygons mapPolygons) {
        this.polygonLimitsArray.add(mapPolygons);
    }

    public void addPolygonPlaneFilter(MapPolygons mapPolygons, double d) {
        if (d <= 0.0) {
            System.out.println("ERROR: initializing PolygonPlaneFilter: clipDistancePlane < 0.0.");
            return;
        }
        this.clipDistancePlane = d;
        this.planeCoefficients = MapPolygons.createPolygonPlaneFilterCoefficients(mapPolygons);
    }
}

