/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JLabel;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeisResidual;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public class SeisPhase {
    private boolean DEBUG;
    static final double RPD = 0.01745329238474369;
    protected static final String UP_FIRST_MOTION_CODES = "UCuc+";
    protected static final String DOWN_FIRST_MOTION_CODES = "Dd-";
    boolean isNllFormatVer2;
    public String label;
    public String inst;
    public String comp;
    public String onset;
    public String phase;
    public String firstMo;
    public String iDate;
    public String hrMin;
    public double sec;
    public double coda_dur;
    public double amplitude;
    public double period;
    public String error_type;
    public double error;
    public double pred_travel_time;
    public double weight;
    public Vect3D loc;
    public Vect3D upVector;
    public Vect3D shiftVector;
    public double dist;
    public double azim;
    public double ray_azim;
    public double ray_dip;
    public int ray_qual;
    public double apriori_weight;
    public double t_correction;
    public double tt_error;
    public int polarity;
    protected SeisResidual seisResidual;
    protected double oneSecToKm;
    protected double pix2WorldScale;
    protected static int iDiamStaSym = 7;
    protected static double stationSymbolSizeFactor = 1.0;
    protected static int iDiamFirstMo = 6;
    protected static double LOC_XYZ_TEST = -1.0E10;

    public static void setStationSymbolSizeFactor(double d) {
        stationSymbolSizeFactor = d;
        iDiamStaSym = (int)(7.0 * d);
    }

    public SeisPhase(ASCIIInputStream aSCIIInputStream, String string, double d, double d2, boolean bl, GeogCoords geogCoords, GeogCoords geogCoords2) throws Exception {
        block24: {
            this.DEBUG = SeismicityFrame.DEBUG_LEVEL > 2;
            this.isNllFormatVer2 = false;
            this.upVector = new Vect3D(0.0, 0.0, 1.0);
            this.shiftVector = new Vect3D(1.0, 1.0, 0.0);
            this.apriori_weight = 1.0;
            this.t_correction = 0.0;
            this.tt_error = 0.0;
            this.polarity = 0;
            this.seisResidual = null;
            double d3 = 0.0;
            String string2 = "";
            String string3 = null;
            this.upVector.normalize();
            this.shiftVector.normalize();
            this.pix2WorldScale = d;
            this.oneSecToKm = d2;
            try {
                String string4;
                String string5;
                string3 = aSCIIInputStream.readLine();
                if (string != null) {
                    string3 = string + " " + string3;
                }
                String[] stringArray = StringExt.parse(string3);
                int n = 0;
                string2 = this.label;
                this.label = stringArray[n++];
                string2 = "inst";
                this.inst = stringArray[n++];
                string2 = "comp";
                this.comp = stringArray[n++];
                string2 = "onset";
                this.onset = stringArray[n++];
                string2 = "phase";
                this.phase = stringArray[n++];
                string2 = "firstMo";
                this.firstMo = stringArray[n++];
                this.setFirstMotionPolarity();
                string2 = "iDate";
                this.iDate = stringArray[n++];
                string2 = "hrMin";
                this.hrMin = stringArray[n++];
                string2 = "sec";
                this.sec = StringExt.parseFloat(stringArray[n++], 0.0f);
                string2 = "error_type";
                this.error_type = stringArray[n++];
                string2 = "error";
                this.error = StringExt.parseFloat(stringArray[n++], -1.0f);
                string2 = "coda_dur";
                this.coda_dur = StringExt.parseFloat(stringArray[n++], -1.0f);
                string2 = "amplitude";
                this.amplitude = StringExt.parseFloat(stringArray[n++], -1.0f);
                string2 = "period";
                this.period = StringExt.parseFloat(stringArray[n++], -1.0f);
                this.isNllFormatVer2 = false;
                string2 = "separator";
                String string6 = stringArray[n++];
                if (string6 != null && !string6.equals(">")) {
                    this.isNllFormatVer2 = true;
                }
                if (this.isNllFormatVer2 && stringArray.length != 29 || !this.isNllFormatVer2 && stringArray.length != 27) {
                    System.out.println("WARNING: Wrong number of fields in NLLoc event file phase record: ");
                    System.out.println("   Phase record: <" + string3 + ">");
                }
                if (this.isNllFormatVer2) {
                    string2 = "apriori_weight";
                    this.apriori_weight = Float.parseFloat(string6);
                    string2 = "separator";
                    string6 = stringArray[n++];
                    if (this.apriori_weight > 999.9) {
                        this.apriori_weight = 1.0;
                    }
                } else {
                    this.apriori_weight = 1.0;
                }
                string2 = "pred_travel_time";
                this.pred_travel_time = StringExt.parseFloat(stringArray[n++], -1.0f);
                string2 = "residual";
                d3 = StringExt.parseFloat(stringArray[n++], 0.0f);
                this.seisResidual = new SeisResidual(this.phase, d3);
                string2 = "weight";
                this.weight = StringExt.parseFloat(stringArray[n++], -1.0f);
                string2 = "loc";
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                boolean bl2 = false;
                if ((string5 = stringArray[n++]).endsWith("g")) {
                    string5 = string5.substring(0, string5.length() - 1);
                    bl2 = true;
                }
                if ((string4 = stringArray[n++]).endsWith("g")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    bl2 = true;
                }
                d4 = StringExt.parseFloat(string5, 0.0f);
                d5 = StringExt.parseFloat(string4, 0.0f);
                d6 = StringExt.parseFloat(stringArray[n++], 0.0f);
                if (d4 < LOC_XYZ_TEST || d5 < LOC_XYZ_TEST || d6 < LOC_XYZ_TEST) {
                    if (this.DEBUG) {
                        System.out.println("WARNING: invalid phase xyz location in phase record: <" + string3 + ">");
                    }
                    return;
                }
                if (geogCoords2.isGlobal()) {
                    Vect3D vect3D = new Vect3D(d5, d4, d6);
                    this.loc = geogCoords.geog2xyz(vect3D);
                    if (geogCoords.isGlobal()) {
                        this.upVector = geogCoords.geog2xyz(vect3D);
                        this.upVector.normalize();
                    }
                    vect3D.x += 1.0;
                    vect3D.y += 1.0;
                    this.shiftVector = geogCoords.geog2xyz(vect3D);
                    this.shiftVector.normalize();
                } else {
                    this.loc = new Vect3D(d4, d5, -d6);
                    if (bl2) {
                        Vect3D vect3D = new Vect3D(d5, d4, d6);
                        this.loc = geogCoords.geog2xyz(vect3D);
                    } else if (geogCoords != null && geogCoords2 != null && geogCoords != geogCoords2) {
                        Vect3D vect3D = geogCoords2.xyz2geog(this.loc);
                        this.loc = geogCoords.geog2xyz(vect3D);
                    }
                }
                string2 = "dist";
                this.dist = StringExt.parseFloat(stringArray[n++], 0.0f);
                string2 = "azim";
                this.azim = StringExt.parseFloat(stringArray[n++], 0.0f);
                string2 = "ray_azim";
                this.ray_azim = StringExt.parseFloat(stringArray[n++], 0.0f);
                string2 = "ray_dip";
                this.ray_dip = StringExt.parseFloat(stringArray[n++], 0.0f);
                string2 = "ray_qual";
                this.ray_qual = StringExt.parseInt(stringArray[n++], 0);
                if (stringArray.length <= n) break block24;
                try {
                    string2 = "t_correction";
                    this.t_correction = StringExt.parseFloat(stringArray[n++], 0.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isNllFormatVer2 && stringArray.length > 1) {
                    try {
                        string2 = "tt_error";
                        this.tt_error = StringExt.parseFloat(stringArray[n++], 0.0f);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: reading NLLoc event file phase record at field: " + string2 + ": " + exception);
                System.out.println("   In phase record: <" + string3 + ">");
                if (SeismicityFrame.PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                return;
            }
        }
    }

    public SeisPhase(DataInputStream dataInputStream, double d, double d2) throws IOException {
        this.DEBUG = SeismicityFrame.DEBUG_LEVEL > 2;
        this.isNllFormatVer2 = false;
        this.upVector = new Vect3D(0.0, 0.0, 1.0);
        this.shiftVector = new Vect3D(1.0, 1.0, 0.0);
        this.apriori_weight = 1.0;
        this.t_correction = 0.0;
        this.tt_error = 0.0;
        this.polarity = 0;
        this.seisResidual = null;
        this.label = dataInputStream.readUTF();
        this.phase = dataInputStream.readUTF();
        this.firstMo = dataInputStream.readUTF();
        this.setFirstMotionPolarity();
        double d3 = dataInputStream.readFloat();
        this.weight = dataInputStream.readFloat();
        double d4 = dataInputStream.readFloat();
        double d5 = dataInputStream.readFloat();
        double d6 = dataInputStream.readFloat();
        this.loc = new Vect3D(d4, d5, d6);
        this.shiftVector.normalize();
        this.pix2WorldScale = d;
        this.oneSecToKm = d2;
        this.seisResidual = new SeisResidual(this.phase, d3);
    }

    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.label);
        dataOutputStream.writeUTF(this.phase);
        dataOutputStream.writeUTF(this.firstMo);
        dataOutputStream.writeFloat((float)this.seisResidual.getResidual());
        dataOutputStream.writeFloat((float)this.weight);
        dataOutputStream.writeFloat((float)this.loc.x);
        dataOutputStream.writeFloat((float)this.loc.y);
        dataOutputStream.writeFloat((float)this.loc.z);
    }

    protected void setFirstMotionPolarity() {
        this.polarity = UP_FIRST_MOTION_CODES.indexOf(this.firstMo) != -1 ? 1 : (DOWN_FIRST_MOTION_CODES.indexOf(this.firstMo) != -1 ? -1 : 0);
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Vect3D vect3D, SeismicityFrame seismicityFrame) {
        int[] nArray;
        if (this.loc == null) {
            return;
        }
        if (bl3 || this.weight > (double)1.4E-45f) {
            if (bl5 && this.ray_qual > 0) {
                double d = 10.0f * (float)this.pix2WorldScale;
                double d2 = (float)Math.sin(0.01745329238474369 * this.ray_dip);
                double d3 = (float)seismicityFrame.geogCoords.geogAng2xyAng(this.ray_azim);
                Vect3D vect3D2 = new Vect3D(vect3D.x + d * Math.sin(0.01745329238474369 * d3) * d2, vect3D.y + d * Math.cos(0.01745329238474369 * d3) * d2, vect3D.z - d * Math.cos(0.01745329238474369 * this.ray_dip));
                int[] nArray2 = new int[3];
                int[] nArray3 = new int[3];
                Matrix3D.applyPerspTrans(vect3D, nArray2);
                Matrix3D.applyPerspTrans(vect3D2, nArray3);
                boolean bl8 = true;
                boolean bl9 = true;
                if (bl9) {
                    if (this.polarity > 0) {
                        if (this.onset.equals("i")) {
                            graphics.setColor(SeismicityColors.phaseRayCompression);
                        } else {
                            graphics.setColor(SeismicityColors.phaseRayCompression.darker().darker());
                        }
                    } else if (this.polarity < 0) {
                        if (this.onset.equals("i")) {
                            graphics.setColor(SeismicityColors.phaseRayDilatation);
                        } else {
                            graphics.setColor(SeismicityColors.phaseRayDilatation.darker().darker());
                        }
                    } else {
                        bl8 = false;
                    }
                } else {
                    graphics.setColor(SeismicityColors.phaseRay);
                }
                if (bl8) {
                    Draw3D.drawLine(graphics, nArray2[0], nArray2[1], nArray3[0], nArray3[1]);
                }
            }
            this.seisResidual.paint(graphics, bl, bl2, this.upVector, this.shiftVector, this.pix2WorldScale, this.oneSecToKm, this.loc, bl6, bl7);
            if (bl4 && this.phase.toUpperCase().startsWith("P")) {
                int[] nArray4 = new int[3];
                nArray = new int[3];
                if (this.polarity == 1) {
                    graphics.setColor(SeismicityColors.phaseFirstMotionUp);
                } else if (this.polarity == -1) {
                    graphics.setColor(SeismicityColors.phaseFirstMotionDown);
                } else {
                    graphics.setColor(Color.gray);
                    Matrix3D.applyPerspTrans(this.loc, nArray4);
                    Draw3D.drawOval(graphics, nArray4[0] - iDiamFirstMo / 2, nArray4[1] - iDiamFirstMo / 2, iDiamFirstMo, iDiamFirstMo);
                    return;
                }
                Vect3D vect3D3 = this.loc;
                Matrix3D.applyPerspTrans(vect3D3, nArray4);
                vect3D3 = this.loc.add(this.upVector.mult(this.oneSecToKm * (double)this.polarity / 10.0));
                Matrix3D.applyPerspTrans(vect3D3, nArray);
                Draw3D.drawLine(graphics, nArray4[0], nArray4[1], nArray[0], nArray[1]);
                Draw3D.fillOval(graphics, nArray4[0] - iDiamFirstMo / 2, nArray4[1] - iDiamFirstMo / 2, iDiamFirstMo, iDiamFirstMo);
            }
        }
        if (bl6 && (bl3 || this.weight > (double)1.4E-45f)) {
            int[] nArray5 = new int[3];
            nArray = new int[3];
            graphics.setColor(SeismicityColors.stationSymbol);
            Matrix3D.applyPerspTrans(this.loc, nArray5);
            if (this.weight > (double)1.4E-45f) {
                Draw3D.fillTriangle(graphics, nArray5[0], nArray5[1], iDiamStaSym);
            } else {
                Draw3D.drawTriangle(graphics, nArray5[0], nArray5[1], iDiamStaSym);
            }
        }
    }

    public String toString() {
        return this.label + " " + this.inst + " " + this.comp + " " + this.onset + " " + this.phase + " " + this.firstMo + " " + this.iDate + " " + this.hrMin + " " + this.sec + " " + this.error_type + " " + this.error + " " + this.coda_dur + " " + this.amplitude + " " + this.period + " " + this.apriori_weight + " " + this.pred_travel_time + " " + this.seisResidual.getResidual() + " " + this.loc.x + " " + this.loc.y + " " + this.loc.z + " " + this.dist + " " + this.azim + " " + this.ray_azim + " " + this.ray_dip + " " + this.ray_qual;
    }

    public JLabel[] getPhaseData(Font font, double d, double d2) {
        String string;
        Font font2 = new Font(font.getName(), 1, font.getSize());
        JLabel[] jLabelArray = new JLabel[13];
        int n = -1;
        jLabelArray[++n] = new JLabel(" " + this.label + " " + this.inst + " " + this.comp);
        jLabelArray[++n] = new JLabel(" " + this.onset + " " + this.phase + " " + this.firstMo);
        String string2 = this.hrMin;
        if (string2.length() == 4) {
            string2 = string2.substring(0, 2) + ":" + string2.substring(2, 4);
        }
        if ((string = new String("" + (float)this.sec)).indexOf(".") == 1) {
            string = "0" + string;
        }
        jLabelArray[++n] = new JLabel(" " + this.iDate + " " + string2 + ":" + string);
        jLabelArray[++n] = new JLabel(" " + this.error_type + " " + (float)this.error);
        jLabelArray[++n] = new JLabel(" " + (float)this.coda_dur + " " + (float)this.amplitude + " " + (float)this.period);
        jLabelArray[++n] = new JLabel(" " + (float)this.apriori_weight);
        jLabelArray[++n] = new JLabel(" " + (float)this.pred_travel_time);
        jLabelArray[++n] = new JLabel(" " + (float)this.seisResidual.getResidual());
        jLabelArray[n].setBackground(new Color(223, 223, 223));
        if (this.seisResidual.isPresidual) {
            double d3;
            double d4 = d3 = d2 > 0.0 ? d2 : this.error;
            if (this.seisResidual.getResidual() < -d3) {
                jLabelArray[n].setFont(font2);
                jLabelArray[n].setBackground(SeismicityColors.phaseResidualPdown);
            } else if (this.seisResidual.getResidual() > d3) {
                jLabelArray[n].setFont(font2);
                jLabelArray[n].setBackground(SeismicityColors.phaseResidualPup);
            }
        } else {
            double d5;
            double d6 = d5 = d > 0.0 ? d : this.error;
            if (this.seisResidual.getResidual() < -d5) {
                jLabelArray[n].setFont(font2);
                jLabelArray[n].setBackground(SeismicityColors.phaseResidualSdown);
            } else if (this.seisResidual.getResidual() > d5) {
                jLabelArray[n].setFont(font2);
                jLabelArray[n].setBackground(SeismicityColors.phaseResidualSup);
            }
        }
        jLabelArray[++n] = new JLabel(" " + (float)this.weight);
        jLabelArray[++n] = new JLabel(" " + (float)this.dist + "  " + (float)this.azim);
        jLabelArray[++n] = new JLabel(" " + (float)this.ray_azim + "  " + (float)this.ray_dip + "  " + this.ray_qual);
        jLabelArray[++n] = new JLabel(" " + (float)this.t_correction);
        jLabelArray[++n] = new JLabel(" " + (float)this.tt_error);
        return jLabelArray;
    }

    public static JLabel[] getPhaseHeadings(double d, double d2) {
        String string = "err";
        if (d2 >= 0.0) {
            string = "" + (float)d2;
        }
        String string2 = "err";
        if (d >= 0.0) {
            string2 = "" + (float)d;
        }
        JLabel[] jLabelArray = new JLabel[]{new JLabel(" sta inst cmp"), new JLabel(" on phs fm"), new JLabel(" date time"), new JLabel(" error"), new JLabel(" coda amp per"), new JLabel(" prior_wt"), new JLabel(" pred_tt"), new JLabel(" resid (" + string + "/" + string2 + ")"), new JLabel(" weight"), new JLabel(" sta: dist az"), new JLabel(" ray: az dip q"), new JLabel(" t_corr"), new JLabel(" tt_err")};
        return jLabelArray;
    }
}

