/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import net.alomax.seismicity.SeisResidual;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class SeisResidualStats
extends SeisResidual {
    protected DescriptiveStatistics descriptiveStatistics = DescriptiveStatistics.newInstance();

    public SeisResidualStats(String string) {
        super(string);
    }

    public void addResidual(double d) {
        this.descriptiveStatistics.addValue(d);
        this.numRes = this.getN();
        this.residual = this.getMean();
    }

    public double getMean() {
        return this.descriptiveStatistics.getMean();
    }

    public double getVariance() {
        return this.descriptiveStatistics.apply(new Variance(false));
    }

    public double getStdDev() {
        double d = -1.0;
        try {
            if (this.getN() > 1) {
                d = Math.sqrt(this.getVariance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getMax() {
        return this.descriptiveStatistics.getMax();
    }

    public double getMin() {
        return this.descriptiveStatistics.getMin();
    }

    public int getN() {
        return (int)this.descriptiveStatistics.getN();
    }
}

