/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.GeneralInputStream;
import net.alomax.seismicity.SeisPhase;
import net.alomax.seismicity.SeisResidual;
import net.alomax.seismicity.SeisResidualStats;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityFrame;
import sdsu.io.ASCIIInputStream;

public class SeisStation {
    public String label;
    protected Vect3D location = null;
    protected Vect3D geogLoc = null;
    protected Vect3D[] textCoords = null;
    protected Vect3D upVector = new Vect3D(0.0, 0.0, 1.0);
    protected Vect3D upVectorText = new Vect3D(0.0, 1.0, 1.0);
    protected Vect3D pathVec = new Vect3D(1.0f, 0.0f, 0.0f);
    public Vect3D shiftVector = new Vect3D(1.0, 1.0, 0.0);
    protected double oneSecToKm;
    protected double pix2WorldScale;
    protected static final int idiam = 4;
    protected SeisResidualStats residualStatsP = new SeisResidualStats("P");
    protected SeisResidualStats residualStatsS = new SeisResidualStats("S");
    protected int numPres = 0;
    protected int numSres = 0;
    protected static boolean shiftStationLabelText = false;
    protected static String stationLabelRemoveText = null;

    public static void setShiftStationLabelText(boolean bl) {
        shiftStationLabelText = bl;
    }

    static void setStationLabelRemoveText(String string) {
        stationLabelRemoveText = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<SeisStation> getNLLStations(SeismicityFrame seismicityFrame, URL uRL, String string, double d, double d2, boolean bl, GeogCoords geogCoords, GeogCoords geogCoords2, Vector<SeisStation> vector) {
        InputStream inputStream = null;
        try {
            inputStream = GeneralInputStream.openStream(uRL, string, true);
            ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(inputStream);
            while (!aSCIIInputStream.eof()) {
                Vect3D vect3D;
                Object object;
                String string2 = aSCIIInputStream.readWord();
                double d3 = Double.parseDouble(aSCIIInputStream.readWord());
                double d4 = Double.parseDouble(aSCIIInputStream.readWord());
                double d5 = Double.parseDouble(aSCIIInputStream.readWord());
                Vect3D vect3D2 = new Vect3D(0.0, 0.0, 1.0);
                Vect3D vect3D3 = new Vect3D(1.0, 1.0, 0.0);
                if (geogCoords.isGlobal()) {
                    object = new Vect3D(d4, d3, d5);
                    vect3D = geogCoords.geog2xyz((Vect3D)object);
                    vect3D2 = geogCoords.geog2xyz((Vect3D)object);
                    ((Vect3D)object).x += 1.0;
                    ((Vect3D)object).y += 1.0;
                    vect3D3 = geogCoords.geog2xyz((Vect3D)object);
                } else {
                    vect3D = new Vect3D(d3, d4, -d5);
                    if (geogCoords != null && geogCoords2 != null && geogCoords != geogCoords2) {
                        object = geogCoords2.xyz2geog(vect3D);
                        vect3D = geogCoords.geog2xyz((Vect3D)object);
                    }
                }
                object = new SeisStation(string2, seismicityFrame, vect3D, vect3D2, vect3D3, d, d2, bl, geogCoords);
                vector.add((SeisStation)object);
                aSCIIInputStream.flushLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return vector;
    }

    public SeisStation(String string, SeismicityFrame seismicityFrame, Vect3D vect3D, Vect3D vect3D2, Vect3D vect3D3, double d, double d2, boolean bl, GeogCoords geogCoords) {
        this.label = string;
        this.pix2WorldScale = d;
        this.oneSecToKm = d2;
        this.location = new Vect3D(vect3D);
        this.geogLoc = geogCoords.xyz2geog(vect3D);
        if (bl) {
            this.upVector = new Vect3D(vect3D2);
            this.upVectorText = new Vect3D(vect3D2);
            vect3D3 = new Vect3D(vect3D3);
            Vect3D vect3D4 = this.geogLoc.add(new Vect3D(0.0, 0.01, 0.0));
            Vect3D vect3D5 = geogCoords.geog2xyz(vect3D4);
            this.pathVec = vect3D5.sub(vect3D);
        }
        this.vectorizeLabel(seismicityFrame, this.pix2WorldScale, geogCoords.transformType == 1);
    }

    public SeisStation(String string, SeismicityFrame seismicityFrame, SeisPhase seisPhase, double d, double d2, boolean bl, GeogCoords geogCoords) {
        this(string, seismicityFrame, seisPhase.loc, seisPhase.upVector, seisPhase.shiftVector, d, d2, bl, geogCoords);
    }

    protected void vectorizeLabel(SeismicityFrame seismicityFrame, double d, boolean bl) {
        if (this.label != null) {
            String string = this.label;
            if (stationLabelRemoveText != null) {
                string = string.replace(stationLabelRemoveText, "");
            }
            int n = 1;
            int n2 = 0;
            if (shiftStationLabelText) {
                n = 0;
                n2 = 1;
                string = " " + string;
            }
            double d2 = 1.0;
            StringVectorizer stringVectorizer = new StringVectorizer(string, seismicityFrame, seismicityFrame.textDensity * d2);
            this.textCoords = stringVectorizer.toWorldCoords(d2 * d, n, n2, this.pathVec, this.upVectorText);
        }
    }

    public void addResidual(SeisPhase seisPhase) {
        if (SeisResidual.isPphase(seisPhase.phase)) {
            this.residualStatsP.addResidual(seisPhase.seisResidual.getResidual());
        } else if (SeisResidual.isSphase(seisPhase.phase)) {
            this.residualStatsS.addResidual(seisPhase.seisResidual.getResidual());
        }
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (this.location == null) {
            return;
        }
        if (bl) {
            graphics.setColor(SeismicityColors.stationLabel);
            if (this.textCoords != null) {
                StringVectorizer.paint(graphics, this.textCoords, this.location.x, this.location.y, this.location.z, true);
            }
        }
        this.residualStatsP.paint(graphics, bl2, bl3, this.upVector, this.shiftVector, this.pix2WorldScale, this.oneSecToKm, this.location, bl4, bl5);
        this.residualStatsS.paint(graphics, bl2, bl3, this.upVector, this.shiftVector, this.pix2WorldScale, this.oneSecToKm, this.location, bl4, bl5);
    }

    public String toString() {
        return this.label + " " + this.residualStatsP.phase + " " + this.residualStatsS.phase + " " + this.location.x + " " + this.location.y + " " + this.location.z + " ";
    }

    public String toLatLonString() {
        return "" + (float)this.geogLoc.x + " " + (float)this.geogLoc.y + " " + (float)this.geogLoc.z + " " + 4 + " " + this.label;
    }
}

