/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.util.GregorianCalendar;
import net.alomax.awt.AJLColor;
import net.alomax.awt.ColorMap;
import net.alomax.seismicity.SeisEvent;
import net.alomax.util.StringExt;

public class SeismicityColorMap
extends ColorMap {
    protected static final GregorianCalendar DEFAULT_CALANDER = new GregorianCalendar();
    public Type type = Type.NULL;
    public static AJLColor.ColorScale colorScale = AJLColor.ColorScale.BATLOW;
    protected boolean initialized = false;
    protected double otimeColorMapRangeDays = 0.0;

    public SeismicityColorMap(Type type) {
        this.type = type;
        this.initialized = false;
    }

    public SeismicityColorMap(Type type, AJLColor.ColorScale colorScale) {
        this.type = type;
        SeismicityColorMap.colorScale = colorScale;
        this.initialized = false;
    }

    public SeismicityColorMap(Type type, double[] dArray, Color[] colorArray) {
        super(dArray, colorArray);
        this.type = type;
        this.initialized = true;
    }

    public SeismicityColorMap(Type type, String string) throws Exception {
        super(string);
        this.type = type;
        this.initialized = true;
    }

    public static SeismicityColorMap createSeismicityColorMap(String string) throws Exception {
        String[] stringArray = string.split("[;#]");
        Type type = SeismicityColorMap.typeFor(stringArray[0]);
        if (stringArray.length > 1) {
            String string2;
            int n = string.indexOf(";");
            if (n < 0) {
                n = string.indexOf("#");
            }
            if (!(string2 = string.substring(n + 1)).contains(",")) {
                return new SeismicityColorMap(type, AJLColor.colorScale(string2));
            }
            if (type.equals((Object)Type.OTIME)) {
                return SeismicityColorMap.createOTimeColorMap(string2);
            }
            return new SeismicityColorMap(type, string2);
        }
        return new SeismicityColorMap(type);
    }

    public static SeismicityColorMap createOTimeColorMap(String string) throws Exception {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        double d = 0.0;
        double d2 = 0.0;
        String[] stringArray = string.split("[;#]");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringExt.parse(stringArray[i], ",");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = Integer.parseInt(stringArray2[2]);
            int n4 = 0;
            int n5 = 0;
            double d3 = 0.0;
            int n6 = 3;
            if (stringArray2.length > 6) {
                n4 = Integer.parseInt(stringArray2[3]);
                n5 = Integer.parseInt(stringArray2[4]);
                d3 = Float.parseFloat(stringArray2[5]);
                n6 = 6;
            }
            double d4 = SeisEvent.calcTimeInMillis(DEFAULT_CALANDER, n, n2, n3, n4, n5, d3);
            if (i == 0) {
                d = d4;
            } else if (i == stringArray.length - 1) {
                d2 = d4;
            }
            stringBuffer.append(d4).append(',');
            stringBuffer.append(stringArray2[n6]);
            if (stringArray2.length > n6 + 1) {
                stringBuffer.append(',').append(stringArray2[n6 + 1]);
            }
            if (stringArray2.length > n6 + 2) {
                stringBuffer.append(',').append(stringArray2[n6 + 2]);
            }
            if (stringArray2.length > n6 + 3) {
                stringBuffer.append(',').append(stringArray2[n6 + 3]);
            }
            stringBuffer.append(';');
        }
        SeismicityColorMap seismicityColorMap = new SeismicityColorMap(Type.OTIME, stringBuffer.toString());
        seismicityColorMap.otimeColorMapRangeDays = (d2 - d) / 8.64E7;
        return seismicityColorMap;
    }

    @Override
    public void setNodeValuesAndColors(double[] dArray, Color[] colorArray) {
        super.setNodeValuesAndColors(dArray, colorArray);
        this.initialized = true;
    }

    public static Type typeFor(String string) {
        for (Type type : Type.values()) {
            if (!string.equalsIgnoreCase(SeismicityColorMap.getName(type))) continue;
            return type;
        }
        return Type.NULL;
    }

    public static String getName(Type type) {
        switch (type) {
            case DEPTH: {
                return "Depth";
            }
            case OTIME: {
                return "OTime";
            }
            case MONTH: {
                return "Month";
            }
            case RMS: {
                return "RMS";
            }
            case ERRH: {
                return "ErrH";
            }
            case ERRZ: {
                return "ErrZ";
            }
            case NPHS: {
                return "Nphs";
            }
            case GAP: {
                return "Gap";
            }
            case DIST: {
                return "Dist";
            }
            case MAG_AMP: {
                return "Mamp";
            }
            case MAG_DUR: {
                return "Mdur";
            }
            case EVT_NUM: {
                return "Evt_Num";
            }
        }
        return "NULL";
    }

    public String getName() {
        return SeismicityColorMap.getName(this.type);
    }

    public String getUnits() {
        switch (this.type) {
            case DEPTH: {
                return "km";
            }
            case OTIME: {
                return "";
            }
            case MONTH: {
                return "";
            }
            case RMS: {
                return "sec";
            }
            case ERRH: {
                return "km";
            }
            case ERRZ: {
                return "km";
            }
            case NPHS: {
                return "";
            }
            case GAP: {
                return "deg";
            }
            case DIST: {
                return "km";
            }
            case MAG_AMP: {
                return "";
            }
            case MAG_DUR: {
                return "";
            }
            case EVT_NUM: {
                return "";
            }
        }
        return "NULL";
    }

    @Override
    public String stringValueOf(double d) {
        if (this.type.equals((Object)Type.OTIME)) {
            DEFAULT_CALANDER.setTimeInMillis((long)(d + 0.5));
            String string = SeisEvent.intString(DEFAULT_CALANDER.get(1), 4);
            if (this.otimeColorMapRangeDays < 3650.0) {
                string = string + SeisEvent.intString(DEFAULT_CALANDER.get(2) + 1, 2) + SeisEvent.intString(DEFAULT_CALANDER.get(5), 2);
                if (this.otimeColorMapRangeDays < 10.0) {
                    string = string + "-" + SeisEvent.intString(DEFAULT_CALANDER.get(11), 2) + "h";
                }
            }
            return string;
        }
        return super.stringValueOf(d);
    }

    public static enum Type {
        NULL,
        DEPTH,
        OTIME,
        MONTH,
        RMS,
        ERRH,
        ERRZ,
        NPHS,
        GAP,
        DIST,
        MAG_AMP,
        MAG_DUR,
        EVT_NUM;

    }
}

