/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.alomax.awt.AJLColor;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public class Text3D {
    protected String theString = null;
    protected Color color;
    protected Vect3D posVec;
    protected Vect3D[] textCoords;

    public Text3D(ASCIIInputStream aSCIIInputStream, Component component, double d, double d2, boolean bl) throws Exception {
        this(aSCIIInputStream, component, d, d2, bl, 1.0);
    }

    public Text3D(ASCIIInputStream aSCIIInputStream, Component component, double d, double d2, boolean bl, double d3) throws Exception {
        Object object;
        float f;
        String string;
        float f2;
        float f3;
        int n = 0;
        int n2 = 0;
        Vect3D vect3D = null;
        Vect3D vect3D2 = null;
        double d4 = 1.0;
        String string2 = null;
        int n3 = -1;
        this.theString = aSCIIInputStream.readWord();
        while (this.theString.trim().startsWith("#")) {
            aSCIIInputStream.flushLine();
            this.theString = aSCIIInputStream.readWord();
        }
        if (this.theString.charAt(0) == '\"') {
            this.theString = this.theString.substring(1);
            while (!this.theString.endsWith("\"")) {
                this.theString = this.theString + aSCIIInputStream.readChar();
            }
            this.theString = this.theString.substring(0, this.theString.length() - 1);
        }
        this.theString = ASCIIInputStream.convertUnicodeToEscapedUnicode(this.theString);
        n = aSCIIInputStream.readInt();
        n2 = aSCIIInputStream.readInt();
        String string3 = aSCIIInputStream.readWord();
        string3 = string3.toUpperCase();
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (string3.compareTo("XYZ") == 0) {
            f4 = aSCIIInputStream.readFloat();
            f5 = aSCIIInputStream.readFloat();
            f6 = aSCIIInputStream.readFloat();
            this.posVec = new Vect3D(f4, f5, f6);
        } else if (string3.compareTo("LATLONDM") == 0) {
            f3 = aSCIIInputStream.readInt();
            f2 = aSCIIInputStream.readFloat();
            string = aSCIIInputStream.readWord();
            f3 = (string = string.toUpperCase()).compareTo("N") == 0 ? f3 : -(f3 += f2 / 60.0f);
            float f7 = aSCIIInputStream.readInt();
            f = aSCIIInputStream.readFloat();
            String string4 = aSCIIInputStream.readWord();
            string4 = string4.toUpperCase();
            f7 = string4.compareTo("E") == 0 ? f7 : -(f7 += f / 60.0f);
            f6 = aSCIIInputStream.readFloat();
            this.posVec = ((SeismicityFrame)component).geogCoords.geog2xyz(f3, f7, -f6);
        } else if (string3.compareTo("LATLON") == 0) {
            f3 = aSCIIInputStream.readFloat();
            f2 = aSCIIInputStream.readFloat();
            f6 = aSCIIInputStream.readFloat();
            this.posVec = ((SeismicityFrame)component).geogCoords.geog2xyz(f3, f2, -f6);
        } else if (string3.compareTo("LONLAT") == 0) {
            f3 = aSCIIInputStream.readFloat();
            f2 = aSCIIInputStream.readFloat();
            f6 = aSCIIInputStream.readFloat();
            this.posVec = ((SeismicityFrame)component).geogCoords.geog2xyz(f2, f3, -f6);
        }
        f4 = aSCIIInputStream.readFloat();
        f5 = aSCIIInputStream.readFloat();
        f6 = aSCIIInputStream.readFloat();
        vect3D = new Vect3D(f4, f5, f6);
        f4 = aSCIIInputStream.readFloat();
        f5 = aSCIIInputStream.readFloat();
        f6 = aSCIIInputStream.readFloat();
        vect3D2 = new Vect3D(f4, f5, f6);
        String string5 = aSCIIInputStream.readWord();
        String string6 = aSCIIInputStream.readWord();
        string = aSCIIInputStream.readWord();
        try {
            int n4 = Integer.valueOf(string5);
            int n5 = Integer.valueOf(string6);
            int n6 = Integer.valueOf(string);
            this.color = new Color(n4, n5, n6);
        }
        catch (NumberFormatException numberFormatException) {
            f = Float.valueOf(string5).floatValue();
            float f8 = Float.valueOf(string6).floatValue();
            float f9 = Float.valueOf(string).floatValue();
            this.color = new Color(f, f8, f9);
        }
        d4 = aSCIIInputStream.readDouble();
        d4 *= d3;
        String[] stringArray = StringExt.parse(aSCIIInputStream.readLine());
        try {
            object = stringArray[0];
            n3 = ((String)object).equalsIgnoreCase("PLAIN") ? 0 : (((String)object).equalsIgnoreCase("BOLD") ? 1 : (((String)object).equalsIgnoreCase("ITALIC") ? 2 : (((String)object).equalsIgnoreCase("BOLD+ITALIC") ? 3 : 0)));
            string2 = stringArray[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.theString != null) {
            object = new StringVectorizer(this.theString, component, string2, n3, -1, d * d4);
            this.textCoords = ((StringVectorizer)object).toWorldCoords(d4 * d2, n, n2, vect3D, vect3D2);
            if (bl) {
                this.textCoords = StringVectorizer.transformToUpOnSphere(this.textCoords, this.posVec);
            }
        }
    }

    public void invertColor() {
        this.color = AJLColor.invert(this.color);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.color);
        StringVectorizer.paint(graphics, this.textCoords, this.posVec.x, this.posVec.y, this.posVec.z, true);
    }
}

