/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.alomax.awt.AJLColor;

public class AJLJButton
extends JButton {
    public static final int TARGET_SIZE = 25;
    public static Dimension prefferedSize = null;
    public static final int AJLJBUTTON_ACTION_EVENT = -1234;
    protected static TimeMonitor timeMonitor = null;
    protected boolean timeMonitorFiredActionPerformed = false;
    protected int timeMonitorSleepTime = 50;
    protected int timeMonitorInitSleepTime = 200;
    protected String label = "";
    protected boolean repeat = false;
    protected boolean inButton = false;
    protected boolean mouseDown = false;
    protected Color controlText = AJLColor.controlText;
    protected Color control = AJLColor.control;
    protected Color controlHighlight = AJLColor.controlHighlight;
    protected Color controlShadow = AJLColor.controlShadow;
    protected Color controlButtonHighlight = this.controlHighlight;

    public AJLJButton(String string) {
        super(string);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setOpaque(true);
        this.enableEvents(8L);
    }

    public AJLJButton(ActionListener actionListener, KeyListener keyListener, String string, boolean bl) {
        this(actionListener, keyListener, string);
        this.repeat = bl;
    }

    public AJLJButton(ActionListener actionListener, KeyListener keyListener, String string) {
        this(string);
        this.addActionListener(actionListener);
        this.addKeyListener(keyListener);
        this.enableEvents(8L);
    }

    public void setImage(Image image) {
        this.setCustomPreferedSize();
        this.setIcon(new ImageIcon(image.getScaledInstance(AJLJButton.prefferedSize.width, AJLJButton.prefferedSize.height, 4)));
    }

    public void setCustomPreferedSize() {
        this.setCustomPreferedSize(25);
    }

    public void setCustomPreferedSize(int n) {
        if (prefferedSize == null) {
            Dimension dimension = this.getToolkit().getScreenSize();
            int n2 = n * dimension.height / 1024;
            if (n2 < n) {
                n2 = n;
            }
            prefferedSize = new Dimension(n2, n2);
        }
        this.setPreferredSize(prefferedSize);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.repeat) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.mouseDown = true;
                    if (timeMonitor != null) {
                        timeMonitor.stop();
                    }
                    timeMonitor = new TimeMonitor(this.timeMonitorInitSleepTime, this.timeMonitorSleepTime);
                    timeMonitor.start();
                    this.repaint();
                    break;
                }
                case 502: {
                    if (timeMonitor != null) {
                        timeMonitor.stop();
                        timeMonitor = null;
                    }
                    if (!this.timeMonitorFiredActionPerformed) {
                        this.notifyListener();
                    }
                    this.mouseDown = false;
                    this.repaint();
                    break;
                }
                case 505: {
                    if (timeMonitor != null) {
                        timeMonitor.stop();
                        timeMonitor = null;
                    }
                    this.mouseDown = false;
                    this.repaint();
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                    break;
                }
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void setRepeatSleepTimes(int n, int n2) {
        this.timeMonitorSleepTime = n;
    }

    protected void notifyListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AJLJButton.this.actionListener != null) {
                    AJLJButton.this.actionListener.actionPerformed(new ActionEvent(this, -1234, "AJLJBUTTON_ACTION_EVENT"));
                }
            }
        });
    }

    public void setColors(Color color, Color color2) {
        if (color != null) {
            this.controlText = color;
        }
        super.setForeground(this.controlText);
        if (color2 != null) {
            this.control = color2;
            this.controlButtonHighlight = AJLColor.lighter(AJLColor.lighter(AJLColor.lighter(color2)));
        }
        super.setBackground(this.control);
    }

    public void setColorsInverted() {
        this.setColors(AJLColor.control, AJLColor.controlText);
        this.repaint();
    }

    public void setColorsDefault() {
        this.setColors(AJLColor.controlText, AJLColor.control);
        this.repaint();
    }

    class TimeMonitor
    extends Timer {
        TimeMonitor(int n, int n2) {
            super(n2, AJLJButton.this.actionListener);
            this.setInitialDelay(n);
            this.setCoalesce(true);
            this.setRepeats(true);
            AJLJButton.this.timeMonitorFiredActionPerformed = false;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AJLJButton.this.timeMonitorFiredActionPerformed = true;
                }
            });
        }
    }
}

