/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.alomax.swing.JPolygonButton;
import net.alomax.swing.NavigationActionEvent;
import net.alomax.swing.NavigationListener;
import net.alomax.swing.SwingText;

public class NavigationPanel
extends JPanel
implements KeyListener,
ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected NavigationListener navigationListener = null;
    protected JPolygonButton rotateUp;
    protected JPolygonButton rotateDown;
    protected JPolygonButton rotateLeft;
    protected JPolygonButton rotateRight;
    protected JPolygonButton azimuthLeft;
    protected JPolygonButton azimuthRight;
    protected JPolygonButton panUp;
    protected JPolygonButton panDown;
    protected JPolygonButton panLeft;
    protected JPolygonButton panRight;
    protected JPolygonButton panUpRight;
    protected JPolygonButton panDownLeft;
    protected JPolygonButton panUpLeft;
    protected JPolygonButton panDownRight;
    protected JPolygonButton zoomIn;
    protected JPolygonButton zoomOut;
    protected JPolygonButton resetButton;
    protected JPolygonButton globalButton;
    protected Component panComponent = null;
    protected Point mousePressedPosition = null;
    protected Color zoomPanBackgroundColor = Color.BLUE;
    int icount = 0;
    protected int keyCount = 0;
    protected boolean ctrlWasPressed = false;

    public NavigationPanel(NavigationListener navigationListener, KeyListener keyListener) {
        this(navigationListener, keyListener, false, false, true, true, true, true, null, null);
    }

    public NavigationPanel(NavigationListener navigationListener, KeyListener keyListener, boolean bl, Component component, Color color) {
        this(navigationListener, keyListener, true, true, true, true, false, false, component, color);
    }

    protected NavigationPanel(NavigationListener navigationListener, KeyListener keyListener, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Component component, Color color) {
        this.navigationListener = navigationListener;
        this.addMouseWheelListener(this);
        this.panComponent = component;
        if (color != null) {
            this.zoomPanBackgroundColor = color;
        }
        int n = 0;
        if (bl3) {
            ++n;
        }
        if (bl4) {
            n += 3;
        }
        if (bl5) {
            ++n;
        }
        if (bl6) {
            n += 3;
        }
        this.rotateUp = new JPolygonButton(JPolygonButton.UP_ARROW, this, this, true);
        this.rotateDown = new JPolygonButton(JPolygonButton.DOWN_ARROW, this, this, true);
        this.rotateLeft = new JPolygonButton(JPolygonButton.LEFT_ARROW, this, this, true);
        this.rotateRight = new JPolygonButton(JPolygonButton.RIGHT_ARROW, this, this, true);
        this.rotateUp.setRepeatSleepTimes(100, 20);
        this.rotateDown.setRepeatSleepTimes(100, 20);
        this.rotateLeft.setRepeatSleepTimes(100, 20);
        this.rotateRight.setRepeatSleepTimes(100, 20);
        this.rotateUp.setPolygonColors(Color.WHITE, Color.WHITE, Color.YELLOW.darker());
        this.rotateDown.setPolygonColors(Color.WHITE, Color.WHITE, Color.YELLOW.darker());
        this.rotateLeft.setPolygonColors(Color.WHITE, Color.WHITE, Color.YELLOW.darker());
        this.rotateRight.setPolygonColors(Color.WHITE, Color.WHITE, Color.YELLOW.darker());
        this.zoomIn = new JPolygonButton(JPolygonButton.PLUS, this, this, true);
        this.zoomOut = new JPolygonButton(JPolygonButton.MINUS, this, this, true);
        this.resetButton = new JPolygonButton(JPolygonButton.CIRCLE_ARROW_IN, this, this, true);
        this.resetButton.setToolTipText(SwingText.INITIAL_VIEW);
        this.globalButton = new JPolygonButton(JPolygonButton.DIVERGING_ARROWS, this, this, true);
        this.globalButton.setToolTipText(SwingText.FULL_VIEW);
        this.zoomIn.setRepeatSleepTimes(100, 20);
        this.zoomOut.setRepeatSleepTimes(100, 20);
        this.zoomIn.setPolygonColors(Color.WHITE, Color.WHITE, Color.GREEN.darker());
        this.zoomOut.setPolygonColors(Color.WHITE, Color.WHITE, Color.GREEN.darker());
        this.resetButton.setPolygonColors(Color.WHITE, Color.WHITE, Color.BLACK);
        this.globalButton.setPolygonColors(Color.WHITE, Color.WHITE, Color.BLACK);
        this.panUp = new JPolygonButton(JPolygonButton.UP_ARROW, this, this, true);
        this.panDown = new JPolygonButton(JPolygonButton.DOWN_ARROW, this, this, true);
        this.panLeft = new JPolygonButton(JPolygonButton.LEFT_ARROW, this, this, true);
        this.panRight = new JPolygonButton(JPolygonButton.RIGHT_ARROW, this, this, true);
        this.panUp.setRepeatSleepTimes(100, 20);
        this.panDown.setRepeatSleepTimes(100, 20);
        this.panLeft.setRepeatSleepTimes(100, 20);
        this.panRight.setRepeatSleepTimes(100, 20);
        this.panUp.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panDown.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panLeft.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panRight.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panUpLeft = new JPolygonButton(JPolygonButton.UP_LEFT_ARROW, this, this, true);
        this.panDownRight = new JPolygonButton(JPolygonButton.DOWN_RIGHT_ARROW, this, this, true);
        this.panDownLeft = new JPolygonButton(JPolygonButton.DOWN_LEFT_ARROW, this, this, true);
        this.panUpRight = new JPolygonButton(JPolygonButton.UP_RIGHT_ARROW, this, this, true);
        this.panUpLeft.setRepeatSleepTimes(100, 20);
        this.panDownRight.setRepeatSleepTimes(100, 20);
        this.panDownLeft.setRepeatSleepTimes(100, 20);
        this.panUpRight.setRepeatSleepTimes(100, 20);
        this.panUpLeft.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panDownRight.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panDownLeft.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.panUpRight.setPolygonColors(Color.WHITE, Color.WHITE, this.zoomPanBackgroundColor);
        this.azimuthLeft = new JPolygonButton(JPolygonButton.LEFT_ARROW, this, this, true);
        this.azimuthRight = new JPolygonButton(JPolygonButton.RIGHT_ARROW, this, this, true);
        this.azimuthLeft.setRepeatSleepTimes(100, 20);
        this.azimuthRight.setRepeatSleepTimes(100, 20);
        this.azimuthLeft.setPolygonColors(Color.WHITE, Color.WHITE, Color.RED.darker());
        this.azimuthRight.setPolygonColors(Color.WHITE, Color.WHITE, Color.RED.darker());
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new GridLayout(1, 0));
            jPanel.setBackground(this.zoomPanBackgroundColor);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
            jPanel2.setBackground(this.zoomPanBackgroundColor);
            if (bl3) {
                jPanel.add(new JLabel());
                jPanel.add(new JLabel());
                jPanel.add(this.zoomOut);
                this.zoomOut.setToolTipText(SwingText.ZOOM_OUT);
                if (bl) {
                    jPanel2.add(this.resetButton);
                }
                if (bl2) {
                    jPanel2.add(this.globalButton);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(new JLabel());
                jPanel.add(this.zoomIn);
                this.zoomIn.setToolTipText(SwingText.ZOOM_IN);
            }
            if (bl4) {
                JPanel jPanel3 = new JPanel(new BorderLayout());
                JPanel jPanel4 = new JPanel(new BorderLayout());
                JPanel jPanel5 = new JPanel(new BorderLayout());
                jPanel5.add((Component)jPanel, "West");
                jPanel5.add((Component)jPanel2, "East");
                jPanel4.add((Component)this.panUpLeft, "West");
                jPanel5.add((Component)this.panUp, "Center");
                jPanel4.add((Component)jPanel5, "Center");
                jPanel4.add((Component)this.panUpRight, "East");
                jPanel3.add((Component)jPanel4, "North");
                jPanel3.add((Component)this.panLeft, "West");
                jPanel3.add(component, "Center");
                jPanel3.add((Component)this.panRight, "East");
                JPanel jPanel6 = new JPanel(new BorderLayout());
                jPanel6.add((Component)this.panDownLeft, "West");
                jPanel6.add((Component)this.panDown, "Center");
                jPanel6.add((Component)this.panDownRight, "East");
                jPanel3.add((Component)jPanel6, "South");
                this.add((Component)jPanel3, "Center");
            } else {
                this.add((Component)jPanel, "West");
                this.add((Component)jPanel2, "East");
            }
        } else {
            JLabel jLabel;
            this.setLayout(new GridLayout(n, 3, 0, 0));
            if (bl3) {
                this.add(this.zoomOut);
                jLabel = new JLabel("Zm", 0);
                jLabel.setOpaque(true);
                jLabel.setForeground(Color.WHITE);
                jLabel.setBackground(Color.GREEN.darker().darker());
                jLabel.setToolTipText(SwingText.ZOOM_TIP);
                this.add(jLabel);
                this.add(this.zoomIn);
            }
            if (bl4) {
                this.add(new JPanel());
                this.add(this.panUp);
                this.add(new JPanel());
                this.add(this.panLeft);
                jLabel = new JLabel("Pan", 0);
                jLabel.setOpaque(true);
                jLabel.setForeground(Color.WHITE);
                jLabel.setBackground(this.zoomPanBackgroundColor.darker());
                jLabel.setToolTipText(SwingText.PAN_TIP);
                this.add(jLabel);
                this.add(this.panRight);
                this.add(new JPanel());
                this.add(this.panDown);
                this.add(new JPanel());
            }
            if (bl5) {
                this.add(this.azimuthLeft);
                jLabel = new JLabel("Az", 0);
                jLabel.setOpaque(true);
                jLabel.setForeground(Color.WHITE);
                jLabel.setBackground(Color.RED.darker().darker());
                jLabel.setToolTipText(SwingText.AZIMUTH_TIP);
                this.add(jLabel);
                this.add(this.azimuthRight);
            }
            if (bl6) {
                this.add(new JPanel());
                this.add(this.rotateUp);
                this.add(new JPanel());
                this.add(this.rotateLeft);
                jLabel = new JLabel("Rot", 0);
                jLabel.setOpaque(true);
                jLabel.setForeground(Color.WHITE);
                jLabel.setBackground(Color.YELLOW.darker().darker());
                jLabel.setToolTipText(SwingText.ROTATE_TIP);
                this.add(jLabel);
                this.add(this.rotateRight);
                this.add(new JPanel());
                this.add(this.rotateDown);
                this.add(new JPanel());
            }
        }
        this.setBorder(new LineBorder(Color.BLACK, 2, true));
        this.enableEvents(8L);
        this.addKeyListener(this);
        this.addKeyListener(keyListener);
    }

    public void fireNavigationActionEvent(int n, int n2) {
        this.fireNavigationActionEvent(n, n2, 0, 0);
    }

    public void fireNavigationActionEvent(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        String string = null;
        NavigationActionEvent navigationActionEvent = new NavigationActionEvent(this, n5, string, n6, n3, n4);
        this.navigationListener.navigationPerformed(navigationActionEvent);
    }

    public void fireNavigationActionEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n2;
        String string = null;
        NavigationActionEvent navigationActionEvent = new NavigationActionEvent(this, n7, string, n8, n3, n4, n5, n6);
        this.navigationListener.navigationPerformed(navigationActionEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource().equals(this.rotateLeft)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_LEFT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.rotateRight)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_RIGHT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.rotateUp)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_UP, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.rotateDown)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_DOWN, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.azimuthLeft)) {
            this.fireNavigationActionEvent(NavigationActionEvent.AZIMUTH_CLOCKWISE, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.azimuthRight)) {
            this.fireNavigationActionEvent(NavigationActionEvent.AZIMUTH_COUNTERCLOCKWISE, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panLeft)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_LEFT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panRight)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_RIGHT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panUp)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_UP, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panDown)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_DOWN, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panUpLeft)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_UP_LEFT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panDownRight)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_DOWN_RIGHT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panUpRight)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_UP_RIGHT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.panDownLeft)) {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_DOWN_LEFT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.zoomIn)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ZOOM_IN, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.zoomOut)) {
            this.fireNavigationActionEvent(NavigationActionEvent.ZOOM_OUT, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.resetButton)) {
            this.fireNavigationActionEvent(NavigationActionEvent.RESET, actionEvent.getModifiers());
        } else if (actionEvent.getSource().equals(this.globalButton)) {
            this.fireNavigationActionEvent(NavigationActionEvent.GLOBAL, actionEvent.getModifiers());
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        System.out.println("NavigationPanel DEBUG: keyPressed: key: " + n + ",  VK_SHIFT: " + 16 + ",  VK_ALT: " + 18);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        System.out.println("NavigationPanel DEBUG: keyReleased: key: " + n + ",  VK_SHIFT: " + 16 + ",  VK_ALT: " + 18);
        if (n != 10) {
            if (n == 37) {
                this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_LEFT, keyEvent.getModifiersEx());
            } else if (n == 39) {
                this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_RIGHT, keyEvent.getModifiersEx());
            } else if (n == 38) {
                this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_UP, keyEvent.getModifiersEx());
            } else if (n == 40) {
                this.fireNavigationActionEvent(NavigationActionEvent.ROTATE_DOWN, keyEvent.getModifiersEx());
            } else if (n == 9) {
                // empty if block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        System.out.println("NavigationPanel DEBUG: keyTyped: key: " + n + ",  VK_SHIFT: " + 16 + ",  VK_ALT: " + 18);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getWheelRotation();
            if (n > 0) {
                this.fireNavigationActionEvent(NavigationActionEvent.ZOOM_OUT, mouseWheelEvent.getModifiersEx());
            } else if (n < 0) {
                this.fireNavigationActionEvent(NavigationActionEvent.ZOOM_IN, mouseWheelEvent.getModifiersEx());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ctrlWasPressed) {
            this.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.mousePressedPosition == null) {
            this.mousePressedPosition = point;
            return;
        }
        int n = point.x - this.mousePressedPosition.x;
        int n2 = point.y - this.mousePressedPosition.y;
        int n3 = 128;
        if (this.ctrlWasPressed || (mouseEvent.getModifiersEx() & n3) == n3) {
            this.fireNavigationActionEvent(NavigationActionEvent.BOX_DRAG, mouseEvent.getModifiersEx(), point.x, point.y, n, n2);
            this.ctrlWasPressed = true;
        } else {
            this.fireNavigationActionEvent(NavigationActionEvent.PAN_OBLIQUE, mouseEvent.getModifiersEx(), n, n2);
            this.mousePressedPosition = point;
            this.ctrlWasPressed = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = point.x - this.panComponent.getWidth() / 2;
        int n2 = point.y - this.panComponent.getHeight() / 2;
        this.fireNavigationActionEvent(NavigationActionEvent.PAN_OBLIQUE, mouseEvent.getModifiersEx(), -n, -n2);
        this.ctrlWasPressed = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressedPosition = mouseEvent.getPoint();
        int n = 128;
        this.ctrlWasPressed = (mouseEvent.getModifiersEx() & n) == n;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.ctrlWasPressed) {
            Point point = mouseEvent.getPoint();
            int n = point.x - this.mousePressedPosition.x;
            int n2 = point.y - this.mousePressedPosition.y;
            this.fireNavigationActionEvent(NavigationActionEvent.BOX_DEFINED, mouseEvent.getModifiersEx(), point.x, point.y, n, n2);
        }
        this.ctrlWasPressed = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mousePressedPosition = null;
    }
}

