/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.alomax.image.ImageException;
import net.alomax.io.GeneralInputStream;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JPolygonButton;
import net.alomax.swing.LeftRightJButton;
import net.alomax.swing.SwingText;

public class SwingExt {
    public static int defaultBorderWidth = 10;
    public static Border defaultEmptyBorder = BorderFactory.createEmptyBorder(defaultBorderWidth, defaultBorderWidth, defaultBorderWidth, defaultBorderWidth);

    public static JMenuItem newJMenuItem(ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenuItem newJMenuItem(ActionListener actionListener, String string, MenuShortcut menuShortcut) {
        JMenuItem jMenuItem = new JMenuItem(string, menuShortcut.getKey());
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(ItemListener itemListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        if (itemListener != null) {
            jCheckBoxMenuItem.addItemListener(itemListener);
        }
        return jCheckBoxMenuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItemActionListener(ActionListener actionListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        if (actionListener != null) {
            jCheckBoxMenuItem.addActionListener(actionListener);
        }
        return jCheckBoxMenuItem;
    }

    public static JButton newJButton(ActionListener actionListener, KeyListener keyListener, String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        jButton.addKeyListener(keyListener);
        return jButton;
    }

    public static JCheckBox newJCheckBox(ItemListener itemListener, String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        if (itemListener != null) {
            jCheckBox.addItemListener(itemListener);
        }
        return jCheckBox;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, String string, int n) {
        JTextField jTextField = new JTextField(string, n);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        SwingExt.addActionPerformedWhenFocusLost(jTextField, actionListener);
        return jTextField;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        SwingExt.addActionPerformedWhenFocusLost(jTextField, actionListener);
        return jTextField;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        SwingExt.addActionPerformedWhenFocusLost(jTextField, actionListener);
        return jTextField;
    }

    protected static void addActionPerformedWhenFocusLost(JComponent jComponent, final ActionListener actionListener) {
        if (actionListener != null) {
            jComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    actionListener.actionPerformed(new ActionEvent(focusEvent.getSource(), focusEvent.getID(), null));
                }
            });
        }
    }

    public static JComboBox newChoice(ItemListener itemListener, String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        if (itemListener != null) {
            jComboBox.addItemListener(itemListener);
        }
        return jComboBox;
    }

    public static JLabel initPanelLabel(String string, JToolBar jToolBar) {
        JLabel jLabel = new JLabel(string, 2);
        jToolBar.add(jLabel);
        return jLabel;
    }

    public static JLabel initPanelLabel(String string, int n, JToolBar jToolBar) {
        JLabel jLabel = new JLabel(string, n);
        jToolBar.add(jLabel);
        return jLabel;
    }

    public static AJLJButton initPanelButton(String string, JToolBar jToolBar, ActionListener actionListener, KeyListener keyListener) {
        AJLJButton aJLJButton = new AJLJButton(actionListener, keyListener, string);
        jToolBar.add(aJLJButton);
        return aJLJButton;
    }

    public static LeftRightJButton initPanelLeftRightButton(JToolBar jToolBar, ActionListener actionListener, KeyListener keyListener) {
        LeftRightJButton leftRightJButton = new LeftRightJButton(actionListener, keyListener);
        jToolBar.add(leftRightJButton);
        return leftRightJButton;
    }

    public static JPolygonButton initPanelPolygonButton(Polygon[] polygonArray, JPanel jPanel, ActionListener actionListener, KeyListener keyListener, boolean bl) {
        JPolygonButton jPolygonButton = new JPolygonButton(polygonArray, "", actionListener, keyListener, bl);
        jPanel.add(jPolygonButton);
        return jPolygonButton;
    }

    public static void setLocationToCenter(Component component, Component component2, Point point) {
        SwingExt.setLocationToCenter(component, component2, point, 0.0);
    }

    public static void setLocationToCenter(Component component, Component component2, Point point, double d) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        int n3 = (int)(d * (double)dimension2.width);
        int n4 = (int)(d * (double)dimension2.height);
        component.setLocation(point.x + n + n3, point.y + n2 + n4);
    }

    public static void setLocationToCenterOfScreen(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        component.setLocation(n, n2);
    }

    public static void setLocationToLeftCenterOfScreen(Component component) {
        int n;
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = n = dimension2.height / 2 - dimension.height / 2;
        component.setLocation(n2, n);
    }

    public static void setLocationOnScreen(Component component, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)((double)dimension.width * d);
        int n2 = (int)((double)dimension.height * d2);
        component.setLocation(n, n2);
    }

    public static boolean setLocationAndSizeToLeftOf(Component component, Component component2, int n, int n2, int n3) {
        Point point = component2.getLocationOnScreen();
        int n4 = point.x < n2 ? 0 : point.x - n2;
        int n5 = point.y;
        component.setLocation(n4, n5);
        if (n3 > 0) {
            component.setSize(point.x - n4, n3);
        }
        return point.x >= n;
    }

    public static void setProportionalSize(Component component, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d2));
    }

    public static void setProportionalSize(Component component, double d, double d2, double d3) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d4 = (double)dimension.width * d;
        double d5 = (double)dimension.height * d2;
        if (dimension.height > dimension.width && d5 / d4 > 1.0 / d3) {
            d5 = d4 / d3;
        }
        if (dimension.width > dimension.height && d4 / d5 > 1.0 / d3) {
            d4 = d5 / d3;
        }
        component.setSize((int)d4, (int)d5);
    }

    public static void setProportionalSize(Component component, Component component2, double d, double d2) {
        Dimension dimension = component2.getSize();
        component.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d2));
    }

    public static boolean getTrueFalseParameter(Applet applet, String string, boolean bl) {
        String string2 = applet.getParameter(string);
        if (string2 != null) {
            return SwingExt.evaluateTrueFalseParameter(string, string2, bl);
        }
        return bl;
    }

    public static boolean evaluateTrueFalseParameter(String string, String string2, boolean bl) {
        if (string2 != null) {
            if (string2.toUpperCase().indexOf("YES") >= 0 || string2.toUpperCase().equals("Y") || string2.toUpperCase().indexOf("TRUE") >= 0 || string2.toUpperCase().indexOf("ON") >= 0) {
                return true;
            }
            if (string2.toUpperCase().indexOf("NO") >= 0 || string2.toUpperCase().equals("N") || string2.toUpperCase().indexOf("FALSE") >= 0 || string2.toUpperCase().indexOf("OFF") >= 0) {
                return false;
            }
        } else {
            System.err.println("ERROR: invalid value: " + string2 + ": for true/false parameter: " + string);
        }
        return bl;
    }

    public static Image getImageResource(Component component, String string) {
        return SwingExt.getImageResource(null, component, string);
    }

    public static Image getImageResource(Class clazz, Component component, String string) {
        Image image = null;
        try {
            URL uRL;
            if (clazz == null) {
                clazz = component.getClass();
            }
            if ((uRL = clazz.getResource(string)) == null && (uRL = clazz.getClassLoader().getResource(string)) == null) {
                throw new Exception();
            }
            image = component.getToolkit().createImage(uRL);
            if (image == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return null;
        }
        try {
            int n;
            boolean bl = component.prepareImage(image, null);
            int n2 = 0;
            while (n2++ < 50 && ((n = component.checkImage(image, null)) & 0x20) == 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public static boolean setImage(Component component, AJLJButton aJLJButton, String string) {
        Image image = SwingExt.getImageResource(component, string);
        if (image == null) {
            return false;
        }
        aJLJButton.setImage(image);
        return true;
    }

    public static boolean setImage(Class clazz, Component component, AJLJButton aJLJButton, String string) {
        Image image = SwingExt.getImageResource(clazz, component, string);
        if (image == null) {
            return false;
        }
        aJLJButton.setImage(image);
        return true;
    }

    public static BufferedImage readImage(URL uRL, String string) {
        Object var2_2 = null;
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
            if (!iterator.hasNext()) {
                throw new ImageException("SwingExt.createImageIcon(): Image type \"" + string2 + "\" not supported");
            }
            ImageReader imageReader = iterator.next();
            BufferedInputStream bufferedInputStream = null;
            ImageInputStream imageInputStream = null;
            BufferedImage bufferedImage = null;
            try {
                bufferedInputStream = new BufferedInputStream(GeneralInputStream.openStream(uRL, string, true));
                imageInputStream = ImageIO.createImageInputStream(bufferedInputStream);
                imageReader.setInput(imageInputStream);
                bufferedImage = imageReader.read(0);
            }
            catch (Exception exception) {
                System.out.println("\nERROR: Reading image file: " + string + " : " + exception);
                exception.printStackTrace();
                throw exception;
            }
            finally {
                try {
                    imageInputStream.flush();
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            String string3 = "ERROR: Cannot load image file: " + string + " (imgURL=" + var2_2 + ")";
            System.err.println(string3);
            return null;
        }
    }

    public static String checkExists(File file) {
        if (file.exists()) {
            Toolkit.getDefaultToolkit().beep();
            Object[] objectArray = new Object[]{SwingText.NO, SwingText.NO_FOR_ALL, SwingText.YES, SwingText.YES_FOR_ALL, SwingText.CANCEL};
            int n = JOptionPane.showOptionDialog(null, file.getName() + ": " + SwingText.FILE_EXISTS_DO_YOU_WANT_TO_REPLACE, SwingText.SAVE_AS, -1, 2, null, objectArray, objectArray[0]);
            if (n >= 0 && n < objectArray.length) {
                return (String)objectArray[n];
            }
            return SwingText.CANCEL;
        }
        return SwingText.YES;
    }
}

