/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

import java.text.DecimalFormat;

public class NumberFormat {
    public static final double INV_LOG10 = 1.0 / Math.log(10.0);
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    public static final DecimalFormat EXPONENTIAL_FORMAT = new DecimalFormat("0.E0");
    public static final char DECIMAL_SEPARATOR = DECIMAL_FORMAT.getDecimalFormatSymbols().getDecimalSeparator();
    private static final int MAXIMUM_EXPONENT = 8;

    public static final String decimalString(double d, int n) {
        return NumberFormat.decimalString(d, -1, n, false);
    }

    public static final String decimalString(double d, int n, int n2, boolean bl) {
        return NumberFormat.decimalString(d, n, n2, n2, bl);
    }

    public static final String decimalString(double d, int n, int n2, int n3, boolean bl) {
        double d2 = Math.abs(d);
        if (d2 > 1.0E7 || d2 < 1.0E-7 && d2 > Double.MIN_VALUE) {
            return NumberFormat.exponentialString(d, n2, n3);
        }
        DECIMAL_FORMAT.setMinimumFractionDigits(n2);
        DECIMAL_FORMAT.setMaximumFractionDigits(n3);
        DECIMAL_FORMAT.setGroupingUsed(false);
        String string = DECIMAL_FORMAT.format(d);
        if (bl) {
            string = NumberFormat.zeroPadString(string, n, n3);
        }
        return string;
    }

    public static final String exponentialString(double d, int n, int n2) {
        EXPONENTIAL_FORMAT.setMinimumFractionDigits(n);
        EXPONENTIAL_FORMAT.setMaximumFractionDigits(n2);
        String string = EXPONENTIAL_FORMAT.format(d);
        return string;
    }

    public static final String intString(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static final String prependBlanks(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    public static final String zeroPadString(String string, int n, int n2) {
        int n3;
        if (n2 > 0) {
            for (n3 = 0; n3 < 1000 && string.length() < n; ++n3) {
                if (string.indexOf(DECIMAL_SEPARATOR) >= 0) continue;
                string = string + ".";
            }
        }
        for (n3 = 0; n3 < 1000 && (n <= 0 || string.length() < n) && string.length() - string.indexOf(DECIMAL_SEPARATOR) - 1 < n2; ++n3) {
            string = string + "0";
        }
        for (n3 = 0; n3 < 1000 && string.length() < n; ++n3) {
            string = "0" + string;
        }
        return string;
    }

    public static final String removeTrailingZeros(String string) {
        if (string.indexOf(DECIMAL_SEPARATOR) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = stringBuffer.indexOf("E");
        if (n2 < 0) {
            n2 = stringBuffer.indexOf("e");
        }
        if (n2 >= 0) {
            n = n2;
        }
        for (int i = n - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '0') {
                if (c != DECIMAL_SEPARATOR) break;
                stringBuffer.delete(i, i + 1);
                break;
            }
            stringBuffer.delete(i, i + 1);
        }
        return stringBuffer.toString();
    }

    public static final String doubleString(double d) {
        return NumberFormat.doubleString(d, -1, -1, false);
    }

    public static final String doubleString(double d, int n) {
        return NumberFormat.doubleString(d, -1, n, false);
    }

    public static final String doubleString(double d, int n, int n2) {
        return NumberFormat.doubleString(d, n, n2, false);
    }

    public static final String doubleString(double d, int n, int n2, boolean bl) {
        int n3 = 0;
        double d2 = Math.abs(d);
        if (d2 > Double.MIN_VALUE) {
            n3 = (int)(Math.log(d2) * INV_LOG10);
        }
        boolean bl2 = false;
        String string = null;
        if (n3 < -3 || n3 > 4) {
            if (n2 < 0) {
                bl2 = true;
                n2 = 4;
            }
            string = NumberFormat.exponentialString(d, n2, n2);
        } else {
            if (n2 < 0) {
                bl2 = true;
                n2 = n3 <= 0 ? Math.abs(n3) + 5 : 4;
            }
            string = NumberFormat.decimalString(d, n, n2, n2, bl);
        }
        if (bl2) {
            string = NumberFormat.removeTrailingZeros(string);
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.indexOf("."));
        }
        return string;
    }

    public static final String floatString(float f, int n, int n2) {
        return NumberFormat.floatString(f, n, n2, true);
    }

    public static final String floatString(float f, int n, int n2, boolean bl) {
        return NumberFormat.doubleString(f, n, n2, bl);
    }

    public static final String StringValueOf(double d, int n) {
        return String.valueOf(d);
    }

    public static final String StringValueOf(float f, int n) {
        return String.valueOf(f);
    }

    public static int decimalPrecision(double d, double d2) {
        if (d2 >= 1.0) {
            return 0;
        }
        if (d2 < (double)1.4E-45f) {
            d2 = 1.4E-45f;
        }
        int n = (int)(-Math.log10(d2));
        int n2 = 0;
        d = Math.abs(d);
        while (Math.abs(d - (double)Math.round(d)) > d2) {
            d *= 10.0;
            if (++n2 < n) continue;
            break;
        }
        return n2;
    }

    public static float nearestPower10(double d) {
        double d2 = Math.pow(10.0, (int)(0.5 + Math.log(d) * INV_LOG10));
        return (float)d2;
    }

    public static double niceValue(double d) {
        double d2 = Math.pow(10.0, 1 + (int)(Math.log(d) * INV_LOG10));
        int n = 0;
        do {
            if (d2 > d) {
                d2 /= 2.0;
            }
            if (d2 > d) {
                d2 /= 2.5;
            }
            if (!(d2 > d)) continue;
            d2 /= 2.0;
        } while (d2 > d && n++ < 1000);
        return d2;
    }

    public static void main(String[] stringArray) {
        double d = 2.0E-10;
        double d2 = -9.0;
        double d3 = d / Math.pow(10.0, d2);
        double d4 = 1.0E-8;
        int n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: tickSpace=" + d + ", scalingExponent=" + d2 + ", decimalPrecision=" + n);
        System.out.println("");
        d = 0.02;
        d2 = -1.0;
        n = NumberFormat.decimalPrecision(d / Math.pow(10.0, d2), d4);
        System.out.println("Finished: tickSpace=" + d + ", scalingExponent=" + d2 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.23;
        d4 = 0.1;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.239;
        d4 = 0.01;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.3;
        d4 = 0.001;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.2999999;
        d4 = 0.001;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.255555;
        d4 = 0.001;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.222222;
        d4 = 0.001;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.277777;
        d4 = 0.001;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.999999;
        d4 = 0.01;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.999999;
        d4 = 0.1;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d3 = 1.999999;
        d4 = 1.0;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
        d4 = 10.0;
        n = NumberFormat.decimalPrecision(d3, d4);
        System.out.println("Finished: dval=" + d3 + ", accuracy=" + d4 + ", decimalPrecision=" + n);
        System.out.println("");
    }
}

