/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.jdk;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.logging.Log;

public class JDK12Hooks
extends JDKHooks {
    private static Log log = DiscoveryLogFactory.newLog(JDK12Hooks.class);
    private static final ClassLoader systemClassLoader = JDK12Hooks.findSystemClassLoader();

    public static void setLog(Log log) {
        JDK12Hooks.log = log;
    }

    @Override
    public String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
    }

    @Override
    public ClassLoader getThreadContextClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        return classLoader;
    }

    @Override
    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    @Override
    public Enumeration getResources(ClassLoader classLoader, String string) throws IOException {
        Enumeration enumeration;
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            log.debug("Could not find resource: " + string);
            enumeration = Collections.enumeration(Collections.EMPTY_LIST);
        } else {
            try {
                enumeration = classLoader.getResources(string);
            }
            catch (RuntimeException runtimeException) {
                log.error("Exception occured during attept to get " + string + " from " + uRL, runtimeException);
                enumeration = Collections.enumeration(Collections.EMPTY_LIST);
            }
            enumeration = JDK12Hooks.getResourcesFromUrl(uRL, enumeration);
        }
        return enumeration;
    }

    private static Enumeration getResourcesFromUrl(final URL uRL, final Enumeration enumeration) {
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = uRL == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL uRL2 = this.next;
                this.next = this.getNext();
                return uRL2;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL uRL2;
                if (!this.firstDone) {
                    this.firstDone = true;
                    uRL2 = uRL;
                } else {
                    uRL2 = null;
                    while (enumeration.hasMoreElements() && uRL2 == null) {
                        uRL2 = (URL)enumeration.nextElement();
                        if (uRL == null || uRL2 == null || !uRL2.equals(uRL)) continue;
                        uRL2 = null;
                    }
                }
                return uRL2;
            }
        };
    }

    private static ClassLoader findSystemClassLoader() {
        SecurityManager securityManager;
        ClassLoader classLoader;
        try {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        if (classLoader == null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkCreateClassLoader();
                classLoader = new PsuedoSystemClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return classLoader;
    }
}

