/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.log;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.log.SimpleLog;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryLogFactory {
    private static LogFactory logFactory = null;
    private static final Hashtable classRegistry = new Hashtable();
    private static final Class[] setLogParamClasses = new Class[]{Log.class};
    private static Log log = DiscoveryLogFactory._newLog(DiscoveryLogFactory.class);

    public static Log newLog(Class clazz) {
        try {
            Method method = ClassUtils.findPublicStaticMethod(clazz, Void.TYPE, "setLog", setLogParamClasses);
            if (method == null) {
                String string = "Internal Error: " + clazz.getName() + " required to implement 'public static void setLog(Log)'";
                log.fatal(string);
                throw new DiscoveryException(string);
            }
        }
        catch (SecurityException securityException) {
            String string = "Required Security Permissions not present";
            log.fatal(string, securityException);
            throw new DiscoveryException(string, securityException);
        }
        if (log.isDebugEnabled()) {
            log.debug("Class meets requirements: " + clazz.getName());
        }
        return DiscoveryLogFactory._newLog(clazz);
    }

    public static Log _newLog(Class clazz) {
        classRegistry.put(clazz, clazz);
        return logFactory == null ? new SimpleLog(clazz.getName()) : logFactory.getInstance(clazz.getName());
    }

    public static void setLog(Log log) {
        DiscoveryLogFactory.log = log;
    }

    public static void setFactory(LogFactory logFactory) {
        if (DiscoveryLogFactory.logFactory == null) {
            DiscoveryLogFactory.logFactory = logFactory;
            Enumeration enumeration = classRegistry.elements();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("Reset Log for: " + clazz.getName());
                }
                Method method = null;
                try {
                    method = clazz.getMethod("setLog", setLogParamClasses);
                }
                catch (Exception exception) {
                    String string = "Internal Error: pre-check for " + clazz.getName() + " failed?!";
                    log.fatal(string, exception);
                    throw new DiscoveryException(string, exception);
                }
                Object[] objectArray = new Object[]{logFactory.getInstance(clazz.getName())};
                try {
                    method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    String string = "Internal Error: setLog failed for " + clazz.getName();
                    log.fatal(string, exception);
                    throw new DiscoveryException(string, exception);
                }
            }
        }
    }
}

