/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.log;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;

public class SimpleLog
implements Log {
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected static final String PROP_LEVEL = "org.apache.commons.discovery.log.level";
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = false;
    protected static DateFormat dateFormatter = null;
    protected static int logLevel = 3;
    private static PrintStream out = System.out;
    protected String logName = null;
    private String prefix = null;

    public static void setLevel(int n) {
        logLevel = n;
    }

    public static int getLevel() {
        return logLevel;
    }

    protected static boolean isLevelEnabled(int n) {
        return n >= SimpleLog.getLevel();
    }

    public SimpleLog(String string) {
        this.logName = string;
    }

    protected void log(int n, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            stringBuffer.append(dateFormatter.format(new Date()));
            stringBuffer.append(" ");
        }
        switch (n) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO ] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN ] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            stringBuffer.append(this.prefix);
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append(" <");
            stringBuffer.append(throwable.toString());
            stringBuffer.append(">");
        }
        out.println(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    @Override
    public final void debug(Object object) {
        if (SimpleLog.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    @Override
    public final void debug(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    @Override
    public final void trace(Object object) {
        if (SimpleLog.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }

    @Override
    public final void trace(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    @Override
    public final void info(Object object) {
        if (SimpleLog.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    @Override
    public final void info(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    @Override
    public final void warn(Object object) {
        if (SimpleLog.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    @Override
    public final void warn(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    @Override
    public final void error(Object object) {
        if (SimpleLog.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    @Override
    public final void error(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    @Override
    public final void fatal(Object object) {
        if (SimpleLog.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    @Override
    public final void fatal(Object object, Throwable throwable) {
        if (SimpleLog.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    @Override
    public final boolean isDebugEnabled() {
        return SimpleLog.isLevelEnabled(2);
    }

    @Override
    public final boolean isErrorEnabled() {
        return SimpleLog.isLevelEnabled(5);
    }

    @Override
    public final boolean isFatalEnabled() {
        return SimpleLog.isLevelEnabled(6);
    }

    @Override
    public final boolean isInfoEnabled() {
        return SimpleLog.isLevelEnabled(3);
    }

    @Override
    public final boolean isTraceEnabled() {
        return SimpleLog.isLevelEnabled(1);
    }

    @Override
    public final boolean isWarnEnabled() {
        return SimpleLog.isLevelEnabled(4);
    }

    static {
        if (showDateTime) {
            dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
        }
        try {
            String string = System.getProperty(PROP_LEVEL);
            if ("all".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(0);
            } else if ("trace".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(1);
            } else if ("debug".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(2);
            } else if ("info".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(3);
            } else if ("warn".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(4);
            } else if ("error".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(5);
            } else if ("fatal".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(6);
            } else if ("off".equalsIgnoreCase(string)) {
                SimpleLog.setLevel(7);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

