/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceDiscover;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.ResourceDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverResources
extends ResourceDiscoverImpl
implements ResourceDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverResources.class);

    public static void setLog(Log log) {
        DiscoverResources.log = log;
    }

    public DiscoverResources() {
    }

    public DiscoverResources(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    @Override
    public ResourceIterator findResources(final String string) {
        if (log.isDebugEnabled()) {
            log.debug("find: resourceName='" + string + "'");
        }
        return new ResourceIterator(){
            private int idx = 0;
            private ClassLoader loader = null;
            private Enumeration resources = null;
            private Resource resource = null;

            @Override
            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextResource();
                }
                return this.resource != null;
            }

            @Override
            public Resource nextResource() {
                Resource resource = this.resource;
                this.resource = null;
                return resource;
            }

            private Resource getNextResource() {
                Resource resource;
                if (this.resources == null || !this.resources.hasMoreElements()) {
                    this.resources = this.getNextResources();
                }
                if (this.resources != null) {
                    URL uRL = (URL)this.resources.nextElement();
                    if (log.isDebugEnabled()) {
                        log.debug("getNextResource: next URL='" + uRL + "'");
                    }
                    resource = new Resource(string, uRL, this.loader);
                } else {
                    resource = null;
                }
                return resource;
            }

            private Enumeration getNextResources() {
                while (this.idx < DiscoverResources.this.getClassLoaders().size()) {
                    this.loader = DiscoverResources.this.getClassLoaders().get(this.idx++);
                    if (log.isDebugEnabled()) {
                        log.debug("getNextResources: search using ClassLoader '" + this.loader + "'");
                    }
                    try {
                        Enumeration enumeration = JDKHooks.getJDKHooks().getResources(this.loader, string);
                        if (enumeration == null || !enumeration.hasMoreElements()) continue;
                        return enumeration;
                    }
                    catch (IOException iOException) {
                        log.warn("getNextResources: Ignoring Exception", iOException);
                    }
                }
                return null;
            }
        };
    }
}

