/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.util.ResizableDoubleArray;

public class DescriptiveStatisticsImpl
extends DescriptiveStatistics
implements Serializable {
    private static final long serialVersionUID = -1868088725461221010L;
    protected int windowSize;
    protected ResizableDoubleArray eDA = new ResizableDoubleArray();

    public DescriptiveStatisticsImpl() {
        this(-1);
    }

    public DescriptiveStatisticsImpl(int n) {
        this.setWindowSize(n);
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public double[] getValues() {
        double[] dArray = new double[this.eDA.getNumElements()];
        System.arraycopy(this.eDA.getElements(), 0, dArray, 0, this.eDA.getNumElements());
        return dArray;
    }

    @Override
    public double getElement(int n) {
        return this.eDA.getElement(n);
    }

    @Override
    public long getN() {
        return this.eDA.getNumElements();
    }

    @Override
    public void addValue(double d) {
        if (this.windowSize != -1) {
            if (this.getN() == (long)this.windowSize) {
                this.eDA.addElementRolling(d);
            } else if (this.getN() < (long)this.windowSize) {
                this.eDA.addElement(d);
            }
        } else {
            this.eDA.addElement(d);
        }
    }

    @Override
    public void clear() {
        this.eDA.clear();
    }

    @Override
    public void setWindowSize(int n) {
        if (n < 1 && n != -1) {
            throw new IllegalArgumentException("window size must be positive.");
        }
        this.windowSize = n;
        if (n != -1 && n < this.eDA.getNumElements()) {
            this.eDA.discardFrontElements(this.eDA.getNumElements() - n);
        }
    }

    @Override
    public double apply(UnivariateStatistic univariateStatistic) {
        return univariateStatistic.evaluate(this.eDA.getValues(), this.eDA.start(), this.eDA.getNumElements());
    }
}

