/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic {
    private static final long serialVersionUID = -8178734905303459453L;
    private SumOfLogs sumOfLogs = new SumOfLogs();

    @Override
    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    @Override
    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return Math.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        this.sumOfLogs.clear();
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) {
        return Math.exp(this.sumOfLogs.evaluate(dArray, n, n2) / (double)n2);
    }

    @Override
    public long getN() {
        return this.sumOfLogs.getN();
    }
}

