/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.ThirdMoment;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 7101857578996691352L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment thirdMoment) {
        this.incMoment = false;
        this.moment = thirdMoment;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double d = this.moment.m2 / (double)(this.moment.n - 1L);
        if (d < 1.0E-19) {
            return 0.0;
        }
        double d2 = this.moment.getN();
        return d2 * this.moment.m3 / ((d2 - 1.0) * (d2 - 2.0) * Math.sqrt(d) * d);
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2) && n2 > 2) {
            Mean mean = new Mean();
            double d2 = mean.evaluate(dArray, n, n2);
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d3 += Math.pow(dArray[i] - d2, 2.0);
                d4 += dArray[i] - d2;
            }
            double d5 = Math.sqrt((d3 - Math.pow(d4, 2.0) / (double)n2) / (double)(n2 - 1));
            double d6 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d6 += Math.pow(dArray[i] - d2, 3.0);
            }
            double d7 = n2;
            d = d7 / ((d7 - 1.0) * (d7 - 2.0)) * (d6 /= Math.pow(d5, 3.0));
        }
        return d;
    }
}

