/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Max
extends AbstractStorelessUnivariateStatistic {
    private static final long serialVersionUID = -5593383832225844641L;
    private long n = 0L;
    private double value = Double.NaN;

    @Override
    public void increment(double d) {
        if (d > this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2)) {
            d = dArray[n];
            for (int i = n; i < n + n2; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                d = d > dArray[i] ? d : dArray[i];
            }
        }
        return d;
    }
}

