/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n = 0;
    private double value = 0.0;

    @Override
    public void increment(double d) {
        this.value += Math.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        if (this.n > 0) {
            return this.value;
        }
        return Double.NaN;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += Math.log(dArray[i]);
            }
        }
        return d;
    }
}

