/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import org.apache.commons.math.util.DoubleArray;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    private static final long serialVersionUID = -3485529955529426875L;
    public static final int ADDITIVE_MODE = 1;
    public static final int MULTIPLICATIVE_MODE = 0;
    protected float contractionCriteria = 2.5f;
    protected float expansionFactor = 2.0f;
    protected int expansionMode = 0;
    protected int initialCapacity = 16;
    protected double[] internalArray;
    protected int numElements = 0;
    protected int startIndex = 0;

    public ResizableDoubleArray() {
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(int n) {
        this.setInitialCapacity(n);
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(int n, float f) {
        this.expansionFactor = f;
        this.setInitialCapacity(n);
        this.internalArray = new double[n];
        this.setContractionCriteria(f + 0.5f);
    }

    public ResizableDoubleArray(int n, float f, float f2) {
        this.expansionFactor = f;
        this.setContractionCriteria(f2);
        this.setInitialCapacity(n);
        this.internalArray = new double[n];
    }

    public ResizableDoubleArray(int n, float f, float f2, int n2) {
        this.expansionFactor = f;
        this.setContractionCriteria(f2);
        this.setInitialCapacity(n);
        this.setExpansionMode(n2);
        this.internalArray = new double[n];
    }

    @Override
    public synchronized void addElement(double d) {
        ++this.numElements;
        if (this.startIndex + this.numElements > this.internalArray.length) {
            this.expand();
        }
        this.internalArray[this.startIndex + (this.numElements - 1)] = d;
        if (this.shouldContract()) {
            this.contract();
        }
    }

    @Override
    public synchronized double addElementRolling(double d) {
        double d2 = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = d;
        if (this.shouldContract()) {
            this.contract();
        }
        return d2;
    }

    protected void checkContractExpand(float f, float f2) {
        if (f < f2) {
            String string = "Contraction criteria can never be smaller than the expansion factor.  This would lead to a never ending loop of expansion and contraction as a newly expanded internal storage array would immediately satisfy the criteria for contraction";
            throw new IllegalArgumentException(string);
        }
        if ((double)this.contractionCriteria <= 1.0) {
            String string = "The contraction criteria must be a number larger than one.  If the contractionCriteria is less than or equal to one an endless loop of contraction and expansion would ensue as an internalArray.length == numElements would satisfy the contraction criteria";
            throw new IllegalArgumentException(string);
        }
        if ((double)f2 <= 1.0) {
            String string = "The expansion factor must be a number greater than 1.0";
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public synchronized void clear() {
        this.numElements = 0;
        this.internalArray = new double[this.initialCapacity];
    }

    public synchronized void contract() {
        double[] dArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        this.internalArray = dArray;
        this.startIndex = 0;
    }

    public synchronized void discardFrontElements(int n) {
        if (n > this.numElements) {
            String string = "Cannot discard more elements than arecontained in this array.";
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = "Cannot discard a negative number of elements.";
            throw new IllegalArgumentException(string);
        }
        this.numElements -= n;
        this.startIndex += n;
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected synchronized void expand() {
        int n = 0;
        n = this.expansionMode == 0 ? (int)Math.ceil((float)this.internalArray.length * this.expansionFactor) : this.internalArray.length + Math.round(this.expansionFactor);
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    private synchronized void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    public float getContractionCriteria() {
        return this.contractionCriteria;
    }

    @Override
    public synchronized double getElement(int n) {
        if (n >= this.numElements) {
            String string = "The index specified: " + n + " is larger than the current number of elements";
            throw new ArrayIndexOutOfBoundsException(string);
        }
        if (n >= 0) {
            return this.internalArray[this.startIndex + n];
        }
        String string = "Elements cannot be retrieved from a negative array index";
        throw new ArrayIndexOutOfBoundsException(string);
    }

    @Override
    public synchronized double[] getElements() {
        double[] dArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        return dArray;
    }

    public float getExpansionFactor() {
        return this.expansionFactor;
    }

    public int getExpansionMode() {
        return this.expansionMode;
    }

    synchronized int getInternalLength() {
        return this.internalArray.length;
    }

    @Override
    public synchronized int getNumElements() {
        return this.numElements;
    }

    public synchronized double[] getValues() {
        return this.internalArray;
    }

    public void setContractionCriteria(float f) {
        this.checkContractExpand(f, this.getExpansionFactor());
        this.contractionCriteria = f;
    }

    @Override
    public synchronized void setElement(int n, double d) {
        if (n < 0) {
            String string = "Cannot set an element at a negative index";
            throw new ArrayIndexOutOfBoundsException(string);
        }
        if (n + 1 > this.numElements) {
            this.numElements = n + 1;
        }
        if (this.startIndex + n >= this.internalArray.length) {
            this.expandTo(this.startIndex + (n + 1));
        }
        this.internalArray[this.startIndex + n] = d;
    }

    public void setExpansionFactor(float f) {
        this.checkContractExpand(this.getContractionCriteria(), f);
        this.expansionFactor = f;
    }

    public void setExpansionMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal expansionMode setting.");
        }
        this.expansionMode = n;
    }

    protected void setInitialCapacity(int n) {
        if (n <= 0) {
            String string = "The initial capacity supplied: " + n + "must be a positive integer";
            throw new IllegalArgumentException(string);
        }
        this.initialCapacity = n;
    }

    public synchronized void setNumElements(int n) {
        if (n < 0) {
            String string = "Number of elements must be zero or a positive integer";
            throw new IllegalArgumentException(string);
        }
        if (this.startIndex + n > this.internalArray.length) {
            this.expandTo(this.startIndex + n);
        }
        this.numElements = n;
    }

    private synchronized boolean shouldContract() {
        if (this.expansionMode == 0) {
            return (float)(this.internalArray.length / this.numElements) > this.contractionCriteria;
        }
        return (float)(this.internalArray.length - this.numElements) > this.contractionCriteria;
    }

    public synchronized int start() {
        return this.startIndex;
    }
}

